/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.xenotech.client.gui.screens;

import com.dairymoose.xenotech.client.gui.screens.TerminalScrollPanel;
import com.dairymoose.xenotech.entity.DummyEntity;
import com.dairymoose.xenotech.network.ServerboundShipNamePacket;
import com.dairymoose.xenotech.network.XenoTechNetwork;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class TerminalScreen
extends Screen {
    private static final Logger LOGGER = LogManager.getLogger();
    protected static final ResourceLocation TERMINAL_GUI = new ResourceLocation("xenotech", "textures/gui/terminal.png");
    final int GUI_WIDTH = 256;
    final int GUI_HEIGHT = 200;
    private TerminalScrollPanel scrollPanel;
    protected TerminalData data = null;
    private Stack<TerminalData> dataStack = new Stack();
    protected int typeSpeedOverride = 0;
    public BlockPos pos;
    private EditBox shipNameBox;
    private static final String TERMINAL_TEXT = "Terminal";
    private static final float textAreaWidthPct = 0.88f;
    private static final float textAreaHeightPct = 0.72f;

    public boolean m_7933_(int key, int p_96553_, int p_96554_) {
        boolean handled = super.m_7933_(key, p_96553_, p_96554_);
        if (!(handled || key != 69 || this.shipNameBox != null && this.shipNameBox.m_94213_())) {
            this.m_7379_();
            return true;
        }
        return handled;
    }

    public static Button.OnPress onPress_acceptNewShipName(TerminalScreen screen, DummyEntity dummy) {
        return btn -> {
            String newName = screen.shipNameBox.m_94155_();
            dummy.setShipName(newName);
            XenoTechNetwork.INSTANCE.sendToServer((Object)new ServerboundShipNamePacket(dummy, newName));
            Minecraft.m_91087_().m_91152_(null);
        };
    }

    public void addShipNameBox(DummyEntity dummy) {
        int startX = (this.f_96543_ - 256) / 2;
        int startY = (this.f_96544_ - 200) / 2;
        if (this.shipNameBox == null) {
            this.shipNameBox = new EditBox(this.f_96547_, startX + 39, startY + 60, 178, 10, (Component)Component.m_237113_((String)""));
            String shipName = dummy.getShipName();
            this.shipNameBox.m_94199_(ServerboundShipNamePacket.SHIP_NAME_MAX_LENGTH);
            this.shipNameBox.m_94144_(shipName);
            this.shipNameBox.m_93692_(true);
        }
        this.m_142416_((GuiEventListener)this.shipNameBox);
        this.m_7522_((GuiEventListener)this.shipNameBox);
    }

    public void setTerminalData(TerminalData data) {
        if (this.data != null) {
            this.dataStack.push(this.data);
        }
        this.data = data;
    }

    public void popDataStack() {
        if (!this.dataStack.isEmpty()) {
            this.data = this.dataStack.pop();
        }
    }

    private static Component getComponentForTitle(String title) {
        return Component.m_237113_((String)title).m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x404040)));
    }

    public TerminalScreen(BlockPos pos) {
        this(null, pos);
    }

    public TerminalScreen(TerminalData data, BlockPos pos) {
        super(TerminalScreen.getComponentForTitle(TERMINAL_TEXT));
        this.pos = pos;
        this.data = data;
    }

    public boolean m_6375_(double x, double y, int button) {
        if (this.scrollPanel != null) {
            this.scrollPanel.quickOutput = true;
            this.scrollPanel.m_6375_(x, y, button);
        }
        return super.m_6375_(x, y, button);
    }

    public void m_94757_(double p_94758_, double p_94759_) {
        if (this.scrollPanel != null) {
            this.scrollPanel.m_94757_(p_94758_, p_94759_);
        }
        super.m_94757_(p_94758_, p_94759_);
    }

    public static Button.OnPress onPress_exit(TerminalScreen thisTerminal) {
        return new Button.OnPress(){

            public void m_93750_(Button arg0) {
                Minecraft.m_91087_().m_91152_(null);
            }
        };
    }

    public static Button.OnPress onPress_back(final TerminalScreen thisTerminal) {
        return new Button.OnPress(){

            public void m_93750_(Button arg0) {
                thisTerminal.popDataStack();
                thisTerminal.reinit(1);
            }
        };
    }

    public void reinit() {
        this.m_7856_();
    }

    public void setTypeSpeedOverride(int override) {
        this.typeSpeedOverride = override;
    }

    public void reinit(int typeSpeedOverride) {
        this.setTypeSpeedOverride(typeSpeedOverride);
        this.m_7856_();
        this.setTypeSpeedOverride(0);
    }

    protected void m_7856_() {
        super.m_7856_();
        if (this.scrollPanel == null) {
            int startX = (this.f_96543_ - 256) / 2;
            int startY = (this.f_96544_ - 200) / 2;
            int textStartLocationAdjustment = 23;
            this.scrollPanel = new TerminalScrollPanel(this, this.f_96541_, 225, 144, startX, startY + textStartLocationAdjustment);
        }
        this.scrollPanel.init();
        this.m_142416_((GuiEventListener)this.scrollPanel);
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_88315_(GuiGraphics graphics, int p_230430_2_, int p_230430_3_, float p_230430_4_) {
        int startX = (this.f_96543_ - 256) / 2;
        int startY = (this.f_96544_ - 200) / 2;
        graphics.m_280218_(TERMINAL_GUI, startX, startY, 0, 0, 256, 200);
        super.m_88315_(graphics, p_230430_2_, p_230430_3_, p_230430_4_);
    }

    public static class TerminalData {
        public String finalText = "";
        public MutableComponent translatable = null;
        public List<TerminalButton> buttons = new ArrayList<TerminalButton>();

        public TerminalData(String finalText, List<TerminalButton> buttons) {
            this.finalText = finalText;
            this.buttons = buttons;
        }

        public TerminalData(String finalText, TerminalScreen screen) {
            this.finalText = finalText;
            this.buttons = List.of(new TerminalButton(Component.m_237115_((String)"terminal.xenotech.exit"), TerminalScreen.onPress_exit(screen)));
        }

        public TerminalData(MutableComponent translatable, List<TerminalButton> buttons) {
            this.translatable = translatable;
            this.buttons = buttons;
        }

        public TerminalData(MutableComponent translatable, TerminalScreen screen) {
            this.translatable = translatable;
            this.buttons = List.of(new TerminalButton(Component.m_237115_((String)"terminal.xenotech.exit"), TerminalScreen.onPress_exit(screen)));
        }
    }

    public static class TerminalButton {
        public String text = "[]";
        public MutableComponent translatable = null;
        public Button.OnPress onPressResult = null;

        public TerminalButton() {
            this.text = null;
            this.onPressResult = null;
        }

        public TerminalButton(String text, Button.OnPress onPressResult) {
            this.text = text;
            this.onPressResult = onPressResult;
        }

        public TerminalButton(MutableComponent translatable, Button.OnPress onPressResult) {
            this.translatable = translatable;
            this.onPressResult = onPressResult;
        }
    }
}

