/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.xenotech.client.gui.screens;

import com.dairymoose.xenotech.client.gui.screens.TerminalScreen;
import com.mojang.blaze3d.vertex.Tesselator;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraftforge.client.gui.widget.ScrollPanel;

public class TerminalScrollPanel
extends ScrollPanel {
    private TerminalScreen parent;
    private static final int PADDING = 0;
    private int verticalPadding = 0;
    private Minecraft minecraft;
    private long timestampStart;
    private int textPointer = 0;
    private int MAX_CHARS_PER_LINE = 40;
    private List<String> lines;
    private int currentLine = 0;
    private int textColor = 2555173;
    private Style textStyle = Style.f_131099_.m_131150_(Minecraft.f_91058_).m_131136_(Boolean.TRUE).m_178520_(this.textColor);
    public static final int TERMINAL_LINE_SPACING = 8;
    private int MS_PER_CHARACTER = 1;
    public boolean quickOutput = false;
    private boolean finishedDrawing = false;
    public static final int DOWN_ARROW_X = 38;
    public static final int DOWN_ARROW_Y = 0;
    public static final int CANCEL_X = 18;
    public static final int CANCEL_Y = 51;
    public static final int ACCEPT_X = 48;
    public static final int ACCEPT_Y = 51;
    public static final int COPIES_TEXT_X = 38;
    public static final int COPIES_TEXT_Y_OLD = 26;
    public static final int COPIES_TEXT_Y = 0;
    private static final int SCROLLPANEL_BORDER = 0;
    private static final int SCROLLPANEL_BAR_WIDTH = 6;
    private static final int SCROLLPANEL_BG_COLOR_FROM = -1072689136;
    private static final int SCROLLPANEL_BG_COLOR_TO = -804253680;
    private static final int SCROLLPANEL_BAR_BG = -14671840;
    private static final int SCROLLPANEL_BAR_EDGE_COLOR = -8355712;
    private static final int SCROLLPANEL_BAR_FG_COLOR = -4144960;
    private List<AbstractWidget> renderables = new ArrayList<AbstractWidget>();

    public List<? extends GuiEventListener> m_6702_() {
        return this.renderables;
    }

    TerminalScrollPanel(TerminalScreen parent, Minecraft mcIn, int widthIn, int heightIn, int x, int y) {
        super(mcIn, widthIn, heightIn, y + 0, x, 0, 6, -1072689136, -804253680, -14671840, -8355712, -4144960);
        this.parent = parent;
        this.minecraft = Minecraft.m_91087_();
    }

    protected void drawBackground(GuiGraphics guiGraphics, Tesselator tess, float partialTick) {
    }

    protected int getScrollAmount() {
        return this.oneLineSize() * 1;
    }

    private List<String> buildLines(String input) {
        input = input.replace("\n", " \n");
        String[] inputWords = input.split(" ");
        ArrayList<String> lines = new ArrayList<String>();
        Object currentText = "";
        boolean first = true;
        for (String word : inputWords) {
            word = word.replaceAll("\t", "  ");
            int sizeWithNextWordAppended = ((String)currentText).length() + 1 + word.length();
            if (word.length() >= this.MAX_CHARS_PER_LINE || sizeWithNextWordAppended > this.MAX_CHARS_PER_LINE || word.startsWith("\n")) {
                first = true;
                lines.add((String)currentText);
                currentText = "";
                if (word.startsWith("\n")) {
                    word = word.substring(1, word.length());
                }
                if (word.length() == 0) continue;
            }
            if (first) {
                first = false;
            } else {
                currentText = (String)currentText + " ";
            }
            currentText = (String)currentText + word;
        }
        if (((String)currentText).length() > 0) {
            lines.add((String)currentText);
        }
        return lines;
    }

    public void init() {
        String translated = null;
        if (this.parent.data.translatable != null) {
            translated = this.parent.data.translatable.getString();
        }
        if (translated == null) {
            translated = this.parent.data.finalText;
        }
        this.lines = this.buildLines(translated);
        this.quickOutput = false;
        this.finishedDrawing = false;
        this.MS_PER_CHARACTER = 12;
        if (this.parent.typeSpeedOverride > 0) {
            this.MS_PER_CHARACTER = this.parent.typeSpeedOverride;
        }
        this.currentLine = 0;
        this.removeButtons();
        this.addButtons();
        this.timestampStart = System.currentTimeMillis();
        this.scrollDistance = 0.0f;
    }

    public NarratableEntry.NarrationPriority m_142684_() {
        return NarratableEntry.NarrationPriority.NONE;
    }

    public void m_142291_(NarrationElementOutput p_169152_) {
    }

    public int oneLineSize() {
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        return 9 + this.verticalPadding;
    }

    public int getContentHeight() {
        int height = 0;
        height += this.lines.size() * this.oneLineSize();
        if ((height += this.renderables.size() * this.oneLineSize()) < this.bottom - this.top - 8) {
            height = this.bottom - this.top - 8;
        }
        return height;
    }

    private void removeWidget(AbstractWidget toRemove) {
        this.renderables.remove(toRemove);
    }

    private void addWidget(AbstractWidget toAdd) {
        this.renderables.add(toAdd);
    }

    private void addRenderableWidget(AbstractWidget toAdd) {
        this.renderables.add(toAdd);
    }

    private int getButtonY(int startY, int buttonNo) {
        return startY + 0 + (this.lines.size() + 1 + buttonNo) * 8;
    }

    private void addButtons() {
        int TEXTURE_HEIGHT;
        int startX = this.left;
        int startY = this.top;
        int BUTTON_TEXTURE_START_X = 0;
        int BUTTON_TEXTURE_START_Y = 200;
        int TEXTURE_Y_OFFSET = TEXTURE_HEIGHT = 7;
        MutableComponent displayButton = null;
        FormattedCharSequence formatted = null;
        int textWidth = 0;
        if (this.parent.data.buttons != null) {
            for (TerminalScreen.TerminalButton terminalButton : this.parent.data.buttons) {
                if (terminalButton.text == null) {
                    this.addWidget((AbstractWidget)new ImageButton(0, 0, 0, 0, 0, 0, 0, TerminalScreen.TERMINAL_GUI, 256, 256, new Button.OnPress(){

                        public void m_93750_(Button param1Button) {
                        }
                    }, (Component)Component.m_237119_()));
                    continue;
                }
                displayButton = terminalButton.translatable != null ? terminalButton.translatable.m_130948_(this.textStyle) : Component.m_237113_((String)terminalButton.text).m_130948_(this.textStyle);
                formatted = displayButton.m_7532_();
                textWidth = this.minecraft.f_91062_.m_92724_(formatted);
                this.addRenderableWidget((AbstractWidget)new ImageButton(startX + 38, this.getButtonY(startY, this.m_6702_().size()), textWidth, TEXTURE_HEIGHT, BUTTON_TEXTURE_START_X, BUTTON_TEXTURE_START_Y, TEXTURE_Y_OFFSET, TerminalScreen.TERMINAL_GUI, 256, 256, terminalButton.onPressResult, (Component)displayButton));
            }
        }
        for (GuiEventListener guiEventListener : this.m_6702_()) {
            if (!(guiEventListener instanceof AbstractWidget)) continue;
            AbstractWidget widget = (AbstractWidget)guiEventListener;
            widget.f_93623_ = false;
            widget.f_93624_ = false;
        }
    }

    public void removeButtons() {
        ArrayList<AbstractWidget> toRemove = new ArrayList<AbstractWidget>();
        for (GuiEventListener guiEventListener : this.m_6702_()) {
            if (!(guiEventListener instanceof AbstractWidget)) continue;
            AbstractWidget widget = (AbstractWidget)guiEventListener;
            toRemove.add(widget);
        }
        for (AbstractWidget abstractWidget : toRemove) {
            this.removeWidget(abstractWidget);
        }
    }

    protected void repositionButtons(int startY) {
        int buttonNo = 0;
        for (AbstractWidget widget : this.renderables) {
            widget.m_253211_(this.getButtonY(startY, buttonNo));
            ++buttonNo;
        }
    }

    protected void drawPanel(GuiGraphics graphics, int entryRight, int relativeY, Tesselator tess, int mouseX, int mouseY) {
        int startX = this.left;
        int startY = relativeY;
        long timestamp = System.currentTimeMillis();
        int lineIndex = 0;
        if (this.quickOutput) {
            this.MS_PER_CHARACTER = 1;
        }
        for (String string : this.lines) {
            long timeDiff = timestamp - this.timestampStart;
            String outputText = string;
            if (lineIndex > this.currentLine) break;
            MutableComponent outputComponent = null;
            if (lineIndex == this.currentLine) {
                this.textPointer = (int)(timeDiff / (long)this.MS_PER_CHARACTER);
                this.textPointer = Math.min(this.textPointer, string.length());
                this.textPointer = Math.max(this.textPointer, 0);
                outputText = string.substring(0, this.textPointer);
                outputComponent = Component.m_237113_((String)outputText).m_130948_(this.textStyle);
                boolean showCursor = true;
                if (this.textPointer == string.length()) {
                    int lastIndex;
                    if (timeDiff / 600L % 2L == 0L) {
                        showCursor = false;
                    }
                    if (lineIndex < (lastIndex = this.lines.size() - 1)) {
                        ++this.currentLine;
                        this.timestampStart = System.currentTimeMillis();
                    } else {
                        this.finishedDrawing = true;
                    }
                }
                if (showCursor) {
                    int nCopies = Math.max(0, Math.min(this.textPointer, string.length()));
                    String cursorText = "\u258c";
                    MutableComponent cursorComponent = Component.m_237113_((String)cursorText).m_130948_(this.textStyle);
                    FormattedCharSequence formatted = outputComponent.m_7532_();
                    int textWidth = this.minecraft.f_91062_.m_92724_(formatted);
                    graphics.m_280430_(this.minecraft.f_91062_, (Component)cursorComponent, startX + 38 + textWidth, startY + 0 + lineIndex * 8, 0);
                }
            }
            if (outputComponent == null) {
                outputComponent = Component.m_237113_((String)outputText).m_130948_(this.textStyle);
            }
            graphics.m_280430_(this.minecraft.f_91062_, (Component)outputComponent, startX + 38, startY + 0 + lineIndex * 8, 0);
            ++lineIndex;
        }
        this.repositionButtons(startY);
        for (AbstractWidget abstractWidget : this.renderables) {
            abstractWidget.m_88315_(graphics, mouseX, mouseY, 0.0f);
        }
        if (this.finishedDrawing) {
            for (GuiEventListener guiEventListener : this.m_6702_()) {
                if (!(guiEventListener instanceof AbstractWidget)) continue;
                AbstractWidget widget = (AbstractWidget)guiEventListener;
                widget.f_93623_ = true;
                widget.f_93624_ = true;
            }
        }
        for (GuiEventListener guiEventListener : this.m_6702_()) {
            if (!(guiEventListener instanceof AbstractWidget)) continue;
            AbstractWidget widget = (AbstractWidget)guiEventListener;
            if (!widget.f_93624_ || widget.m_6035_() == null || widget.m_6035_() == Component.m_237119_()) continue;
            Component displayComponent = widget.m_6035_();
            if (widget.m_198029_()) {
                displayComponent = Component.m_237113_((String)displayComponent.getString()).m_130948_(this.textStyle.m_178520_(0x7F7F7F));
            }
            int bumpHeight = -1;
            graphics.m_280653_(this.minecraft.f_91062_, displayComponent, widget.m_252754_() + widget.m_5711_() / 2, widget.m_252907_() + (widget.m_93694_() - 8) / 2 + bumpHeight, 0);
        }
    }
}

