/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.xenotech.entity;

import com.dairymoose.xenotech.BlockEntityUtils;
import com.dairymoose.xenotech.CollisionUtils;
import com.dairymoose.xenotech.CreateModCompat;
import com.dairymoose.xenotech.ItemStorage;
import com.dairymoose.xenotech.XenoBlocks;
import com.dairymoose.xenotech.XenoTechClient;
import com.dairymoose.xenotech.XenoTechCommon;
import com.dairymoose.xenotech.XenoTechUtils;
import com.dairymoose.xenotech.block.BalloonBlock;
import com.dairymoose.xenotech.block.BuzzsawBlock;
import com.dairymoose.xenotech.block.CombineHarvesterBlock;
import com.dairymoose.xenotech.block.DriverSeatBlock;
import com.dairymoose.xenotech.block.IntegratedGunBlock;
import com.dairymoose.xenotech.block.JetThrusterBlock;
import com.dairymoose.xenotech.block.MiningDrillBlock;
import com.dairymoose.xenotech.block.MountedGunBlock;
import com.dairymoose.xenotech.block.PrecisionDrillBlock;
import com.dairymoose.xenotech.block.PropellerBlock;
import com.dairymoose.xenotech.block.SailBlock;
import com.dairymoose.xenotech.block.SportTireBlock;
import com.dairymoose.xenotech.client.gui.screens.AscentTaskItem;
import com.dairymoose.xenotech.client.gui.screens.BackwardsTaskItem;
import com.dairymoose.xenotech.client.gui.screens.DelayTaskItem;
import com.dairymoose.xenotech.client.gui.screens.DescentTaskItem;
import com.dairymoose.xenotech.client.gui.screens.ForwardTaskItem;
import com.dairymoose.xenotech.client.gui.screens.PeriodicEventTaskItem;
import com.dairymoose.xenotech.client.gui.screens.TaskElement;
import com.dairymoose.xenotech.client.gui.screens.TaskItem;
import com.dairymoose.xenotech.client.gui.screens.TaskItemType;
import com.dairymoose.xenotech.client.gui.screens.TaskList;
import com.dairymoose.xenotech.client.gui.screens.TaskParamType;
import com.dairymoose.xenotech.client.gui.screens.TurnTaskItem;
import com.dairymoose.xenotech.entity.Kinematics;
import com.dairymoose.xenotech.entity.RenderableBlock;
import com.dairymoose.xenotech.entity.ShipRenderableStorage;
import com.dairymoose.xenotech.entity.WaterColliderEntity;
import com.dairymoose.xenotech.network.ClientboundBlockEntitySyncPacket;
import com.dairymoose.xenotech.network.ClientboundMultipartShipDataPacket;
import com.dairymoose.xenotech.network.ClientboundTasklistPacket;
import com.dairymoose.xenotech.network.ServerboundAdjustVehicleDeltaPacket;
import com.dairymoose.xenotech.network.ServerboundCarriedPlayerReminder;
import com.dairymoose.xenotech.network.XenoTechNetwork;
import com.dairymoose.xenotech.util.HBlockPos;
import com.dairymoose.xenotech.world.level.block.entity.BaseDrillBlockEntity;
import com.dairymoose.xenotech.world.level.block.entity.BuzzsawBlockEntity;
import com.dairymoose.xenotech.world.level.block.entity.FluidShippingTankBlockEntity;
import com.dairymoose.xenotech.world.level.block.entity.IntegratedGunBlockEntity;
import com.dairymoose.xenotech.world.level.block.entity.InternalCombustionEngineBlockEntity;
import com.dairymoose.xenotech.world.level.block.entity.ManipulatorBlockEntity;
import com.dairymoose.xenotech.world.level.block.entity.MountedGunBlockEntity;
import com.dairymoose.xenotech.world.level.block.entity.ShipTerminalBlockEntity;
import com.dairymoose.xenotech.world.level.block.entity.SteamEngineBlockEntity;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.math.Axis;
import com.simibubi.create.content.fluids.tank.FluidTankBlockEntity;
import com.simibubi.create.content.logistics.vault.ItemVaultBlockEntity;
import java.awt.geom.Point2D;
import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ChunkBufferBuilderPack;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.AbstractBannerBlock;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CarpetBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.FurnaceBlock;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.NetherWartBlock;
import net.minecraft.world.level.block.RailBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.TorchBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WaterlilyBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joml.Matrix4f;

public class DummyEntity
extends Entity {
    public static final EntityType<DummyEntity> DUMMY_ENTITY = EntityType.Builder.m_20704_(DummyEntity::new, (MobCategory)MobCategory.MISC).m_20699_(1.0f, 1.0f).m_20702_(50).m_20712_(new ResourceLocation("xenotech", "dummy").toString());
    private static final Logger LOGGER = LogManager.getLogger();
    private static final EntityDataAccessor<Float> DATA_ID_RIDE_HEIGHT = SynchedEntityData.m_135353_(DummyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> TARGET_ENTITY_ID = SynchedEntityData.m_135353_(DummyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<String> RENDERABLE_BLOCKLIST = SynchedEntityData.m_135353_(DummyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Float> Y_ROT_REQUEST = SynchedEntityData.m_135353_(DummyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> STARTING_ANGLE = SynchedEntityData.m_135353_(DummyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<String> SHIP_NAME = SynchedEntityData.m_135353_(DummyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Long> UNIQUE_ID = SynchedEntityData.m_135353_(DummyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_244073_);
    private static final EntityDataAccessor<Boolean> OUT_OF_FUEL = SynchedEntityData.m_135353_(DummyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Float> SERVER_ADDED_ASCENT = SynchedEntityData.m_135353_(DummyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Boolean> DRILL_ENABLED = SynchedEntityData.m_135353_(DummyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> BUZZSAW_ENABLED = SynchedEntityData.m_135353_(DummyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> WEAPONS_ENABLED = SynchedEntityData.m_135353_(DummyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> ANY_DRILL_ACTIVE = SynchedEntityData.m_135353_(DummyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> MOUNTED_GUN_TYPE = SynchedEntityData.m_135353_(DummyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Long> METRICS_BLOCKS_TRAVELLED = SynchedEntityData.m_135353_(DummyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_244073_);
    private static final EntityDataAccessor<Long> METRICS_TIME_SPENT_CONSUMING_FUEL_SEC = SynchedEntityData.m_135353_(DummyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_244073_);
    private static final EntityDataAccessor<Long> METRICS_TIME_UNTIL_EMPTY_SEC = SynchedEntityData.m_135353_(DummyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_244073_);
    private static final EntityDataAccessor<String> METRICS_CREATION_DATE = SynchedEntityData.m_135353_(DummyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<String> METRICS_CREATOR_NAME = SynchedEntityData.m_135353_(DummyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final int MOUNTED_GUN_TYPE_MINIGUN = 0;
    public static final int MOUNTED_GUN_TYPE_CHAIR = 1;
    public final RandomSource f_19796_ = RandomSource.m_216327_();
    public BlockPos startingTerminalPos = new BlockPos(0, 0, 0);
    public List<RenderableBlock> renderables = new ArrayList<RenderableBlock>();
    public float weight = 0.0f;
    public XenoTechUtils.MoverStats moverStats = new XenoTechUtils.MoverStats();
    public XenoTechUtils.MoverStats liftMoverStats = new XenoTechUtils.MoverStats();
    public boolean isBoat = false;
    public boolean isGroundVehicle = false;
    public static boolean enableStepUp = true;
    float addedAscent = 0.0f;
    public Object storedEntityRenderer = null;
    public float renderSize = 1.7f;
    public long lastRenderTimestamp = 0L;
    public boolean firstRun = true;
    public static Entity movedEntity = null;
    public long uniqueId = -1L;
    private boolean hasDefaultName = true;
    private boolean digitized = false;
    public static boolean freeFlightMode = false;
    double mouseLastX = Double.NaN;
    double mouseLastY = Double.NaN;
    public static boolean showBlockStateOverridesOnClient = false;
    public static boolean debug_alwaysShowBlockState = false;
    public static boolean doBlockStateOverride = false;
    public static boolean doBlockEntityOverride = true;
    public static boolean doSetBlockOverride = true;
    public static boolean alwaysDoSetBlockOverride = true;
    public static boolean doNotRender = false;
    public int autopilotAutoAscendTicks = 0;
    public int autopilotAutoDescendTicks = 0;
    public boolean autopilotWantToAscend = false;
    public boolean autopilotWantToDescend = false;
    public float noseTilt = 0.0f;
    public float noseTiltMax = 8.0f;
    public float lastVerticalSpinSpeed = 0.0f;
    public int ticksUntilSelfDestruction = -1;
    private float mountedGunInitialParentAngle;
    public Set<IntegratedWeaponInfo> integratedWeapons = new HashSet<IntegratedWeaponInfo>();
    public List<IntegratedWeaponInfo> weaponAssignments = new ArrayList<IntegratedWeaponInfo>();
    public Map<RenderType, BufferBuilder.RenderedBuffer> cachedRenders = null;
    public Map<RenderType, VertexBuffer> buffers = null;
    public CompletableFuture<Boolean> renderFuture = null;
    public Set<RenderType> uploadedBuffers = new HashSet<RenderType>();
    public Object bufferBuilderPack;
    public final RandomSource batchRenderRandom = RandomSource.m_216327_();
    private static SoundEvent[] newHoverSounds = new SoundEvent[]{(SoundEvent)XenoBlocks.SOUND_EVENT_HELICOPTER_HOVER_P1.get(), (SoundEvent)XenoBlocks.SOUND_EVENT_HELICOPTER_HOVER_P2.get(), (SoundEvent)XenoBlocks.SOUND_EVENT_HELICOPTER_HOVER_P3.get(), (SoundEvent)XenoBlocks.SOUND_EVENT_HELICOPTER_HOVER_P4.get()};
    private static float[] newHoverSoundLengths = new float[]{0.9f, 0.9f, 0.9f, 0.95f};
    int newHoverSoundIndex = 0;
    public TaskList taskList = new TaskList();
    public ShipRenderableStorage shipRenderableStorage = new ShipRenderableStorage();
    public boolean shouldConstructNewShip = false;
    private boolean applyGravity = false;
    public MountedGunBlockEntity thisMountedGun = null;
    public List<Entity> alwaysCarryList = new ArrayList<Entity>();
    public static Map<UUID, LogoutPositionInfo> playerLogoutRelativePosMap = new HashMap<UUID, LogoutPositionInfo>();
    public static Object globalDummySetLock = new Object();
    private static Set<DummyEntityHolder> dummiesGlobal = ConcurrentHashMap.newKeySet();
    public Map<BlockPos, RenderableBlock> renderableLookup = new HashMap<BlockPos, RenderableBlock>();
    public Map<BlockPos, RenderableBlock> fixedInitialPosRenderableLookup = new HashMap<BlockPos, RenderableBlock>();
    public static boolean invalidateCachedDummyListClient = false;
    public static boolean invalidateCachedDummyListServer = false;
    private static List<DummyEntity> cachedDummiesClient = null;
    private static List<DummyEntity> cachedDummiesServer = null;
    public int incrementer = 0;
    public boolean disassemblyCheckInProgress = false;
    public boolean disassemblyInProgress = false;
    private float invFriction;
    private Status status;
    private Status oldStatus;
    private float landFriction;
    private double waterLevel;
    private double lastYd;
    private float deltaRotation;
    private float yRotPerTick = 0.75f;
    private float yRotPerTickControlledLocally = 2.0f;
    public boolean forwardCommandActive = false;
    public boolean reverseCommandActive = false;
    public boolean wantToBrake = false;
    private float localInstanceSpeed = 0.0f;
    public static float entityLastClientFrameTime = 0.0f;
    public static boolean clientControlled = false;
    public static boolean serverControlled = true;
    public static boolean bothSidesControlled = serverControlled && clientControlled;
    private boolean clientTurningLeftOrRight = false;
    public boolean speedVectorIsPositive = true;
    private boolean yVectorIsPositive = true;
    public int yVectorNegativeTicks = 0;
    public int villagerRidingTicks = 0;
    public int playerRidingTicks = 0;
    public DummyEntityHolder thisHolder = null;
    private static final int drillProgressMax = 50;
    private static final int buzzsawProgressMax = 9;
    private boolean considerDiagonalsForMoveTree = true;
    private Map<BlockPos, Set<BlockPos>> buzzsawLeafSet = new HashMap<BlockPos, Set<BlockPos>>();
    public static int MAX_MOVE_TREE_VISIT_COUNT = 12000;
    public static int MAX_LOG_DESTROY_SIZE = 1200;
    public static int MAX_LEAF_DESTROY_SIZE = 200;
    boolean isProbablyATree = true;
    int moveTreeDownVisitedCount = 0;
    private int buzzsawDestructionId = -1;
    private static int buzzsawDestroyWidth = 5;
    private static int buzzsawDestroyHeight = 3;
    private static int buzzsawDestroyMaxDistance = buzzsawDestroyHeight + 1;
    private static int drillDestroyMaxDist = 10;
    public static boolean buzzsawIgnorePersistentLeaves;
    public static boolean ignorePersistentLeaves;
    private RenderableBlock lastBuzzsawRenderable;
    private Set<BlockPos> fullBuzzsawTreeBlockSet;
    private boolean buzzsawDidDestroy = false;
    public static float serverReachScaleMult;
    public static float buzzsawReachScale;
    public static float drillReachScale;
    public static boolean drillCanMineAxeBlocks;
    public static boolean drillCanMineShovelBlocks;
    public static float axeMineableSpeedScale;
    public static float shovelMineableSpeedScale;
    private boolean doDrillExtraReach = true;
    private boolean playedDrillSoundThisTick = false;
    private boolean playedBuzzsawSoundThisTick = false;
    private Map<BlockPos, MiningProgress> drillMiningProgressMap = new HashMap<BlockPos, MiningProgress>();
    private Map<BlockPos, MiningProgress> buzzsawMiningProgressMap = new HashMap<BlockPos, MiningProgress>();
    private int drillInactiveTicks = 0;
    private int localPlayerServerReminderIntervalTicks = 20;
    private int playerRemainCapturedTicks = 30;
    private static final double captureDistAbove = 3.5;
    private double xzEntityCaptureSize = 1.2;
    private Map<Integer, Integer> carriedPlayerLastCapturedTimestamp = new HashMap<Integer, Integer>();
    private boolean clientSendsCarriedReminders = true;
    private boolean hasDriverSeat = false;
    public boolean hasBuzzsaw = false;
    public boolean hasDrill = false;
    private int moveTreeDownTicks = -1;
    private static final int TICKS_TO_WAIT_BEFORE_MOVING_TREE = 3;
    private static boolean serverInflateBoundingBoxes;
    private static double serverBoundingBoxInflateFactor;
    private List<Entity> priorEntitiesList = new ArrayList<Entity>();
    public static int checkForNewEntitiesTickPeriod;
    private int lastCapturedTick = 0;
    public static Set<String> blacklistedProjectileKillEntities;
    public static Set<String> blacklistedCarryEntities;
    private static final long TIME_DIFFERENCE = 6000L;
    private static final long TIME_FULL_DAY = 24000L;
    private static final int TIME_UNITS_PER_MINUTE = 1000;
    private static final double TASKLIST_AUTO_CORRECT_DISTANCE = 1.3;
    private static final double TASKLIST_AUTO_CORRECT_DISTANCE_SQR = 1.6900000000000002;
    private static final double TASKLIST_AUTO_BRAKE_DISTANCE = 0.75;
    private static final double TASKLIST_AUTO_BRAKE_DISTANCE_SQR = 0.5625;
    private static final double NEED_TO_BRAKE_LENGTH = 0.01;
    private static final double NEED_TO_BRAKE_LENGTH_SQR = 1.0E-4;
    private static final double ARREST_MOVEMENT_DIST = 0.25;
    private static final double ARREST_MOVEMENT_DIST_SQR = 0.0625;
    private static final double ARREST_MOVEMENT_SPEED = 0.1;
    private boolean executingActionList = false;
    public static boolean playerTemporarilyIgnoreCollision;
    private int currentTaskIndex = -1;
    private List<TaskItem> currentTaskList = null;
    private TaskItem currentTask = null;
    private TaskElement currentTaskListElement = null;
    private boolean useDiagonalsForUnloadIntoChest = true;
    public static int unloadIntoChestDistanceMultiplier;
    private boolean useTimeForStopping = false;
    private boolean useArrestMovement = true;
    public static boolean autoKillAllNpcProjectiles;
    public static boolean drillKillsFallingBlock;
    public static boolean killProjectilesUsingMixin;
    public static boolean localPlayerBeingCarriedByDummy;
    public static boolean updateInProgress;
    public static Vec3 dummyMovementVec;
    public static float pilotingWindshieldDistance;
    private static final float FORWARD_SPEED = 0.25f;
    private static final float FORWARD_SPEED_PILOTED_BONUS_ACCELERATION = 0.04f;
    private static final float FORWARD_SPEED_PILOTED_MULT = 9.0f;
    private static final float PILOTED_ASCENT = 0.3f;
    private static final float PILOTED_DESCENT = -0.3f;
    private static final float ROTATION_CLAMP_MOUNTED_GUN_VERTICAL = 55.0f;
    private static final float ROTATION_CLAMP_MOUNTED_GUN_HORZ = 80.0f;
    private static final float ROTATION_CLAMP = 140.0f;
    private static final float ROTATION_CLAMP_VILLAGER = 95.0f;
    private static final double AUTO_BRAKE_THRESHOLD = 0.015;
    private static final double AUTO_BRAKE_THRESHOLD_SQR = 2.25E-4;
    private static final double MAX_SPEED_GROUNDED_BOAT = 0.11000000000000001;
    private static final double MAX_SPEED_GROUNDED_BOAT_SQR = 0.012100000000000003;
    private static final double MAX_SPEED_GROUNDED_AIRSHIP = 0.4;
    private static final double MAX_SPEED_GROUNDED_AIRSHIP_SQR = 0.16000000000000003;
    private float minimumTurnSpeedPctPlayer = 0.75f;
    private float minimumTurnSpeedPctVillager = 0.75f;
    public static List<Player> newlyLoggedIn;
    public static DummyEntity currentlyTickingDummyEntity;
    public boolean blockEntityTickInProgress = false;
    public static double MIN_SPEED_FOR_TAKEOFF;
    public static double MIN_SPEED_FOR_TAKEOFF_SQR;
    public static float planeAscentAccelScaleFactor;
    public static float planeAscentSpeedScaleFactor;
    public static float TAKEOFF_ASCENT_VALUE;
    public static float TAKEOFF_ASCENT_MAX_VALUE;
    public static boolean enableBlockEntitiesOnboard;
    private int lastCarriedTickTimestamp = 0;
    private int currentTickTimestamp = 0;
    public Vec3 metricsUpdatePosition = null;
    public Vec3 positionLastTick = null;
    public float yRotLastTick = -400.0f;
    public Set<Integer> carried = new HashSet<Integer>();
    private int noneCarriedAutoBrakeTickCount = 30;
    private int inAirTicks = 0;
    private int onGroundTicks = 0;
    private boolean onGroundInternal = false;
    private int soundTicksLeft = 0;
    private float GROUNDED_AIRSHIP_ACCEL_MULT_PLANE_ONLY = 0.7f;
    private float GROUNDED_AIRSHIP_ACCEL_MULT = 0.4f;
    private int fwdCommandActiveTicks = 0;
    private int ascendTicksRequiredForTakeoff = 15;
    private int ascendTicksRequiredForJetTakeoff = 8;
    public int ascendingTicks = 0;
    public double lastHorizontalSpeed = 0.0;
    public double currentHorizontalSpeed = 0.0;
    public boolean hasForwardMotion = true;
    private boolean forceCollision = false;
    public static boolean usePlayerGradualTurning;
    private static float playerFlyerTurnValueIncreaseMagnitude;
    boolean usePlayerFlyerPercentageDecay = false;
    private static float playerFlyerTurnDecayFactorMin;
    private static float playerFlyerTurnDecayFactorMax;
    private static float playerFlyerTurnAdditiveDecay;
    private static float playerFlyerTurnValue;
    public static float turningScaleForPlayerFlyerMin;
    public static float turningScaleForPlayerFlyerMax;
    private static float playerFlyerFreeFlightPitchValue;
    public static float turningScaleForBalloon;
    public static float turningScaleForSportTire;
    public static float turningScaleForJetThruster;
    public static float turningScaleForSailboat;
    public static float turningScaleGeneric;
    private int clientIgnitionSoundTicks = 0;
    private int clientCarIdleSoundTicks = 0;
    private boolean hasRotationCollision;
    private boolean everUpdatedMetrics = false;
    public boolean strafeLeft;
    public boolean strafeRight;
    private boolean oneTime_createdBlockEntities;
    private boolean everUpdatedFuelMetrics = false;
    public float observedYRotAccumulator = 0.0f;
    public static float drillSoundVolume;
    public static float buzzsawSoundVolume;
    private static float reverseSpeedFactor;
    public static boolean enableHelicopterHoverSound;
    public static boolean useOldHelicopterHoverSound;
    public static float helicopterHoverSoundVolume;
    public static float engineSoundVolume;
    public static boolean terminalVisibleWhilePiloted;
    public static boolean doBatchRendering;
    public static boolean disableBatchRenderingDuringOutline;
    public static boolean showOutlineWarningMessage;
    private int ENGINE_SOUND_PERSIST_DURATION_TICKS = 100;
    private int persistentIdleSoundTicks = 0;
    private Double groundHeightY = null;
    private Double groundedRenderableY = null;
    public static float FURNANCE_BURN_TIME_MULT;
    public static int FURNANCE_BURN_TIME_MAX_SECONDS;
    public static int REFINED_OIL_BURN_MINUTES;
    private long metrics_ticksConsumingFuel = 0L;
    private long metrics_timeUntilEmptyTicks = 0L;
    private List<RenderableBlock> engineBlocksCachedForOneTick = null;
    private static boolean modifyHoverName;
    protected int lerpSteps;
    protected double lerpX;
    protected double lerpY;
    protected double lerpZ;
    protected double lerpYRot;
    protected double lerpXRot;
    private float strafeSpeed = 0.0f;
    private boolean collisionResponseCanBounce = false;
    private float collisionCheckStepUp = 1.2f;
    private float stepUpYIncrease = 1.0f;
    private boolean horizontalCollisionStepUp = false;
    private WaterColliderEntity waterCollider = null;
    public boolean recentlyChangedPilotingStaus = false;
    private boolean shrinkSmallHitboxes = true;
    private boolean collisionResponseStopMoving;
    public static boolean useComplexCollisionProperty;
    private boolean useComplexCollision = false;
    private double blockCollisionInflation = -0.15;
    private AABB lastAabbAll = null;
    private AABB lastAabbCollidersOnly = null;
    public boolean doneWithSetup = false;
    private static boolean dummyShouldScanForPreexisting;
    public static final float ENTITY_SHAKE_VALUE = 5.0f;
    public static final float ENTITY_TWITCH_MAX = 15.0f;
    private Entity entityCopy = null;
    public VehicleType vehicleType = VehicleType.HELICOPTER;
    public static Set<BlockPos> blockPosToRemoveForAssembly;
    public static boolean allowMissingBlocksDuringReassembly;
    public static boolean assemblyInProgress;

    public float getMountedGunInitialParentAngle() {
        return this.mountedGunInitialParentAngle;
    }

    public void setMountedGunInitialParentAngle(float mountedGunInitialParentAngle) {
        this.mountedGunInitialParentAngle = mountedGunInitialParentAngle;
    }

    public boolean isDigitized() {
        return this.digitized;
    }

    public void setDigitized(boolean digitized) {
        this.digitized = digitized;
    }

    public String getShipName() {
        return (String)this.f_19804_.m_135370_(SHIP_NAME);
    }

    public void setMetric_CreationDate(String text) {
        this.f_19804_.m_135381_(METRICS_CREATION_DATE, (Object)text);
    }

    public void setMetric_CreatorName(String text) {
        this.f_19804_.m_135381_(METRICS_CREATOR_NAME, (Object)text);
    }

    public void setMetric_BlocksTravelled(long in) {
        this.f_19804_.m_135381_(METRICS_BLOCKS_TRAVELLED, (Object)in);
    }

    public void setMetric_TimeSpentConsumingFuel(long in) {
        this.f_19804_.m_135381_(METRICS_TIME_SPENT_CONSUMING_FUEL_SEC, (Object)in);
    }

    public void setMetric_TimeUntilEmpty(long in) {
        this.f_19804_.m_135381_(METRICS_TIME_UNTIL_EMPTY_SEC, (Object)in);
    }

    public long getMetric_BlocksTravelled() {
        return (Long)this.f_19804_.m_135370_(METRICS_BLOCKS_TRAVELLED);
    }

    public long getMetric_TimeSpentConsumingFuel() {
        return (Long)this.f_19804_.m_135370_(METRICS_TIME_SPENT_CONSUMING_FUEL_SEC);
    }

    public long getMetric_TimeUntilEmpty() {
        return (Long)this.f_19804_.m_135370_(METRICS_TIME_UNTIL_EMPTY_SEC);
    }

    public String getMetric_CreationDate() {
        return (String)this.f_19804_.m_135370_(METRICS_CREATION_DATE);
    }

    public String getMetric_CreatorName() {
        return (String)this.f_19804_.m_135370_(METRICS_CREATOR_NAME);
    }

    public void setShipName(String shipName) {
        this.updateDefaultNameStatus();
        this.f_19804_.m_135381_(SHIP_NAME, (Object)shipName);
    }

    private void updateDefaultNameStatus() {
        String shipName = this.getShipName();
        this.hasDefaultName = shipName.equals("Unnamed");
    }

    public Component m_7770_() {
        if (this.isNotShip()) {
            return null;
        }
        return Component.m_237113_((String)this.getShipName());
    }

    public boolean m_20151_() {
        if (this.isNotShip()) {
            return false;
        }
        if (this.m_146895_() == null) {
            return !this.hasDefaultName;
        }
        return false;
    }

    public static void clearDummiesGlobal() {
        LOGGER.debug("Clear dummies global");
        dummiesGlobal.clear();
    }

    public static DummyEntity getNearestDummyEntity(Entity e) {
        DummyEntity closest = null;
        List<DummyEntity> allDummies = DummyEntity.getAllDummies(e.m_9236_());
        if (allDummies != null && allDummies.size() > 0) {
            closest = allDummies.get(0);
            double leastDistSqr = allDummies.get(0).m_20280_(e);
            for (DummyEntity dummyEntity : allDummies) {
                double distSqr = dummyEntity.m_20280_(e);
                if (!(distSqr < leastDistSqr)) continue;
                leastDistSqr = distSqr;
                closest = dummyEntity;
            }
        }
        return closest;
    }

    public static DummyEntity getNearestDummyEntityConsideringBoundingBox(Entity e) {
        DummyEntity closest = null;
        List<DummyEntity> allDummies = DummyEntity.getAllDummies(e.m_9236_());
        if (allDummies != null && allDummies.size() > 0) {
            ArrayList<DummyEntity> dummiesToConsider = new ArrayList<DummyEntity>();
            for (DummyEntity dummyEntity : allDummies) {
                if (!dummyEntity.entityIsNearby(e)) continue;
                dummiesToConsider.add(dummyEntity);
            }
            if (dummiesToConsider.isEmpty()) {
                return DummyEntity.getNearestDummyEntity(e);
            }
            closest = (DummyEntity)((Object)dummiesToConsider.get(0));
            double leastDistSqr = ((DummyEntity)((Object)dummiesToConsider.get(0))).m_20280_(e);
            for (DummyEntity dummyEntity : dummiesToConsider) {
                double distSqr = dummyEntity.m_20280_(e);
                if (!(distSqr < leastDistSqr)) continue;
                leastDistSqr = distSqr;
                closest = dummyEntity;
            }
        }
        return closest;
    }

    public static List<DummyEntity> getAllDummies(Level level) {
        int entityLevelClass;
        if (!invalidateCachedDummyListClient && level.f_46443_ && cachedDummiesClient != null) {
            return cachedDummiesClient;
        }
        if (!invalidateCachedDummyListServer && !level.f_46443_ && cachedDummiesServer != null) {
            return cachedDummiesServer;
        }
        ArrayList<DummyEntity> dummyList = new ArrayList<DummyEntity>();
        int n = entityLevelClass = level instanceof ServerLevel ? 1 : 0;
        if (dummiesGlobal != null) {
            for (DummyEntityHolder holder : dummiesGlobal) {
                if (holder == null || holder.dummy == null || holder.levelClass != entityLevelClass || holder.dummy == null || holder.dummy.m_213877_() || holder.dummy.isNotShip()) continue;
                dummyList.add(holder.dummy);
            }
        }
        if (!level.f_46443_) {
            cachedDummiesServer = dummyList;
            invalidateCachedDummyListServer = false;
        } else {
            cachedDummiesClient = dummyList;
            invalidateCachedDummyListClient = false;
        }
        LOGGER.debug("Computed new cached dummy list of size=" + dummyList.size());
        return dummyList;
    }

    public static DummyEntity getDummyEntityForCarried(Entity e) {
        if (e == null) {
            return null;
        }
        boolean entityLevelClass = e.m_9236_() instanceof ServerLevel;
        List<DummyEntity> dummies = DummyEntity.getAllDummies(e.m_9236_());
        for (DummyEntity dummy : dummies) {
            if (dummy.carried == null || !dummy.carried.contains(e.m_19879_())) continue;
            return dummy;
        }
        return null;
    }

    public DummyEntity(EntityType<?> p_i48580_1_, Level p_i48580_2_) {
        super(p_i48580_1_, p_i48580_2_);
    }

    public void loadSavedData() {
        if (this.uniqueId > 0L) {
            this.shipRenderableStorage.readAllRecordsFromFile(this.uniqueId, this);
            if (this.renderables == null || this.renderables.isEmpty()) {
                LOGGER.warn("renderables list was empty!");
            } else {
                LOGGER.debug("got renderable count=" + this.renderables.size());
            }
        }
    }

    public void saveData() {
        if (this.uniqueId > 0L) {
            LOGGER.debug("saving renderable count=" + this.renderables.size());
            this.shipRenderableStorage.saveAllRecordsToFile(this.uniqueId, this);
            try {
                this.shipRenderableStorage.saveMetadataToFile(this.uniqueId, this);
            }
            catch (Exception e) {
                LOGGER.error("Got error saving metadata!", (Throwable)e);
            }
        }
    }

    public static TeleportLocation getTeleportLocationForDummyByUniqueId(Level level, long uniqueId) {
        boolean entityLevelClass = level instanceof ServerLevel;
        DummyEntity existing = null;
        List<DummyEntity> dummies = DummyEntity.getAllDummies(level);
        for (DummyEntity dummy : dummies) {
            if (dummy.uniqueId != uniqueId) continue;
            LOGGER.debug("Found existing loaded entity=" + dummy);
            existing = dummy;
            break;
        }
        LOGGER.debug("Checking metadata for teleport location for uniqueId=" + uniqueId + " with level=" + level);
        List<ShipRenderableStorage.RecordMetadata> records = ShipRenderableStorage.readMetadataFromFile();
        for (ShipRenderableStorage.RecordMetadata record : records) {
            if (record.uniqueId != uniqueId) continue;
            Vec3 pos = record.pos;
            if (existing == null) {
                LOGGER.debug("Entity did not exist, searching...");
                AABB aabb = AABB.m_165882_((Vec3)pos, (double)10.0, (double)10.0, (double)10.0);
                List candidates = level.m_45976_(DummyEntity.class, aabb);
                for (DummyEntity entity : candidates) {
                    if (entity.uniqueId != uniqueId) continue;
                    LOGGER.debug("Found entity match at pos=" + entity.m_20182_());
                    existing = entity;
                    break;
                }
            }
            Vec3 entityLocation = null;
            float yRotDiff = 0.0f;
            float yRot = 0.0f;
            boolean digitized = false;
            Level destLevel = null;
            if (existing != null) {
                entityLocation = existing.m_20182_();
                yRotDiff = existing.getYRotDiff();
                yRot = existing.m_146908_();
                digitized = existing.isDigitized();
                destLevel = existing.m_9236_();
                LOGGER.debug("Got entity location of " + entityLocation);
            } else {
                LOGGER.debug("No matching entity, using last known position of " + record.pos);
                entityLocation = record.pos;
                yRotDiff = record.yRotDiff;
                yRot = record.yRot;
                digitized = record.digitized == 1;
                destLevel = ShipRenderableStorage.levelFromDimensionName(record.dimension);
            }
            TeleportLocation tele = new TeleportLocation();
            Vec3 teleporterAbsolute = entityLocation.m_82549_(record.teleporterRelativeOffset);
            Vec3 revolved = XenoTechUtils.revolve(new Point2D.Double(entityLocation.f_82479_, entityLocation.f_82481_), yRotDiff, teleporterAbsolute);
            tele.loc = revolved.m_82520_(0.0, 0.05, 0.0);
            if (record.teleporterRelativeOffset.f_82479_ == 0.0 && record.teleporterRelativeOffset.f_82480_ == 0.0 && record.teleporterRelativeOffset.f_82481_ == 0.0) {
                tele.loc = null;
            }
            if (record.direction == 110) {
                tele.direction = Direction.NORTH;
            } else if (record.direction == 101) {
                tele.direction = Direction.EAST;
            } else if (record.direction == 115) {
                tele.direction = Direction.SOUTH;
            } else if (record.direction == 119) {
                tele.direction = Direction.WEST;
            }
            if (record.yRotDiff != 0.0f && tele.direction != null) {
                tele.direction = Direction.m_252919_((Matrix4f)Axis.f_252392_.m_252977_(yRotDiff).get(new Matrix4f()), (Direction)tele.direction);
            }
            tele.entity = existing;
            tele.yRot = yRot;
            tele.digitized = digitized;
            tele.destLevel = destLevel;
            return tele;
        }
        return null;
    }

    public void loadFromNbt(CompoundTag tag) {
        if (tag != null && tag.m_128441_("UniqueId")) {
            block19: {
                this.uniqueId = tag.m_128454_("UniqueId");
                this.f_19804_.m_135381_(UNIQUE_ID, (Object)this.uniqueId);
                LOGGER.debug("LOAD: set uniqueId to " + this.uniqueId + " from NBT for entityId=" + this.m_19879_());
                this.loadSavedData();
                try {
                    if (tag.m_128441_("TaskList")) {
                        CompoundTag taskListTag = tag.m_128469_("TaskList");
                        TaskList taskList = new TaskList();
                        taskList.fromNbt(taskListTag, Optional.empty());
                        this.taskList = taskList;
                    }
                }
                catch (Exception ex) {
                    LOGGER.error("Error loading TaskList", (Throwable)ex);
                }
                try {
                    if (tag.m_128441_("CurrentTask")) {
                        CompoundTag currentTaskTag = tag.m_128469_("CurrentTask");
                        this.currentTask = TaskItem.fromNbt(currentTaskTag);
                        LOGGER.debug("Current task is: " + this.currentTask);
                    }
                }
                catch (Exception ex) {
                    LOGGER.error("Error loading CurrentTask", (Throwable)ex);
                }
                try {
                    if (!tag.m_128441_("CurrentTaskListElement")) break block19;
                    try {
                        String elementText = tag.m_128461_("CurrentTaskListElement");
                        this.currentTaskListElement = TaskElement.valueOf(elementText);
                        if (this.taskList != null) {
                            TaskItem eventTaskItem = TaskItem.event(this.currentTaskListElement);
                            this.currentTaskList = new ArrayList<TaskItem>();
                            this.currentTaskList = this.taskList.getTaskItemsForEvent(eventTaskItem);
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error("Error loading CurrentTaskListElement", (Throwable)e);
                    }
                }
                catch (Exception ex) {
                    LOGGER.error("Error loading CurrentTaskListElement", (Throwable)ex);
                }
            }
            if (tag.m_128441_("WantToBrake")) {
                this.wantToBrake = tag.m_128471_("WantToBrake");
            }
            if (tag.m_128441_("ReverseCommandActive")) {
                this.reverseCommandActive = tag.m_128471_("ReverseCommandActive");
            }
            if (tag.m_128441_("ForwardCommandActive")) {
                this.forwardCommandActive = tag.m_128471_("ForwardCommandActive");
            }
            if (tag.m_128441_("CurrentHorizontalSpeed")) {
                this.currentHorizontalSpeed = tag.m_128459_("CurrentHorizontalSpeed");
            }
            if (tag.m_128441_("CurrentTaskIndex")) {
                this.currentTaskIndex = tag.m_128451_("CurrentTaskIndex");
            }
            if (tag.m_128441_("ExecutingActionList")) {
                this.executingActionList = tag.m_128471_("executingActionList");
            }
            if (tag.m_128441_("YRotRequest")) {
                this.f_19804_.m_135381_(Y_ROT_REQUEST, (Object)Float.valueOf(tag.m_128457_("YRotRequest")));
            }
        }
    }

    public void saveToNbt(CompoundTag tag) {
        if (tag != null && this.uniqueId > 0L) {
            tag.m_128356_("UniqueId", this.uniqueId);
            LOGGER.debug("SAVE: save uniqueId to NBT as " + this.uniqueId + " for entityId=" + this.m_19879_());
            this.saveData();
            try {
                if (this.taskList != null) {
                    tag.m_128365_("TaskList", (Tag)this.taskList.toNbt());
                }
            }
            catch (Exception ex) {
                LOGGER.error("Error saving TaskList", (Throwable)ex);
            }
            try {
                if (this.currentTask != null) {
                    tag.m_128365_("CurrentTask", (Tag)this.currentTask.toNbt());
                }
            }
            catch (Exception ex) {
                LOGGER.error("Error saving CurrentTask", (Throwable)ex);
            }
            if (this.currentTaskListElement != null) {
                tag.m_128359_("CurrentTaskListElement", this.currentTaskListElement.name());
            }
            tag.m_128379_("WantToBrake", this.wantToBrake);
            tag.m_128379_("ReverseCommandActive", this.reverseCommandActive);
            tag.m_128379_("ForwardCommandActive", this.forwardCommandActive);
            tag.m_128347_("CurrentHorizontalSpeed", this.currentHorizontalSpeed);
            tag.m_128405_("CurrentTaskIndex", this.currentTaskIndex);
            tag.m_128379_("ExecutingActionList", this.executingActionList);
            tag.m_128350_("YRotRequest", this.getYRotRequest());
        }
    }

    public void m_20258_(CompoundTag tag) {
        super.m_20258_(tag);
        this.loadFromNbt(tag);
        this.f_19804_.m_135381_(RENDERABLE_BLOCKLIST, (Object)("load" + this.incrementer++));
    }

    public CompoundTag m_20240_(CompoundTag tag) {
        this.saveToNbt(tag);
        return super.m_20240_(tag);
    }

    protected float m_6380_(Pose pose, EntityDimensions dimensions) {
        return 1.62f;
    }

    public void digitize(ServerPlayer player) {
        this.setDigitized(true);
        this.saveData();
        for (Integer i : this.carried) {
            Entity e = this.m_9236_().m_6815_(i.intValue());
            if (!(e instanceof LivingEntity)) continue;
            LivingEntity living = (LivingEntity)e;
            living.m_7292_(new MobEffectInstance(MobEffects.f_19591_, 40, 1));
        }
        ItemStack toSpawn = new ItemStack((ItemLike)XenoBlocks.ITEM_DIGITIZED_SHIP.get());
        LOGGER.debug("digitized with uniqueId=" + this.uniqueId);
        toSpawn.m_41784_().m_128356_("UniqueId", this.uniqueId);
        String shipName = this.getShipName();
        if (shipName != null && !shipName.isBlank() && !shipName.equals("Unnamed")) {
            toSpawn.m_41783_().m_128359_("ShipName", shipName);
            toSpawn.m_41714_((Component)Component.m_237113_((String)("Digitized Ship: " + shipName)));
        }
        toSpawn.m_41783_().m_128356_("Metrics_BlocksTravelled", this.getMetric_BlocksTravelled());
        toSpawn.m_41783_().m_128356_("Metrics_TimeSpentConsumingFuel", this.getMetric_TimeSpentConsumingFuel());
        toSpawn.m_41783_().m_128356_("Metrics_TimeUntilEmpty", this.getMetric_TimeUntilEmpty());
        toSpawn.m_41783_().m_128359_("Metrics_CreationDate", this.getMetric_CreationDate());
        toSpawn.m_41783_().m_128359_("Metrics_CreatorName", this.getMetric_CreatorName());
        if (player != null && player.m_150109_().m_36062_() != -1) {
            player.m_36356_(toSpawn);
        } else {
            ItemEntity itemEntity = this.m_19983_(toSpawn);
            itemEntity.m_20242_(false);
            itemEntity.m_246865_(new Vec3(0.0, 0.2, 0.0));
        }
        this.m_6074_();
    }

    public Rotation getBlockStateRotationForDisassembly(float yRotInitial, float disassemblyRot) {
        float yRotDiff = disassemblyRot - yRotInitial;
        if (yRotDiff < 0.0f) {
            yRotDiff += 360.0f;
        }
        if (yRotDiff == 90.0f) {
            return Rotation.CLOCKWISE_90;
        }
        if (yRotDiff == 180.0f) {
            return Rotation.CLOCKWISE_180;
        }
        if (yRotDiff == 270.0f) {
            return Rotation.COUNTERCLOCKWISE_90;
        }
        return Rotation.NONE;
    }

    public float sanitizeAngle(float angle) {
        if ((angle %= 360.0f) < 0.0f) {
            angle += 360.0f;
        }
        return angle;
    }

    public float getSanitizedRotationAngle() {
        float yRot = this.m_146908_();
        return this.sanitizeAngle(yRot);
    }

    public float get90DegreeDisassemblyAngle() {
        float disassemblyRot = 90.0f * (float)((int)(this.getSanitizedRotationAngle() + 45.0f) / 90);
        if ((double)disassemblyRot == 360.0) {
            disassemblyRot = 0.0f;
        }
        return disassemblyRot;
    }

    public float getSanitizedYRotDiff() {
        float yRotDiff = this.getYRotDiff();
        return this.sanitizeAngle(yRotDiff);
    }

    public float get90DegreeReassemblyAngle() {
        float disassemblyRot = 90.0f * (float)((int)(this.getSanitizedYRotDiff() + 45.0f) / 90);
        if ((double)disassemblyRot == 360.0) {
            disassemblyRot = 0.0f;
        }
        return disassemblyRot;
    }

    public float get90DegreeStartingAngle() {
        float disassemblyRot = 90.0f * (float)((int)(this.getSanitizedStartingAngle() + 45.0f) / 90);
        if ((double)disassemblyRot == 360.0) {
            disassemblyRot = 0.0f;
        }
        return disassemblyRot;
    }

    public Float getDisassemblyRotation() {
        boolean canDisassemble = true;
        float yRotInitial = this.m_146908_();
        float yRot = this.getSanitizedRotationAngle();
        float disassemblyRot = this.get90DegreeDisassemblyAngle();
        LOGGER.debug("check for disassembly at angle=" + disassemblyRot + " for entity with yRot=" + this.m_146908_() + " and sanitized angle=" + yRot);
        this.m_146922_(disassemblyRot);
        canDisassemble = this.canDisassemble();
        if (!canDisassemble) {
            LOGGER.debug("check for disassembly at angle=" + (disassemblyRot += 90.0f));
            this.m_146922_(disassemblyRot);
            canDisassemble = this.canDisassemble();
        }
        if (!canDisassemble) {
            LOGGER.debug("check for disassembly at angle=" + (disassemblyRot += 90.0f));
            this.m_146922_(disassemblyRot);
            canDisassemble = this.canDisassemble();
        }
        if (!canDisassemble) {
            LOGGER.debug("check for disassembly at angle=" + (disassemblyRot += 90.0f));
            this.m_146922_(disassemblyRot);
            canDisassemble = this.canDisassemble();
        }
        this.m_146922_(yRotInitial);
        if (canDisassemble) {
            return Float.valueOf(this.sanitizeAngle(disassemblyRot));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canDisassemble() {
        this.disassemblyCheckInProgress = true;
        Vec3 initialPos = this.m_20182_();
        BlockPos initialBlockPos = BlockPos.m_274446_((Position)initialPos);
        Vec3 truncatedPos = new Vec3((double)initialBlockPos.m_123341_() + 0.5, (double)initialBlockPos.m_123342_(), (double)initialBlockPos.m_123343_() + 0.5);
        this.m_20343_(truncatedPos.f_82479_, truncatedPos.f_82480_, truncatedPos.f_82481_);
        try {
            for (RenderableBlock renderable : this.renderables) {
                Vec3 location;
                Vec3 roundedLocation = location = XenoTechUtils.revolve(this, new Vec3(renderable.absoluteX(this), renderable.absoluteY(this), renderable.absoluteZ(this)));
                BlockPos pos = XenoTechUtils.blockPosRotate(this, renderable.pos);
                BlockState state = this.m_9236_().m_8055_(pos);
                if (state.m_60713_(Blocks.f_50575_) || state.m_60713_(Blocks.f_50576_) || state.m_247087_()) continue;
                LOGGER.warn("disassembly is not possible due to block: " + state + " at position: " + pos);
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.m_20343_(initialPos.f_82479_, initialPos.f_82480_, initialPos.f_82481_);
            this.disassemblyCheckInProgress = false;
        }
    }

    public boolean disassemble() {
        LOGGER.debug("disassemble for uniqueId=" + this.uniqueId + " with entity=" + this);
        boolean canDisassemble = true;
        if (this.renderables != null && !this.renderables.isEmpty()) {
            Float disassemblyRot = this.getDisassemblyRotation();
            if (disassemblyRot == null) {
                canDisassemble = false;
            }
            if (canDisassemble) {
                this.saveData();
                Rotation rotation = this.getBlockStateRotationForDisassembly(this.getSanitizedStartingAngle(), disassemblyRot.floatValue());
                LOGGER.debug("disassembly begin for uniqueId=" + this.uniqueId + " with disassemblyRot=" + disassemblyRot + " vs startingAngle=" + this.getStartingAngle() + " with rotation=" + rotation);
                Vec3 initialPos = this.m_20182_();
                BlockPos initialBlockPos = BlockPos.m_274446_((Position)initialPos);
                Vec3 truncatedPos = new Vec3((double)initialBlockPos.m_123341_() + 0.5, (double)Math.round(initialPos.f_82480_), (double)initialBlockPos.m_123343_() + 0.5);
                this.m_20343_(truncatedPos.f_82479_, truncatedPos.f_82480_, truncatedPos.f_82481_);
                this.m_146922_(disassemblyRot.floatValue());
                LOGGER.debug("begin disassembly at location: " + truncatedPos);
                ArrayList<RenderableBlock> postponedBlocks = new ArrayList<RenderableBlock>();
                this.disassemblyInProgress = true;
                for (RenderableBlock renderable : this.renderables) {
                    if (this.isFaceAttachedBlock(renderable.pos, renderable.state)) {
                        postponedBlocks.add(renderable);
                        continue;
                    }
                    this.disassembleOneBlock(rotation, renderable);
                }
                if (!postponedBlocks.isEmpty()) {
                    LOGGER.debug("postponed disassembly for " + postponedBlocks.size() + " blocks");
                    for (RenderableBlock renderable : postponedBlocks) {
                        this.disassembleOneBlock(rotation, renderable);
                    }
                }
                this.teleportCarriedUpwards();
                this.giveCarriedTemporaryLevitation();
                LOGGER.debug("disassembly complete for uniqueId=" + this.uniqueId);
                this.disassemblyInProgress = false;
                this.m_6074_();
                return true;
            }
            return false;
        }
        LOGGER.warn("tried to assemble empty ship");
        return true;
    }

    private void disassembleOneBlock(Rotation rotation, RenderableBlock renderable) {
        Vec3 location = XenoTechUtils.revolve(this, new Vec3(renderable.absoluteX(this), renderable.absoluteY(this), renderable.absoluteZ(this)));
        LOGGER.debug("renderable: " + renderable + " at location=" + location);
        Vec3 roundedLocation = location;
        BlockPos pos = BlockPos.m_274446_((Position)roundedLocation);
        pos = XenoTechUtils.blockPosRotate(this, renderable.pos);
        LOGGER.debug("roundedLocation: " + roundedLocation + " making BlockPos=" + pos);
        BlockState state = this.m_9236_().m_8055_(pos);
        if (state.m_247087_() || state.m_60713_(Blocks.f_50575_) || state.m_60713_(Blocks.f_50576_)) {
            if (state.m_60713_(Blocks.f_50575_) || state.m_60713_(Blocks.f_50576_)) {
                this.m_9236_().m_46961_(pos, true);
            }
            BlockState rotatedState = renderable.state;
            try {
                rotatedState = renderable.state.m_60717_(rotation);
            }
            catch (Exception ex) {
                LOGGER.error("Got error rotating state: " + renderable.state, (Throwable)ex);
            }
            if (rotatedState.m_61138_((Property)BlockStateProperties.f_61362_)) {
                rotatedState = this.m_9236_().m_6425_(pos).m_192917_((Fluid)Fluids.f_76193_) ? (BlockState)rotatedState.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(true)) : (BlockState)rotatedState.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false));
            }
            this.m_9236_().m_7731_(pos, rotatedState, 2);
            BlockEntity blockEntity = this.m_9236_().m_7702_(pos);
            if (blockEntity != null) {
                if (renderable.tag != null) {
                    LOGGER.debug("load tag for state=" + renderable.state + ": " + renderable.tag);
                    blockEntity.m_142466_(renderable.tag);
                    if (blockEntity instanceof MountedGunBlockEntity) {
                        MountedGunBlockEntity mgb = (MountedGunBlockEntity)blockEntity;
                        mgb.renderable = null;
                    }
                }
                if (rotatedState.m_60713_((Block)XenoBlocks.BLOCK_SHIP_TERMINAL.get()) && blockEntity instanceof ShipTerminalBlockEntity) {
                    ShipTerminalBlockEntity terminalEntity = (ShipTerminalBlockEntity)blockEntity;
                    LOGGER.debug("assign reassemblyUniqueId=" + this.uniqueId);
                    terminalEntity.reassemblyUniqueId = this.uniqueId;
                    terminalEntity.metricsBlocksTravelled = this.getMetric_BlocksTravelled();
                    terminalEntity.metricsTimeSpentConsumingFuelSec = this.getMetric_TimeSpentConsumingFuel();
                    terminalEntity.metricsTimeUntilEmptySec = this.getMetric_TimeUntilEmpty();
                    terminalEntity.metricsCreationDate = this.getMetric_CreationDate();
                    terminalEntity.metricsCreatorName = this.getMetric_CreatorName();
                }
                blockEntity.m_58904_().markAndNotifyBlock(blockEntity.m_58899_(), blockEntity.m_58904_().m_46745_(blockEntity.m_58899_()), blockEntity.m_58900_(), blockEntity.m_58900_(), 2, 0);
                blockEntity.m_6596_();
            }
        }
    }

    private void teleportCarriedUpwards() {
        for (Integer carriedId : this.carried) {
            Entity e = this.m_9236_().m_6815_(carriedId.intValue());
            if (!(e instanceof LivingEntity)) continue;
            LivingEntity living = (LivingEntity)e;
            living.m_20343_(living.m_20185_(), living.m_20186_() + 0.4, living.m_20189_());
            if (!(living instanceof ServerPlayer)) continue;
            ServerPlayer player = (ServerPlayer)living;
            player.f_8906_.m_9774_(player.m_20185_(), player.m_20186_(), player.m_20189_(), player.m_146908_(), player.m_146909_());
        }
    }

    private void giveCarriedTemporaryLevitation() {
        for (Integer carriedId : this.carried) {
            Entity e = this.m_9236_().m_6815_(carriedId.intValue());
            if (!(e instanceof LivingEntity)) continue;
            LivingEntity living = (LivingEntity)e;
            living.m_7292_(new MobEffectInstance(MobEffects.f_19620_, 10, 255));
        }
    }

    public static void addUniqueGlobalDummy(DummyEntityHolder holder) {
        if (dummiesGlobal.add(holder)) {
            LOGGER.debug("new unique global dummy added: " + holder + " with uniqueId=" + (Serializable)(holder.dummy != null ? Long.valueOf(holder.dummy.uniqueId) : "?"));
            invalidateCachedDummyListServer = true;
            invalidateCachedDummyListClient = true;
        }
    }

    public void onAddedToWorld() {
        this.thisHolder = new DummyEntityHolder(this);
        if (!this.isNotShip()) {
            DummyEntity.addUniqueGlobalDummy(this.thisHolder);
        }
        super.onAddedToWorld();
    }

    public void setStartingAngle(float startingAngle) {
        this.f_19804_.m_135381_(STARTING_ANGLE, (Object)Float.valueOf(startingAngle));
    }

    public float getStartingAngle() {
        return ((Float)this.f_19804_.m_135370_(STARTING_ANGLE)).floatValue();
    }

    public float getSanitizedStartingAngle() {
        return this.sanitizeAngle(this.getStartingAngle());
    }

    public float getYRotDiff() {
        float diff = this.m_146908_() - ((Float)this.f_19804_.m_135370_(STARTING_ANGLE)).floatValue();
        return diff;
    }

    public float getInterpYRotDiff(float partialTick) {
        float yRotPartial = (this.m_146908_() - this.f_19859_) * partialTick;
        float diff = this.f_19859_ + yRotPartial - ((Float)this.f_19804_.m_135370_(STARTING_ANGLE)).floatValue();
        return diff;
    }

    public float yRotForRender(float yRotInput) {
        float diff = yRotInput - ((Float)this.f_19804_.m_135370_(STARTING_ANGLE)).floatValue();
        return diff;
    }

    public float getYRotRequest() {
        return ((Float)this.f_19804_.m_135370_(Y_ROT_REQUEST)).floatValue();
    }

    @Nullable
    private boolean isUnderwater(AABB toCheck) {
        AABB aabb = toCheck;
        double d0 = aabb.f_82292_ + 0.001;
        int i = Mth.m_14107_((double)aabb.f_82288_);
        int j = Mth.m_14165_((double)aabb.f_82291_);
        int k = Mth.m_14107_((double)aabb.f_82292_);
        int l = Mth.m_14165_((double)d0);
        int i1 = Mth.m_14107_((double)aabb.f_82290_);
        int j1 = Mth.m_14165_((double)aabb.f_82293_);
        boolean flag = false;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    blockpos$mutableblockpos.m_122178_(k1, l1, i2);
                    FluidState fluidstate = this.m_9236_().m_6425_((BlockPos)blockpos$mutableblockpos);
                    if (!fluidstate.m_205070_(FluidTags.f_13131_) || !(d0 < (double)((float)blockpos$mutableblockpos.m_123342_() + fluidstate.m_76155_((BlockGetter)this.m_9236_(), (BlockPos)blockpos$mutableblockpos)))) continue;
                    if (!fluidstate.m_76170_()) {
                        return true;
                    }
                    flag = true;
                }
            }
        }
        return flag;
    }

    public float getGroundFriction() {
        AABB aabb = this.m_20191_();
        AABB aabb1 = new AABB(aabb.f_82288_, aabb.f_82289_ - 0.001, aabb.f_82290_, aabb.f_82291_, aabb.f_82289_, aabb.f_82293_);
        int i = Mth.m_14107_((double)aabb1.f_82288_) - 1;
        int j = Mth.m_14165_((double)aabb1.f_82291_) + 1;
        int k = Mth.m_14107_((double)aabb1.f_82289_) - 1;
        int l = Mth.m_14165_((double)aabb1.f_82292_) + 1;
        int i1 = Mth.m_14107_((double)aabb1.f_82290_) - 1;
        int j1 = Mth.m_14165_((double)aabb1.f_82293_) + 1;
        VoxelShape voxelshape = Shapes.m_83064_((AABB)aabb1);
        float f = 0.0f;
        int k1 = 0;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int l1 = i; l1 < j; ++l1) {
            for (int i2 = i1; i2 < j1; ++i2) {
                int j2 = (l1 != i && l1 != j - 1 ? 0 : 1) + (i2 != i1 && i2 != j1 - 1 ? 0 : 1);
                if (j2 == 2) continue;
                for (int k2 = k; k2 < l; ++k2) {
                    if (j2 > 0 && (k2 == k || k2 == l - 1)) continue;
                    blockpos$mutableblockpos.m_122178_(l1, k2, i2);
                    BlockState blockstate = this.m_9236_().m_8055_((BlockPos)blockpos$mutableblockpos);
                    if (blockstate.m_60734_() instanceof WaterlilyBlock || !Shapes.m_83157_((VoxelShape)blockstate.m_60812_((BlockGetter)this.m_9236_(), (BlockPos)blockpos$mutableblockpos).m_83216_((double)l1, (double)k2, (double)i2), (VoxelShape)voxelshape, (BooleanOp)BooleanOp.f_82689_)) continue;
                    f += blockstate.getFriction((LevelReader)this.m_9236_(), (BlockPos)blockpos$mutableblockpos, (Entity)this);
                    ++k1;
                }
            }
        }
        return f / (float)k1;
    }

    private boolean checkInWater(AABB toCheck) {
        AABB aabb = toCheck;
        int i = Mth.m_14107_((double)aabb.f_82288_);
        int j = Mth.m_14165_((double)aabb.f_82291_);
        int k = Mth.m_14107_((double)aabb.f_82289_);
        int l = Mth.m_14165_((double)aabb.f_82292_);
        int i1 = Mth.m_14107_((double)aabb.f_82290_);
        int j1 = Mth.m_14165_((double)aabb.f_82293_);
        boolean flag = false;
        this.waterLevel = -1.7976931348623157E308;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int k1 = i; k1 < j; ++k1) {
            for (int y = k; y < l; ++y) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    blockpos$mutableblockpos.m_122178_(k1, y, i2);
                    FluidState fluidstate = this.m_9236_().m_6425_((BlockPos)blockpos$mutableblockpos);
                    if (!fluidstate.m_205070_(FluidTags.f_13131_)) continue;
                    float f = (float)y + fluidstate.m_76155_((BlockGetter)this.m_9236_(), (BlockPos)blockpos$mutableblockpos);
                    this.waterLevel = Math.max((double)f, this.waterLevel);
                    flag |= aabb.f_82289_ < (double)f;
                }
            }
        }
        return flag;
    }

    public float getWaterLevelAbove(AABB toCheck) {
        AABB aabb = toCheck;
        int i = Mth.m_14107_((double)aabb.f_82288_);
        int j = Mth.m_14165_((double)aabb.f_82291_);
        int k = Mth.m_14107_((double)aabb.f_82292_);
        int l = Mth.m_14165_((double)(aabb.f_82292_ - this.lastYd));
        int i1 = Mth.m_14107_((double)aabb.f_82290_);
        int j1 = Mth.m_14165_((double)aabb.f_82293_);
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        block0: for (int k1 = k; k1 < l; ++k1) {
            float f = 0.0f;
            for (int l1 = i; l1 < j; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    blockpos$mutableblockpos.m_122178_(l1, k1, i2);
                    FluidState fluidstate = this.m_9236_().m_6425_((BlockPos)blockpos$mutableblockpos);
                    if (fluidstate.m_205070_(FluidTags.f_13131_)) {
                        f = Math.max(f, fluidstate.m_76155_((BlockGetter)this.m_9236_(), (BlockPos)blockpos$mutableblockpos));
                    }
                    if (f >= 1.0f) continue block0;
                }
            }
            if (!(f < 1.0f)) continue;
            return (float)blockpos$mutableblockpos.m_123342_() + f;
        }
        return l + 1;
    }

    public boolean intersectsX(AABB first, AABB second) {
        return first.f_82291_ > second.f_82288_ && first.f_82291_ < second.f_82291_ || first.f_82288_ > second.f_82288_ && first.f_82288_ < second.f_82291_;
    }

    public boolean intersectsY(AABB first, AABB second) {
        return first.f_82292_ > second.f_82288_ && first.f_82291_ < second.f_82291_ || first.f_82288_ > second.f_82288_ && first.f_82288_ < second.f_82291_;
    }

    public boolean intersectsZ(AABB first, AABB second) {
        return first.f_82293_ > second.f_82290_ && first.f_82293_ < second.f_82293_ || first.f_82290_ > second.f_82290_ && first.f_82290_ < second.f_82293_;
    }

    public void refreshCaptureTimestampForPlayer(Entity e) {
        this.carriedPlayerLastCapturedTimestamp.put(e.m_19879_(), this.f_19797_);
    }

    private boolean addToChest(List<ItemStack> itemStacks) {
        for (RenderableBlock renderable : this.renderables) {
            if (!this.isValidOnboardContainer(renderable) || !this.addToSpecificContainer(itemStacks, (Container)renderable.tempBlockEntity)) continue;
            return true;
        }
        return false;
    }

    private boolean addToSpecificContainer(List<ItemStack> itemStacks, Container container) {
        ItemStack itemStack2;
        int k;
        ArrayList<Integer> airSlots = new ArrayList<Integer>();
        HashMap<Integer, List> itemStackIndexToChestSlots = new HashMap<Integer, List>();
        List itemStackCopy = itemStacks.stream().map(itemStack -> itemStack.m_41777_()).collect(Collectors.toList());
        itemStackIndexToChestSlots.clear();
        airSlots.clear();
        int containerSize = container.m_6643_();
        for (int i = 0; i < containerSize; ++i) {
            ItemStack chestItem = container.m_8020_(i);
            if (chestItem.m_41619_()) {
                airSlots.add(i);
                continue;
            }
            for (k = 0; k < itemStackCopy.size(); ++k) {
                itemStack2 = (ItemStack)itemStackCopy.get(k);
                if (itemStack2.m_41619_() || !ItemStack.m_150942_((ItemStack)chestItem, (ItemStack)itemStack2) || chestItem.m_41613_() >= chestItem.m_41741_()) continue;
                int diff = Math.min(itemStack2.m_41613_(), chestItem.m_41741_() - chestItem.m_41613_());
                itemStack2.m_41774_(diff);
                itemStackIndexToChestSlots.computeIfAbsent(k, key -> new ArrayList()).add(i);
            }
        }
        long emptyCount = itemStackCopy.stream().filter(itemStack -> itemStack.m_41619_()).count();
        if (emptyCount > 0L) {
            long remainingCount = (long)itemStackCopy.size() - emptyCount;
            if ((long)airSlots.size() >= remainingCount) {
                itemStackIndexToChestSlots.forEach((itemStackIndex, chestSlots) -> {
                    ItemStack itemStack = (ItemStack)itemStacks.get((int)itemStackIndex);
                    for (int i = 0; i < chestSlots.size(); ++i) {
                        int chestSlot = (Integer)chestSlots.get(i);
                        ItemStack chestItem = container.m_8020_(chestSlot);
                        int diff = Math.min(itemStack.m_41613_(), chestItem.m_41741_() - chestItem.m_41613_());
                        itemStack.m_41774_(diff);
                        int newCount = chestItem.m_41613_() + diff;
                        chestItem.m_41764_(newCount);
                    }
                });
                int freeSlotIndex = 0;
                for (int k2 = 0; k2 < itemStacks.size(); ++k2) {
                    ItemStack itemStack3 = itemStacks.get(k2);
                    if (itemStack3.m_41619_()) continue;
                    int airSlot = (Integer)airSlots.get(freeSlotIndex++);
                    container.m_6836_(airSlot, itemStack3);
                }
                container.m_6596_();
                return true;
            }
        } else if (airSlots.size() >= itemStacks.size()) {
            for (k = 0; k < itemStacks.size(); ++k) {
                itemStack2 = itemStacks.get(k);
                int airSlot = (Integer)airSlots.get(k);
                container.m_6836_(airSlot, itemStack2);
            }
            return true;
        }
        return false;
    }

    private void moveTreeDown(RenderableBlock renderable, Set<BlockPos> treeBlocks) {
        this.buzzsawLeafSet.clear();
        if (treeBlocks.isEmpty()) {
            return;
        }
        LinkedList<BlockPos> queue = new LinkedList<BlockPos>();
        for (BlockPos pos : treeBlocks) {
            queue.add(pos);
        }
        treeBlocks = new LinkedHashSet<BlockPos>();
        this.isProbablyATree = true;
        this.moveTreeDownVisitedCount = 0;
        while (!queue.isEmpty()) {
            BlockPos pos = (BlockPos)queue.poll();
            ++this.moveTreeDownVisitedCount;
            BlockPos northPos = pos.m_122012_();
            BlockPos eastPos = pos.m_122029_();
            BlockPos southPos = pos.m_122019_();
            BlockPos westPos = pos.m_122024_();
            BlockPos abovePos = pos.m_7494_();
            BlockPos belowPos = pos.m_7495_();
            BlockState northState = this.m_9236_().m_8055_(northPos);
            BlockState eastState = this.m_9236_().m_8055_(eastPos);
            BlockState southState = this.m_9236_().m_8055_(southPos);
            BlockState westState = this.m_9236_().m_8055_(westPos);
            BlockState aboveState = this.m_9236_().m_8055_(abovePos);
            BlockState belowState = this.m_9236_().m_8055_(belowPos);
            this.moveTreeVisitNode(treeBlocks, queue, northPos, northState);
            this.moveTreeVisitNode(treeBlocks, queue, eastPos, eastState);
            this.moveTreeVisitNode(treeBlocks, queue, southPos, southState);
            this.moveTreeVisitNode(treeBlocks, queue, westPos, westState);
            this.moveTreeVisitNode(treeBlocks, queue, abovePos, aboveState);
            this.moveTreeVisitNode(treeBlocks, queue, belowPos, belowState);
            if (this.considerDiagonalsForMoveTree) {
                BlockPos nePos = pos.m_122012_().m_122029_();
                BlockPos nwPos = pos.m_122012_().m_122024_();
                BlockPos sePos = pos.m_122019_().m_122029_();
                BlockPos swPos = pos.m_122019_().m_122024_();
                BlockState neState = this.m_9236_().m_8055_(nePos);
                BlockState nwState = this.m_9236_().m_8055_(nwPos);
                BlockState seState = this.m_9236_().m_8055_(sePos);
                BlockState swState = this.m_9236_().m_8055_(swPos);
                this.moveTreeVisitNode(treeBlocks, queue, nePos, neState);
                this.moveTreeVisitNode(treeBlocks, queue, nwPos, nwState);
                this.moveTreeVisitNode(treeBlocks, queue, sePos, seState);
                this.moveTreeVisitNode(treeBlocks, queue, swPos, swState);
                BlockPos aboveNorth = pos.m_7494_().m_122012_();
                BlockPos aboveSouth = pos.m_7494_().m_122019_();
                BlockPos aboveEast = pos.m_7494_().m_122029_();
                BlockPos aboveWest = pos.m_7494_().m_122024_();
                BlockPos belowNorth = pos.m_7495_().m_122012_();
                BlockPos belowSouth = pos.m_7495_().m_122019_();
                BlockPos belowEast = pos.m_7495_().m_122029_();
                BlockPos belowWest = pos.m_7495_().m_122024_();
                BlockState aboveNorthState = this.m_9236_().m_8055_(aboveNorth);
                BlockState aboveSouthState = this.m_9236_().m_8055_(aboveSouth);
                BlockState aboveEastState = this.m_9236_().m_8055_(aboveEast);
                BlockState aboveWestState = this.m_9236_().m_8055_(aboveWest);
                BlockState belowNorthState = this.m_9236_().m_8055_(belowNorth);
                BlockState belowSouthState = this.m_9236_().m_8055_(belowSouth);
                BlockState belowEastState = this.m_9236_().m_8055_(belowEast);
                BlockState belowWestState = this.m_9236_().m_8055_(belowWest);
                this.moveTreeVisitNode(treeBlocks, queue, aboveNorth, aboveNorthState);
                this.moveTreeVisitNode(treeBlocks, queue, aboveSouth, aboveSouthState);
                this.moveTreeVisitNode(treeBlocks, queue, aboveEast, aboveEastState);
                this.moveTreeVisitNode(treeBlocks, queue, aboveWest, aboveWestState);
                this.moveTreeVisitNode(treeBlocks, queue, belowNorth, belowNorthState);
                this.moveTreeVisitNode(treeBlocks, queue, belowSouth, belowSouthState);
                this.moveTreeVisitNode(treeBlocks, queue, belowEast, belowEastState);
                this.moveTreeVisitNode(treeBlocks, queue, belowWest, belowWestState);
                BlockPos aboveNe = pos.m_7494_().m_122012_().m_122029_();
                BlockPos aboveNw = pos.m_7494_().m_122012_().m_122024_();
                BlockPos aboveSe = pos.m_7494_().m_122019_().m_122029_();
                BlockPos aboveSw = pos.m_7494_().m_122019_().m_122024_();
                BlockPos belowNe = pos.m_7495_().m_122012_().m_122029_();
                BlockPos belowNw = pos.m_7495_().m_122012_().m_122024_();
                BlockPos belowSe = pos.m_7495_().m_122019_().m_122029_();
                BlockPos belowSw = pos.m_7495_().m_122019_().m_122024_();
                BlockState aboveNeState = this.m_9236_().m_8055_(aboveNe);
                BlockState aboveNwState = this.m_9236_().m_8055_(aboveNw);
                BlockState aboveSeState = this.m_9236_().m_8055_(aboveSe);
                BlockState aboveSwState = this.m_9236_().m_8055_(aboveSw);
                BlockState belowNeState = this.m_9236_().m_8055_(belowNe);
                BlockState belowNwState = this.m_9236_().m_8055_(belowNw);
                BlockState belowSeState = this.m_9236_().m_8055_(belowSe);
                BlockState belowSwState = this.m_9236_().m_8055_(belowSw);
                this.moveTreeVisitNode(treeBlocks, queue, aboveNe, aboveNeState);
                this.moveTreeVisitNode(treeBlocks, queue, aboveNw, aboveNwState);
                this.moveTreeVisitNode(treeBlocks, queue, aboveSe, aboveSeState);
                this.moveTreeVisitNode(treeBlocks, queue, aboveSw, aboveSwState);
                this.moveTreeVisitNode(treeBlocks, queue, belowNe, belowNeState);
                this.moveTreeVisitNode(treeBlocks, queue, belowNw, belowNwState);
                this.moveTreeVisitNode(treeBlocks, queue, belowSe, belowSeState);
                this.moveTreeVisitNode(treeBlocks, queue, belowSw, belowSwState);
            }
            if (treeBlocks.size() < MAX_MOVE_TREE_VISIT_COUNT) continue;
            queue.clear();
            break;
        }
        if (!this.isProbablyATree) {
            LOGGER.error("Skipping moveTreeDown because this is probably not a tree");
            return;
        }
        LOGGER.debug("TreeBlocks size=" + treeBlocks.size());
        TreeSet<BlockPos> ascendingTreeBlocks = new TreeSet<BlockPos>((o1, o2) -> {
            if (o1.m_123342_() != o2.m_123342_()) {
                return o1.m_123342_() - o2.m_123342_();
            }
            if (o1.m_123341_() == o2.m_123341_() && o1.m_123343_() == o2.m_123343_()) {
                return 0;
            }
            return 1;
        });
        for (BlockPos pos : treeBlocks) {
            BlockState current = this.m_9236_().m_8055_(pos);
            if (this.isLog(current)) {
                if (ascendingTreeBlocks.size() >= MAX_LOG_DESTROY_SIZE) continue;
                ascendingTreeBlocks.add(pos);
                continue;
            }
            if (!this.isLeaf(current)) continue;
            Set<BlockPos> leafSet = this.buzzsawLeafSet.get(renderable.pos);
            if (leafSet == null) {
                leafSet = new LinkedHashSet<BlockPos>();
                this.buzzsawLeafSet.put(renderable.pos, leafSet);
            }
            leafSet.add(pos);
        }
        block3: for (BlockPos pos : ascendingTreeBlocks) {
            BlockState currentState = this.m_9236_().m_8055_(pos);
            for (int i = buzzsawDestroyHeight; i > 0; --i) {
                BlockPos belowPos = pos.m_6625_(i);
                BlockState belowState = this.m_9236_().m_8055_(belowPos);
                if (!belowState.m_247087_() || !currentState.m_60710_((LevelReader)this.m_9236_(), belowPos)) continue;
                this.m_9236_().m_46961_(pos, false);
                this.m_9236_().m_7731_(belowPos, currentState, 2);
                continue block3;
            }
        }
    }

    private void moveTreeVisitNode(Set<BlockPos> treeBlocks, Queue<BlockPos> queue, BlockPos northPos, BlockState current) {
        if (!treeBlocks.contains(northPos) && this.isLogOrLeaf(current) && !this.isBlacklistedForMoveTree(current)) {
            treeBlocks.add(northPos);
            queue.add(northPos);
        }
        if (this.moveTreeDownVisitedCount <= 50 && (current.m_60713_(Blocks.f_50058_) || current.m_60713_(Blocks.f_50185_) || current.m_60713_(Blocks.f_50091_) || current.m_60734_() instanceof DoorBlock || current.m_60734_() instanceof TrapDoorBlock || current.m_60734_() instanceof FenceBlock || current.m_60734_() instanceof FenceGateBlock || current.m_60734_() instanceof BedBlock || current.m_60734_() instanceof FurnaceBlock)) {
            this.isProbablyATree = false;
            return;
        }
    }

    private boolean isBlacklistedForMoveTree(BlockState state) {
        return state.m_204336_(BlockTags.f_13090_);
    }

    private void buzzsawDestroyBlockProgressAt(LevelChunk levelChunk, BlockPos blockRotPos, int visualProgress, int destroyWidth, int destroyHeight) {
        int width = destroyWidth;
        int height = destroyHeight;
        int halfWidth = width / 2;
        int halfHeight = height / 2;
        for (int x = -halfWidth; x <= halfWidth; ++x) {
            for (int z = -halfWidth; z <= halfWidth; ++z) {
                for (int h = -halfHeight; h <= halfHeight; ++h) {
                    BlockPos current = blockRotPos.m_6630_(h).m_122030_(x).m_122020_(z);
                    BlockState state = this.m_9236_().m_8055_(current);
                    if (!this.isLog(state)) continue;
                    this.m_9236_().m_6801_(this.buzzsawDestructionId--, current, visualProgress);
                }
            }
        }
    }

    private void buzzsawUpdateDestroySet(BlockPos blockRotPos, int destroyWidth, int destroyHeight, Set<BlockPos> destroyBlockPos) {
        if (!this.m_9236_().f_46443_) {
            int width = destroyWidth;
            int height = destroyHeight;
            int halfWidth = width / 2;
            int halfHeight = height / 2;
            for (int x = -halfWidth; x <= halfWidth; ++x) {
                for (int z = -halfWidth; z <= halfWidth; ++z) {
                    for (int h = -halfHeight; h <= halfHeight; ++h) {
                        BlockPos current = blockRotPos.m_6630_(h).m_122030_(x).m_122020_(z);
                        BlockState state = this.m_9236_().m_8055_(current);
                        if (!this.isLogOrLeaf(state)) continue;
                        destroyBlockPos.add(current);
                    }
                }
            }
        }
    }

    private boolean isLog(BlockState state) {
        return !state.m_247087_() && state.m_204336_(BlockTags.f_144280_);
    }

    private boolean isLeaf(BlockState state) {
        boolean isLeafByTag;
        boolean bl = isLeafByTag = !state.m_60713_(Blocks.f_49990_) && (state.m_204336_(BlockTags.f_13035_) || state.m_204336_(BlockTags.f_278411_) || state.m_204336_(BlockTags.f_13078_));
        if (isLeafByTag && state.m_60734_() instanceof LeavesBlock && ((Boolean)state.m_61143_((Property)LeavesBlock.f_54419_)).booleanValue() && ignorePersistentLeaves) {
            return false;
        }
        return isLeafByTag;
    }

    private boolean isLogOrLeaf(BlockState state) {
        return this.isLog(state) || this.isLeaf(state);
    }

    private boolean isShovellable(BlockState state) {
        return state.m_204336_(BlockTags.f_144283_);
    }

    private boolean isAxeMineable(BlockState state) {
        return drillCanMineAxeBlocks && this.isLogOrLeaf(state);
    }

    private boolean isShovelMineable(BlockState state) {
        return drillCanMineShovelBlocks && this.isShovellable(state);
    }

    private boolean isMineable(BlockState state) {
        return state.m_204336_(BlockTags.f_144282_) || this.isAxeMineable(state) || this.isShovelMineable(state);
    }

    private void processDrill(RenderableBlock renderable, Vec3 rotPos, int width, int height) {
        BlockEntity extraReach2;
        float viewVectorScaling = drillReachScale;
        if (!this.m_9236_().f_46443_) {
            viewVectorScaling *= serverReachScaleMult;
        }
        Vec3 viewVector = this.m_20252_(1.0f);
        Vec3 scaledViewVector = viewVector.m_82490_((double)viewVectorScaling);
        Vec3 centerPos = rotPos.m_82549_(scaledViewVector);
        Vec3 rightTurnViewVec = viewVector.m_82524_(1.5707964f);
        DrillInfo di = new DrillInfo();
        for (int w = -width / 2; w <= width / 2; ++w) {
            for (int h = -height / 2; h <= height / 2; ++h) {
                Vec3 checkPos = centerPos.m_82549_(rightTurnViewVec.m_82490_((double)w));
                checkPos = checkPos.m_82520_(0.0, (double)h, 0.0);
                this.drillOneLocation(renderable, di, checkPos);
            }
        }
        if (this.doDrillExtraReach && width > 1) {
            float diagPct = this.angleDiagonalPercent();
            float extraReach2 = 0.0f;
            if ((double)diagPct >= 0.025) {
                extraReach2 += 1.0f;
            }
            if (extraReach2 != 0.0f) {
                for (int h = -height / 2; h <= height / 2; ++h) {
                    Vec3 checkPos = centerPos.m_82549_(rightTurnViewVec.m_82490_((double)(width / 2) + (double)extraReach2 / 2.0));
                    checkPos = checkPos.m_82520_(0.0, (double)h, 0.0);
                    this.drillOneLocation(renderable, di, checkPos);
                    checkPos = centerPos.m_82549_(rightTurnViewVec.m_82490_(-((double)(width / 2) + (double)extraReach2 / 2.0)));
                    checkPos = checkPos.m_82520_(0.0, (double)h, 0.0);
                    this.drillOneLocation(renderable, di, checkPos);
                }
            }
        }
        if (di.didDestroy) {
            this.drillMiningProgressMap.remove(renderable.pos);
        }
        if ((extraReach2 = renderable.tempBlockEntity) instanceof BaseDrillBlockEntity) {
            BaseDrillBlockEntity drill = (BaseDrillBlockEntity)extraReach2;
            if (this.m_9236_().f_46443_) {
                if (drill.active && !this.playedDrillSoundThisTick) {
                    this.playedDrillSoundThisTick = true;
                    final DummyEntity thisEntity = this;
                    final float volume = 0.8f * drillSoundVolume / 100.0f;
                    float pitchRandom = 0.12f;
                    double pitchVariance = Math.random() * (double)pitchRandom - (double)(pitchRandom / 2.0f);
                    float pitchMod = 1.2f + 0.4f * ((float)drill.deactivationTicks / 40.0f);
                    final float pitch = (1.0f + (float)pitchVariance) * pitchMod;
                    DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> new Runnable(){

                        @Override
                        public void run() {
                            DummyEntity.this.m_9236_().m_6269_((Player)Minecraft.m_91087_().f_91074_, (Entity)thisEntity, (SoundEvent)XenoBlocks.SOUND_EVENT_DRILL_SPIN.get(), SoundSource.BLOCKS, volume, pitch);
                        }
                    });
                }
            } else if (drill.active && drillKillsFallingBlock) {
                List entities = this.m_9236_().m_6249_((Entity)null, AABB.m_165882_((Vec3)drill.m_58899_().m_252807_(), (double)5.0, (double)3.0, (double)5.0), x -> x instanceof FallingBlockEntity);
                for (Entity e : entities) {
                    if (!(e instanceof FallingBlockEntity)) continue;
                    FallingBlockEntity fallingBlock = (FallingBlockEntity)e;
                    fallingBlock.m_6074_();
                    ItemEntity itemEntity = fallingBlock.m_19998_((ItemLike)fallingBlock.m_31980_().m_60734_());
                }
            }
            if (drill.deactivationTicks > 0) {
                --drill.deactivationTicks;
            }
            if (drill.deactivationTicks == 0) {
                drill.active = false;
                drill.deactivationTicks = -1;
            }
        }
    }

    private boolean angleIsDiagonal() {
        float sanitizedAngle = this.getSanitizedRotationAngle();
        float modAngle = sanitizedAngle % 90.0f;
        float diagDiff = 22.5f;
        float diagonalAngleMin = 45.0f - diagDiff;
        float diagonalAngleMax = 45.0f + diagDiff;
        return modAngle >= diagonalAngleMin && modAngle <= diagonalAngleMax;
    }

    public float angleDiagonalPercent() {
        float sanitizedAngle = this.getSanitizedRotationAngle();
        float modAngle = sanitizedAngle % 90.0f;
        float distFrom45 = Math.abs(modAngle - 45.0f);
        return 1.0f - distFrom45 / 45.0f;
    }

    private void drillOneLocation(RenderableBlock renderable, DrillInfo di, Vec3 checkPos) {
        block38: {
            block35: {
                MiningProgress mp;
                BlockState state;
                BlockPos checkBlockPos;
                block37: {
                    block36: {
                        checkBlockPos = XenoTechUtils.blockPosFromRotPos(checkPos);
                        state = this.m_9236_().m_8055_(checkBlockPos);
                        if (!this.isMineable(state)) break block35;
                        mp = this.drillMiningProgressMap.get(renderable.pos);
                        if (mp == null) break block36;
                        if (checkBlockPos.m_123333_((Vec3i)mp.target) <= drillDestroyMaxDist) break block37;
                    }
                    if (!this.drillMiningMapHasTarget(checkBlockPos)) {
                        if (mp != null) {
                            LOGGER.debug("reset progress at: " + checkBlockPos + " due to mismatch with target=" + mp.target);
                            this.m_9236_().m_6801_(-1, mp.target, -1);
                        }
                        mp = new MiningProgress(checkBlockPos);
                        this.drillMiningProgressMap.put(renderable.pos, mp);
                    }
                }
                if (mp != null) {
                    float destroySpeed;
                    if (!di.updatedProgressThisTick && mp.progress < 50 && (destroySpeed = state.m_60800_((BlockGetter)this.m_9236_(), checkBlockPos)) >= 0.0f) {
                        di.updatedProgressThisTick = true;
                        float speedMult = 15.0f;
                        if (drillCanMineAxeBlocks && this.isLeaf(state)) {
                            speedMult = 50.0f;
                        } else if (this.isAxeMineable(state)) {
                            speedMult *= axeMineableSpeedScale;
                        } else if (this.isShovelMineable(state)) {
                            speedMult *= shovelMineableSpeedScale;
                        }
                        int progressTicks = (int)(speedMult / destroySpeed);
                        if (progressTicks <= 0 || destroySpeed == 0.0f) {
                            progressTicks = 1;
                        }
                        mp.progress += progressTicks;
                    }
                    float progressPct = (float)mp.progress / 50.0f;
                    int visualProgress = (int)(progressPct * 10.0f);
                    if (mp.progress >= 50) {
                        BlockEntity blockEntity = renderable.tempBlockEntity;
                        if (blockEntity instanceof BaseDrillBlockEntity) {
                            BaseDrillBlockEntity drill = (BaseDrillBlockEntity)blockEntity;
                            if (!this.m_9236_().f_46443_ || this.anyDrillActive()) {
                                drill.active = true;
                                if (drill.deactivationTicks <= 0) {
                                    drill.deactivationTicks = 40;
                                }
                                this.m_9236_().m_6801_(this.buzzsawDestructionId--, checkBlockPos, -1);
                            }
                        }
                        if ((blockEntity = this.m_9236_()) instanceof ServerLevel) {
                            List drops;
                            boolean added;
                            ServerLevel serverLevel = (ServerLevel)blockEntity;
                            ItemStack itemStack = ItemStack.f_41583_;
                            BlockEntity blockEntity2 = renderable.tempBlockEntity;
                            if (blockEntity2 instanceof BaseDrillBlockEntity) {
                                BaseDrillBlockEntity drill = (BaseDrillBlockEntity)blockEntity2;
                                if (drill.hasSilkTouch) {
                                    itemStack = new ItemStack((ItemLike)Items.f_42391_);
                                    itemStack.m_41663_(Enchantments.f_44985_, 1);
                                }
                            }
                            if (added = this.addToChest(drops = Block.m_49874_((BlockState)state, (ServerLevel)serverLevel, (BlockPos)checkBlockPos, null, null, (ItemStack)itemStack))) {
                                LOGGER.trace("Added to chest");
                                this.m_9236_().m_46961_(checkBlockPos, false);
                            } else {
                                for (ItemStack drop : drops) {
                                    ItemEntity itemEntity = new ItemEntity(this.m_9236_(), (double)checkBlockPos.m_123341_() + 0.5, (double)checkBlockPos.m_123342_() + 0.5, (double)checkBlockPos.m_123343_() + 0.5, drop);
                                    this.m_9236_().m_7967_((Entity)itemEntity);
                                }
                                this.m_9236_().m_46961_(checkBlockPos, false);
                            }
                        }
                        di.didDestroy = true;
                        if (!this.m_9236_().f_46443_) {
                            this.setAnyDrillActive(false);
                        }
                    } else if (!this.m_9236_().f_46443_ || this.anyDrillActive()) {
                        BlockEntity blockEntity;
                        if (!this.m_9236_().f_46443_) {
                            this.setAnyDrillActive(true);
                        }
                        if ((blockEntity = renderable.tempBlockEntity) instanceof BaseDrillBlockEntity) {
                            BaseDrillBlockEntity drill = (BaseDrillBlockEntity)blockEntity;
                            drill.active = true;
                            drill.deactivationTicks = -1;
                        }
                        this.forceCollision = true;
                        this.collisionResponseStopMoving = true;
                        this.m_9236_().m_6801_(this.buzzsawDestructionId--, checkBlockPos, visualProgress);
                    }
                } else {
                    BlockEntity blockEntity = renderable.tempBlockEntity;
                    if (blockEntity instanceof BaseDrillBlockEntity) {
                        BaseDrillBlockEntity drill = (BaseDrillBlockEntity)blockEntity;
                        if (drill.deactivationTicks <= 0) {
                            drill.deactivationTicks = 40;
                        }
                    }
                }
                break block38;
            }
            BlockEntity blockEntity = renderable.tempBlockEntity;
            if (blockEntity instanceof BaseDrillBlockEntity) {
                BaseDrillBlockEntity drill = (BaseDrillBlockEntity)blockEntity;
                if (drill.deactivationTicks <= 0) {
                    drill.deactivationTicks = 40;
                }
            }
        }
    }

    private void processBuzzsaw(RenderableBlock renderable, Vec3 rotPos) {
        Vec3 viewVector = this.m_20252_(1.0f);
        float viewVectorScale = buzzsawReachScale;
        if (!this.m_9236_().f_46443_) {
            viewVectorScale *= serverReachScaleMult;
        }
        Vec3 scaledViewVector = viewVector.m_82490_((double)viewVectorScale);
        Vec3 rightTurnViewVec = viewVector.m_82524_(1.5707964f);
        Vec3 leftTurnViewVec = viewVector.m_82524_(-1.5707964f);
        this.buzzsawDidDestroy = false;
        HashSet<MiningProgress> updatedSet = new HashSet<MiningProgress>();
        boolean activeStatus = false;
        HashSet<BlockPos> destroyPos = new HashSet<BlockPos>();
        Vec3 checkPos = rotPos.m_82549_(scaledViewVector);
        int width = 3;
        int height = 1;
        for (int w = -width / 2; w <= width / 2; ++w) {
            for (int h = -height / 2; h <= height / 2; ++h) {
                Vec3 newCheckPos = checkPos.m_82549_(rightTurnViewVec.m_82490_((double)w));
                newCheckPos = newCheckPos.m_82520_(0.0, (double)h, 0.0);
                BlockPos checkBlockPos = XenoTechUtils.blockPosFromRotPos(newCheckPos);
                BlockState checkState = this.m_9236_().m_8055_(checkBlockPos);
                activeStatus = this.buzzsawTryDestroyColumnAt(newCheckPos, renderable, updatedSet, destroyPos) || activeStatus;
            }
        }
        if (!this.m_9236_().f_46443_ && !destroyPos.isEmpty()) {
            for (BlockPos toDestroy : destroyPos) {
                List drops;
                boolean added;
                BlockState state = this.m_9236_().m_8055_(toDestroy);
                LOGGER.debug("destroy block at: " + toDestroy);
                ItemStack itemStack = ItemStack.f_41583_;
                BlockEntity blockEntity = renderable.tempBlockEntity;
                if (blockEntity instanceof BuzzsawBlockEntity) {
                    BuzzsawBlockEntity buzzsaw = (BuzzsawBlockEntity)blockEntity;
                    if (buzzsaw.hasSilkTouch) {
                        itemStack = new ItemStack((ItemLike)Items.f_42391_);
                        itemStack.m_41663_(Enchantments.f_44985_, 1);
                    }
                }
                if (added = this.addToChest(drops = Block.m_49874_((BlockState)state, (ServerLevel)((ServerLevel)this.m_9236_()), (BlockPos)toDestroy, null, null, (ItemStack)itemStack))) {
                    LOGGER.trace("Added to chest");
                    this.m_9236_().m_46961_(toDestroy, false);
                } else {
                    for (ItemStack drop : drops) {
                        ItemEntity itemEntity = new ItemEntity(this.m_9236_(), (double)toDestroy.m_123341_() + 0.5, (double)toDestroy.m_123342_() + 0.5, (double)toDestroy.m_123343_() + 0.5, drop);
                        this.m_9236_().m_7967_((Entity)itemEntity);
                    }
                    this.m_9236_().m_46961_(toDestroy, false);
                }
                if (!this.isLog(state) || this.isLeaf(state)) continue;
                this.buzzsawDidDestroy = true;
            }
        }
        if (this.buzzsawDidDestroy) {
            this.buzzsawMiningProgressMap.remove(renderable.pos);
            if (this.lastBuzzsawRenderable == null || renderable.pos.m_123342_() > this.lastBuzzsawRenderable.pos.m_123342_()) {
                this.lastBuzzsawRenderable = renderable;
            }
            if (this.fullBuzzsawTreeBlockSet == null) {
                this.fullBuzzsawTreeBlockSet = new HashSet<BlockPos>();
            }
            this.fullBuzzsawTreeBlockSet.addAll(destroyPos);
        }
        if (activeStatus) {
            if (!this.playedBuzzsawSoundThisTick) {
                this.playedBuzzsawSoundThisTick = true;
                final DummyEntity thisEntity = this;
                final float volume = 0.9f * buzzsawSoundVolume / 100.0f;
                float pitchRandom = 0.12f;
                double pitchVariance = Math.random() * (double)pitchRandom - (double)(pitchRandom / 2.0f);
                float pitchMod = 1.2f;
                final float pitch = (1.0f + (float)pitchVariance) * pitchMod;
                DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> new Runnable(){

                    @Override
                    public void run() {
                        DummyEntity.this.m_9236_().m_6269_((Player)Minecraft.m_91087_().f_91074_, (Entity)thisEntity, (SoundEvent)XenoBlocks.SOUND_EVENT_BUZZSAW_SPIN.get(), SoundSource.BLOCKS, volume, pitch);
                    }
                });
            }
            if (!this.m_9236_().f_46443_ || this.anyDrillActive()) {
                if (!this.m_9236_().f_46443_) {
                    this.setAnyDrillActive(true);
                }
                this.forceCollision = true;
                this.collisionResponseStopMoving = true;
            }
        } else {
            this.buzzsawMiningProgressMap.remove(renderable.pos);
            if (this.moveTreeDownTicks == -1) {
                if (!this.m_9236_().f_46443_ && this.anyDrillActive()) {
                    ++this.drillInactiveTicks;
                    if (this.drillInactiveTicks >= 7) {
                        LOGGER.debug("Buzzsaw set to inactive");
                        this.setAnyDrillActive(false);
                        this.drillInactiveTicks = 0;
                    }
                }
            } else {
                this.drillInactiveTicks = 0;
            }
        }
        renderable.state = (BlockState)renderable.state.m_61124_((Property)BuzzsawBlock.ACTIVE, (Comparable)Boolean.valueOf(activeStatus));
    }

    private boolean drillMiningMapHasTarget(BlockPos target) {
        for (Map.Entry<BlockPos, MiningProgress> entry : this.drillMiningProgressMap.entrySet()) {
            if (!entry.getValue().target.equals((Object)target)) continue;
            return true;
        }
        return false;
    }

    private boolean buzzsawMiningMapHasTarget(BlockPos target) {
        for (Map.Entry<BlockPos, MiningProgress> entry : this.buzzsawMiningProgressMap.entrySet()) {
            if (!entry.getValue().target.equals((Object)target)) continue;
            return true;
        }
        return false;
    }

    private boolean buzzsawTryDestroyColumnAt(Vec3 checkPos, RenderableBlock renderable, Set<MiningProgress> updatedSet, Set<BlockPos> destroyPos) {
        BlockPos currentPos;
        int h;
        BlockPos blockRotPos = XenoTechUtils.blockPosFromRotPos(checkPos);
        LevelChunk levelChunk = this.m_9236_().m_46745_(blockRotPos);
        boolean sawIsActive = false;
        int height = buzzsawDestroyHeight;
        boolean reachedMaxProgress = false;
        int halfHeight = height / 2;
        for (h = -halfHeight; h <= halfHeight; ++h) {
            BlockState state;
            block11: {
                MiningProgress mp;
                block13: {
                    block12: {
                        currentPos = blockRotPos.m_6630_(h);
                        state = this.m_9236_().m_8055_(currentPos);
                        if (!this.isLog(state)) break block11;
                        mp = this.buzzsawMiningProgressMap.get(renderable.pos);
                        if (mp == null) break block12;
                        if (currentPos.m_123333_((Vec3i)mp.target) <= buzzsawDestroyMaxDistance) break block13;
                    }
                    if (!this.buzzsawMiningMapHasTarget(currentPos)) {
                        if (mp != null) {
                            LOGGER.debug("reset progress at: " + currentPos + " due to mismatch with target=" + mp.target);
                            this.m_9236_().m_6801_(-1, mp.target, -1);
                        }
                        mp = new MiningProgress(currentPos);
                        this.buzzsawMiningProgressMap.put(renderable.pos, mp);
                    }
                }
                if (mp == null) continue;
                if (!updatedSet.contains(mp) && mp.progress < 9) {
                    ++mp.progress;
                    updatedSet.add(mp);
                }
                float progressPct = (float)mp.progress / 9.0f;
                int visualProgress = (int)(progressPct * 10.0f);
                if (mp.progress >= 9) {
                    reachedMaxProgress = true;
                } else {
                    LOGGER.debug("destroyProgress at: " + currentPos + " with progress=" + visualProgress);
                    this.buzzsawDestroyBlockProgressAt(levelChunk, currentPos, visualProgress, buzzsawDestroyWidth, 1);
                }
                sawIsActive = true;
                continue;
            }
            if (!this.isLeaf(state)) continue;
            this.buzzsawDidDestroy = true;
            this.buzzsawUpdateDestroySet(currentPos, buzzsawDestroyWidth, 1, destroyPos);
        }
        if (reachedMaxProgress) {
            this.buzzsawMiningProgressMap.remove(renderable.pos);
            for (h = -halfHeight; h <= halfHeight; ++h) {
                currentPos = blockRotPos.m_6630_(h);
                LOGGER.debug("destroyBlock at: " + currentPos + " with progress=-1");
                this.buzzsawDestroyBlockProgressAt(levelChunk, currentPos, -1, buzzsawDestroyWidth, 1);
                this.buzzsawUpdateDestroySet(currentPos, buzzsawDestroyWidth, 1, destroyPos);
            }
        }
        return sawIsActive;
    }

    private void processCombineHarvester(BlockPos blockRotPos, ServerLevel serverLevel) {
        LevelChunk levelChunk = serverLevel.m_46745_(blockRotPos);
        BlockState state = levelChunk.m_8055_(blockRotPos);
        Block block = state.m_60734_();
        if (block instanceof CropBlock) {
            CropBlock crop = (CropBlock)block;
            try {
                if (crop.m_52305_(state) >= crop.m_7419_()) {
                    this.processOneCropBlock(blockRotPos, serverLevel, levelChunk, state, crop);
                }
            }
            catch (Exception ex) {
                LOGGER.debug("Got error checking crop=" + crop, (Throwable)ex);
            }
        } else {
            Block ex = state.m_60734_();
            if (ex instanceof NetherWartBlock) {
                NetherWartBlock wart = (NetherWartBlock)ex;
                try {
                    if ((Integer)state.m_61143_((Property)NetherWartBlock.f_54967_) >= 3) {
                        this.processOneCropBlock(blockRotPos, serverLevel, levelChunk, state, wart);
                    }
                }
                catch (Exception ex2) {
                    LOGGER.debug("Got error checking crop=" + wart, (Throwable)ex2);
                }
            }
        }
    }

    private void processOneCropBlock(BlockPos blockRotPos, ServerLevel serverLevel, LevelChunk levelChunk, BlockState state, Object cropBlock) {
        boolean added;
        List drops = Block.m_49869_((BlockState)state, (ServerLevel)serverLevel, (BlockPos)blockRotPos, (BlockEntity)levelChunk.m_7702_(blockRotPos));
        LOGGER.debug("Got crop at pos=" + blockRotPos + " with drops=" + drops);
        ItemStack seedStack = null;
        if (cropBlock instanceof CropBlock) {
            CropBlock crop = (CropBlock)cropBlock;
            seedStack = crop.m_7397_((BlockGetter)serverLevel, blockRotPos, state);
        } else if (cropBlock instanceof NetherWartBlock) {
            NetherWartBlock wart = (NetherWartBlock)cropBlock;
            seedStack = wart.m_7397_((BlockGetter)serverLevel, blockRotPos, state);
        }
        Item seedItem = seedStack.m_41720_();
        ItemStack toRemove = null;
        boolean canReplant = false;
        for (ItemStack itemStack2 : drops) {
            if (!itemStack2.m_150930_(seedItem)) continue;
            canReplant = true;
            itemStack2.m_41774_(1);
            if (!itemStack2.m_41619_()) break;
            toRemove = itemStack2;
            break;
        }
        if (toRemove != null) {
            drops.remove(toRemove);
        }
        if (!(added = this.addToChest(drops))) {
            drops.forEach(itemStack -> {
                ItemEntity itemEntity = new ItemEntity((Level)serverLevel, (double)blockRotPos.m_123341_() + 0.5, (double)blockRotPos.m_123342_() + 0.5, (double)blockRotPos.m_123343_() + 0.5, itemStack);
                itemEntity.m_32060_();
                serverLevel.m_7967_((Entity)itemEntity);
            });
        } else {
            LOGGER.trace("Added to chest");
        }
        if (canReplant) {
            BlockState replantedState = null;
            if (cropBlock instanceof CropBlock) {
                CropBlock crop = (CropBlock)cropBlock;
                replantedState = (BlockState)state.m_61124_((Property)CropBlock.f_52244_, (Comparable)Integer.valueOf(0));
            } else if (cropBlock instanceof NetherWartBlock) {
                NetherWartBlock wart = (NetherWartBlock)cropBlock;
                replantedState = (BlockState)state.m_61124_((Property)NetherWartBlock.f_54967_, (Comparable)Integer.valueOf(0));
            }
            LOGGER.debug("Replanted with state=" + replantedState);
            serverLevel.m_7731_(blockRotPos, replantedState, 2);
        } else {
            serverLevel.m_7731_(blockRotPos, Blocks.f_50016_.m_49966_(), 2);
        }
    }

    public void setWeaponsEnabled(boolean enabled) {
        this.f_19804_.m_135381_(WEAPONS_ENABLED, (Object)enabled);
    }

    public void setBuzzsawEnabled(boolean enabled) {
        this.f_19804_.m_135381_(BUZZSAW_ENABLED, (Object)enabled);
    }

    public void setDrillEnabled(boolean enabled) {
        this.f_19804_.m_135381_(DRILL_ENABLED, (Object)enabled);
    }

    public boolean isWeaponsEnabled() {
        return (Boolean)this.f_19804_.m_135370_(WEAPONS_ENABLED);
    }

    public boolean isBuzzsawEnabled() {
        return (Boolean)this.f_19804_.m_135370_(BUZZSAW_ENABLED);
    }

    public boolean isDrillEnabled() {
        return (Boolean)this.f_19804_.m_135370_(DRILL_ENABLED);
    }

    public boolean anyDrillActive() {
        return (Boolean)this.f_19804_.m_135370_(ANY_DRILL_ACTIVE);
    }

    public void setAnyDrillActive(boolean isActive) {
        this.f_19804_.m_135381_(ANY_DRILL_ACTIVE, (Object)isActive);
    }

    public void checkRenderableForBlockInteractions(Vec3 rotPos, RenderableBlock renderable, BlockPos blockRotPos) {
        BaseDrillBlockEntity drill;
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (renderable.state.m_60734_() instanceof CombineHarvesterBlock) {
                this.processCombineHarvester(blockRotPos, serverLevel);
            }
        }
        if (renderable.state.m_60734_() instanceof BuzzsawBlock && !this.reverseCommandActive) {
            if (this.isBuzzsawEnabled()) {
                this.processBuzzsaw(renderable, rotPos);
            } else {
                this.setAnyDrillActive(false);
            }
        }
        if (renderable.state.m_60734_() instanceof PrecisionDrillBlock && !this.reverseCommandActive) {
            if (this.isDrillEnabled()) {
                this.processDrill(renderable, rotPos, 1, 1);
            } else {
                level = renderable.tempBlockEntity;
                if (level instanceof BaseDrillBlockEntity) {
                    drill = (BaseDrillBlockEntity)level;
                    drill.active = false;
                    drill.deactivationTicks = -1;
                    this.setAnyDrillActive(false);
                }
            }
        }
        if (renderable.state.m_60734_() instanceof MiningDrillBlock && !this.reverseCommandActive) {
            if (this.isDrillEnabled()) {
                this.processDrill(renderable, rotPos, 5, 3);
            } else {
                level = renderable.tempBlockEntity;
                if (level instanceof BaseDrillBlockEntity) {
                    drill = (BaseDrillBlockEntity)level;
                    drill.active = false;
                    drill.deactivationTicks = -1;
                    this.setAnyDrillActive(false);
                }
            }
        }
    }

    public Set<Integer> getCarriedEntities() {
        float loadFactor = 0.75f;
        int allocSize = (int)Math.ceil((float)this.renderables.size() / loadFactor) + 1;
        Map<Object, Object> newRenderableLookup = null;
        Vec3 deltaMov = this.m_20184_();
        double deltaMovSqr = deltaMov.m_82556_();
        boolean computeNewRenderableLookupMap = false;
        if (this.renderableLookup == null || this.renderableLookup.isEmpty() || this.currentHorizontalSpeed > 0.0 || deltaMovSqr > 1.0E-6) {
            newRenderableLookup = new HashMap(allocSize, loadFactor);
            computeNewRenderableLookupMap = true;
        } else {
            newRenderableLookup = this.renderableLookup;
        }
        boolean computeNewFixedInitialRenderableLookupMap = false;
        if (this.fixedInitialPosRenderableLookup.isEmpty()) {
            computeNewFixedInitialRenderableLookupMap = true;
        }
        HashSet<Integer> chosenEntities = new HashSet<Integer>();
        if (!this.m_9236_().f_46443_) {
            this.checkForGenericTasklistEvents();
        }
        this.buzzsawDestructionId = -1;
        if (this.moveTreeDownTicks == -1) {
            this.lastBuzzsawRenderable = null;
            this.fullBuzzsawTreeBlockSet = null;
        }
        if (this.renderables.size() > 0) {
            this.playedDrillSoundThisTick = false;
            this.playedBuzzsawSoundThisTick = false;
            for (RenderableBlock renderable : this.renderables) {
                boolean haveCachedResult;
                Vec3 actualPos = XenoTechUtils.revolve(this, new Vec3(renderable.absoluteX(this), renderable.absoluteY(this), renderable.absoluteZ(this)));
                actualPos = new Vec3(actualPos.f_82479_, actualPos.f_82480_, actualPos.f_82481_);
                BlockPos actualBlockPos = XenoTechUtils.blockPosFromRotPos(actualPos);
                if (computeNewRenderableLookupMap) {
                    newRenderableLookup.put(actualBlockPos, renderable);
                }
                if (computeNewFixedInitialRenderableLookupMap) {
                    this.fixedInitialPosRenderableLookup.put(renderable.pos, renderable);
                }
                this.checkRenderableForBlockInteractions(actualPos, renderable, actualBlockPos);
                if (!this.m_9236_().f_46443_) {
                    this.checkRenderableForTasklistEvents(renderable, actualBlockPos);
                }
                CollisionContext ctx = null;
                boolean isEmptyShape = false;
                boolean bl = haveCachedResult = renderable.lastCarriedEntityCollisionState != null && renderable.lastCarriedEntityCollisionState == renderable.state;
                if (haveCachedResult) {
                    isEmptyShape = renderable.lastCarriedEntityEmptyShape;
                } else {
                    try {
                        isEmptyShape = renderable.state.m_60742_((BlockGetter)this.m_9236_(), actualBlockPos, ctx).m_83281_();
                    }
                    catch (Exception ex) {
                        LOGGER.debug("getCollisionShape error from BlockState=" + renderable.state + ", this is a bug in another mod, please report it to the author", (Throwable)ex);
                        isEmptyShape = true;
                    }
                }
                if (!isEmptyShape) {
                    renderable.lastCarriedEntityCollisionState = renderable.state;
                    renderable.lastCarriedEntityEmptyShape = false;
                    double inflateFactor = 1.0;
                    if (serverInflateBoundingBoxes && !this.m_9236_().f_46443_) {
                        inflateFactor = serverBoundingBoxInflateFactor;
                    }
                    this.xzEntityCaptureSize = 1.0 + 2.0 * this.currentHorizontalSpeed * inflateFactor;
                    List entities = null;
                    int lastCapturedTickDiff = this.f_19797_ - this.lastCapturedTick;
                    if (this.f_19797_ % checkForNewEntitiesTickPeriod == 0 || this.priorEntitiesList == null || lastCapturedTickDiff >= 10) {
                        entities = this.m_9236_().m_6249_((Entity)null, AABB.m_165882_((Vec3)actualPos.m_82520_(0.5, 0.0, 0.5), (double)this.xzEntityCaptureSize, (double)4.5, (double)this.xzEntityCaptureSize), x -> !(x instanceof DummyEntity) && !blacklistedCarryEntities.contains(ForgeRegistries.ENTITY_TYPES.getKey((Object)x.m_6095_()).toString()) && !blacklistedCarryEntities.contains(ForgeRegistries.ENTITY_TYPES.getKey((Object)x.m_6095_()).m_135827_() + ":*") && !x.m_5833_() && (this.vehicleType == VehicleType.SUBMARINE || x != null || x instanceof Projectile));
                        this.lastCapturedTick = this.f_19797_;
                    } else {
                        entities = this.priorEntitiesList;
                    }
                    if (this.alwaysCarryList != null && this.alwaysCarryList.size() > 0) {
                        int i;
                        ArrayList<Entity> removeList = new ArrayList<Entity>();
                        for (i = 0; i < this.alwaysCarryList.size(); ++i) {
                            Entity toAdd = this.alwaysCarryList.get(i);
                            if (toAdd != null && !toAdd.m_213877_()) {
                                entities.add(this.alwaysCarryList.get(i));
                                continue;
                            }
                            removeList.add(toAdd);
                        }
                        for (i = 0; i < removeList.size(); ++i) {
                            Entity toRemove = (Entity)removeList.get(i);
                            this.alwaysCarryList.remove(toRemove);
                        }
                    }
                    this.priorEntitiesList = entities;
                    for (Entity e : entities) {
                        if (e instanceof Player) {
                            this.refreshCaptureTimestampForPlayer(e);
                            if (this.clientSendsCarriedReminders && this.m_9236_().f_46443_ && this.f_19797_ % this.localPlayerServerReminderIntervalTicks == 0 && Minecraft.m_91087_().f_91074_.m_19879_() == e.m_19879_()) {
                                XenoTechNetwork.INSTANCE.sendToServer((Object)new ServerboundCarriedPlayerReminder(this));
                            }
                        }
                        if (this.m_146895_() == e) continue;
                        chosenEntities.add(e.m_19879_());
                    }
                    continue;
                }
                renderable.lastCarriedEntityCollisionState = renderable.state;
                renderable.lastCarriedEntityEmptyShape = true;
            }
        }
        this.buzzsawLevelTree();
        this.renderableLookup = newRenderableLookup;
        int tickTimestamp = this.f_19797_;
        for (Map.Entry<Integer, Integer> timestampEntry : this.carriedPlayerLastCapturedTimestamp.entrySet()) {
            int timeDiffTicks;
            Entity e = this.m_9236_().m_6815_(timestampEntry.getKey().intValue());
            if (!(e instanceof Player) || (timeDiffTicks = tickTimestamp - timestampEntry.getValue()) > this.playerRemainCapturedTicks || this.m_146895_() == e) continue;
            chosenEntities.add(e.m_19879_());
        }
        return chosenEntities;
    }

    private void buzzsawLevelTree() {
        if (this.lastBuzzsawRenderable != null && this.fullBuzzsawTreeBlockSet != null && !this.fullBuzzsawTreeBlockSet.isEmpty()) {
            this.moveTreeDownTicks = this.moveTreeDownTicks == -1 ? 3 : --this.moveTreeDownTicks;
            if (this.moveTreeDownTicks == 0) {
                this.moveTreeDownTicks = -1;
                this.buzzsawMiningProgressMap.clear();
                if (!this.m_9236_().f_46443_) {
                    LOGGER.debug("move tree down starting at Y: " + this.fullBuzzsawTreeBlockSet.iterator().next().m_123342_());
                    this.moveTreeDown(this.lastBuzzsawRenderable, this.fullBuzzsawTreeBlockSet);
                }
                if (this.reverseCommandActive) {
                    this.buzzsawLeafSet.clear();
                } else {
                    Set<BlockPos> leafSet = this.buzzsawLeafSet.get(this.lastBuzzsawRenderable.pos);
                    if (leafSet != null && !leafSet.isEmpty()) {
                        LOGGER.debug("destroy all leaves with size=" + leafSet.size());
                        int destroyCount = 0;
                        if (!this.m_9236_().f_46443_) {
                            for (BlockPos pos : leafSet) {
                                List drops;
                                boolean added;
                                BlockState state = this.m_9236_().m_8055_(pos);
                                if (!this.isLeaf(state)) continue;
                                ItemStack itemStack = ItemStack.f_41583_;
                                BlockEntity blockEntity = this.lastBuzzsawRenderable.tempBlockEntity;
                                if (blockEntity instanceof BuzzsawBlockEntity) {
                                    BuzzsawBlockEntity buzzsaw = (BuzzsawBlockEntity)blockEntity;
                                    if (buzzsaw.hasSilkTouch) {
                                        itemStack = new ItemStack((ItemLike)Items.f_42391_);
                                        itemStack.m_41663_(Enchantments.f_44985_, 1);
                                    }
                                }
                                if (added = this.addToChest(drops = Block.m_49874_((BlockState)state, (ServerLevel)((ServerLevel)this.m_9236_()), (BlockPos)pos, null, null, (ItemStack)itemStack))) {
                                    LOGGER.trace("Added to chest");
                                    ++destroyCount;
                                    this.m_9236_().m_46961_(pos, false);
                                } else {
                                    for (ItemStack drop : drops) {
                                        ItemEntity itemEntity = new ItemEntity(this.m_9236_(), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, drop);
                                        this.m_9236_().m_7967_((Entity)itemEntity);
                                    }
                                    ++destroyCount;
                                    this.m_9236_().m_46961_(pos, false);
                                }
                                if (destroyCount < MAX_LEAF_DESTROY_SIZE) continue;
                                break;
                            }
                            LOGGER.debug("destroyed " + destroyCount + " leaves");
                            this.buzzsawLeafSet.remove(this.lastBuzzsawRenderable.pos);
                            leafSet.clear();
                        }
                    }
                }
            }
        }
    }

    private void checkForGenericTasklistEvents() {
        TaskItem.TaskParam delayParam;
        TaskItem eventTaskItem;
        TaskItem periodicEvent;
        TaskItem.TaskParam amPmParam;
        TaskItem eventTaskItem2;
        if (this.executingActionList || this.taskList.isEmpty() || this.m_146895_() == null || this.m_146895_() instanceof Player) {
            return;
        }
        TaskItem dailyEvent = TaskItem.event(TaskElement.DAILY_EVENT);
        if (this.taskList.hasTaskListForEvent(dailyEvent) && (eventTaskItem2 = this.taskList.getFirstTaskForEvent(dailyEvent)) != null && (amPmParam = eventTaskItem2.taskParams.get((Object)TaskParamType.PARAM_AM_PM)) != null) {
            String text = amPmParam.value.toLowerCase();
            String lowercase = text.toLowerCase();
            boolean hasAmPmEnding = false;
            boolean isPm = true;
            if (lowercase.endsWith("am")) {
                hasAmPmEnding = true;
                isPm = false;
            } else if (lowercase.endsWith("pm")) {
                hasAmPmEnding = true;
                isPm = true;
            }
            String textWithoutEnding = (hasAmPmEnding ? text.substring(0, text.length() - 2) : text).trim();
            String[] split = textWithoutEnding.split(":");
            if (split.length == 2) {
                int hour;
                long currentTime;
                TaskItem.TaskParam hrParam = new TaskItem.TaskParam();
                hrParam.value = split[0];
                TaskItem.TaskParam minParam = new TaskItem.TaskParam();
                minParam.value = split[1];
                int inputHr = hrParam.toInt(12, 1, 12);
                int inputMin = minParam.toInt(0, 0, 60);
                boolean isPmTime = false;
                long dayTime = this.m_9236_().m_46468_();
                long displayTime = currentTime = (dayTime + 6000L) % 24000L;
                if (currentTime >= 12000L) {
                    isPmTime = true;
                    displayTime = currentTime - 12000L;
                }
                if ((hour = (int)displayTime / 1000) == 0) {
                    hour = 12;
                }
                int minute = 60 * ((int)displayTime % 1000) / 1000;
                if (hour == inputHr && minute == inputMin && isPm == isPmTime) {
                    String amPmText = "AM";
                    if (isPm) {
                        amPmText = "PM";
                    }
                    LOGGER.debug("Daily event triggered at time=" + hour + ":" + minute + " " + amPmText);
                    this.processActionList(eventTaskItem2, this.taskList.getTaskItemsForEvent(eventTaskItem2));
                }
            }
        }
        if (this.taskList.hasTaskListForEvent(periodicEvent = TaskItem.event(TaskElement.PERIODIC_EVENT)) && (eventTaskItem = this.taskList.getFirstTaskForEvent(periodicEvent)) != null && (delayParam = eventTaskItem.taskParams.get((Object)TaskParamType.PARAM_DELAY_SEC)) != null && eventTaskItem instanceof PeriodicEventTaskItem) {
            PeriodicEventTaskItem periodic = (PeriodicEventTaskItem)eventTaskItem;
            int delay = delayParam.toInt(10, 1, 9999);
            if (delay != periodic.previousDelay) {
                LOGGER.debug("delay value changed for periodic event, resetting timer for new value: " + delay);
                periodic.delayTickCounter = -1;
            }
            periodic.delayTickCounter = periodic.delayTickCounter == -1 ? delay * 20 : --periodic.delayTickCounter;
            if (periodic.delayTickCounter == 0) {
                periodic.delayTickCounter = -1;
                LOGGER.debug("Periodic event triggered");
                this.processActionList(eventTaskItem, this.taskList.getTaskItemsForEvent(eventTaskItem));
            }
            periodic.previousDelay = delay;
        }
    }

    private void checkRenderableForTasklistEvents(RenderableBlock renderable, BlockPos actualBlockPos) {
        if (this.executingActionList || this.taskList.isEmpty() || this.m_146895_() == null || this.m_146895_() instanceof Player) {
            return;
        }
        BlockPos belowPos = actualBlockPos.m_7495_();
        BlockState belowState = this.m_9236_().m_8055_(belowPos);
        if (belowState.m_60803_()) {
            int maxPower = 0;
            for (Direction d : Direction.values()) {
                int power = belowState.m_60746_((BlockGetter)this.m_9236_(), belowPos, d);
                if (power <= maxPower) continue;
                maxPower = power;
            }
            TaskItem redstoneEvent = TaskItem.event(TaskElement.REDSTONE_EVENT);
            TaskItem redstoneEvent2 = TaskItem.event(TaskElement.REDSTONE_EVENT2);
            if (this.taskList.hasTaskListForEvent(redstoneEvent) || this.taskList.hasTaskListForEvent(redstoneEvent2)) {
                TaskItem eventTaskItem = this.taskList.getFirstTaskForEvent(redstoneEvent);
                this.processRedstoneEvent(maxPower, redstoneEvent, eventTaskItem);
                TaskItem eventTaskItem2 = this.taskList.getFirstTaskForEvent(redstoneEvent2);
                this.processRedstoneEvent(maxPower, redstoneEvent2, eventTaskItem2);
            }
        }
    }

    private void processRedstoneEvent(int maxPower, TaskItem redstoneEvent, TaskItem eventTaskItem) {
        if (eventTaskItem != null) {
            TaskItem.TaskParam minRedstoneParam = eventTaskItem.taskParams.get((Object)TaskParamType.PARAM_MIN_REDSTONE);
            TaskItem.TaskParam maxRedstoneParam = eventTaskItem.taskParams.get((Object)TaskParamType.PARAM_MAX_REDSTONE);
            int minRedstone = 1;
            int maxRedstone = 15;
            if (minRedstoneParam != null) {
                minRedstone = minRedstoneParam.toInt(minRedstone, minRedstone, maxRedstone);
            }
            if (maxRedstoneParam != null) {
                maxRedstone = maxRedstoneParam.toInt(maxRedstone, minRedstone, maxRedstone);
            }
            if (maxPower >= minRedstone && maxPower <= maxRedstone) {
                LOGGER.debug("Redstone event triggered for power=" + maxPower);
                this.processActionList(redstoneEvent, this.taskList.getTaskItemsForEvent(redstoneEvent));
            }
        }
    }

    private void processActionList(TaskItem eventTaskItem, List<TaskItem> taskItems) {
        int index = 0;
        for (TaskItem taskItem : taskItems) {
            if (taskItem.taskType == TaskItemType.ACTION) {
                this.currentTaskListElement = eventTaskItem.element;
                this.executingActionList = true;
                this.currentTaskList = taskItems;
                this.currentTask = taskItem;
                this.currentTask.inProgress = false;
                this.currentTask.reset();
                this.currentTaskIndex = index;
                break;
            }
            ++index;
        }
    }

    private void resetActionList() {
        TaskElement element = null;
        if (this.currentTask != null) {
            element = this.currentTask.element;
            this.currentTask.inProgress = false;
            this.currentTask.reset();
        }
        if (element != null && (element == TaskElement.FORWARD_ACTION || element == TaskElement.BACKWARDS_ACTION)) {
            this.wantToBrake = false;
            this.forwardCommandActive = false;
            this.reverseCommandActive = false;
        }
        this.currentTaskListElement = null;
        this.currentTask = null;
        this.currentTaskList = null;
        this.currentTaskIndex = -1;
        this.executingActionList = false;
    }

    private void processCurrentTask() {
        if (this.currentTask != null && this.currentTaskList != null) {
            if (this.currentTask.taskType == TaskItemType.EVENT) {
                LOGGER.debug("Finished task list");
                this.resetActionList();
                return;
            }
            if (this.m_146895_() == null) {
                this.resetActionList();
                return;
            }
            if (!this.currentTask.inProgress) {
                this.handleUnprogressedTasks();
            } else {
                this.handleInProgressTasks();
            }
        }
    }

    private void handleUnprogressedTasks() {
        if (this.currentTask.element == TaskElement.FORWARD_ACTION) {
            TaskItem taskItem;
            TaskItem.TaskParam blockCountParam = this.currentTask.taskParams.get((Object)TaskParamType.PARAM_BLOCK_COUNT);
            if (blockCountParam != null && (taskItem = this.currentTask) instanceof ForwardTaskItem) {
                ForwardTaskItem forward = (ForwardTaskItem)taskItem;
                int blockCount = blockCountParam.toInt(1, 1, 9999);
                this.currentTask.inProgress = true;
                double topSpeedBps = (double)this.moverStats.topSpeed * 20.0;
                double accelBpss = (double)this.moverStats.acceleration * 20.0 * 20.0;
                Kinematics.MovementInfo mi = Kinematics.computeMovements(blockCount, topSpeedBps, accelBpss, reverseSpeedFactor);
                Vec3 displacement = this.m_20252_(1.0f).m_82542_((double)blockCount, 0.0, (double)blockCount);
                forward.targetLocation = this.m_20182_().m_82549_(displacement);
                forward.taskForwardAction = true;
                this.wantToBrake = false;
                this.reverseCommandActive = false;
                this.forwardCommandActive = true;
                LOGGER.debug("Forward with position=" + this.m_20182_() + " and targetLocation=" + forward.targetLocation);
                LOGGER.debug("Begin task=" + this.currentTask.displayName + " with distance=" + blockCount);
            }
        } else if (this.currentTask.element == TaskElement.BACKWARDS_ACTION) {
            TaskItem blockCount;
            TaskItem.TaskParam blockCountParam = this.currentTask.taskParams.get((Object)TaskParamType.PARAM_BLOCK_COUNT);
            if (blockCountParam != null && (blockCount = this.currentTask) instanceof BackwardsTaskItem) {
                BackwardsTaskItem backwards = (BackwardsTaskItem)blockCount;
                int blockCount2 = blockCountParam.toInt(1, 1, 9999);
                this.currentTask.inProgress = true;
                float topSpeedBps = this.moverStats.topSpeed * 20.0f;
                float accelBpss = this.moverStats.acceleration * 20.0f * 20.0f;
                Kinematics.MovementInfo mi = Kinematics.computeMovements(blockCount2, topSpeedBps, accelBpss, reverseSpeedFactor);
                Vec3 displacement = this.m_20252_(1.0f).m_82542_((double)blockCount2, 0.0, (double)blockCount2);
                backwards.targetLocation = this.m_20182_().m_82546_(displacement);
                backwards.taskBackwardsAction = true;
                this.wantToBrake = false;
                this.reverseCommandActive = true;
                this.forwardCommandActive = false;
                LOGGER.debug("Backwards with position=" + this.m_20182_() + " and targetLocation=" + backwards.targetLocation);
                LOGGER.debug("Begin task=" + this.currentTask.displayName + " with distance=" + blockCount2);
            }
        } else if (this.currentTask.element == TaskElement.DELAY_ACTION) {
            TaskItem blockCount2;
            TaskItem.TaskParam delayParam = this.currentTask.taskParams.get((Object)TaskParamType.PARAM_DELAY_SEC);
            if (delayParam != null && (blockCount2 = this.currentTask) instanceof DelayTaskItem) {
                DelayTaskItem delay = (DelayTaskItem)blockCount2;
                int delaySec = delayParam.toInt(1, 1, 9999);
                this.currentTask.inProgress = true;
                delay.taskDelayTickCounter = delaySec * 20;
                LOGGER.debug("Begin task=" + this.currentTask.displayName + " with delay=" + delaySec);
            }
        } else if (this.currentTask.element == TaskElement.TURN_LEFT_ACTION) {
            TaskItem delaySec;
            TaskItem.TaskParam degreesParam = this.currentTask.taskParams.get((Object)TaskParamType.PARAM_DEGREES);
            if (degreesParam != null && (delaySec = this.currentTask) instanceof TurnTaskItem) {
                TurnTaskItem turn = (TurnTaskItem)delaySec;
                int degrees = degreesParam.toInt(90, 0, 360);
                this.currentTask.inProgress = true;
                turn.targetAngle = this.correctTo45Angle(this.sanitizeAngle(this.m_146908_() - (float)degrees));
                this.turn(-degrees);
                LOGGER.debug("Begin task=" + this.currentTask.displayName + " with degrees=" + degrees + " and target angle=" + turn.targetAngle);
            }
        } else if (this.currentTask.element == TaskElement.TURN_RIGHT_ACTION) {
            TaskItem degrees;
            TaskItem.TaskParam degreesParam = this.currentTask.taskParams.get((Object)TaskParamType.PARAM_DEGREES);
            if (degreesParam != null && (degrees = this.currentTask) instanceof TurnTaskItem) {
                TurnTaskItem turn = (TurnTaskItem)degrees;
                int degrees2 = degreesParam.toInt(90, 0, 360);
                this.currentTask.inProgress = true;
                turn.targetAngle = this.correctTo45Angle(this.sanitizeAngle(this.m_146908_() + (float)degrees2));
                this.turn(degrees2);
                LOGGER.debug("Begin task=" + this.currentTask.displayName + " with degrees=" + degrees2 + " and target angle=" + turn.targetAngle);
            }
        } else if (this.currentTask.element == TaskElement.UNLOAD_CARGO_ACTION) {
            this.currentTask.inProgress = true;
            LOGGER.debug("Begin task=" + this.currentTask.displayName);
        } else if (this.currentTask.element == TaskElement.LOAD_CARGO_ACTION) {
            this.currentTask.inProgress = true;
            LOGGER.debug("Begin task=" + this.currentTask.displayName);
        } else if (this.currentTask.element == TaskElement.CREATE_MOD_TAKE_FROM_ITEM_VAULT) {
            if (!XenoTechCommon.CREATE_MOD.exec(() -> {
                this.currentTask.inProgress = true;
                LOGGER.debug("Begin task=" + this.currentTask.displayName);
            })) {
                this.advanceCurrentTask();
            }
        } else if (this.currentTask.element == TaskElement.CREATE_MOD_ADD_TO_ITEM_VAULT) {
            if (!XenoTechCommon.CREATE_MOD.exec(() -> {
                this.currentTask.inProgress = true;
                LOGGER.debug("Begin task=" + this.currentTask.displayName);
            })) {
                this.advanceCurrentTask();
            }
        } else if (this.currentTask.element == TaskElement.CREATE_MOD_TAKE_FROM_FLUID_TANK) {
            if (!XenoTechCommon.CREATE_MOD.exec(() -> {
                this.currentTask.inProgress = true;
                LOGGER.debug("Begin task=" + this.currentTask.displayName);
            })) {
                this.advanceCurrentTask();
            }
        } else if (this.currentTask.element == TaskElement.CREATE_MOD_ADD_TO_FLUID_TANK) {
            if (!XenoTechCommon.CREATE_MOD.exec(() -> {
                this.currentTask.inProgress = true;
                LOGGER.debug("Begin task=" + this.currentTask.displayName);
            })) {
                this.advanceCurrentTask();
            }
        } else if (this.currentTask.element == TaskElement.VERTICAL_ASCENT_ACTION) {
            if (this.liftMoverStats.acceleration == 0.0f) {
                this.advanceCurrentTask();
            } else {
                TaskItem degrees2;
                TaskItem.TaskParam blockCountParam = this.currentTask.taskParams.get((Object)TaskParamType.PARAM_BLOCK_COUNT);
                if (blockCountParam != null && (degrees2 = this.currentTask) instanceof AscentTaskItem) {
                    AscentTaskItem verticalTask = (AscentTaskItem)degrees2;
                    int blockCount = blockCountParam.toInt(1, 1, 9999);
                    this.currentTask.inProgress = true;
                    verticalTask.targetLocation = this.m_20182_().m_82520_(0.0, (double)blockCount, 0.0);
                    this.autopilotWantToAscend = true;
                    this.autopilotWantToDescend = false;
                    this.wantToBrake = false;
                    this.reverseCommandActive = false;
                    this.forwardCommandActive = false;
                    LOGGER.debug("Ascend with position=" + this.m_20182_() + " and targetLocation=" + verticalTask.targetLocation);
                    LOGGER.debug("Begin task=" + this.currentTask.displayName + " with distance=" + blockCount);
                }
            }
        } else if (this.currentTask.element == TaskElement.VERTICAL_DESCENT_ACTION) {
            if (this.liftMoverStats.acceleration == 0.0f) {
                this.advanceCurrentTask();
            } else {
                TaskItem blockCount;
                TaskItem.TaskParam blockCountParam = this.currentTask.taskParams.get((Object)TaskParamType.PARAM_BLOCK_COUNT);
                if (blockCountParam != null && (blockCount = this.currentTask) instanceof DescentTaskItem) {
                    DescentTaskItem verticalTask = (DescentTaskItem)blockCount;
                    int blockCount3 = blockCountParam.toInt(1, 1, 9999);
                    this.currentTask.inProgress = true;
                    verticalTask.targetLocation = this.m_20182_().m_82520_(0.0, (double)(-blockCount3), 0.0);
                    this.autopilotWantToAscend = false;
                    this.autopilotWantToDescend = true;
                    this.wantToBrake = false;
                    this.reverseCommandActive = false;
                    this.forwardCommandActive = false;
                    LOGGER.debug("Descend with position=" + this.m_20182_() + " and targetLocation=" + verticalTask.targetLocation);
                    LOGGER.debug("Begin task=" + this.currentTask.displayName + " with distance=" + blockCount3);
                }
            }
        }
    }

    private float correctTo45Angle(float sanitizedAngle) {
        float[] angles45 = new float[]{0.0f, 45.0f, 90.0f, 135.0f, 180.0f, 225.0f, 270.0f, 315.0f};
        for (int i = 0; i < angles45.length; ++i) {
            float angleDiff = Math.abs(angles45[i] - sanitizedAngle);
            if (!(angleDiff < 1.0f)) continue;
            sanitizedAngle = angles45[i];
            break;
        }
        return sanitizedAngle;
    }

    private float correctToRightAngle(float sanitizedAngle) {
        float[] rightAngles = new float[]{0.0f, 90.0f, 180.0f, 270.0f};
        for (int i = 0; i < rightAngles.length; ++i) {
            float angleDiff = Math.abs(rightAngles[i] - sanitizedAngle);
            if (!(angleDiff < 1.0f)) continue;
            sanitizedAngle = rightAngles[i];
            break;
        }
        return sanitizedAngle;
    }

    private void handleInProgressTasks() {
        double currentSpeed = this.m_20184_().m_165924_();
        if (this.currentTask.element == TaskElement.FORWARD_ACTION || this.currentTask.element == TaskElement.BACKWARDS_ACTION) {
            TaskItem remainingDistance2;
            double stoppingDistance;
            int excessTimePercentInteger;
            double excessTimeByPercent;
            double tStop;
            Vec3 taskTargetLocation = null;
            Vec3 horizontalMask = new Vec3(1.0, 0.0, 1.0);
            TaskItem taskItem = this.currentTask;
            if (taskItem instanceof ForwardTaskItem) {
                ForwardTaskItem forward = (ForwardTaskItem)taskItem;
                taskTargetLocation = forward.targetLocation;
                if (forward.taskForwardAction) {
                    if (this.useTimeForStopping) {
                        double t = Kinematics.timeToReachLocationInTicks(this.m_20182_(), forward.targetLocation, currentSpeed);
                        tStop = Kinematics.timeRequiredToStopInTicks(currentSpeed, this.moverStats.acceleration, reverseSpeedFactor);
                        excessTimeByPercent = t / tStop;
                        excessTimePercentInteger = (int)(excessTimeByPercent *= 100.0);
                        if (currentSpeed == 0.0 || excessTimePercentInteger > 104) {
                            this.reverseCommandActive = false;
                            this.forwardCommandActive = true;
                        } else {
                            this.reverseCommandActive = true;
                            this.forwardCommandActive = false;
                        }
                    } else {
                        double remainingDistance2 = forward.targetLocation.m_82559_(horizontalMask).m_82554_(this.m_20182_().m_82559_(horizontalMask));
                        tStop = Kinematics.timeRequiredToStopInTicks(currentSpeed, this.getForwardAccel(), reverseSpeedFactor);
                        stoppingDistance = Kinematics.dist(currentSpeed, tStop, this.getReverseAccel());
                        stoppingDistance = Kinematics.distFromVelocity(currentSpeed, 0.0, tStop);
                        if (!forward.isBraking) {
                            if (currentSpeed == 0.0 || stoppingDistance < remainingDistance2) {
                                LOGGER.trace("forward: dist=" + remainingDistance2 + ", stopTime=" + tStop + " with stoppingDistance=" + stoppingDistance + " and currentSpeed=" + currentSpeed);
                                this.reverseCommandActive = false;
                                this.forwardCommandActive = true;
                            } else {
                                forward.isBraking = true;
                            }
                        }
                        if (forward.isBraking) {
                            if (tStop > 0.0) {
                                LOGGER.trace("BRAKING forward: dist=" + remainingDistance2 + ", stopTime=" + tStop + " with stoppingDistance=" + stoppingDistance + " and currentSpeed=" + currentSpeed);
                                this.reverseCommandActive = true;
                                this.forwardCommandActive = false;
                            } else {
                                this.reverseCommandActive = false;
                                this.forwardCommandActive = false;
                                this.wantToBrake = true;
                            }
                        }
                    }
                }
            }
            if ((remainingDistance2 = this.currentTask) instanceof BackwardsTaskItem) {
                BackwardsTaskItem backwards = (BackwardsTaskItem)remainingDistance2;
                taskTargetLocation = backwards.targetLocation;
                if (backwards.taskBackwardsAction) {
                    if (this.useTimeForStopping) {
                        double t = Kinematics.timeToReachLocationInTicks(this.m_20182_(), backwards.targetLocation, currentSpeed);
                        tStop = Kinematics.timeRequiredToStopInTicks(currentSpeed, this.moverStats.acceleration, reverseSpeedFactor);
                        excessTimeByPercent = t / tStop;
                        excessTimePercentInteger = (int)(excessTimeByPercent *= 100.0);
                        if (currentSpeed == 0.0 || excessTimePercentInteger > 104) {
                            this.reverseCommandActive = true;
                            this.forwardCommandActive = false;
                        } else {
                            this.reverseCommandActive = false;
                            this.forwardCommandActive = true;
                        }
                    } else {
                        double remainingDistance3 = backwards.targetLocation.m_82559_(horizontalMask).m_82554_(this.m_20182_().m_82559_(horizontalMask));
                        tStop = Kinematics.timeRequiredToStopInTicks(currentSpeed, this.getForwardAccel(), reverseSpeedFactor);
                        stoppingDistance = Kinematics.dist(currentSpeed, tStop, this.getReverseAccel());
                        stoppingDistance = Kinematics.distFromVelocity(currentSpeed, 0.0, tStop);
                        if (!backwards.isBraking) {
                            if (currentSpeed == 0.0 || stoppingDistance < remainingDistance3) {
                                this.reverseCommandActive = true;
                                this.forwardCommandActive = false;
                            } else {
                                backwards.isBraking = true;
                            }
                        }
                        if (backwards.isBraking) {
                            if (tStop > 0.0) {
                                this.reverseCommandActive = false;
                                this.forwardCommandActive = true;
                            } else {
                                this.reverseCommandActive = false;
                                this.forwardCommandActive = false;
                                this.wantToBrake = true;
                            }
                        }
                    }
                }
            }
            if (taskTargetLocation != null) {
                TaskItem speedLowEnough2;
                boolean passedDestination;
                Vec3 vectorToLocation = taskTargetLocation.m_82546_(this.m_20182_());
                Vec3 viewVec = this.m_20252_(1.0f);
                TaskItem tStop2 = this.currentTask;
                if (tStop2 instanceof BackwardsTaskItem) {
                    BackwardsTaskItem backwards = (BackwardsTaskItem)tStop2;
                    if (backwards.taskBackwardsAction) {
                        viewVec = viewVec.m_82542_(-1.0, -1.0, -1.0);
                    }
                }
                boolean bl = passedDestination = vectorToLocation.m_82541_().m_82526_(viewVec) < 0.0;
                if (this.arrestMovementNearDestination(currentSpeed, taskTargetLocation, horizontalMask)) {
                    currentSpeed = 0.0;
                }
                if (this.currentTask.element == TaskElement.FORWARD_ACTION) {
                    TaskItem taskItem2 = this.currentTask;
                    if (taskItem2 instanceof ForwardTaskItem) {
                        Vec3 autoCorrectLocation;
                        boolean inAutocorrectDistance;
                        boolean speedLowEnough2;
                        ForwardTaskItem forward = (ForwardTaskItem)taskItem2;
                        this.wantToBrake = false;
                        boolean bl2 = speedLowEnough2 = currentSpeed <= 0.01;
                        if ((taskTargetLocation != null && speedLowEnough2 || passedDestination || !forward.taskForwardAction) && ((inAutocorrectDistance = this.isInAutocorrectDistance(autoCorrectLocation = new Vec3(taskTargetLocation.m_7096_(), this.m_20186_(), taskTargetLocation.m_7094_()))) || passedDestination || !forward.taskForwardAction)) {
                            if (forward.taskForwardAction) {
                                forward.taskForwardAction = false;
                                this.reverseCommandActive = true;
                                this.forwardCommandActive = false;
                            }
                            this.wantToBrake = true;
                            if (passedDestination) {
                                LOGGER.warn("Passed destination while moving forward!");
                            }
                            if (speedLowEnough2 && inAutocorrectDistance) {
                                this.autocorrectToLocation(autoCorrectLocation);
                            }
                            if (speedLowEnough2) {
                                this.advanceCurrentTask();
                            }
                        }
                    }
                } else if (this.currentTask.element == TaskElement.BACKWARDS_ACTION && (speedLowEnough2 = this.currentTask) instanceof BackwardsTaskItem) {
                    Vec3 autoCorrectLocation;
                    boolean inAutocorrectDistance;
                    BackwardsTaskItem backwards = (BackwardsTaskItem)speedLowEnough2;
                    this.wantToBrake = false;
                    boolean bl3 = speedLowEnough = currentSpeed <= 0.01;
                    if ((taskTargetLocation != null && speedLowEnough || passedDestination || !backwards.taskBackwardsAction) && ((inAutocorrectDistance = this.isInAutocorrectDistance(autoCorrectLocation = new Vec3(taskTargetLocation.m_7096_(), this.m_20186_(), taskTargetLocation.m_7094_()))) || passedDestination || !backwards.taskBackwardsAction)) {
                        if (backwards.taskBackwardsAction) {
                            backwards.taskBackwardsAction = false;
                            this.reverseCommandActive = false;
                            this.forwardCommandActive = true;
                        }
                        this.wantToBrake = true;
                        if (passedDestination) {
                            LOGGER.warn("Passed destination while moving backwards!");
                        }
                        if (speedLowEnough && inAutocorrectDistance) {
                            this.autocorrectToLocation(autoCorrectLocation);
                        }
                        if (speedLowEnough) {
                            this.advanceCurrentTask();
                        }
                    }
                }
            }
        } else if (this.currentTask.element == TaskElement.VERTICAL_ASCENT_ACTION) {
            TaskItem horizontalMask = this.currentTask;
            if (horizontalMask instanceof AscentTaskItem) {
                Vec3 verticalMask;
                AscentTaskItem verticalTask = (AscentTaskItem)horizontalMask;
                double ySpeed = Math.abs(this.m_20184_().f_82480_);
                if (this.arrestMovementNearDestination(ySpeed, verticalTask.targetLocation, verticalMask = new Vec3(0.0, 1.0, 0.0))) {
                    ySpeed = 0.0;
                    verticalTask.isBraking = true;
                }
                if (this.f_19863_ || verticalTask.isBraking && ySpeed <= 0.001) {
                    this.autopilotWantToAscend = false;
                    this.autopilotWantToDescend = false;
                    if (this.isInAutocorrectDistance(verticalTask.targetLocation)) {
                        this.autocorrectToLocation(verticalTask.targetLocation);
                    }
                    this.advanceCurrentTask();
                } else if (this.useTimeForStopping) {
                    boolean inAutocorrectDistance;
                    double t = Kinematics.timeToReachLocationInTicks(this.m_20182_(), verticalTask.targetLocation, ySpeed);
                    double tStop = Kinematics.timeRequiredToStopInTicks(ySpeed, this.liftMoverStats.acceleration, 1.0);
                    double excessTimeByPercent = t / (tStop /= 2.0);
                    int excessTimePercentInteger = (int)(excessTimeByPercent *= 100.0);
                    Vec3 vecToLoc = verticalTask.targetLocation.m_82546_(this.m_20182_());
                    boolean bl = inAutocorrectDistance = this.m_20238_(verticalTask.targetLocation) <= 1.6900000000000002;
                    if (!verticalTask.isBraking) {
                        if (ySpeed == 0.0 || excessTimePercentInteger > 104) {
                            this.autopilotWantToAscend = true;
                            this.autopilotWantToDescend = false;
                        } else if (tStop != 0.0) {
                            LOGGER.debug("braking");
                            verticalTask.isBraking = true;
                        }
                    }
                    if (verticalTask.isBraking) {
                        if (tStop > 0.0) {
                            this.autopilotWantToAscend = false;
                            this.autopilotWantToDescend = true;
                        } else {
                            this.autopilotWantToAscend = false;
                            this.autopilotWantToDescend = false;
                            this.wantToBrake = true;
                        }
                    }
                } else {
                    double remainingDistance = Math.abs(verticalTask.targetLocation.f_82480_ - this.m_20182_().f_82480_);
                    double tStop = Kinematics.timeRequiredToStopInTicks(ySpeed, this.liftMoverStats.acceleration, 1.0);
                    double stoppingDistance = Kinematics.dist(ySpeed, tStop, -this.liftMoverStats.acceleration);
                    stoppingDistance = Kinematics.distFromVelocity(ySpeed, 0.0, tStop);
                    LOGGER.trace("ascend: dist=" + remainingDistance + ", stopTime=" + tStop + " with stoppingDistance=" + stoppingDistance + " and speed=" + ySpeed);
                    if (!verticalTask.isBraking) {
                        if (ySpeed == 0.0 || stoppingDistance < remainingDistance) {
                            this.autopilotWantToAscend = true;
                            this.autopilotWantToDescend = false;
                        } else if (tStop != 0.0) {
                            LOGGER.debug("braking");
                            verticalTask.isBraking = true;
                        }
                    }
                    if (verticalTask.isBraking) {
                        if (tStop > 0.0) {
                            this.autopilotWantToAscend = false;
                            this.autopilotWantToDescend = true;
                        } else {
                            this.autopilotWantToAscend = false;
                            this.autopilotWantToDescend = false;
                            this.wantToBrake = true;
                        }
                    }
                }
            }
        } else if (this.currentTask.element == TaskElement.VERTICAL_DESCENT_ACTION) {
            TaskItem ySpeed = this.currentTask;
            if (ySpeed instanceof DescentTaskItem) {
                DescentTaskItem verticalTask = (DescentTaskItem)ySpeed;
                double ySpeed2 = Math.abs(this.m_20184_().f_82480_);
                if (this.arrestMovementNearDestination(ySpeed2, verticalTask.targetLocation, new Vec3(0.0, 1.0, 0.0))) {
                    ySpeed2 = 0.0;
                    verticalTask.isBraking = true;
                }
                if (this.f_19863_ || verticalTask.isBraking && ySpeed2 <= 0.001) {
                    this.autopilotWantToAscend = false;
                    this.autopilotWantToDescend = false;
                    if (this.isInAutocorrectDistance(verticalTask.targetLocation)) {
                        this.autocorrectToLocation(verticalTask.targetLocation);
                    }
                    this.advanceCurrentTask();
                } else if (this.useTimeForStopping) {
                    boolean inAutocorrectDistance;
                    double t = Kinematics.timeToReachLocationInTicks(this.m_20182_(), verticalTask.targetLocation, ySpeed2);
                    double tStop = Kinematics.timeRequiredToStopInTicks(ySpeed2, this.liftMoverStats.acceleration, 1.0);
                    double excessTimeByPercent = t / (tStop /= 2.0);
                    int excessTimePercentInteger = (int)(excessTimeByPercent *= 100.0);
                    Vec3 vecToLoc = verticalTask.targetLocation.m_82546_(this.m_20182_());
                    boolean bl = inAutocorrectDistance = this.m_20238_(verticalTask.targetLocation) <= 1.6900000000000002;
                    if (!verticalTask.isBraking) {
                        if (ySpeed2 == 0.0 || excessTimePercentInteger > 104) {
                            this.autopilotWantToAscend = false;
                            this.autopilotWantToDescend = true;
                        } else if (tStop != 0.0) {
                            verticalTask.isBraking = true;
                        }
                    }
                    if (verticalTask.isBraking) {
                        this.autopilotWantToAscend = true;
                        this.autopilotWantToDescend = false;
                    }
                } else {
                    double remainingDistance = Math.abs(verticalTask.targetLocation.f_82480_ - this.m_20182_().f_82480_);
                    double tStop = Kinematics.timeRequiredToStopInTicks(ySpeed2, this.liftMoverStats.acceleration, 1.0);
                    double stoppingDistance = Kinematics.dist(ySpeed2, tStop, -this.liftMoverStats.acceleration);
                    stoppingDistance = Kinematics.distFromVelocity(ySpeed2, 0.0, tStop);
                    LOGGER.trace("descend: dist=" + remainingDistance + ", stopTime=" + tStop + " with stoppingDistance=" + stoppingDistance);
                    if (!verticalTask.isBraking) {
                        if (ySpeed2 == 0.0 || stoppingDistance < remainingDistance) {
                            this.autopilotWantToAscend = false;
                            this.autopilotWantToDescend = true;
                        } else if (tStop != 0.0) {
                            verticalTask.isBraking = true;
                        }
                    }
                    if (verticalTask.isBraking) {
                        this.autopilotWantToAscend = true;
                        this.autopilotWantToDescend = false;
                    }
                }
            }
        } else if (this.currentTask.element == TaskElement.DELAY_ACTION) {
            TaskItem ySpeed2 = this.currentTask;
            if (ySpeed2 instanceof DelayTaskItem) {
                DelayTaskItem delay = (DelayTaskItem)ySpeed2;
                --delay.taskDelayTickCounter;
                if (delay.taskDelayTickCounter <= 0) {
                    this.currentTask.inProgress = false;
                    this.advanceCurrentTask();
                }
            }
        } else if (this.currentTask.element == TaskElement.TURN_LEFT_ACTION) {
            if (this.getYRotRequest() == 0.0f) {
                this.currentTask.inProgress = false;
                TaskItem ySpeed2 = this.currentTask;
                if (ySpeed2 instanceof TurnTaskItem) {
                    TurnTaskItem turn = (TurnTaskItem)ySpeed2;
                    float sanitizedYRot = this.getSanitizedRotationAngle();
                    float angleDiff = Math.abs(sanitizedYRot - turn.targetAngle);
                    if (angleDiff <= 10.0f || angleDiff >= 350.0f) {
                        LOGGER.debug("auto-correct left-turn to angle=" + turn.targetAngle + " from angle=" + sanitizedYRot);
                        this.m_146922_(turn.targetAngle);
                    }
                }
                this.advanceCurrentTask();
            }
        } else if (this.currentTask.element == TaskElement.TURN_RIGHT_ACTION) {
            if (this.getYRotRequest() == 0.0f) {
                this.currentTask.inProgress = false;
                TaskItem sanitizedYRot = this.currentTask;
                if (sanitizedYRot instanceof TurnTaskItem) {
                    TurnTaskItem turn = (TurnTaskItem)sanitizedYRot;
                    float sanitizedYRot2 = this.getSanitizedRotationAngle();
                    float angleDiff = Math.abs(sanitizedYRot2 - turn.targetAngle);
                    LOGGER.trace("sanitizedYRot=" + sanitizedYRot2 + ", turn.targetAngle=" + turn.targetAngle + ", angleDiff=" + angleDiff);
                    if (angleDiff <= 10.0f || angleDiff >= 350.0f) {
                        LOGGER.debug("auto-correct right-turn to angle=" + turn.targetAngle + " from angle=" + sanitizedYRot2);
                        this.m_146922_(turn.targetAngle);
                    }
                }
                this.advanceCurrentTask();
            }
        } else if (this.currentTask.element == TaskElement.UNLOAD_CARGO_ACTION) {
            this.currentTask.inProgress = false;
            ArrayList<Container> onboardContainers = new ArrayList<Container>();
            ArrayList containers = new ArrayList();
            this.gatherOnboardAndNearbyContainers(onboardContainers, containers, Container.class);
            TaskItem.TaskParam itemFilterParam = this.currentTask.taskParams.get((Object)TaskParamType.PARAM_ITEM_FILTER);
            String filterText = null;
            if (itemFilterParam != null) {
                filterText = itemFilterParam.value;
            }
            ArrayList<Container> depositedContainers = new ArrayList<Container>();
            if (!containers.isEmpty() && !onboardContainers.isEmpty()) {
                LOGGER.debug("Found " + onboardContainers.size() + " onboard containers, " + containers + " world containers");
                for (Container onboard : onboardContainers) {
                    block1: for (int i = 0; i < onboard.m_6643_(); ++i) {
                        ItemStack onboardItem = onboard.m_8020_(i);
                        if (onboardItem.m_41619_() || !ItemStorage.itemStackMatchesTextFilter(onboardItem, filterText)) continue;
                        for (Container container : containers) {
                            ArrayList<ItemStack> toAdd = new ArrayList<ItemStack>();
                            toAdd.add(onboardItem);
                            if (!this.addToSpecificContainer(toAdd, container)) continue;
                            onboard.m_6836_(i, ItemStack.f_41583_);
                            depositedContainers.add(container);
                            continue block1;
                        }
                    }
                }
            }
            this.spawnDepositContainerParticles(depositedContainers);
            this.advanceCurrentTask();
        } else if (this.currentTask.element == TaskElement.LOAD_CARGO_ACTION) {
            this.currentTask.inProgress = false;
            ArrayList<Container> onboardContainers = new ArrayList<Container>();
            ArrayList containers = new ArrayList();
            this.gatherOnboardAndNearbyContainers(onboardContainers, containers, Container.class);
            TaskItem.TaskParam itemFilterParam = this.currentTask.taskParams.get((Object)TaskParamType.PARAM_ITEM_FILTER);
            String filterText = null;
            if (itemFilterParam != null) {
                filterText = itemFilterParam.value;
            }
            ArrayList<Container> depositedContainers = new ArrayList<Container>();
            if (!containers.isEmpty() && !onboardContainers.isEmpty()) {
                LOGGER.debug("Found " + onboardContainers.size() + " onboard containers, " + containers + " world containers");
                for (Container worldContainer : containers) {
                    block4: for (int i = 0; i < worldContainer.m_6643_(); ++i) {
                        ItemStack worldItem = worldContainer.m_8020_(i);
                        if (worldItem.m_41619_() || !ItemStorage.itemStackMatchesTextFilter(worldItem, filterText)) continue;
                        for (Container onboard : onboardContainers) {
                            ArrayList<ItemStack> toAdd = new ArrayList<ItemStack>();
                            toAdd.add(worldItem);
                            if (!this.addToSpecificContainer(toAdd, onboard)) continue;
                            worldContainer.m_6836_(i, ItemStack.f_41583_);
                            depositedContainers.add(onboard);
                            continue block4;
                        }
                    }
                }
            }
            this.spawnDepositContainerParticles(depositedContainers);
            this.advanceCurrentTask();
        } else if (this.currentTask.element == TaskElement.CREATE_MOD_TAKE_FROM_ITEM_VAULT) {
            XenoTechCommon.CREATE_MOD.exec(() -> {
                this.currentTask.inProgress = false;
                ArrayList<Container> onboardContainers = new ArrayList<Container>();
                ArrayList containers = new ArrayList();
                this.gatherOnboardAndNearbyContainers(onboardContainers, containers, ItemVaultBlockEntity.class);
                TaskItem.TaskParam itemFilterParam = this.currentTask.taskParams.get((Object)TaskParamType.PARAM_ITEM_FILTER);
                String filterText = null;
                if (itemFilterParam != null) {
                    filterText = itemFilterParam.value;
                }
                boolean foundController = false;
                ArrayList<Container> depositedContainers = new ArrayList<Container>();
                if (!containers.isEmpty() && !onboardContainers.isEmpty()) {
                    LOGGER.debug("Found " + onboardContainers.size() + " onboard containers, " + containers + " world containers");
                    for (ItemVaultBlockEntity worldContainer : containers) {
                        if (!(worldContainer = CreateModCompat.lookupController(worldContainer, ItemVaultBlockEntity.class)).isController()) continue;
                        foundController = true;
                        ItemStackHandler handler = worldContainer.getInventoryOfBlock();
                        if (handler == null) continue;
                        block1: for (int i = 0; i < handler.getSlots(); ++i) {
                            ItemStack worldItem = handler.getStackInSlot(i);
                            if (worldItem.m_41619_() || !ItemStorage.itemStackMatchesTextFilter(worldItem, filterText)) continue;
                            for (Container onboard : onboardContainers) {
                                ArrayList<ItemStack> toAdd = new ArrayList<ItemStack>();
                                toAdd.add(worldItem);
                                if (!this.addToSpecificContainer(toAdd, onboard)) continue;
                                handler.setStackInSlot(i, ItemStack.f_41583_);
                                depositedContainers.add(onboard);
                                worldContainer.m_6596_();
                                continue block1;
                            }
                        }
                    }
                }
                if (!foundController) {
                    LOGGER.debug("No controller found for task=" + this.currentTask.displayName);
                }
                this.spawnDepositContainerParticles(depositedContainers);
                this.advanceCurrentTask();
            });
        } else if (this.currentTask.element == TaskElement.CREATE_MOD_ADD_TO_ITEM_VAULT) {
            XenoTechCommon.CREATE_MOD.exec(() -> {
                this.currentTask.inProgress = false;
                ArrayList<Container> onboardContainers = new ArrayList<Container>();
                ArrayList containers = new ArrayList();
                this.gatherOnboardAndNearbyContainers(onboardContainers, containers, ItemVaultBlockEntity.class);
                TaskItem.TaskParam itemFilterParam = this.currentTask.taskParams.get((Object)TaskParamType.PARAM_ITEM_FILTER);
                String filterText = null;
                if (itemFilterParam != null) {
                    filterText = itemFilterParam.value;
                }
                boolean foundController = false;
                ArrayList<Container> depositedContainers = new ArrayList<Container>();
                if (!containers.isEmpty() && !onboardContainers.isEmpty()) {
                    LOGGER.debug("Found " + onboardContainers.size() + " onboard containers, " + containers + " world containers");
                    for (Container onboard : onboardContainers) {
                        block1: for (int i = 0; i < onboard.m_6643_(); ++i) {
                            ItemStack onboardItem = onboard.m_8020_(i);
                            if (onboardItem.m_41619_() || !ItemStorage.itemStackMatchesTextFilter(onboardItem, filterText)) continue;
                            for (ItemVaultBlockEntity container : containers) {
                                if (!(container = CreateModCompat.lookupController(container, ItemVaultBlockEntity.class)).isController()) continue;
                                foundController = true;
                                ItemStackHandler handler = container.getInventoryOfBlock();
                                if (handler == null) continue;
                                ArrayList<ItemStack> toAdd = new ArrayList<ItemStack>();
                                toAdd.add(onboardItem);
                                boolean added = false;
                                for (int k = 0; k < handler.getSlots(); ++k) {
                                    int limit = handler.getSlotLimit(k);
                                    ItemStack vaultItem = handler.getStackInSlot(k);
                                    int combinedCount = vaultItem.m_41613_() + onboardItem.m_41613_();
                                    if (vaultItem.m_41619_()) {
                                        handler.insertItem(k, onboardItem, false);
                                        onboard.m_6836_(i, ItemStack.f_41583_);
                                        added = true;
                                        break;
                                    }
                                    if (!ItemStack.m_150942_((ItemStack)vaultItem, (ItemStack)onboardItem) || combinedCount > limit) continue;
                                    onboard.m_6836_(i, ItemStack.f_41583_);
                                    vaultItem.m_41764_(combinedCount);
                                    added = true;
                                    break;
                                }
                                if (!added) continue;
                                container.m_6596_();
                                continue block1;
                            }
                        }
                    }
                }
                if (!foundController) {
                    LOGGER.debug("No controller found for task=" + this.currentTask.displayName);
                }
                this.spawnDepositContainerParticles(depositedContainers);
                this.advanceCurrentTask();
            });
        } else if (this.currentTask.element == TaskElement.CREATE_MOD_TAKE_FROM_FLUID_TANK) {
            XenoTechCommon.CREATE_MOD.exec(() -> {
                this.currentTask.inProgress = false;
                ArrayList<FluidShippingTankBlockEntity> fluidShippingTanks = new ArrayList<FluidShippingTankBlockEntity>();
                this.gatherFluidShippingTanks(fluidShippingTanks);
                ArrayList containers = new ArrayList();
                this.gatherOnboardAndNearbyContainers(null, containers, FluidTankBlockEntity.class);
                boolean foundController = false;
                ArrayList<Container> depositedContainers = new ArrayList<Container>();
                if (!containers.isEmpty() && !fluidShippingTanks.isEmpty()) {
                    for (FluidTankBlockEntity worldContainer : containers) {
                        if (!(worldContainer = CreateModCompat.lookupController(worldContainer, FluidTankBlockEntity.class)).isController()) continue;
                        foundController = true;
                        IFluidTank handler = worldContainer.getTankInventory();
                        if (handler == null || handler.getFluid().isEmpty()) continue;
                        for (FluidShippingTankBlockEntity shippingTank : fluidShippingTanks) {
                            int capacity = shippingTank.getFluidInventory().getCapacity();
                            int amount = shippingTank.getFluidInventory().getFluidAmount();
                            int deficit = capacity - amount;
                            FluidStack toDrain = handler.getFluid().copy();
                            int drainAmount = Math.min(deficit, toDrain.getAmount());
                            toDrain.setAmount(drainAmount);
                            FluidStack drained = handler.drain(toDrain, IFluidHandler.FluidAction.SIMULATE);
                            if (shippingTank.getFluidInventory().fill(drained, IFluidHandler.FluidAction.SIMULATE) != drainAmount) continue;
                            drained = handler.drain(toDrain, IFluidHandler.FluidAction.EXECUTE);
                            shippingTank.getFluidInventory().fill(drained, IFluidHandler.FluidAction.EXECUTE);
                            LOGGER.debug("Drained " + drained.getAmount() + " from Fluid Tank: " + worldContainer);
                            worldContainer.m_6596_();
                            this.m_9236_().m_7260_(worldContainer.m_58899_(), worldContainer.m_58900_(), worldContainer.m_58900_(), 2);
                        }
                    }
                }
                if (!foundController) {
                    LOGGER.debug("No controller found for task=" + this.currentTask.displayName);
                }
                this.spawnDepositContainerParticles(depositedContainers);
                this.advanceCurrentTask();
            });
        } else if (this.currentTask.element == TaskElement.CREATE_MOD_ADD_TO_FLUID_TANK) {
            XenoTechCommon.CREATE_MOD.exec(() -> {
                this.currentTask.inProgress = false;
                ArrayList<FluidShippingTankBlockEntity> fluidShippingTanks = new ArrayList<FluidShippingTankBlockEntity>();
                this.gatherFluidShippingTanks(fluidShippingTanks);
                ArrayList containers = new ArrayList();
                this.gatherOnboardAndNearbyContainers(null, containers, FluidTankBlockEntity.class);
                boolean foundController = false;
                ArrayList<Container> depositedContainers = new ArrayList<Container>();
                if (!containers.isEmpty() && !fluidShippingTanks.isEmpty()) {
                    LOGGER.debug("Found " + fluidShippingTanks.size() + " onboard containers, " + containers + " world containers");
                    block0: for (FluidShippingTankBlockEntity shippingTank : fluidShippingTanks) {
                        if (shippingTank.getFluidInventory().isEmpty()) continue;
                        for (FluidTankBlockEntity container : containers) {
                            int amount;
                            int capacity;
                            int deficit;
                            if (!(container = CreateModCompat.lookupController(container, FluidTankBlockEntity.class)).isController()) continue;
                            foundController = true;
                            IFluidTank handler = container.getTankInventory();
                            if (handler == null || (deficit = (capacity = handler.getCapacity()) - (amount = handler.getFluidAmount())) <= 0) continue;
                            FluidStack toAdd = shippingTank.getFluidInventory().getFluid().copy();
                            int addAmount = Math.min(deficit, toAdd.getAmount());
                            toAdd.setAmount(addAmount);
                            int addedCount = handler.fill(toAdd, IFluidHandler.FluidAction.SIMULATE);
                            if (addedCount != addAmount) continue;
                            int filledAmount = handler.fill(toAdd, IFluidHandler.FluidAction.EXECUTE);
                            FluidStack toDrain = toAdd.copy();
                            toDrain.setAmount(filledAmount);
                            FluidStack drained = shippingTank.getFluidInventory().drain(toDrain, IFluidHandler.FluidAction.EXECUTE);
                            LOGGER.debug("Added " + filledAmount + " to Fluid Tank: " + container + " based on deficit=" + deficit);
                            container.m_6596_();
                            this.m_9236_().m_7260_(container.m_58899_(), container.m_58900_(), container.m_58900_(), 2);
                            if (!shippingTank.getFluidInventory().isEmpty()) continue;
                            continue block0;
                        }
                    }
                }
                if (!foundController) {
                    LOGGER.debug("No controller found for task=" + this.currentTask.displayName);
                }
                this.spawnDepositContainerParticles(depositedContainers);
                this.advanceCurrentTask();
            });
        }
    }

    private void gatherFluidShippingTanks(List<FluidShippingTankBlockEntity> fluidShippingTanks) {
        if (fluidShippingTanks == null) {
            return;
        }
        for (RenderableBlock renderable : this.renderables) {
            BlockEntity blockEntity = renderable.tempBlockEntity;
            if (!(blockEntity instanceof FluidShippingTankBlockEntity)) continue;
            FluidShippingTankBlockEntity shippingTank = (FluidShippingTankBlockEntity)blockEntity;
            fluidShippingTanks.add(shippingTank);
        }
    }

    private <T> void gatherOnboardAndNearbyContainers(List<Container> onboardContainers, List<T> containers, Class containerClass) {
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        for (RenderableBlock renderable : this.renderables) {
            Vec3 rotPos = XenoTechUtils.getRotPosForRenderable(this, renderable);
            BlockPos rotBlockPos = XenoTechUtils.blockPosFromRotPos(rotPos);
            if (onboardContainers != null && this.isValidOnboardContainer(renderable)) {
                onboardContainers.add((Container)renderable.tempBlockEntity);
            }
            if (containers == null) continue;
            this.populateNearbyContainerList(containers, visited, rotBlockPos, containerClass);
        }
    }

    private void spawnDepositContainerParticles(List<Container> depositedContainers) {
        for (Container container : depositedContainers) {
            if (!(container instanceof BlockEntity)) continue;
            BlockEntity blockEntity = (BlockEntity)container;
            BlockPos blockEntityPos = blockEntity.m_58899_();
            Level level = this.m_9236_();
            if (!(level instanceof ServerLevel)) continue;
            ServerLevel serverLevel = (ServerLevel)level;
            int count = 50;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123808_, (double)blockEntityPos.m_123341_() + 0.5, (double)blockEntityPos.m_123342_() + 1.1, (double)blockEntityPos.m_123343_() + 0.5, count, 0.6, 0.6, 0.6, 0.1);
        }
    }

    private void autocorrectToLocation(Vec3 taskTargetLocation) {
        LOGGER.debug("auto-correct position to location=" + taskTargetLocation + " with distance=" + Math.sqrt(this.m_20238_(taskTargetLocation)));
        this.m_146884_(taskTargetLocation);
        this.resetMovementInputs();
    }

    private boolean isInStopTaskDistance(Vec3 taskTargetLocation, Vec3 positionMult) {
        return this.m_20182_().m_82559_(positionMult).m_82557_(taskTargetLocation.m_82559_(positionMult)) <= 1.6900000000000002;
    }

    private boolean isInAutocorrectDistance(Vec3 taskTargetLocation) {
        return this.isInStopTaskDistance(taskTargetLocation, new Vec3(1.0, 1.0, 1.0));
    }

    private boolean arrestMovementNearDestination(double currentSpeed, Vec3 taskTargetLocation, Vec3 positionMult) {
        if (!this.useArrestMovement) {
            return false;
        }
        if (this.m_20182_().m_82559_(positionMult).m_82557_(taskTargetLocation.m_82559_(positionMult)) <= 0.0625 && currentSpeed <= 0.1) {
            double dist = this.m_20182_().m_82559_(positionMult).m_82554_(taskTargetLocation.m_82559_(positionMult));
            LOGGER.debug("Arrest movement with distance=" + dist + " and speed=" + currentSpeed);
            this.m_20334_(0.0, 0.0, 0.0);
            this.resetMovementInputs();
            return true;
        }
        return false;
    }

    private void resetMovementInputs() {
        this.forwardCommandActive = false;
        this.reverseCommandActive = false;
        this.autopilotWantToAscend = false;
        this.autopilotWantToDescend = false;
        this.wantToBrake = false;
    }

    private void advanceCurrentTask() {
        LOGGER.debug("advance to next task");
        if (this.currentTask != null) {
            this.currentTask.inProgress = false;
        }
        ++this.currentTaskIndex;
        this.currentTask = this.currentTaskList.get(this.currentTaskIndex % this.currentTaskList.size());
        this.currentTask.reset();
        this.currentTask.inProgress = false;
    }

    private <T> void populateNearbyContainerList(List<T> containers, Set<BlockPos> visited, BlockPos rotBlockPos, Class containerClass) {
        for (int i = 1; i <= unloadIntoChestDistanceMultiplier; ++i) {
            BlockEntity container;
            BlockEntity container2;
            BlockPos north = rotBlockPos.m_122013_(i);
            BlockPos east = rotBlockPos.m_122030_(i);
            BlockPos south = rotBlockPos.m_122020_(i);
            BlockPos west = rotBlockPos.m_122025_(i);
            BlockPos above = rotBlockPos.m_6630_(i);
            BlockPos below = rotBlockPos.m_6625_(i);
            LevelChunk levelChunk = this.m_9236_().m_46745_(north);
            BlockEntity northState = levelChunk.m_7702_(north);
            levelChunk = this.m_9236_().m_46745_(east);
            BlockEntity eastState = levelChunk.m_7702_(east);
            levelChunk = this.m_9236_().m_46745_(south);
            BlockEntity southState = levelChunk.m_7702_(south);
            levelChunk = this.m_9236_().m_46745_(west);
            BlockEntity westState = levelChunk.m_7702_(west);
            levelChunk = this.m_9236_().m_46745_(above);
            BlockEntity aboveState = levelChunk.m_7702_(above);
            levelChunk = this.m_9236_().m_46745_(below);
            BlockEntity belowState = levelChunk.m_7702_(below);
            if (!visited.contains(north)) {
                visited.add(north);
                container2 = northState;
                if (containerClass.isInstance(container2)) {
                    containers.add(container2);
                }
            }
            if (!visited.contains(east)) {
                visited.add(east);
                container2 = eastState;
                if (containerClass.isInstance(container2)) {
                    containers.add(container2);
                }
            }
            if (!visited.contains(south)) {
                visited.add(south);
                container2 = southState;
                if (containerClass.isInstance(container2)) {
                    containers.add(container2);
                }
            }
            if (!visited.contains(west)) {
                visited.add(west);
                container2 = westState;
                if (containerClass.isInstance(container2)) {
                    containers.add(container2);
                }
            }
            if (!visited.contains(above)) {
                visited.add(above);
                container2 = aboveState;
                if (containerClass.isInstance(container2)) {
                    containers.add(container2);
                }
            }
            if (!visited.contains(below)) {
                visited.add(below);
                container2 = belowState;
                if (containerClass.isInstance(container2)) {
                    containers.add(container2);
                }
            }
            if (!this.useDiagonalsForUnloadIntoChest) continue;
            BlockPos ne = rotBlockPos.m_122013_(i).m_122030_(i);
            BlockPos nw = rotBlockPos.m_122013_(i).m_122025_(i);
            BlockPos se = rotBlockPos.m_122020_(i).m_122030_(i);
            BlockPos sw = rotBlockPos.m_122020_(i).m_122025_(i);
            levelChunk = this.m_9236_().m_46745_(ne);
            BlockEntity neState = levelChunk.m_7702_(ne);
            levelChunk = this.m_9236_().m_46745_(nw);
            BlockEntity nwState = levelChunk.m_7702_(nw);
            levelChunk = this.m_9236_().m_46745_(se);
            BlockEntity seState = levelChunk.m_7702_(se);
            levelChunk = this.m_9236_().m_46745_(sw);
            BlockEntity swState = levelChunk.m_7702_(sw);
            if (!visited.contains(ne)) {
                visited.add(ne);
                container = neState;
                if (containerClass.isInstance(container)) {
                    containers.add(container);
                }
            }
            if (!visited.contains(nw)) {
                visited.add(nw);
                container = nwState;
                if (containerClass.isInstance(container)) {
                    containers.add(container);
                }
            }
            if (!visited.contains(se)) {
                visited.add(se);
                container = seState;
                if (containerClass.isInstance(container)) {
                    containers.add(container);
                }
            }
            if (visited.contains(sw)) continue;
            visited.add(sw);
            container = swState;
            if (!containerClass.isInstance(container)) continue;
            containers.add(container);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isValidOnboardContainer(RenderableBlock renderable) {
        BlockEntity blockEntity = renderable.tempBlockEntity;
        if (!(blockEntity instanceof Container)) return false;
        Container container = (Container)blockEntity;
        if (renderable.tempBlockEntity instanceof SteamEngineBlockEntity) return false;
        if (renderable.tempBlockEntity instanceof InternalCombustionEngineBlockEntity) return false;
        return true;
    }

    public void rotateCarriedEntities(Set<Integer> chosenEntities, float rotationDelta) {
        for (Integer chosen : chosenEntities) {
            Entity e = this.m_9236_().m_6815_(chosen.intValue());
            if (e == null || e.m_5833_()) continue;
            Vec3 pos = e.m_20182_();
            Point2D.Double dummyPos = new Point2D.Double(this.m_20185_(), this.m_20189_());
            Vec3 rotatedPos = XenoTechUtils.revolve(dummyPos, rotationDelta, pos);
            e.m_146884_(rotatedPos);
            e.m_146922_(e.m_146908_() + rotationDelta);
            e.m_5618_(e.m_146908_());
            LOGGER.trace("relocate entity " + e + " from " + pos + " to " + rotatedPos + " with distance=" + pos.m_82554_(rotatedPos));
        }
    }

    public void moveCarriedEntities(Set<Integer> chosenEntities, Vec3 movementVec) {
        this.applySubmarineBreathEffect(this.m_146895_());
        for (Integer chosen : chosenEntities) {
            boolean clientDoesServerUpdates;
            Projectile projectile;
            Entity e = this.m_9236_().m_6815_(chosen.intValue());
            if (e == null || e.m_5833_()) continue;
            if (autoKillAllNpcProjectiles && e instanceof Projectile && !((projectile = (Projectile)e).m_19749_() instanceof Player)) {
                projectile.m_6074_();
            }
            if (this.noseTilt != 0.0f) {
                e.m_252801_();
            }
            if ((clientDoesServerUpdates = clientControlled) && (e instanceof Player && !e.m_9236_().f_46443_ || !(e instanceof Player) && e.m_9236_().f_46443_)) continue;
            this.applySubmarineBreathEffect(e);
            double lx = e.m_20185_() + movementVec.f_82479_;
            double ly = e.m_20186_() + movementVec.f_82480_;
            double lz = e.m_20189_() + movementVec.f_82481_;
            Vec3 newCoord = new Vec3(lx, ly, lz);
            Vec3 oldCoord = e.m_20182_();
            Vec3 coordDiff = newCoord.m_82546_(oldCoord);
            coordDiff = coordDiff.m_82549_(e.m_20184_().m_82542_(1.0, 1.0, 1.0));
            Vec3 thisPos = this.m_20182_();
            double distMovedSqr = 0.0;
            if (this.positionLastTick != null) {
                distMovedSqr = thisPos.m_82546_(this.positionLastTick).m_82556_();
            }
            Vec3 delta = this.m_20184_();
            if (distMovedSqr > 0.0) {
                Vec3 entityDeltaMov = e.m_20184_();
                double my = e.m_20186_() + movementVec.f_82480_;
                if (movementVec.f_82480_ != 0.0) {
                    this.m_6853_(true);
                    this.setEntityOnGroundIfNotFalling(e);
                    double gravity = 0.08;
                    if (e instanceof LivingEntity) {
                        LivingEntity le = (LivingEntity)e;
                        AttributeInstance gravityAttribute = le.m_21051_((Attribute)ForgeMod.ENTITY_GRAVITY.get());
                        gravity = gravityAttribute.m_22135_();
                    }
                }
                Vec3 collidePos = new Vec3(e.m_20185_() + movementVec.f_82479_, my, e.m_20189_() + movementVec.f_82481_);
                if (this.positionLastTick != null) {
                    collidePos = e.m_20182_().m_82549_(thisPos.m_82546_(this.positionLastTick));
                }
                if (this.m_146895_() == e) continue;
                this.entityAllowFlying(e);
                BlockPos moveToPos = BlockPos.m_274446_((Position)collidePos);
                BlockState moveToState = this.m_9236_().m_8055_(moveToPos);
                BlockPos entityCurrentPos = e.m_20183_();
                BlockState entityBlockState = e.m_20075_();
                if (e instanceof Player) {
                    if (e.m_20202_() != null) continue;
                    this.m_6853_(true);
                    this.setEntityOnGroundIfNotFalling(e);
                    if (this.entityWouldCollideAt(e, moveToPos, moveToState, 0.1) || e.m_20039_(entityCurrentPos, entityBlockState)) {
                        LOGGER.trace("Entity " + e.m_7755_().getString() + " would collide at position=" + moveToPos + " with state=" + moveToState + ", skipping movement!");
                    } else {
                        e.m_6034_(collidePos.f_82479_, collidePos.f_82480_, collidePos.f_82481_);
                        if (this.m_9236_().f_46443_) {
                            e.m_217006_(collidePos.f_82479_, collidePos.f_82480_, collidePos.f_82481_);
                        }
                    }
                    LOGGER.trace("moved player=" + e.m_7755_().m_214077_() + " on level=" + this.m_9236_() + " to pos=" + collidePos);
                    final DummyEntity thisEntity = this;
                    final Player pl = (Player)e;
                    if (!clientDoesServerUpdates) continue;
                    DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> new Runnable(){

                        @Override
                        public void run() {
                            if (thisEntity.m_9236_().f_46443_ && Minecraft.m_91087_().m_91091_() && Minecraft.m_91087_().f_91073_ != null) {
                                Entity serverEntity;
                                ServerLevel serverLevel = Minecraft.m_91087_().m_91092_().m_129880_(Minecraft.m_91087_().f_91073_.m_46472_());
                                LOGGER.trace("serverLevel=" + (Level)serverLevel);
                                if (serverLevel != null && (serverEntity = serverLevel.m_6815_(pl.m_19879_())) != null) {
                                    LOGGER.trace("playerAdjust: serverEntity=" + serverEntity + " for level=" + thisEntity.m_9236_());
                                }
                            }
                        }
                    });
                    continue;
                }
                if (e instanceof DummyEntity) {
                    DummyEntity carriedDummy = (DummyEntity)e;
                    continue;
                }
                if ((!clientControlled || !this.m_9236_().f_46443_) && (!serverControlled || this.m_9236_().f_46443_)) continue;
                if (this.entityWouldCollideAt(e, moveToPos, moveToState, 0.1) || e.m_20039_(entityCurrentPos, entityBlockState)) {
                    LOGGER.trace("Entity " + e.m_7755_().getString() + " would collide at position=" + moveToPos + " with state=" + moveToState + ", skipping movement!");
                    continue;
                }
                e.m_146884_(collidePos);
                if (!this.m_9236_().f_46443_) continue;
                e.m_217006_(collidePos.f_82479_, collidePos.f_82480_, collidePos.f_82481_);
                continue;
            }
            this.entityAllowFlying(e);
        }
    }

    private void entityAllowFlying(Entity e) {
        this.setEntityOnGroundIfNotFalling(e);
        if (e instanceof ServerPlayer) {
            ServerPlayer p = (ServerPlayer)e;
            p.f_8906_.f_9737_ = 0;
        }
    }

    private void setEntityOnGroundIfNotFalling(Entity e) {
        if (Math.abs(e.m_20184_().f_82480_) <= 1.0E-6) {
            e.m_6853_(true);
            e.m_183634_();
        }
    }

    private boolean entityWouldCollideAt(Entity e, BlockPos moveToPos, BlockState moveToState, double hitboxInflation) {
        VoxelShape voxelshape = moveToState.m_60742_((BlockGetter)this.m_9236_(), moveToPos, CollisionContext.m_82750_((Entity)e));
        VoxelShape voxelshape1 = voxelshape.m_83216_((double)moveToPos.m_123341_(), (double)moveToPos.m_123342_(), (double)moveToPos.m_123343_());
        AABB bb = e.m_20191_();
        AABB checkBb = AABB.m_165882_((Vec3)new Vec3((double)moveToPos.m_123341_(), (double)moveToPos.m_123342_(), (double)moveToPos.m_123343_()), (double)bb.m_82362_(), (double)bb.m_82376_(), (double)bb.m_82385_());
        checkBb = checkBb.m_82400_(hitboxInflation);
        return Shapes.m_83157_((VoxelShape)voxelshape1, (VoxelShape)Shapes.m_83064_((AABB)checkBb), (BooleanOp)BooleanOp.f_82689_);
    }

    private void applySubmarineBreathEffect(Entity e) {
        if (e == null) {
            return;
        }
        if (e instanceof LivingEntity) {
            MobEffectInstance conduitPowerInst;
            LivingEntity living = (LivingEntity)e;
            if (this.vehicleType == VehicleType.SUBMARINE && ((conduitPowerInst = living.m_21124_(MobEffects.f_19592_)) == null || conduitPowerInst.m_19557_() <= 1)) {
                if (e.m_20146_() < e.m_6062_()) {
                    int diff = e.m_6062_() - e.m_20146_();
                    e.m_20301_(e.m_20146_() + Math.min(diff, 30));
                }
                living.m_7292_(new MobEffectInstance(MobEffects.f_19592_, 15, 1));
            }
        }
    }

    protected void clampRotation(Entity e) {
        float f = Mth.m_14177_((float)(e.m_146908_() - this.m_146908_()));
        float f1 = Mth.m_14036_((float)f, (float)-140.0f, (float)140.0f);
        if (this.isNotShip()) {
            float yRotDiff = this.mountedGunYClamp(e);
            e.m_146922_(e.m_146908_() + yRotDiff);
            float xRotDiff = this.mountedGunXClamp(e);
            e.m_146926_(e.m_146909_() + xRotDiff);
            return;
        }
        e.m_5618_(this.m_146908_());
        if (e instanceof Villager) {
            f1 = Mth.m_14036_((float)f, (float)-95.0f, (float)95.0f);
        }
        e.m_146922_(e.m_146908_() + (f1 - f));
        e.m_5616_(e.m_146908_());
    }

    private float mountedGunXClamp(Entity e) {
        float x = Mth.m_14177_((float)(e.m_146909_() - 0.0f));
        float x1 = Mth.m_14036_((float)x, (float)-55.0f, (float)55.0f);
        float xRotDiff = x1 - x;
        return xRotDiff;
    }

    private float mountedGunYClamp(Entity e) {
        float parentDiff = 0.0f;
        if (this.thisMountedGun != null && this.thisMountedGun.carrier != null) {
            parentDiff = this.thisMountedGun.carrier.m_146908_() - this.mountedGunInitialParentAngle;
        }
        float y = Mth.m_14177_((float)(e.m_146908_() - this.getStartingAngle() - parentDiff));
        float fY = Mth.m_14036_((float)y, (float)-80.0f, (float)80.0f);
        float yRotDiff = fY - y;
        return yRotDiff;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7340_(Entity e) {
        if (this.isFreeFlightMode()) {
            e.m_146922_(this.m_146908_());
            e.m_146926_(this.m_146909_());
        }
        this.clampRotation(e);
    }

    public float yRotPerTickLocalScaledByVelocity() {
        float vPct = (float)this.currentHorizontalSpeed / this.moverStats.topSpeed;
        if (this.isBrakingInput() && (vPct += 0.1f) > 1.0f) {
            vPct = 1.0f;
        }
        float minTurnSpeedPct = this.minimumTurnSpeedPctPlayer;
        if (this.m_146895_() instanceof Villager) {
            minTurnSpeedPct = this.minimumTurnSpeedPctVillager;
        }
        vPct = Math.max(vPct, minTurnSpeedPct);
        float yRotPerTick = this.yRotPerTickControlledLocally * vPct;
        yRotPerTick = this.applyTurnScaling(yRotPerTick);
        if (this.isGradualTurningActive()) {
            yRotPerTick = this.applyTurnScalingPlayerFlyingVehicle(yRotPerTick);
        }
        return yRotPerTick;
    }

    private float applyTurnScaling(float turningVal) {
        turningVal = this.hasSportTireSteering() ? (turningVal *= turningScaleForSportTire) : (this.hasJetThrusterSteering() ? (turningVal *= turningScaleForJetThruster) : (this.hasSailboatSteering() ? (turningVal *= turningScaleForSailboat) : (this.hasBalloonSteering() ? (turningVal *= turningScaleForBalloon) : (turningVal *= turningScaleGeneric))));
        return turningVal;
    }

    private float applyTurnScalingPlayerFlyingVehicle(float turningVal) {
        float turnScaleMax = turningScaleForPlayerFlyerMax;
        float turnScaleMin = turningScaleForPlayerFlyerMin;
        if (this.isFreeFlightMode()) {
            turnScaleMax = 1.5f;
            turnScaleMin = 0.1f;
        }
        float scaleFactor = this.getAbsPlayerFlyerTurnValue() * turnScaleMax + (1.0f - this.getAbsPlayerFlyerTurnValue()) * turnScaleMin;
        return turningVal *= scaleFactor;
    }

    private Vec3 getRidingPosition(double riderDist) {
        float yRot = this.m_146908_();
        yRot += 180.0f;
        double xValue = (double)Mth.m_14031_((float)(-(yRot %= 360.0f) * ((float)Math.PI / 180))) * riderDist;
        double yValue = (double)Mth.m_14089_((float)(yRot * ((float)Math.PI / 180))) * riderDist;
        return new Vec3(this.m_20185_() + xValue, this.m_20186_(), this.m_20189_() + yValue);
    }

    private Vec3 getOrbitalRidingPosition(Vec3 origin, Entity e, double riderDist) {
        Vec3 view = e.m_20252_(1.0f).m_82490_(-riderDist);
        return new Vec3(origin.f_82479_ + view.f_82479_, origin.f_82480_ + view.f_82480_, origin.f_82481_ + view.f_82481_);
    }

    public void m_19956_(Entity e, Entity.MoveFunction mov) {
        if (this.isNotShip()) {
            float xRotPct = e.m_146909_() / 55.0f;
            float fwdDistAdjustment = -0.7f;
            if (this.getMountedGunType() == 1) {
                Vec3 origin = new Vec3(this.m_20185_(), this.m_20186_() + this.m_6048_() + 0.28, this.m_20189_());
                e.m_6034_(origin.f_82479_, origin.f_82480_, origin.f_82481_);
            } else {
                float vertDistAdjustment = 0.25f;
                Vec3 origin = new Vec3(this.m_20185_(), this.m_20186_() + this.m_6048_(), this.m_20189_());
                Vec3 ridingPos = this.getOrbitalRidingPosition(origin, e, 0.85 + (double)(xRotPct * fwdDistAdjustment));
                e.m_6034_(ridingPos.f_82479_, ridingPos.f_82480_ + (double)Mth.m_14154_((float)(xRotPct * vertDistAdjustment)), ridingPos.f_82481_);
            }
            this.clampRotation(e);
            return;
        }
        if (this.isFreeFlightMode()) {
            Vec3 origin = new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_());
            float xRot = this.m_146909_();
            float yRot = this.m_146908_();
            float adjustY = Mth.m_14031_((float)(-xRot * ((float)Math.PI / 180)));
            float lengthXZ = Mth.m_14089_((float)(xRot * ((float)Math.PI / 180)));
            float adjustX = Mth.m_14031_((float)(yRot * ((float)Math.PI / 180))) * adjustY;
            float adjustZ = Mth.m_14089_((float)(yRot * ((float)Math.PI / 180))) * adjustY;
            float sphereDist = e.m_20192_();
            float y = Mth.m_14089_((float)(xRot * ((float)Math.PI / 180))) * sphereDist;
            float xz = Mth.m_14031_((float)(xRot * ((float)Math.PI / 180))) * sphereDist;
            float x = Mth.m_14031_((float)(-yRot * ((float)Math.PI / 180))) * xz;
            float z = Mth.m_14089_((float)(-yRot * ((float)Math.PI / 180))) * xz;
            Vec3 eyeLocation = new Vec3((double)x, (double)y, (double)z);
            Vec3 playerPosBelowEye = eyeLocation.m_82492_(0.0, (double)sphereDist, 0.0);
            e.m_6034_(origin.f_82479_ + playerPosBelowEye.f_82479_, origin.f_82480_ + playerPosBelowEye.f_82480_, origin.f_82481_ + playerPosBelowEye.f_82481_);
            return;
        }
        e.m_146884_(this.getRidingPosition(pilotingWindshieldDistance));
        float viewRot = 0.0f;
        if ((double)this.getYRotRequest() > 0.0 && !this.hasRotationCollision) {
            viewRot = this.yRotPerTickLocalScaledByVelocity();
        } else if ((double)this.getYRotRequest() < 0.0 && !this.hasRotationCollision) {
            viewRot = -this.yRotPerTickLocalScaledByVelocity();
        }
        e.m_146922_(e.m_146908_() + viewRot);
        e.m_5616_(e.m_6080_() + viewRot);
        this.clampRotation(e);
    }

    public boolean isFreeFlightMode() {
        return freeFlightMode && this.m_9236_().f_46443_ && this.m_6109_();
    }

    public LivingEntity m_6688_() {
        Entity entity = this.m_146895_();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            return living;
        }
        return null;
    }

    public boolean shouldRiderSit() {
        if (this.hasDriverSeat) {
            return true;
        }
        return this.isNotShip() && this.getMountedGunType() == 1;
    }

    public void repositionNewlyLoggedInPlayers() {
        for (int i = 0; i < newlyLoggedIn.size(); ++i) {
            Player player = newlyLoggedIn.get(i);
            LogoutPositionInfo logoutInfo = playerLogoutRelativePosMap.get(player.m_20148_());
            if (logoutInfo == null || !this.m_20148_().equals(logoutInfo.dummyId)) continue;
            newlyLoggedIn.remove(player);
            playerLogoutRelativePosMap.remove(player.m_20148_());
            if (logoutInfo.relativePos == null) continue;
            LOGGER.info("Relocate logged-in player: " + player + " to " + this + " with offset=" + logoutInfo.relativePos);
            Vec3 finalPos = this.m_20182_().m_82549_(logoutInfo.relativePos);
            player.m_20248_(finalPos.f_82479_, finalPos.f_82480_, finalPos.f_82481_);
        }
    }

    public boolean hasSpecificBlockEntityOnboard(BlockEntity specific) {
        for (RenderableBlock renderable : this.renderables) {
            if (renderable.tempBlockEntity != specific) continue;
            return true;
        }
        return false;
    }

    public void tickAndRelocateBlockEntities() {
        currentlyTickingDummyEntity = this;
        this.blockEntityTickInProgress = true;
        for (RenderableBlock renderable : this.renderables) {
            CompoundTag updateTag;
            BlockEntityTicker ticker;
            if (!renderable.state.m_155947_()) continue;
            Vec3 rotPos = XenoTechUtils.revolve(this, new Vec3(renderable.absoluteX(this), renderable.absoluteY(this), renderable.absoluteZ(this)));
            BlockPos blockRotPos = XenoTechUtils.blockPosFromRotPos(rotPos);
            BlockEntityUtils.populateBlockEntity(renderable, this.m_9236_(), blockRotPos);
            if (renderable.tempBlockEntity != null && (ticker = renderable.tempBlockEntity.m_58900_().m_155944_(this.m_9236_(), renderable.tempBlockEntity.m_58903_())) != null) {
                try {
                    ticker.m_155252_(this.m_9236_(), blockRotPos, renderable.state, renderable.tempBlockEntity);
                }
                catch (Exception ex) {
                    LOGGER.debug("error in ticker: " + renderable.state, (Throwable)ex);
                }
            }
            if (this.m_9236_().f_46443_ || renderable.tempBlockEntity == null || this.f_19797_ % 20 != 0 || (updateTag = renderable.tempBlockEntity.m_5995_()) == null) continue;
            XenoTechNetwork.INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> this), (Object)new ClientboundBlockEntitySyncPacket(this, renderable.pos, updateTag));
        }
        this.blockEntityTickInProgress = false;
    }

    private AABB makeAABBsquareShaped(AABB input) {
        if (input == null) {
            return null;
        }
        double minXZ = Math.min(input.f_82288_, input.f_82290_);
        double maxXZ = Math.max(input.f_82291_, input.f_82293_);
        double minXZabs = Math.abs(minXZ);
        double maxXZabs = Math.abs(maxXZ);
        double maxValue = Math.max(minXZabs, maxXZabs);
        return new AABB(-maxValue, input.f_82289_, -maxValue, maxValue, input.f_82292_, maxValue);
    }

    public boolean boundingBoxIsNearby(AABB boundingBox) {
        if (boundingBox == null) {
            return false;
        }
        AABB entityBounds = this.getRenderablesAABB(true);
        if (entityBounds != null) {
            entityBounds = this.makeAABBsquareShaped(entityBounds);
            entityBounds = entityBounds.m_82400_(2.0);
            entityBounds = entityBounds.m_82400_(8.0);
            entityBounds = entityBounds.m_82383_(this.m_20182_());
            return entityBounds.m_82381_(boundingBox);
        }
        return false;
    }

    public boolean entityIsNearby(Entity e) {
        if (e == null) {
            return false;
        }
        return this.boundingBoxIsNearby(e.m_20191_());
    }

    public boolean m_6000_(double p_20296_, double p_20297_, double p_20298_) {
        return true;
    }

    public int getInAirTicks() {
        return this.inAirTicks;
    }

    public void setInAirTicks(int inAirTicks) {
        this.inAirTicks = inAirTicks;
    }

    public boolean isHoveringInAir() {
        if (this.vehicleType == VehicleType.SUBMARINE) {
            return false;
        }
        return this.inAirTicks > 0;
    }

    public boolean m_20096_() {
        return this.onGroundInternal;
    }

    public void setOnGroundInternal(boolean onGround) {
        this.onGroundInternal = onGround;
    }

    public boolean isOutOfFuel() {
        return (Boolean)this.f_19804_.m_135370_(OUT_OF_FUEL);
    }

    /*
     * Unable to fully structure code
     */
    public void m_8119_() {
        block189: {
            block188: {
                block194: {
                    block190: {
                        block193: {
                            block191: {
                                block192: {
                                    if (this.hasStoredEntityId()) {
                                        if (!this.m_9236_().f_46443_) {
                                            if (this.ticksUntilSelfDestruction == -1) {
                                                this.ticksUntilSelfDestruction = 80;
                                            }
                                            if (this.ticksUntilSelfDestruction > 0) {
                                                --this.ticksUntilSelfDestruction;
                                                if (this.ticksUntilSelfDestruction == 0) {
                                                    this.m_146870_();
                                                }
                                            }
                                        }
                                        return;
                                    }
                                    if (this.isNotShip()) {
                                        if (this.m_146895_() == null && !this.m_9236_().f_46443_) {
                                            if (this.ticksUntilSelfDestruction == -1) {
                                                this.ticksUntilSelfDestruction = 80;
                                            }
                                            if (this.ticksUntilSelfDestruction > 0) {
                                                --this.ticksUntilSelfDestruction;
                                                if (this.ticksUntilSelfDestruction == 0) {
                                                    DummyEntity.LOGGER.warn("Non-ship self destructed: " + this);
                                                    this.makeThisMountedGunRideable();
                                                    this.m_146870_();
                                                }
                                            }
                                        }
                                        if (this.m_146895_() != null) {
                                            this.m_20242_(true);
                                        }
                                        if ((var2_1 = this.m_6688_()) instanceof Player) {
                                            p = (Player)var2_1;
                                            this.m_19915_(p.m_146908_(), p.m_146909_());
                                            this.entityAllowFlying((Entity)p);
                                            if (this.m_9236_().f_46443_ && this.m_6109_()) {
                                                p.m_217006_(p.m_20185_(), p.m_20186_(), p.m_20189_());
                                            }
                                        }
                                        if (this.thisMountedGun != null && (var2_1 = this.thisMountedGun.carrier) instanceof DummyEntity) {
                                            carrier = (DummyEntity)var2_1;
                                            if (this.thisMountedGun.renderable != null) {
                                                oldPos = this.m_20182_();
                                                newPos = XenoTechUtils.getRotPosForRenderable(carrier, this.thisMountedGun.renderable);
                                                newPos = new Vec3(newPos.f_82479_ + 0.5, newPos.f_82480_, newPos.f_82481_ + 0.5);
                                                if (!oldPos.equals((Object)newPos)) {
                                                    diff = this.m_20182_().m_82546_(carrier.m_20182_());
                                                    DummyEntity.LOGGER.trace("Move " + this + " to pos=" + newPos + " from pos=" + oldPos + " with diff=" + diff + " using offset=" + this.thisMountedGun.relativeCarrierOffset + " having distance=" + diff.m_82553_());
                                                    this.m_6034_(newPos.f_82479_, newPos.f_82480_, newPos.f_82481_);
                                                    this.m_217006_(newPos.f_82479_, newPos.f_82480_, newPos.f_82481_);
                                                }
                                            } else {
                                                DummyEntity.LOGGER.warn("renderable was null for: " + carrier);
                                            }
                                        } else if (!DummyEntity.clientControlled && this.m_9236_().f_46443_) {
                                            this.doLerp();
                                        }
                                        return;
                                    }
                                    this.currentTickTimestamp = this.f_19797_;
                                    newPos = this.m_146895_();
                                    if (newPos instanceof Villager) {
                                        villager = (Villager)newPos;
                                        ++this.villagerRidingTicks;
                                    } else {
                                        newPos = this.m_146895_();
                                        if (newPos instanceof Player) {
                                            player = (Player)newPos;
                                            ++this.playerRidingTicks;
                                        }
                                    }
                                    player = this.m_146895_();
                                    if (player instanceof Player) {
                                        player = player;
                                        v0 = true;
                                    } else {
                                        v0 = false;
                                    }
                                    this.setIntegratedWeaponsActive(v0);
                                    if (!this.m_9236_().f_46443_) {
                                        this.repositionNewlyLoggedInPlayers();
                                    }
                                    if (this.m_9236_().f_46443_) {
                                        thisEntity = this;
                                        DistExecutor.runWhenOn((Dist)Dist.CLIENT, (Supplier<Runnable>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$tick$20(com.dairymoose.xenotech.entity.DummyEntity ), ()Ljava/lang/Runnable;)((DummyEntity)this, (DummyEntity)thisEntity));
                                    }
                                    if (DummyEntity.serverControlled && !this.m_9236_().f_46443_) ** GOTO lbl-1000
                                    if (DummyEntity.clientControlled && !this.m_9236_().f_46443_) lbl-1000:
                                    // 2 sources

                                    {
                                        v1 = true;
                                    } else {
                                        v1 = false;
                                    }
                                    canMove = v1;
                                    this.f_19794_ = true;
                                    if (this.m_146895_() != null) {
                                        this.m_146895_().f_19794_ = true;
                                        this.m_20242_(true);
                                    }
                                    super.m_8119_();
                                    if (this.firstRun) {
                                        this.firstRun = false;
                                        entityId = (Integer)this.f_19804_.m_135370_(DummyEntity.TARGET_ENTITY_ID);
                                        if (entityId == null || entityId <= 0) {
                                            // empty if block
                                        }
                                        renderableBlocklist = (String)this.f_19804_.m_135370_(DummyEntity.RENDERABLE_BLOCKLIST);
                                        renderablesSize = 0;
                                        if (this.renderables != null) {
                                            renderablesSize = this.renderables.size();
                                        }
                                        DummyEntity.LOGGER.info("Entity located at " + this.m_20183_() + " for level=" + this.m_9236_() + " with id=" + this.m_19879_() + " with uniqueId=" + this.uniqueId + " with renderables=" + renderablesSize);
                                    }
                                    if (this.f_19797_ % 100 == 0) {
                                        DummyEntity.LOGGER.trace("this=" + this + ", lastDummy=" + DummyEntity.dummiesGlobal + ", renderables=" + this.renderables.size() + " for level=" + this.m_9236_() + " with carried=" + this.carried);
                                    }
                                    if (!this.m_9236_().f_46443_ && this.f_19797_ % 8 == 0 && (entityId = (Integer)this.f_19804_.m_135370_(DummyEntity.TARGET_ENTITY_ID)) != null && entityId > 0 && this.f_19797_ >= 72) {
                                        DummyEntity.LOGGER.trace("removing dummy because entityId=" + entityId);
                                        this.m_142687_(Entity.RemovalReason.DISCARDED);
                                    }
                                    speedShouldDecay = true;
                                    if (this.m_146895_() instanceof Player) {
                                        speedShouldDecay = false;
                                    }
                                    if (!this.m_9236_().f_46443_ && this.m_146895_() != null) {
                                        this.wantToBrake = false;
                                    }
                                    this.addedAscent = 0.0f;
                                    if (this.m_146895_() == null || !this.m_6109_() || !this.m_9236_().f_46443_) break block188;
                                    if (Minecraft.m_91087_().f_91074_ == null || Minecraft.m_91087_().f_91074_.f_108618_ == null) break block189;
                                    fwd = Minecraft.m_91087_().f_91074_.f_108618_.m_108577_();
                                    back = Minecraft.m_91087_().f_91074_.f_108618_.f_108567_ <= -0.001f;
                                    left = Minecraft.m_91087_().f_91074_.f_108618_.f_108570_;
                                    right = Minecraft.m_91087_().f_91074_.f_108618_.f_108571_;
                                    up = Minecraft.m_91087_().f_91074_.f_108618_.f_108572_;
                                    down = XenoTechClient.isControlDown;
                                    alt = XenoTechClient.isAltDown;
                                    freeFlightX = 0.0;
                                    freeFlightY = 0.0;
                                    if (this.isFreeFlightMode()) {
                                        xPos = Minecraft.m_91087_().f_91067_.m_91589_();
                                        yPos = Minecraft.m_91087_().f_91067_.m_91594_();
                                        if (!Double.isNaN(this.mouseLastX)) {
                                            xDiff = xPos - this.mouseLastX;
                                            freeFlightX = xDiff / 4000.0;
                                            largestValuePossible = 0.2;
                                            if (Math.abs(freeFlightX) > largestValuePossible) {
                                                freeFlightX = largestValuePossible * Math.signum(freeFlightX);
                                            }
                                            DummyEntity.playerFlyerTurnValue = (float)((double)DummyEntity.playerFlyerTurnValue + freeFlightX);
                                        }
                                        if (!Double.isNaN(this.mouseLastY)) {
                                            yDiff = yPos - this.mouseLastY;
                                            freeFlightY = yDiff / 1500.0;
                                            largestValuePossible = 0.1;
                                            if (Math.abs(freeFlightX) > largestValuePossible) {
                                                freeFlightX = largestValuePossible * Math.signum(freeFlightX);
                                                DummyEntity.LOGGER.info("hit max possible y: " + freeFlightX);
                                            }
                                            DummyEntity.playerFlyerFreeFlightPitchValue = (float)((double)DummyEntity.playerFlyerFreeFlightPitchValue + freeFlightY);
                                        }
                                        if (!alt) {
                                            left = false;
                                            right = false;
                                        }
                                        tooFastToHover = 0.2;
                                        if (this.isHoveringInAir() && this.currentHorizontalSpeed >= tooFastToHover) {
                                            up = false;
                                            down = false;
                                        }
                                        this.mouseLastX = xPos;
                                        this.mouseLastY = yPos;
                                    }
                                    if (this.isOutOfFuel()) {
                                        fwd = false;
                                        down = false;
                                        alt = false;
                                        up = false;
                                    }
                                    if (fwd) {
                                        this.wantToBrake = false;
                                        this.reverseCommandActive = false;
                                        this.forwardCommandActive = true;
                                        ++this.fwdCommandActiveTicks;
                                    } else {
                                        this.forwardCommandActive = false;
                                        speedShouldDecay = true;
                                        this.localInstanceSpeed = 0.0f;
                                        this.fwdCommandActiveTicks = 0;
                                    }
                                    if (back) {
                                        this.wantToBrake = false;
                                        this.forwardCommandActive = false;
                                        this.reverseCommandActive = true;
                                    } else {
                                        this.reverseCommandActive = false;
                                    }
                                    if (alt) break block190;
                                    this.strafeLeft = false;
                                    this.strafeRight = false;
                                    if (left && !right) {
                                        DummyEntity.playerFlyerTurnValue = this.isGradualTurningActive() ? (DummyEntity.playerFlyerTurnValue += -DummyEntity.playerFlyerTurnValueIncreaseMagnitude) : -1.0f;
                                    }
                                    if (right && !left) {
                                        DummyEntity.playerFlyerTurnValue = this.isGradualTurningActive() ? (DummyEntity.playerFlyerTurnValue += DummyEntity.playerFlyerTurnValueIncreaseMagnitude) : 1.0f;
                                    }
                                    if (!left && !right) break block191;
                                    if (!right) break block192;
                                    if (DummyEntity.playerFlyerTurnValue < 0.0f) break block191;
                                }
                                if (!left) break block193;
                                if (!(DummyEntity.playerFlyerTurnValue > 0.0f)) break block193;
                            }
                            if (this.isGradualTurningActive()) {
                                initialTurnValue = DummyEntity.playerFlyerTurnValue;
                                speedPct = (float)this.currentHorizontalSpeed / this.moverStats.topSpeed;
                                playerFlyerTurnDecayFactor = 0.0f;
                                playerFlyerTurnDecayFactor = this.usePlayerFlyerPercentageDecay ? speedPct * DummyEntity.playerFlyerTurnDecayFactorMax + (1.0f - speedPct) * DummyEntity.playerFlyerTurnDecayFactorMin : 1.0f;
                                DummyEntity.playerFlyerTurnValue *= playerFlyerTurnDecayFactor;
                                if (!this.usePlayerFlyerPercentageDecay) {
                                    turnDecay = DummyEntity.playerFlyerTurnAdditiveDecay;
                                    if (this.isFreeFlightMode()) {
                                        turnDecay = DummyEntity.playerFlyerTurnAdditiveDecay / 80.0f;
                                    }
                                    DummyEntity.playerFlyerTurnValue = this.getAbsPlayerFlyerTurnValue() <= turnDecay ? 0.0f : (DummyEntity.playerFlyerTurnValue -= turnDecay * (float)Mth.m_14205_((double)DummyEntity.playerFlyerTurnValue));
                                }
                                if (DummyEntity.playerFlyerTurnValue != 0.0f) {
                                    DummyEntity.LOGGER.trace("turn value from " + initialTurnValue + " to " + DummyEntity.playerFlyerTurnValue);
                                }
                            } else {
                                DummyEntity.playerFlyerTurnValue = 0.0f;
                            }
                        }
                        if (this.isFreeFlightMode()) {
                            pitchDecay = 0.012f;
                            DummyEntity.playerFlyerFreeFlightPitchValue = Math.abs(DummyEntity.playerFlyerFreeFlightPitchValue) <= pitchDecay ? 0.0f : (DummyEntity.playerFlyerFreeFlightPitchValue -= pitchDecay * (float)Mth.m_14205_((double)DummyEntity.playerFlyerFreeFlightPitchValue));
                        }
                        if ((double)this.getAbsPlayerFlyerTurnValue() <= 0.005) {
                            if (DummyEntity.playerFlyerTurnValue != 0.0f) {
                                DummyEntity.LOGGER.trace("turn value hit 0.0");
                            }
                            DummyEntity.playerFlyerTurnValue = 0.0f;
                        }
                        if ((double)Math.abs(DummyEntity.playerFlyerFreeFlightPitchValue) <= 0.005) {
                            DummyEntity.playerFlyerFreeFlightPitchValue = 0.0f;
                        }
                        if (DummyEntity.playerFlyerTurnValue == 0.0f) {
                            this.f_19804_.m_135381_(DummyEntity.Y_ROT_REQUEST, (Object)Float.valueOf(0.0f));
                        }
                        if (DummyEntity.playerFlyerTurnValue > 1.0f) {
                            DummyEntity.playerFlyerTurnValue = 1.0f;
                        } else if (DummyEntity.playerFlyerTurnValue < -1.0f) {
                            DummyEntity.playerFlyerTurnValue = -1.0f;
                        }
                        if (this.isFreeFlightMode()) {
                            if (DummyEntity.playerFlyerFreeFlightPitchValue > 1.0f) {
                                DummyEntity.playerFlyerFreeFlightPitchValue = 1.0f;
                            } else if (DummyEntity.playerFlyerFreeFlightPitchValue < -1.0f) {
                                DummyEntity.playerFlyerFreeFlightPitchValue = -1.0f;
                            }
                        }
                        if (DummyEntity.playerFlyerTurnValue > 0.0f) {
                            this.f_19804_.m_135381_(DummyEntity.Y_ROT_REQUEST, (Object)Float.valueOf(0.0f));
                            this.turn(45.0f);
                        } else if (DummyEntity.playerFlyerTurnValue < 0.0f) {
                            this.f_19804_.m_135381_(DummyEntity.Y_ROT_REQUEST, (Object)Float.valueOf(0.0f));
                            this.turn(-45.0f);
                        }
                        if (this.isFreeFlightMode()) {
                            xRotDelta = DummyEntity.playerFlyerFreeFlightPitchValue * 2.5f;
                            playerXRotMatch = this.m_146909_() == Minecraft.m_91087_().f_91074_.m_146909_();
                            this.m_146926_(this.m_146909_() + xRotDelta);
                            xRotDiff = Minecraft.m_91087_().f_91074_.m_146909_() - Minecraft.m_91087_().f_91074_.f_19860_;
                            Minecraft.m_91087_().f_91074_.m_146922_(this.m_146908_());
                            Minecraft.m_91087_().f_91074_.m_146926_(this.m_146909_());
                            Minecraft.m_91087_().f_91074_.f_19860_ = Minecraft.m_91087_().f_91074_.m_146909_() - xRotDiff;
                        }
                        break block194;
                    }
                    if (this.isHoveringInAir() && this.vehicleType == VehicleType.HELICOPTER) {
                        if (left && !right) {
                            this.strafeLeft = true;
                            this.strafeRight = false;
                        } else if (right && !left) {
                            this.strafeLeft = false;
                            this.strafeRight = true;
                        } else {
                            this.strafeLeft = false;
                            this.strafeRight = false;
                        }
                    } else {
                        this.strafeLeft = false;
                        this.strafeRight = false;
                    }
                }
                if (this.vehicleType == VehicleType.BOAT) break block189;
                engineAccel = this.liftMoverStats.acceleration;
                if (this.liftMoverStats.acceleration == 0.0f && this.isFlyingVehicle() && (horzSpeedSqr = this.m_20184_().m_165925_()) >= DummyEntity.MIN_SPEED_FOR_TAKEOFF_SQR) {
                    engineAccel = this.moverStats.acceleration * DummyEntity.planeAscentAccelScaleFactor;
                }
                if (up && !down) {
                    ascendMod = 1.0f;
                    if (this.ascendingTicks >= 0 && this.inAirTicks <= 0) {
                        ascendMod = 0.3f;
                        ++this.ascendingTicks;
                    }
                    this.addedAscent = engineAccel * ascendMod;
                } else if (this.ascendingTicks >= 0 && this.inAirTicks <= 0) {
                    this.ascendingTicks = 0;
                }
                if (down && !up) {
                    this.addedAscent = -engineAccel;
                }
                break block189;
            }
            if (this.m_9236_().f_46443_ && (nearby = this.boundingBoxIsNearby(Minecraft.m_91087_().f_91074_.m_20191_())) && !Minecraft.m_91087_().f_91074_.m_5833_()) {
                up = Minecraft.m_91087_().f_91074_.f_108618_.f_108572_;
                ladderDelta = -0.14f;
                if (up) {
                    ladderDelta = 0.18f;
                }
                ladderReachVertDist = 1.6f;
                ladderReachHorzDist = 0.4f;
                ladderReachHorzDistSqr = ladderReachHorzDist * ladderReachHorzDist;
                for (RenderableBlock renderable : this.renderables) {
                    if (!(renderable.state.m_60734_() instanceof LadderBlock)) continue;
                    rotPos = XenoTechUtils.getRotPosForRenderable(this, renderable);
                    rotPos = rotPos.m_82520_(0.5, -0.5, 0.5);
                    posDiff = rotPos.m_82546_(Minecraft.m_91087_().f_91074_.m_20182_());
                    yDiff = Math.abs(rotPos.f_82480_ - Minecraft.m_91087_().f_91074_.m_20186_());
                    if (!(yDiff <= (double)ladderReachVertDist) || !(posDiff.m_165925_() <= (double)ladderReachHorzDistSqr)) continue;
                    delta = Minecraft.m_91087_().f_91074_.m_20184_();
                    Minecraft.m_91087_().f_91074_.m_20334_(delta.f_82479_, (double)ladderDelta, delta.f_82481_);
                    Minecraft.m_91087_().f_91074_.m_183634_();
                    break;
                }
            }
        }
        if (!this.m_6109_() && this.m_9236_().f_46443_ && this.carried.contains(Minecraft.m_91087_().f_91074_.m_19879_())) {
            if (XenoTechCommon.KEYBOARD_EVENT_SHIP_LEFT && !XenoTechCommon.KEYBOARD_EVENT_SHIP_RIGHT) {
                this.clientTurningLeftOrRight = true;
                XenoTechCommon.ship5Left(this, this.m_20183_());
            } else if (!XenoTechCommon.KEYBOARD_EVENT_SHIP_LEFT && XenoTechCommon.KEYBOARD_EVENT_SHIP_RIGHT) {
                this.clientTurningLeftOrRight = true;
                XenoTechCommon.ship5Right(this, this.m_20183_());
            } else if (this.clientTurningLeftOrRight) {
                this.clientTurningLeftOrRight = false;
                XenoTechCommon.shipStopTurning(this, this.m_20183_());
            }
            if (XenoTechCommon.KEYBOARD_EVENT_SHIP_ASCEND && !XenoTechCommon.KEYBOARD_EVENT_SHIP_DESCEND) {
                XenoTechCommon.shipAscend(this, this.m_20183_(), false);
            } else if (!XenoTechCommon.KEYBOARD_EVENT_SHIP_ASCEND && XenoTechCommon.KEYBOARD_EVENT_SHIP_DESCEND) {
                XenoTechCommon.shipDescend(this, this.m_20183_(), false);
            }
        }
        if (this.autopilotAutoAscendTicks > 0) {
            --this.autopilotAutoAscendTicks;
            this.autopilotWantToAscend = true;
            this.autopilotWantToDescend = false;
        }
        if (this.autopilotAutoDescendTicks > 0) {
            --this.autopilotAutoDescendTicks;
            this.autopilotWantToAscend = false;
            this.autopilotWantToDescend = true;
        }
        if (this.vehicleType != VehicleType.BOAT && !(this.m_146895_() instanceof Player)) {
            engineAccel = this.liftMoverStats.acceleration;
            if (this.liftMoverStats.acceleration == 0.0f && this.isFlyingVehicle() && (horzSpeedSqr = this.m_20184_().m_165925_()) >= DummyEntity.MIN_SPEED_FOR_TAKEOFF_SQR) {
                engineAccel = this.moverStats.acceleration * DummyEntity.planeAscentAccelScaleFactor;
            }
            if (this.autopilotWantToAscend && !this.autopilotWantToDescend) {
                this.addedAscent = engineAccel;
                this.autopilotWantToAscend = false;
                this.autopilotWantToDescend = false;
            }
            if (!this.autopilotWantToAscend && this.autopilotWantToDescend) {
                this.addedAscent = -engineAccel;
                this.autopilotWantToAscend = false;
                this.autopilotWantToDescend = false;
            }
        }
        if (this.yVectorNegativeTicks > 0) {
            --this.yVectorNegativeTicks;
            if (this.yVectorNegativeTicks == 0) {
                this.yVectorIsPositive = true;
            }
        }
        if (this.m_9236_().f_46443_ && (double)this.addedAscent == 0.0) {
            this.addedAscent = ((Float)this.f_19804_.m_135370_(DummyEntity.SERVER_ADDED_ASCENT)).floatValue();
        }
        forceAscent = false;
        gravity = 0.0;
        bwi = new BoatWaterInfo();
        bwi.forceAscent = forceAscent;
        bwi.gravity = gravity;
        boatHasFluidBelow = false;
        if (this.vehicleType == VehicleType.BOAT || this.vehicleType == VehicleType.SUBMARINE) {
            boatHasFluidBelow = this.hasFluidBelow();
            if (this.vehicleType == VehicleType.BOAT && boatHasFluidBelow) {
                this.boatGetWaterInfo(bwi);
                forceAscent = bwi.forceAscent;
                gravity = bwi.gravity;
            }
        }
        this.calculateAirGroundStatus();
        gravity = this.calculateShipGravity(gravity);
        v2 = blockPosIsSubmerged = this.m_9236_().m_6425_(this.m_20183_()).getFluidType() != Fluids.f_76191_.getFluidType();
        if (this.vehicleType != VehicleType.SUBMARINE && blockPosIsSubmerged) {
            this.m_20256_(this.m_20184_().m_82542_(0.945, 0.945, 0.945));
            gravity *= 0.25;
        } else if (!(this.vehicleType != VehicleType.SUBMARINE && this.vehicleType != VehicleType.BOAT || boatHasFluidBelow)) {
            subDelta = this.m_20184_();
            horzSpeedSqr = subDelta.m_165925_();
            if (horzSpeedSqr > 0.012100000000000003 && (horzSpeed = this.currentHorizontalSpeed) != 0.0) {
                vX = 0.11000000000000001 * subDelta.f_82479_ / horzSpeed;
                vZ = 0.11000000000000001 * subDelta.f_82481_ / horzSpeed;
                this.m_20334_(vX, subDelta.f_82480_, vZ);
            }
        } else if (this.isFlyingVehicle() && this.m_20096_() && this.onGroundTicks >= 100 && !(planeLiftingOff = this.isPlaneAttemptingTakeoff()) && (horzSpeedSqr = (subDelta = this.m_20184_()).m_165925_()) > 0.16000000000000003 && (horzSpeed = this.currentHorizontalSpeed) != 0.0) {
            vX = 0.4 * subDelta.f_82479_ / horzSpeed;
            vZ = 0.4 * subDelta.f_82481_ / horzSpeed;
            this.m_20334_(vX, subDelta.f_82480_, vZ);
        }
        if (!this.m_9236_().f_46443_) {
            this.processCurrentTask();
        }
        if (this.oneTime_createdBlockEntities) {
            if (!this.m_9236_().f_46443_) {
                this.tickFuel();
                if (!this.hasEnoughFuel()) {
                    this.f_19804_.m_135381_(DummyEntity.OUT_OF_FUEL, (Object)true);
                } else {
                    this.f_19804_.m_135381_(DummyEntity.OUT_OF_FUEL, (Object)false);
                }
            }
            if (this.isOutOfFuel()) {
                this.forwardCommandActive = false;
                this.reverseCommandActive = false;
                this.strafeLeft = false;
                this.strafeRight = false;
                if (this.addedAscent > 0.0f) {
                    this.addedAscent = 0.0f;
                }
                this.inAirTicks = 0;
                if (this.currentHorizontalSpeed <= 0.1) {
                    this.zeroYRotRequest();
                }
            }
            this.captureFuelMetrics();
            this.engineBlocksCachedForOneTick = null;
        }
        if (!this.m_9236_().f_46443_) {
            this.f_19804_.m_135381_(DummyEntity.SERVER_ADDED_ASCENT, (Object)Float.valueOf(this.addedAscent));
        }
        if (this.forwardCommandActive || this.reverseCommandActive) {
            speed = this.getForwardAccel();
            if (this.isBrakingInput()) {
                speed = this.getReverseAccel();
            }
            this.adjustSpeed(speed, this.addedAscent, 1.0f, gravity, forceAscent);
        } else if (speedShouldDecay) {
            retainPct = 0.9989f;
            if (this.m_20096_()) {
                retainPct = this.isFlyingVehicle() != false ? 0.982f : 0.989f;
            }
            if (this.m_20184_().m_82556_() <= 2.25E-4) {
                this.wantToBrake = true;
            }
            this.adjustSpeed(0.0f, this.addedAscent, retainPct, gravity, forceAscent);
        }
        DummyEntity.LOGGER.trace("Level=" + this.m_9236_());
        this.forceCollision = false;
        this.collisionResponseStopMoving = false;
        currentCarried = this.getCarriedEntities();
        if (DummyEntity.enableBlockEntitiesOnboard) {
            this.tickAndRelocateBlockEntities();
        }
        this.oneTime_createdBlockEntities = true;
        setDiff = Sets.symmetricDifference(this.carried, currentCarried);
        if (setDiff != null && !setDiff.isEmpty()) {
            for (Integer eid : setDiff) {
                e = this.m_9236_().m_6815_(eid.intValue());
                if (e == null || e.m_213877_()) continue;
                e.m_252801_();
            }
        }
        this.carried = currentCarried;
        this.autoBrakeIfNoneCarried();
        localId = 0;
        if (this.m_9236_().f_46443_) {
            localId = Minecraft.m_91087_().f_91074_.m_19879_();
        } else if (FMLLoader.getDist().isClient() && (serv = this.m_9236_().m_7654_()) != null && (players = serv.m_6846_().m_11314_()) != null && players.size() > 0) {
            localId = ((ServerPlayer)players.get(0)).m_19879_();
        }
        if (this.m_9236_().f_46443_) {
            DummyEntity.LOGGER.trace("localId = " + localId);
            if (this.carried.contains(localId)) {
                // empty if block
            }
        }
        if (this.m_9236_().f_46443_ && Minecraft.m_91087_().f_91074_ != null) {
            DummyEntity.LOGGER.trace("Carried=" + this.carried + ", pid=" + Minecraft.m_91087_().f_91074_.m_19879_());
        }
        yDiffBefore = 0.0;
        if (this.m_9236_().f_46443_ && Minecraft.m_91087_().f_91074_ != null) {
            yDiffBefore = Minecraft.m_91087_().f_91074_.m_20186_() - this.m_20186_();
            if (yDiffBefore < 0.0) {
                yDiffBefore = 0.0;
            }
            DummyEntity.LOGGER.trace("yDiffBefore=" + yDiffBefore + ", PlayerYBefore = " + Minecraft.m_91087_().f_91074_.m_20186_());
        }
        if (this.m_9236_().f_46443_) {
            DummyEntity.LOGGER.trace("DummyYbefore=" + this.m_20186_());
        }
        DummyEntity.dummyMovementVec = null;
        DummyEntity.dummyMovementVec = this.m_20184_();
        DummyEntity.updateInProgress = true;
        oldCoord = this.m_20182_();
        thisDelta = this.m_20184_();
        DummyEntity.LOGGER.trace("thisDelta = " + thisDelta);
        if (this.m_9236_().f_46443_ && this.m_146895_() != null && this.m_6109_()) {
            XenoTechNetwork.INSTANCE.sendToServer((Object)new ServerboundAdjustVehicleDeltaPacket(this, thisDelta, this.speedVectorIsPositive, this.getInAirTicks()));
        }
        newPos = new Vec3(this.m_20185_() + thisDelta.f_82479_, this.m_20186_() + thisDelta.f_82480_, this.m_20189_() + thisDelta.f_82481_);
        if (forceAscent) {
            this.m_20334_(thisDelta.f_82479_, 0.0, thisDelta.f_82481_);
        }
        if (this.isWaterborneShip() && this.currentHorizontalSpeed > 0.0) {
            this.destroyLilyPads();
        }
        this.f_19862_ = false;
        this.f_19863_ = false;
        this.horizontalCollisionStepUp = false;
        if (this.hasBlockCollisions(thisDelta) || this.forceCollision) {
            if (!this.horizontalCollisionStepUp) {
                newPos = this.collisionResponse();
                thisDelta = this.m_20184_();
            } else {
                newPos = new Vec3(newPos.f_82479_, newPos.f_82480_ + (double)this.stepUpYIncrease, newPos.f_82481_);
            }
        }
        if (this.m_146895_() != null && this.m_146895_() instanceof Player) {
            if (this.m_6109_() && this.m_9236_().f_46443_) {
                this.m_146884_(newPos);
                this.m_217006_(newPos.f_82479_, newPos.f_82480_, newPos.f_82481_);
            }
        } else {
            thisEntity = this;
            clientDoesServerUpdates = true;
            newPosCopy = newPos;
            DistExecutor.runWhenOn((Dist)Dist.CLIENT, (Supplier<Runnable>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$tick$21(net.minecraft.world.entity.Entity boolean net.minecraft.world.phys.Vec3 ), ()Ljava/lang/Runnable;)((DummyEntity)this, (Entity)thisEntity, (boolean)clientDoesServerUpdates, (Vec3)newPosCopy));
            if (!DummyEntity.bothSidesControlled) {
                if (DummyEntity.clientControlled && (!clientDoesServerUpdates || this.m_9236_().f_46443_)) {
                    DummyEntity.LOGGER.trace("Set DummyEntity position to " + newPos + " for level=" + this.m_9236_());
                    this.m_146884_(newPos);
                    if (clientDoesServerUpdates) {
                        DistExecutor.runWhenOn((Dist)Dist.CLIENT, (Supplier<Runnable>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$tick$22(net.minecraft.world.entity.Entity net.minecraft.world.phys.Vec3 ), ()Ljava/lang/Runnable;)((DummyEntity)this, (Entity)thisEntity, (Vec3)newPosCopy));
                    }
                }
            }
            if (!DummyEntity.bothSidesControlled) {
                if (DummyEntity.serverControlled && !this.m_9236_().f_46443_) {
                    DummyEntity.LOGGER.trace("Set DummyEntity position to " + newPos + " for level=" + this.m_9236_());
                    this.m_146884_(newPos);
                }
            }
            if (DummyEntity.bothSidesControlled) {
                DummyEntity.LOGGER.trace("Set DummyEntity position to " + newPos + " for level=" + this.m_9236_());
                if (this.m_9236_().f_46443_) {
                    // empty if block
                }
                this.m_146884_(newPos);
                this.m_217006_(newPos.f_82479_, newPos.f_82480_, newPos.f_82481_);
            }
        }
        if (!DummyEntity.clientControlled && this.m_9236_().f_46443_) {
            this.doLerp();
        }
        this.captureMotionVariables();
        if (this.m_9236_().f_46443_ && !this.isOutOfFuel()) {
            if (this.hasJetThruster()) {
                idleVolumeMult = 1.0f;
                if (!this.isHoveringInAir()) {
                    idleVolumeMult = 0.35f;
                }
                this.playLocalEngineSound((SoundEvent)XenoBlocks.SOUND_EVENT_JET_THRUSTER_STARTUP.get(), (SoundEvent)XenoBlocks.SOUND_EVENT_JET_THRUSTER_BURN.get(), 4, idleVolumeMult);
            } else if (this.hasCombustionEngine()) {
                this.playLocalEngineSound((SoundEvent)XenoBlocks.SOUND_EVENT_CAR_IGNITION.get(), (SoundEvent)XenoBlocks.SOUND_EVENT_CAR_IDLE.get(), 3, 1.0f);
            } else if (this.hasSteamEngine()) {
                this.playLocalEngineSound((SoundEvent)XenoBlocks.SOUND_EVENT_STEAM_ENGINE_STARTUP.get(), (SoundEvent)XenoBlocks.SOUND_EVENT_STEAM_ENGINE.get(), 3, 1.0f);
            }
        }
        newCoord = this.m_20182_();
        movementVec = newCoord.m_82546_(oldCoord);
        yDiff = 0.0;
        if (this.m_9236_().f_46443_) {
            if (Minecraft.m_91087_().f_91074_ != null) {
                yDiff = this.m_20186_() - Minecraft.m_91087_().f_91074_.m_20186_() + 0.12;
                DummyEntity.LOGGER.trace("yDist before=" + yDiff);
            }
            DummyEntity.LOGGER.trace("deltaY=" + yDiff);
            DummyEntity.LOGGER.trace("DummyYafter=" + this.m_20186_());
            DummyEntity.LOGGER.trace("movementVec.y=" + movementVec.f_82480_);
        }
        movementVec = new Vec3(movementVec.f_82479_, movementVec.f_82480_ + 0.01, movementVec.f_82481_);
        this.moveCarriedEntities(this.carried, movementVec);
        if (this.m_9236_().f_46443_ && Minecraft.m_91087_().f_91074_ != null) {
            DummyEntity.LOGGER.trace("PlayerY=" + Minecraft.m_91087_().f_91074_.m_20186_());
            yDiff = Minecraft.m_91087_().f_91074_.m_20186_() - this.m_20186_();
            if (yDiff < 0.0) {
                // empty if block
            }
        }
        if ((double)Math.abs(yRotRequest = this.getYRotRequest()) >= 1.0E-5) {
            yRotDelta = Mth.m_14154_((float)yRotRequest);
            tickVal = this.yRotPerTick;
            tickVal = this.applyTurnScaling(tickVal);
            if (this.m_6109_() && this.m_9236_().f_46443_) {
                tickVal = this.yRotPerTickLocalScaledByVelocity();
            }
            if (this.m_146895_() instanceof Villager) {
                tickVal = this.yRotPerTickLocalScaledByVelocity();
            }
            if (tickVal < yRotDelta) {
                yRotDelta = tickVal;
            }
            doRotation = true;
            this.hasRotationCollision = false;
            if (this.hasBlockCollisionsForRotation(yRotRequest > 0.0f ? yRotDelta : -yRotDelta)) {
                this.hasRotationCollision = true;
                DummyEntity.LOGGER.debug("got rotation collision");
                doRotation = this.horizontalCollisionStepUp == false ? false : false;
            }
            if (doRotation) {
                if (yRotRequest > 0.0f) {
                    this.m_146922_(this.m_146908_() + yRotDelta);
                    yRotRequest -= yRotDelta;
                    if (yRotRequest < 0.0f) {
                        yRotRequest = 0.0f;
                    }
                } else {
                    this.m_146922_(this.m_146908_() - yRotDelta);
                    yRotRequest += yRotDelta;
                    if (yRotRequest > 0.0f) {
                        yRotRequest = 0.0f;
                    }
                }
                this.f_19804_.m_135381_(DummyEntity.Y_ROT_REQUEST, (Object)Float.valueOf(yRotRequest));
            }
        } else {
            yRotRequest = 0.0f;
        }
        this.observedYRotAccumulator = (float)((double)this.observedYRotAccumulator * 0.88);
        if (this.yRotLastTick != -400.0f && (observedYRot = this.m_146908_() - this.yRotLastTick) != 0.0f) {
            this.observedYRotAccumulator += observedYRot;
            yRotAccumulatorMax = 10.0f;
            if (this.observedYRotAccumulator >= yRotAccumulatorMax) {
                this.observedYRotAccumulator = yRotAccumulatorMax;
            } else if (this.observedYRotAccumulator <= -yRotAccumulatorMax) {
                this.observedYRotAccumulator = -yRotAccumulatorMax;
            }
            this.rotateCarriedEntities(this.carried, observedYRot);
        }
        if (!(this.m_9236_().f_46443_ || this.everUpdatedMetrics && this.f_19797_ % 100 != 0)) {
            this.updateMetrics();
        }
        this.yRotLastTick = this.m_146908_();
        this.positionLastTick = this.m_20182_();
        DummyEntity.updateInProgress = false;
        ++XenoTechCommon.dummyUpdates;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isGradualTurningActive() {
        if (this.isGroundVehicle()) return false;
        if (!(this.m_146895_() instanceof Player)) return false;
        if (!usePlayerGradualTurning) return false;
        return true;
    }

    private void captureFuelMetrics() {
        if (this.isConsumingZeroFuel()) {
            if (!this.everUpdatedFuelMetrics) {
                List<RenderableBlock> engineBlocks;
                this.everUpdatedFuelMetrics = true;
                this.everUpdatedMetrics = false;
                if (this.engineBlocksCachedForOneTick == null) {
                    engineBlocks = this.getEngineBlocks();
                    this.engineBlocksCachedForOneTick = engineBlocks;
                }
                if (this.engineBlocksCachedForOneTick != null) {
                    engineBlocks = this.engineBlocksCachedForOneTick;
                    this.computeMetrics_timeUntilEmpty(engineBlocks);
                }
            }
            return;
        }
        ++this.metrics_ticksConsumingFuel;
        if (this.engineBlocksCachedForOneTick != null) {
            this.computeMetrics_timeUntilEmpty(this.engineBlocksCachedForOneTick);
        }
    }

    public void updateMetrics() {
        long positionDiff;
        this.everUpdatedMetrics = true;
        if (this.metricsUpdatePosition == null) {
            this.metricsUpdatePosition = this.m_20182_();
        }
        if ((positionDiff = (long)this.metricsUpdatePosition.m_82554_(this.m_20182_())) > 0L) {
            this.f_19804_.m_135381_(METRICS_BLOCKS_TRAVELLED, (Object)((Long)this.f_19804_.m_135370_(METRICS_BLOCKS_TRAVELLED) + positionDiff));
        }
        if (this.metrics_ticksConsumingFuel > 0L) {
            long secsConsumingFuel = this.metrics_ticksConsumingFuel / 20L;
            this.f_19804_.m_135381_(METRICS_TIME_SPENT_CONSUMING_FUEL_SEC, (Object)((Long)this.f_19804_.m_135370_(METRICS_TIME_SPENT_CONSUMING_FUEL_SEC) + secsConsumingFuel));
            this.metrics_ticksConsumingFuel = 0L;
        }
        long secsUntilEmpty = this.metrics_timeUntilEmptyTicks / 20L;
        this.f_19804_.m_135381_(METRICS_TIME_UNTIL_EMPTY_SEC, (Object)secsUntilEmpty);
        this.metricsUpdatePosition = this.m_20182_();
    }

    private void setIntegratedWeaponsActive(boolean isActive) {
        if (!this.integratedWeapons.isEmpty()) {
            for (IntegratedWeaponInfo iwi : this.integratedWeapons) {
                Block block;
                if (iwi.renderable == null || !((block = iwi.renderable.state.m_60734_()) instanceof IntegratedGunBlock)) continue;
                IntegratedGunBlock igb = (IntegratedGunBlock)block;
                boolean currentActive = (Boolean)iwi.renderable.state.m_61143_((Property)IntegratedGunBlock.ACTIVE);
                if (currentActive == isActive) continue;
                iwi.renderable.state = (BlockState)iwi.renderable.state.m_61124_((Property)IntegratedGunBlock.ACTIVE, (Comparable)Boolean.valueOf(isActive));
                if (iwi.blockEntity == null) continue;
                iwi.blockEntity.barrelRotation = 0.0f;
                iwi.blockEntity.barrelRotationSpeed = 0.0f;
            }
        }
    }

    private boolean isPlaneAttemptingTakeoff() {
        return this.liftMoverStats.acceleration == 0.0f && this.isFlyingVehicle() && this.currentHorizontalSpeed >= MIN_SPEED_FOR_TAKEOFF * 0.8 && (double)this.addedAscent > 0.0 && this.inAirTicks <= 20;
    }

    private void destroyLilyPads() {
        for (RenderableBlock renderable : this.renderables) {
            Vec3 rotPos = XenoTechUtils.getRotPosForRenderable(this, renderable);
            rotPos.m_82549_(this.m_20184_());
            BlockPos blockRotPos = XenoTechUtils.blockPosFromRotPos(rotPos);
            BlockState moveToState = this.m_9236_().m_8055_(blockRotPos);
            BlockPos belowBlockRotPos = blockRotPos.m_7495_();
            BlockState belowMoveToState = this.m_9236_().m_8055_(belowBlockRotPos);
            BlockPos aboveBlockRotPos = blockRotPos.m_7494_();
            BlockState aboveMoveToState = this.m_9236_().m_8055_(aboveBlockRotPos);
            if (moveToState.m_60734_() instanceof WaterlilyBlock) {
                this.m_9236_().m_46953_(blockRotPos, true, (Entity)this);
            }
            if (belowMoveToState.m_60734_() instanceof WaterlilyBlock) {
                this.m_9236_().m_46953_(belowBlockRotPos, true, (Entity)this);
            }
            if (!(aboveMoveToState.m_60734_() instanceof WaterlilyBlock)) continue;
            this.m_9236_().m_46953_(aboveBlockRotPos, true, (Entity)this);
        }
    }

    private void calculateAirGroundStatus() {
        if (!this.hasSolidGroundBelow()) {
            this.onGroundTicks = 0;
            if ((double)this.addedAscent > 0.0) {
                if (!this.m_9236_().f_46443_ || !this.m_6109_()) {
                    ++this.ascendingTicks;
                }
            } else if (this.m_9236_().f_46443_ && this.m_6109_()) {
                this.ascendingTicks = 0;
            }
            if (this.liftMoverStats.moverBlockType instanceof JetThrusterBlock && this.ascendingTicks >= this.ascendTicksRequiredForJetTakeoff || this.ascendingTicks >= this.ascendTicksRequiredForTakeoff || this.inAirTicks > 0) {
                ++this.inAirTicks;
            }
            this.setOnGroundInternal(false);
        } else {
            this.inAirTicks = 0;
            if (!this.m_9236_().f_46443_ || !this.m_6109_()) {
                this.ascendingTicks = 0;
            }
            ++this.onGroundTicks;
            this.setOnGroundInternal(true);
            this.adjustHeightToMatchGroundLevel();
        }
    }

    private void adjustHeightToMatchGroundLevel() {
        double floatingOffGroundHeight;
        if (this.groundHeightY != null && this.groundedRenderableY != null && this.addedAscent == 0.0f && this.vehicleType == VehicleType.GROUND && this.groundedRenderableY > this.groundHeightY && (floatingOffGroundHeight = this.groundedRenderableY - this.groundHeightY) > 0.0 && floatingOffGroundHeight < 1.0) {
            Vec3 pos = this.m_20182_();
            double newY = pos.f_82480_ - floatingOffGroundHeight;
            LOGGER.debug("Adjusting entity to new height=" + newY + " from old height=" + pos.f_82480_ + " for entity=" + this + " based on groundHeight=" + this.groundHeightY + " and renderable height=" + this.groundedRenderableY);
            if (this.m_9236_().f_46443_ && this.m_6109_()) {
                this.m_6034_(pos.f_82479_, newY, pos.f_82481_);
            } else if (!this.m_9236_().f_46443_ && !(this.m_6688_() instanceof Player)) {
                this.m_6034_(pos.f_82479_, newY, pos.f_82481_);
            }
        }
    }

    private double calculateShipGravity(double gravity) {
        if ((double)this.liftMoverStats.acceleration == 0.0 && this.vehicleType != VehicleType.SUBMARINE) {
            boolean planeLiftingOff;
            double horzSpeedSqr = this.m_20184_().m_165925_();
            if (!this.m_20096_() && !(planeLiftingOff = this.isPlaneAttemptingTakeoff())) {
                float easeOfFloatingFactor = 1.0f;
                float gravReductionPct = 0.0f;
                if (this.moverStats.topSpeed > 0.0f && this.vehicleType == VehicleType.PLANE) {
                    float remainFlyingSpeed = (float)(MIN_SPEED_FOR_TAKEOFF * (double)1.4f);
                    float speedPct = (float)this.currentHorizontalSpeed / remainFlyingSpeed;
                    if (speedPct > 1.0f) {
                        speedPct = 1.0f;
                    }
                    gravReductionPct = easeOfFloatingFactor * speedPct;
                }
                if (gravReductionPct > 1.0f) {
                    gravReductionPct = 1.0f;
                }
                gravity = -0.08 * (double)(1.0f - gravReductionPct);
            }
        } else {
            boolean isSubmarineAboveWater;
            boolean liftingOff = this.ascendingTicks > 0;
            boolean bl = isSubmarineAboveWater = this.vehicleType == VehicleType.SUBMARINE && this.m_9236_().m_46745_(this.m_20183_().m_7495_()).m_6425_(this.m_20183_().m_7495_()).getFluidType() == Fluids.f_76191_.getFluidType();
            if (isSubmarineAboveWater && !this.m_20096_() || this.vehicleType != VehicleType.SUBMARINE && !this.m_20096_() && !liftingOff && !this.isHoveringInAir()) {
                float easeOfFloatingFactor = 0.0f;
                float gravReductionPct = 0.0f;
                if (this.moverStats.topSpeed > 0.0f) {
                    gravReductionPct = easeOfFloatingFactor * ((float)this.currentHorizontalSpeed / this.moverStats.topSpeed);
                }
                if (isSubmarineAboveWater) {
                    gravReductionPct = 0.0f;
                }
                if (gravReductionPct > 1.0f) {
                    gravReductionPct = 1.0f;
                }
                gravity = -0.08 * (double)(1.0f - gravReductionPct);
            }
        }
        return gravity;
    }

    private boolean hasFluidBelow() {
        for (RenderableBlock renderable : this.renderables) {
            Vec3 rotPos = XenoTechUtils.getRotPosForRenderable(this, renderable);
            BlockPos blockRotPos = XenoTechUtils.blockPosFromRotPos(rotPos);
            FluidState thisFluidState = this.m_9236_().m_6425_(blockRotPos);
            FluidState belowFluidState = this.m_9236_().m_6425_(blockRotPos.m_7495_());
            if (thisFluidState.m_76152_() != Fluids.f_76191_) {
                return true;
            }
            if (belowFluidState.m_76152_() == Fluids.f_76191_) continue;
            return true;
        }
        return false;
    }

    private void boatGetWaterInfo(BoatWaterInfo bwi) {
        AABB aabb;
        AABB aabbCopy = aabb = this.getRenderablesAABB(true);
        double yHeight = aabb.f_82292_ - aabb.f_82289_;
        BlockPos pos = this.m_20183_();
        aabb = aabb.m_82383_(new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()));
        boolean inWater = this.checkInWater(aabb);
        this.waterLevel += 2.0;
        LOGGER.trace("check in water for aabb=" + aabb + ", ?=" + inWater + " for blockPos=" + pos + " with originalAABB=" + aabbCopy + " with waterLevel=" + this.waterLevel);
        float waterLevel = (float)this.waterLevel;
        if (this.m_20186_() > (double)(waterLevel + 0.1f)) {
            LOGGER.trace("well above waterlevel with y=" + this.m_20186_());
            bwi.gravity = -0.08;
        } else if (this.m_20186_() < (double)(waterLevel - 0.1f)) {
            bwi.forceAscent = true;
            this.addedAscent = 0.1f;
            LOGGER.trace("well below waterlevel with y=" + this.m_20186_());
        } else if (Math.abs(this.m_20186_() - (double)waterLevel) >= 0.01) {
            bwi.forceAscent = true;
            this.addedAscent = waterLevel - (float)this.m_20186_();
            LOGGER.trace("near waterlevel with y=" + this.m_20186_() + ", set new y to: " + this.addedAscent);
        } else {
            LOGGER.trace("at waterlevel with y=" + this.m_20186_());
        }
    }

    private boolean isWaterborneShip() {
        return this.vehicleType == VehicleType.SUBMARINE || this.vehicleType == VehicleType.BOAT;
    }

    private float getReverseAccel() {
        float speed = this.getForwardAccel();
        speed = reverseSpeedFactor * -speed;
        return speed;
    }

    private float getForwardAccel() {
        float speed = this.moverStats.acceleration;
        if (!this.isBrakingInput() && this.m_20096_() && this.isFlyingVehicle()) {
            speed = this.vehicleType == VehicleType.PLANE ? (speed *= this.GROUNDED_AIRSHIP_ACCEL_MULT_PLANE_ONLY) : (speed *= this.GROUNDED_AIRSHIP_ACCEL_MULT);
        }
        return speed;
    }

    private void playLocalEngineSound(final SoundEvent startup, final SoundEvent idle, int idleSoundDuration, float idleVolumeMult) {
        boolean isMoving;
        float configVolumeMod = engineSoundVolume / 100.0f;
        boolean bl = isMoving = this.currentHorizontalSpeed > 0.0 || this.isHoveringInAir() || this.addedAscent > 0.0f;
        if (this.persistentIdleSoundTicks == 0 && isMoving && this.lastHorizontalSpeed == 0.0 && this.clientIgnitionSoundTicks <= 0) {
            if (this.clientIgnitionSoundTicks <= 0) {
                this.clientIgnitionSoundTicks = 20;
                final float volume = 1.0f * configVolumeMod;
                final DummyEntity thisEntity = this;
                DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> new Runnable(){

                    @Override
                    public void run() {
                        DummyEntity.this.m_9236_().m_6269_((Player)Minecraft.m_91087_().f_91074_, (Entity)thisEntity, startup, SoundSource.BLOCKS, volume, 1.0f);
                    }
                });
            }
        } else if (isMoving || this.persistentIdleSoundTicks > 0) {
            --this.clientIgnitionSoundTicks;
            if (this.clientIgnitionSoundTicks <= 0) {
                if (this.clientCarIdleSoundTicks <= 0) {
                    if (isMoving) {
                        this.persistentIdleSoundTicks = this.ENGINE_SOUND_PERSIST_DURATION_TICKS;
                    }
                    this.clientCarIdleSoundTicks = idleSoundDuration;
                    final float volume = 0.9f * configVolumeMod * idleVolumeMult;
                    float pitch = 1.0f;
                    double speedPct = this.currentHorizontalSpeed / (double)this.moverStats.topSpeed;
                    if ((double)this.moverStats.topSpeed > 0.0) {
                        float pitchMaxIncrease = 0.7f;
                        pitch += pitchMaxIncrease * (float)Math.min(speedPct, 1.0);
                        if (speedPct >= 0.95) {
                            pitch = (float)((double)pitch + Math.random() * 0.05);
                        }
                    }
                    final DummyEntity thisEntity = this;
                    final float idlePitch = pitch;
                    DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> new Runnable(){

                        @Override
                        public void run() {
                            DummyEntity.this.m_9236_().m_6269_((Player)Minecraft.m_91087_().f_91074_, (Entity)thisEntity, idle, SoundSource.BLOCKS, volume, idlePitch);
                        }
                    });
                } else {
                    --this.clientCarIdleSoundTicks;
                }
            }
        }
        if (this.persistentIdleSoundTicks > 0) {
            --this.persistentIdleSoundTicks;
        }
    }

    private List<RenderableBlock> getEngineBlocks() {
        ArrayList<RenderableBlock> engineBlocks = new ArrayList<RenderableBlock>();
        for (int i = 0; i < this.renderables.size(); ++i) {
            BlockEntity blockEntity = this.renderables.get((int)i).tempBlockEntity;
            if (blockEntity instanceof SteamEngineBlockEntity) {
                SteamEngineBlockEntity engine = (SteamEngineBlockEntity)blockEntity;
                engineBlocks.add(this.renderables.get(i));
                continue;
            }
            blockEntity = this.renderables.get((int)i).tempBlockEntity;
            if (!(blockEntity instanceof InternalCombustionEngineBlockEntity)) continue;
            InternalCombustionEngineBlockEntity engine = (InternalCombustionEngineBlockEntity)blockEntity;
            engineBlocks.add(this.renderables.get(i));
        }
        return engineBlocks;
    }

    private void tickFuel() {
        if (this.m_9236_().f_46443_) {
            return;
        }
        if (this.isConsumingZeroFuel()) {
            return;
        }
        List<RenderableBlock> engineBlocks = this.getEngineBlocks();
        this.engineBlocksCachedForOneTick = engineBlocks;
        block0: for (int i = 0; i < engineBlocks.size(); ++i) {
            int modifiedBurnTime;
            ItemStack itemStack;
            BlockEntity blockEntity = engineBlocks.get((int)i).tempBlockEntity;
            if (blockEntity instanceof SteamEngineBlockEntity) {
                SteamEngineBlockEntity engine = (SteamEngineBlockEntity)blockEntity;
                for (int k = 0; k < engine.m_6643_(); ++k) {
                    itemStack = engine.m_8020_(k);
                    modifiedBurnTime = this.getSteamEngineBurnTime(itemStack);
                    if (modifiedBurnTime <= 0) continue;
                    this.applyBurnTicksToItem(itemStack, modifiedBurnTime);
                    Vec3 rotPos = XenoTechUtils.getRotPosForRenderable(this, engineBlocks.get(i));
                    Level level = this.m_9236_();
                    if (!(level instanceof ServerLevel)) continue block0;
                    ServerLevel serverLevel = (ServerLevel)level;
                    if (this.f_19797_ % 2 != 0) continue block0;
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123777_, rotPos.f_82479_ + 0.5, rotPos.f_82480_ + 1.6, rotPos.f_82481_ + 0.5, 0, 0.0, 10.0, 0.0, 0.013);
                    continue block0;
                }
                continue;
            }
            BlockEntity k = engineBlocks.get((int)i).tempBlockEntity;
            if (!(k instanceof InternalCombustionEngineBlockEntity)) continue;
            InternalCombustionEngineBlockEntity engine = (InternalCombustionEngineBlockEntity)k;
            for (int k2 = 0; k2 < engine.m_6643_(); ++k2) {
                itemStack = engine.m_8020_(k2);
                modifiedBurnTime = this.getOilBurnTime(itemStack);
                if (itemStack.m_150930_((Item)XenoBlocks.ITEM_REFINED_OIL_BUCKET.get())) {
                    this.applyBurnTicksToItem(itemStack, modifiedBurnTime);
                    continue block0;
                }
                if (!itemStack.m_150930_((Item)XenoBlocks.ITEM_OIL_BARREL.get())) continue;
                this.applyBurnTicksToItem(itemStack, modifiedBurnTime);
                continue block0;
            }
        }
    }

    private void computeMetrics_timeUntilEmpty(List<RenderableBlock> engineBlocks) {
        this.metrics_timeUntilEmptyTicks = 0L;
        for (int i = 0; i < engineBlocks.size(); ++i) {
            int burnTicks;
            int modifiedBurnTime;
            ItemStack itemStack;
            BlockEntity blockEntity = engineBlocks.get((int)i).tempBlockEntity;
            if (blockEntity instanceof SteamEngineBlockEntity) {
                SteamEngineBlockEntity engine = (SteamEngineBlockEntity)blockEntity;
                for (int k = 0; k < engine.m_6643_(); ++k) {
                    itemStack = engine.m_8020_(k);
                    modifiedBurnTime = this.getSteamEngineBurnTime(itemStack);
                    burnTicks = this.getBurnTicks(itemStack);
                    this.metrics_timeUntilEmptyTicks += (long)(modifiedBurnTime * itemStack.m_41613_() - burnTicks);
                }
                continue;
            }
            BlockEntity k = engineBlocks.get((int)i).tempBlockEntity;
            if (!(k instanceof InternalCombustionEngineBlockEntity)) continue;
            InternalCombustionEngineBlockEntity engine = (InternalCombustionEngineBlockEntity)k;
            for (int k2 = 0; k2 < engine.m_6643_(); ++k2) {
                itemStack = engine.m_8020_(k2);
                modifiedBurnTime = this.getOilBurnTime(itemStack);
                burnTicks = this.getBurnTicks(itemStack);
                this.metrics_timeUntilEmptyTicks += (long)(modifiedBurnTime * itemStack.m_41613_() - burnTicks);
            }
        }
    }

    private int getOilBurnTime(ItemStack itemStack) {
        if (itemStack.m_150930_((Item)XenoBlocks.ITEM_REFINED_OIL_BUCKET.get())) {
            int modifiedBurnTime = REFINED_OIL_BURN_MINUTES * 1200;
            return modifiedBurnTime;
        }
        if (itemStack.m_150930_((Item)XenoBlocks.ITEM_OIL_BARREL.get())) {
            int modifiedBurnTime = REFINED_OIL_BURN_MINUTES * 4 * 1200;
            return modifiedBurnTime;
        }
        return 0;
    }

    private int getSteamEngineBurnTime(ItemStack itemStack) {
        int maxBurn;
        int burnTime = ForgeHooks.getBurnTime((ItemStack)itemStack, null);
        int modifiedBurnTime = (int)((float)burnTime * FURNANCE_BURN_TIME_MULT);
        if (modifiedBurnTime > (maxBurn = FURNANCE_BURN_TIME_MAX_SECONDS * 20)) {
            modifiedBurnTime = maxBurn;
        }
        return modifiedBurnTime;
    }

    private boolean isConsumingZeroFuel() {
        return this.currentHorizontalSpeed <= 0.01 && !this.isHoveringInAir();
    }

    private void applyBurnTicksToItem(ItemStack itemStack, int modifiedBurnTime) {
        int burnTicks = 0;
        burnTicks = this.getBurnTicks(itemStack);
        if (++burnTicks > modifiedBurnTime) {
            itemStack.m_41774_(1);
            if (itemStack.m_41783_() != null && itemStack.m_41783_().m_128441_("BurnTicks")) {
                itemStack.m_41783_().m_128473_("BurnTicks");
            }
            if (itemStack.hasCraftingRemainingItem() && itemStack.m_41613_() == 0) {
                // empty if block
            }
        } else {
            itemStack.m_41784_().m_128405_("BurnTicks", burnTicks);
            if (modifyHoverName) {
                float remaining = 1.0f - (float)burnTicks / (float)modifiedBurnTime;
                int remainingInt = (int)(remaining * 1000.0f);
                int remainingIntDecimal = remainingInt % 10;
                itemStack.m_41787_();
                String newName = itemStack.m_41786_().getString() + " (" + (remainingInt /= 10) + "." + remainingIntDecimal + "%)";
                itemStack.m_41714_((Component)Component.m_237113_((String)newName));
            }
        }
    }

    private int getBurnTicks(ItemStack itemStack) {
        int burnTicks = 0;
        if (itemStack.m_41783_() != null && itemStack.m_41783_().m_128441_("BurnTicks")) {
            burnTicks = itemStack.m_41783_().m_128451_("BurnTicks");
        }
        return burnTicks;
    }

    private boolean hasJetThruster() {
        return this.moverStats.moverBlockType instanceof JetThrusterBlock;
    }

    private boolean hasCombustionEngine() {
        List<RenderableBlock> engineBlocks = this.getEngineBlocks();
        for (int i = 0; i < engineBlocks.size(); ++i) {
            BlockEntity blockEntity = engineBlocks.get((int)i).tempBlockEntity;
            if (!(blockEntity instanceof InternalCombustionEngineBlockEntity)) continue;
            InternalCombustionEngineBlockEntity engine = (InternalCombustionEngineBlockEntity)blockEntity;
            return true;
        }
        return false;
    }

    private boolean hasSteamEngine() {
        List<RenderableBlock> engineBlocks = this.getEngineBlocks();
        for (int i = 0; i < engineBlocks.size(); ++i) {
            BlockEntity blockEntity = engineBlocks.get((int)i).tempBlockEntity;
            if (!(blockEntity instanceof SteamEngineBlockEntity)) continue;
            SteamEngineBlockEntity engine = (SteamEngineBlockEntity)blockEntity;
            return true;
        }
        return false;
    }

    private boolean hasEnoughFuel() {
        Block block;
        if (this.vehicleType == VehicleType.BALLOON || this.vehicleType == VehicleType.BOAT) {
            block = this.moverStats.moverBlockType;
            if (block instanceof PropellerBlock) {
                PropellerBlock prop = (PropellerBlock)block;
            } else {
                block = this.liftMoverStats.moverBlockType;
                if (block instanceof PropellerBlock) {
                    PropellerBlock liftProp = (PropellerBlock)block;
                } else {
                    block = this.moverStats.moverBlockType;
                    if (block instanceof JetThrusterBlock) {
                        JetThrusterBlock prop = (JetThrusterBlock)block;
                    } else {
                        block = this.liftMoverStats.moverBlockType;
                        if (block instanceof JetThrusterBlock) {
                            JetThrusterBlock prop = (JetThrusterBlock)block;
                        } else {
                            return true;
                        }
                    }
                }
            }
        }
        List<RenderableBlock> engineBlocks = this.getEngineBlocks();
        for (int i = 0; i < engineBlocks.size(); ++i) {
            ItemStack itemStack;
            block = engineBlocks.get((int)i).tempBlockEntity;
            if (block instanceof SteamEngineBlockEntity) {
                SteamEngineBlockEntity engine = (SteamEngineBlockEntity)block;
                for (int k = 0; k < engine.m_6643_(); ++k) {
                    itemStack = engine.m_8020_(k);
                    int burnTime = ForgeHooks.getBurnTime((ItemStack)itemStack, null);
                    if (burnTime <= 0) continue;
                    return true;
                }
                continue;
            }
            BlockEntity k = engineBlocks.get((int)i).tempBlockEntity;
            if (!(k instanceof InternalCombustionEngineBlockEntity)) continue;
            InternalCombustionEngineBlockEntity engine = (InternalCombustionEngineBlockEntity)k;
            for (int k2 = 0; k2 < engine.m_6643_(); ++k2) {
                itemStack = engine.m_8020_(k2);
                if (itemStack.m_150930_((Item)XenoBlocks.ITEM_REFINED_OIL_BUCKET.get())) {
                    return true;
                }
                if (!itemStack.m_150930_((Item)XenoBlocks.ITEM_OIL_BARREL.get())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isGroundVehicle() {
        return this.vehicleType == VehicleType.GROUND;
    }

    private boolean isFlyingVehicle() {
        return this.vehicleType == VehicleType.HELICOPTER || this.vehicleType == VehicleType.PLANE || this.vehicleType == VehicleType.BALLOON;
    }

    private boolean hasBalloonSteering() {
        return this.vehicleType == VehicleType.BALLOON;
    }

    private boolean hasSportTireSteering() {
        return this.vehicleType == VehicleType.GROUND && this.moverStats.moverBlockType instanceof SportTireBlock;
    }

    private boolean hasSailboatSteering() {
        return this.vehicleType == VehicleType.BOAT && this.moverStats.moverBlockType instanceof SailBlock;
    }

    private boolean hasJetThrusterSteering() {
        return this.moverStats.moverBlockType instanceof JetThrusterBlock;
    }

    private void autoBrakeIfNoneCarried() {
        boolean hasNoCarriedEntities;
        boolean bl = hasNoCarriedEntities = this.carried == null || this.carried.isEmpty();
        if ((hasNoCarriedEntities || this.carried.stream().noneMatch(x -> this.m_9236_().m_6815_(x.intValue()) instanceof Player)) && this.m_146895_() == null) {
            int timeDiff = this.currentTickTimestamp - this.lastCarriedTickTimestamp;
            if (timeDiff >= this.noneCarriedAutoBrakeTickCount) {
                if (this.forwardCommandActive) {
                    LOGGER.debug("Begin braking because no players are carried");
                }
                this.forwardCommandActive = false;
                this.wantToBrake = true;
            }
        } else {
            this.lastCarriedTickTimestamp = this.currentTickTimestamp;
        }
    }

    private void captureMotionVariables() {
        Vec2 moveVec2d;
        float dot;
        Vec3 delta = this.m_20184_();
        this.lastHorizontalSpeed = this.currentHorizontalSpeed;
        this.currentHorizontalSpeed = delta.m_165924_();
        Vec3 viewVec = this.m_20252_(1.0f);
        Vec2 viewVec2d = new Vec2((float)viewVec.f_82479_, (float)viewVec.f_82481_).m_165902_();
        Vec3 thisPos = this.m_20182_();
        Vec3 moveVec = new Vec3(0.0, 0.0, 0.0);
        if (this.positionLastTick != null) {
            moveVec = thisPos.m_82546_(this.positionLastTick);
        }
        this.hasForwardMotion = (double)(dot = viewVec2d.m_165905_(moveVec2d = new Vec2((float)moveVec.f_82479_, (float)moveVec.f_82481_).m_165902_())) >= 0.0;
    }

    public boolean isBrakingInput() {
        return this.reverseCommandActive && this.speedVectorIsPositive || this.forwardCommandActive && !this.speedVectorIsPositive;
    }

    private boolean hasSolidGroundBelow() {
        this.groundHeightY = null;
        this.groundedRenderableY = null;
        for (RenderableBlock renderable : this.renderables) {
            Vec3 rotPos = XenoTechUtils.getRotPosForRenderable(this, renderable);
            BlockPos rotBlockPos = XenoTechUtils.blockPosFromRotPos(rotPos);
            LevelChunk levelChunk = this.m_9236_().m_46745_(rotBlockPos);
            BlockState realBelowState = levelChunk.m_8055_(rotBlockPos.m_7495_());
            if (!realBelowState.m_60783_((BlockGetter)this.m_9236_(), rotBlockPos, Direction.UP)) continue;
            this.groundHeightY = (double)rotBlockPos.m_123342_() + this.m_9236_().m_45573_(rotBlockPos);
            this.groundedRenderableY = rotPos.f_82480_;
            return true;
        }
        return false;
    }

    public void m_6453_(double p_20977_, double p_20978_, double p_20979_, float p_20980_, float p_20981_, int p_20982_, boolean p_20983_) {
        this.lerpX = p_20977_;
        this.lerpY = p_20978_;
        this.lerpZ = p_20979_;
        this.lerpYRot = p_20980_;
        this.lerpXRot = p_20981_;
        this.lerpSteps = p_20982_;
    }

    private void doLerp() {
        if (this.lerpSteps > 0) {
            double d0 = this.m_20185_() + (this.lerpX - this.m_20185_()) / (double)this.lerpSteps;
            double d2 = this.m_20186_() + (this.lerpY - this.m_20186_()) / (double)this.lerpSteps;
            double d4 = this.m_20189_() + (this.lerpZ - this.m_20189_()) / (double)this.lerpSteps;
            double d6 = Mth.m_14175_((double)(this.lerpYRot - (double)this.m_146908_()));
            this.m_146922_(this.m_146908_() + (float)d6 / (float)this.lerpSteps);
            this.m_146926_(this.m_146909_() + (float)(this.lerpXRot - (double)this.m_146909_()) / (float)this.lerpSteps);
            --this.lerpSteps;
            this.m_6034_(d0, d2, d4);
            this.m_19915_(this.m_146908_(), this.m_146909_());
        }
    }

    private void adjustSpeed(float speed, float addedAscent, float retainPercent, double gravity, boolean forceAscent) {
        float yRot;
        Vec3 delta = this.m_20184_();
        Vec3 deltaWithoutY = new Vec3(delta.f_82479_, 0.0, delta.f_82481_);
        float speedMult = retainPercent;
        float verticalSpeedMult = 0.988f;
        if (this.wantToBrake) {
            speedMult = 0.982f;
            verticalSpeedMult = 0.9f;
            float setToZeroThreshold = 0.023f;
            float setToZeroThresholdSqr = setToZeroThreshold * setToZeroThreshold;
            if (deltaWithoutY.m_165925_() <= (double)setToZeroThresholdSqr) {
                deltaWithoutY = new Vec3(0.0, 0.0, 0.0);
            }
        }
        float forwardFacingYRot = yRot = this.m_146908_();
        Vec3 yRotMovementVector = new Vec3(Math.sin(-yRot * ((float)Math.PI / 180)), 0.0, Math.cos(-yRot * ((float)Math.PI / 180)));
        if (!this.speedVectorIsPositive) {
            yRot += 180.0f;
        }
        double maxSpeedAutopilot = this.moverStats.topSpeed;
        double maxSpeedPiloted = this.moverStats.topSpeed;
        boolean inputDirectionIsSameAsSpeedVector = speed > 0.0f;
        double maxSpeedAutopilotSqr = maxSpeedAutopilot * maxSpeedAutopilot;
        if (this.m_6109_() && this.m_9236_().f_46443_) {
            if (inputDirectionIsSameAsSpeedVector && deltaWithoutY.m_82556_() >= maxSpeedPiloted * maxSpeedPiloted) {
                speed = 0.0f;
            }
        } else if (inputDirectionIsSameAsSpeedVector && deltaWithoutY.m_82556_() >= maxSpeedAutopilotSqr) {
            speed = 0.0f;
        }
        if (this.strafeSpeed != 0.0f && (double)Math.abs(this.strafeSpeed) <= 1.0E-4) {
            this.strafeSpeed = 0.0f;
        }
        double currentHorizontalSpeed = deltaWithoutY.m_82553_();
        if (this.isFreeFlightMode() && this.isHoveringInAir()) {
            currentHorizontalSpeed = delta.m_82553_();
        }
        if ((double)this.strafeSpeed != 0.0) {
            double dotProductScaledSpeed;
            scaleFactor = deltaWithoutY.m_82541_().m_82526_(yRotMovementVector.m_82541_());
            currentHorizontalSpeed = dotProductScaledSpeed = deltaWithoutY.m_82490_(scaleFactor).m_82553_();
        } else {
            scaleFactor = deltaWithoutY.m_82541_().m_82526_(yRotMovementVector.m_82541_());
        }
        double newSpeed = currentHorizontalSpeed + (double)speed;
        if (Math.abs(currentHorizontalSpeed) <= maxSpeedPiloted && Math.abs(newSpeed) > maxSpeedPiloted) {
            newSpeed = maxSpeedPiloted;
        }
        if (this.isFreeFlightMode() && this.isHoveringInAir()) {
            double h = deltaWithoutY.m_82553_();
            if (Math.abs(h) > maxSpeedPiloted) {
                limiter = 0.994;
                LOGGER.debug("harsh limiting newSpeed from " + newSpeed + " to " + newSpeed * limiter);
                newSpeed *= limiter;
            } else if (Math.abs(newSpeed) > maxSpeedPiloted) {
                limiter = 0.99998;
                LOGGER.debug("limiting newSpeed from " + newSpeed + " to " + newSpeed * limiter);
                newSpeed *= limiter;
            }
        }
        boolean strafingShouldReduceTopSpeed = false;
        boolean strafeInputActive = false;
        float strafeAngle = forwardFacingYRot;
        boolean haveStrafeAngle = false;
        double speedBeforeStrafing = newSpeed;
        if (this.strafeLeft || this.strafeRight || (double)this.strafeSpeed != 0.0) {
            if (this.strafeLeft && this.strafeRight) {
                LOGGER.debug("both strafes active, doing nothing");
            } else {
                if (strafingShouldReduceTopSpeed) {
                    maxSpeedPiloted *= 0.75;
                }
                if (this.strafeLeft) {
                    this.strafeSpeed -= this.getStrafeAcceleration();
                    strafeInputActive = true;
                } else if (this.strafeRight) {
                    this.strafeSpeed += this.getStrafeAcceleration();
                    strafeInputActive = true;
                }
                if ((double)this.strafeSpeed > 0.0) {
                    strafeAngle += 90.0f;
                    haveStrafeAngle = true;
                } else {
                    strafeAngle -= 90.0f;
                    haveStrafeAngle = true;
                }
                float strafeMaxSpeed = this.getStrafeSpeedMax();
                if (this.getAbsStrafeSpeed() > strafeMaxSpeed) {
                    this.strafeSpeed = strafeMaxSpeed * (float)Mth.m_14205_((double)this.strafeSpeed);
                }
            }
        }
        if (!strafeInputActive && this.strafeSpeed != 0.0f) {
            this.strafeSpeed = this.isHoveringInAir() ? (this.strafeSpeed *= 0.98f) : (this.strafeSpeed *= 0.94f);
        }
        if (strafeInputActive && Math.abs(newSpeed) > maxSpeedPiloted) {
            newSpeed = maxSpeedPiloted;
        }
        if (currentHorizontalSpeed == 0.0 && newSpeed == 0.0) {
            this.speedVectorIsPositive = true;
        }
        LOGGER.trace("adjust speed from " + currentHorizontalSpeed * 20.0 + " to " + newSpeed * 20.0);
        this.checkForNegativeVector(currentHorizontalSpeed, newSpeed);
        double strafeX = 0.0;
        double strafeZ = 0.0;
        if ((double)this.strafeSpeed != 0.0 && haveStrafeAngle) {
            float absStrafeSpeed = this.getAbsStrafeSpeed();
            strafeX = Math.sin(-strafeAngle * ((float)Math.PI / 180)) * (double)absStrafeSpeed;
            strafeZ = Math.cos(-strafeAngle * ((float)Math.PI / 180)) * (double)absStrafeSpeed;
        }
        double xValue = Math.sin(-yRot * ((float)Math.PI / 180)) * newSpeed * (double)speedMult + strafeX;
        double zValue = Math.cos(-yRot * ((float)Math.PI / 180)) * newSpeed * (double)speedMult + strafeZ;
        double decayedDeltaY = delta.f_82480_ * (double)verticalSpeedMult;
        if (addedAscent != 0.0f) {
            decayedDeltaY = delta.f_82480_;
        }
        double yValue = decayedDeltaY;
        if (forceAscent) {
            yValue = addedAscent;
        } else {
            boolean ascentIsSameAsDeltaY;
            float maxLiftSpeedAutopilot = this.liftMoverStats.topSpeed;
            float maxLiftSpeedPiloted = this.liftMoverStats.topSpeed;
            if (this.liftMoverStats.acceleration == 0.0f) {
                maxLiftSpeedAutopilot = this.moverStats.topSpeed * planeAscentSpeedScaleFactor;
                maxLiftSpeedPiloted = this.moverStats.topSpeed * planeAscentSpeedScaleFactor;
            }
            boolean bl = ascentIsSameAsDeltaY = (double)Math.signum(addedAscent) == Math.signum(delta.f_82480_);
            if (this.m_6109_() && this.m_9236_().f_46443_) {
                if (ascentIsSameAsDeltaY && Math.abs(delta.f_82480_) >= (double)Math.abs(maxLiftSpeedPiloted)) {
                    addedAscent = 0.0f;
                }
            } else if (ascentIsSameAsDeltaY && Math.abs(delta.f_82480_) >= (double)Math.abs(maxLiftSpeedAutopilot)) {
                addedAscent = 0.0f;
            }
            yValue += (double)addedAscent;
        }
        if (this.isFreeFlightMode() && this.isHoveringInAir()) {
            float accelValue;
            float xRot = this.m_146909_();
            double xzVelocity = 1.0;
            speedMult = 1.0f;
            float f = accelValue = this.forwardCommandActive ? this.moverStats.acceleration : 0.0f;
            if (!forceAscent) {
                double gravityInfluence = Math.sin(xRot * ((float)Math.PI / 180)) * 0.019;
                double speedBeforeGravity = newSpeed;
                newSpeed += gravityInfluence;
                yValue = delta.f_82480_ * 0.998;
                yValue += Math.sin(-xRot * ((float)Math.PI / 180)) * (double)accelValue * (double)speedMult;
            }
            xValue = delta.f_82479_ * 0.998;
            xValue += Math.sin(-yRot * ((float)Math.PI / 180)) * (double)accelValue * xzVelocity * (double)speedMult + strafeX;
            zValue = delta.f_82481_ * 0.998;
            zValue += Math.cos(-yRot * ((float)Math.PI / 180)) * (double)accelValue * xzVelocity * (double)speedMult + strafeZ;
        }
        if (!this.yVectorIsPositive) {
            yValue = -yValue;
        }
        this.m_20334_(xValue, yValue += gravity, zValue);
    }

    private float getStrafeAcceleration() {
        return this.moverStats.acceleration * 1.5f;
    }

    public float getPlayerFlyerTurnValue() {
        return playerFlyerTurnValue;
    }

    public float getAbsPlayerFlyerTurnValue() {
        return Mth.m_14154_((float)playerFlyerTurnValue);
    }

    public float getStrafeSpeed() {
        return this.strafeSpeed;
    }

    public float getAbsStrafeSpeed() {
        return Mth.m_14154_((float)this.strafeSpeed);
    }

    public float getStrafeSpeedMax() {
        return this.moverStats.topSpeed * 0.25f;
    }

    private void checkForNegativeVectorIgnoringPlayerInput(double currentSpeed, double newSpeed) {
        if (currentSpeed >= 0.0 && newSpeed < 0.0) {
            this.speedVectorIsPositive = false;
        } else if (currentSpeed >= 0.0 && newSpeed < 0.0) {
            this.speedVectorIsPositive = true;
        }
    }

    private void checkForNegativeVector(double currentSpeed, double newSpeed) {
        if (currentSpeed >= 0.0 && newSpeed < 0.0 && this.reverseCommandActive) {
            this.speedVectorIsPositive = false;
        } else if (currentSpeed >= 0.0 && newSpeed < 0.0 && this.forwardCommandActive) {
            this.speedVectorIsPositive = true;
        }
    }

    private Vec3 collisionResponse() {
        Vec3 delta = this.m_20184_();
        if (this.f_19862_) {
            this.forwardCommandActive = false;
            this.reverseCommandActive = false;
            this.wantToBrake = false;
            if (this.collisionResponseCanBounce) {
                this.speedVectorIsPositive = !this.speedVectorIsPositive;
            }
            this.fwdCommandActiveTicks = 0;
        }
        if (this.f_19863_) {
            this.autopilotAutoAscendTicks = 0;
            this.autopilotAutoDescendTicks = 0;
        }
        float speedToZeroThreshold = 0.2f;
        float speedToZeroThresholdSqr = speedToZeroThreshold * speedToZeroThreshold;
        delta = delta.m_82556_() <= (double)speedToZeroThresholdSqr ? new Vec3(this.f_19862_ ? 0.0 : delta.f_82479_, this.f_19863_ ? 0.0 : delta.f_82480_, this.f_19862_ ? 0.0 : delta.f_82481_) : delta.m_82542_(this.f_19862_ ? 0.2 : 1.0, this.f_19863_ ? 0.0 : delta.f_82480_, this.f_19862_ ? 0.2 : 1.0);
        if (this.collisionResponseStopMoving) {
            delta = new Vec3(0.0, delta.f_82480_, 0.0);
        }
        if (this.forceCollision) {
            LOGGER.trace("force collision");
        }
        if (this.forceCollision || this.f_19862_) {
            LOGGER.trace("collisionResponse: delta before collision=" + this.m_20184_() + ", delta after collision=" + delta);
        }
        this.m_20256_(delta);
        Vec3 newPos = new Vec3(this.f_19862_ ? this.m_20185_() : this.m_20185_() + delta.f_82479_, this.f_19863_ ? this.m_20186_() : this.m_20186_() + delta.f_82480_, this.f_19862_ ? this.m_20189_() : this.m_20189_() + delta.f_82481_);
        return newPos;
    }

    public Vec3 normalizeSmallerMinSize(Vec3 vec) {
        double d0 = Math.sqrt(vec.f_82479_ * vec.f_82479_ + vec.f_82480_ * vec.f_82480_ + vec.f_82481_ * vec.f_82481_);
        return d0 <= 1.0E-8 ? Vec3.f_82478_ : new Vec3(vec.f_82479_ / d0, vec.f_82480_ / d0, vec.f_82481_ / d0);
    }

    private boolean hasBlockCollisionForOneRenderable(RenderableBlock renderable, Vec3 offsetToApplyToRenderablePos, Vec3 delta, double hitboxInflation, boolean rotationCollision) {
        this.useComplexCollision = useComplexCollisionProperty;
        if (rotationCollision) {
            // empty if block
        }
        double x = renderable.absoluteX(this);
        double y = renderable.absoluteY(this);
        double z = renderable.absoluteZ(this);
        Vec3 rotPos = XenoTechUtils.revolve(this, new Vec3(x, y, z));
        rotPos = new Vec3(rotPos.f_82479_ + 0.5, rotPos.f_82480_, rotPos.f_82481_ + 0.5);
        VoxelShape collisionShape = renderable.state.m_60812_((BlockGetter)this.m_9236_(), XenoTechUtils.blockPosFromRotPos(rotPos));
        if (offsetToApplyToRenderablePos.m_82556_() != 0.0) {
            rotPos = rotPos.m_82549_(offsetToApplyToRenderablePos);
        }
        if (!collisionShape.m_83281_()) {
            collisionShape = collisionShape.m_83216_(rotPos.f_82479_, rotPos.f_82480_, rotPos.f_82481_);
            AABB collisionBox = collisionShape.m_83215_();
            collisionBox = collisionBox.m_82386_(-collisionBox.m_82362_() / 2.0, 0.0, -collisionBox.m_82385_() / 2.0);
            double xSize = collisionBox.m_82362_();
            double zSize = collisionBox.m_82385_();
            if (this.useComplexCollision) {
                if (xSize > -hitboxInflation && zSize > -hitboxInflation) {
                    collisionBox = collisionBox.m_82377_(hitboxInflation, 0.0, hitboxInflation);
                } else if (this.shrinkSmallHitboxes) {
                    collisionBox = collisionBox.m_82377_(-xSize / 2.0, 0.0, -zSize / 2.0);
                }
            } else if (xSize > -hitboxInflation && zSize > -hitboxInflation) {
                collisionBox = collisionBox.m_82377_(hitboxInflation, 0.0, hitboxInflation);
            } else if (this.shrinkSmallHitboxes) {
                collisionBox = collisionBox.m_82377_(-xSize / 2.0, 0.0, -zSize / 2.0);
            }
            ArrayList emptyList = new ArrayList();
            if (this.waterCollider == null) {
                this.waterCollider = new WaterColliderEntity(WaterColliderEntity.WATER_COLLIDER_ENTITY, this.m_9236_());
            }
            this.waterCollider.m_20343_(rotPos.f_82479_, rotPos.f_82480_ + 1.0, rotPos.f_82481_);
            Vec3 horizontalDelta = new Vec3(delta.f_82479_, 0.0, delta.f_82481_);
            Vec3 verticalDelta = new Vec3(0.0, delta.f_82480_, 0.0);
            WaterColliderEntity collisionContextEntity = this.waterCollider;
            if (this.vehicleType == VehicleType.GROUND || this.vehicleType == VehicleType.SUBMARINE) {
                collisionContextEntity = null;
            }
            Vec3 horzOutput = Entity.m_198894_((Entity)collisionContextEntity, (Vec3)horizontalDelta, (AABB)collisionBox, (Level)this.m_9236_(), emptyList);
            Vec3 vertOutput = Entity.m_198894_((Entity)collisionContextEntity, (Vec3)verticalDelta, (AABB)collisionBox, (Level)this.m_9236_(), emptyList);
            if (horzOutput.f_82479_ != horizontalDelta.f_82479_ || vertOutput.f_82480_ != verticalDelta.f_82480_ || horzOutput.f_82481_ != horizontalDelta.f_82481_) {
                if (horzOutput.f_82479_ != horizontalDelta.f_82479_ || horzOutput.f_82481_ != horizontalDelta.f_82481_) {
                    if (this.useComplexCollision) {
                        Vec3 rotPos2 = XenoTechUtils.getRotPosForRenderable(this, renderable);
                        VoxelShape shapeToRotate = renderable.state.m_60812_((BlockGetter)this.m_9236_(), XenoTechUtils.blockPosFromRotPos(rotPos2));
                        Vec3 centeredRotPos = new Vec3(rotPos2.f_82479_ + 0.5, rotPos2.f_82480_, rotPos2.f_82481_ + 0.5);
                        AABB rotateBounds = shapeToRotate.m_83215_();
                        LOGGER.trace("rotateBounds1=" + rotateBounds);
                        rotateBounds = rotateBounds.m_82386_(-rotateBounds.m_82362_() / 2.0, 0.0, -rotateBounds.m_82385_() / 2.0);
                        LOGGER.trace("rotateBounds2=" + rotateBounds);
                        rotateBounds = rotateBounds.m_82383_(centeredRotPos);
                        int shapeCount = 0;
                        int emptyShapeCount = 0;
                        int nonEmptyShapeCount = 0;
                        Iterable shapes = this.m_9236_().m_186434_((Entity)collisionContextEntity, collisionBox.m_82369_(horizontalDelta));
                        block0: for (VoxelShape shape : shapes) {
                            ++shapeCount;
                            if (!shape.m_83281_()) {
                                ++nonEmptyShapeCount;
                                for (AABB aabb : shape.m_83299_()) {
                                    double angle = this.getYRotDiff();
                                    LOGGER.trace("check for intersection for angle=" + angle + " and rotateBounds=" + rotateBounds + " vs aabb=" + aabb);
                                    LOGGER.trace("rotateBounds center=" + rotateBounds.m_82399_() + " vs centeredRotPos=" + centeredRotPos + " for renderable=" + renderable);
                                    if (!CollisionUtils.rotatedIntersects(angle, rotateBounds, aabb, centeredRotPos)) continue;
                                    LOGGER.trace("got collision from renderable=" + renderable.state + " vs aabb=" + aabb);
                                    this.f_19862_ = true;
                                    continue block0;
                                }
                                continue;
                            }
                            ++emptyShapeCount;
                        }
                        if (!this.f_19862_) {
                            LOGGER.trace("skip horizontal collision due to complex collision check, empty=" + emptyShapeCount + " vs non-empty=" + nonEmptyShapeCount);
                            return false;
                        }
                    } else {
                        this.f_19862_ = true;
                    }
                    if (!this.isHoveringInAir()) {
                        collisionBox = collisionBox.m_82386_(0.0, (double)this.collisionCheckStepUp, 0.0);
                        Vec3 aboveBlockHorzOutput = Entity.m_198894_((Entity)collisionContextEntity, (Vec3)horizontalDelta, (AABB)collisionBox, (Level)this.m_9236_(), emptyList);
                        if (aboveBlockHorzOutput.f_82479_ == horizontalDelta.f_82479_ && aboveBlockHorzOutput.f_82481_ == horizontalDelta.f_82481_) {
                            this.horizontalCollisionStepUp = true;
                        }
                    }
                }
                if (vertOutput.f_82480_ != verticalDelta.f_82480_) {
                    this.f_19863_ = true;
                }
                String collisionType = "none";
                if (this.f_19862_ && this.f_19863_) {
                    collisionType = "dual";
                } else if (this.f_19862_) {
                    collisionType = "horizontal";
                } else if (this.f_19863_) {
                    collisionType = "vertical";
                }
                String stepUpText = " ";
                if (this.horizontalCollisionStepUp) {
                    stepUpText = " STEP-UP ";
                }
                LOGGER.debug("got" + stepUpText + "collision of type=" + collisionType + " for renderable:" + renderable + ", delta=" + delta + " vs outputs=" + horzOutput + "/" + vertOutput + " with rotPos=" + rotPos + " for dummyPosition=" + this.m_20182_());
                return true;
            }
        }
        return false;
    }

    private boolean hasBlockCollisionsForRotation(float yRotDelta) {
        LOGGER.trace("check for collisions based off yRotDelta=" + yRotDelta);
        if (yRotDelta == 0.0f) {
            return false;
        }
        if (!this.renderables.isEmpty()) {
            for (RenderableBlock renderable : this.renderables) {
                double x = renderable.absoluteX(this);
                double y = renderable.absoluteY(this);
                double z = renderable.absoluteZ(this);
                Vec3 currentPos = XenoTechUtils.revolve(this, new Vec3(x, y + 1.0, z));
                Point2D.Double pt = new Point2D.Double(this.m_20185_(), this.m_20189_());
                float farAwayRot = yRotDelta / 2.0f;
                Vec3 rotPosFarAway = XenoTechUtils.revolve(pt, this.getYRotDiff() - farAwayRot, new Vec3(renderable.absoluteX(this) + 0.5, renderable.absoluteY(this) + 1.0, renderable.absoluteZ(this) + 0.5));
                Vec3 rotPos = XenoTechUtils.revolve(pt, this.getYRotDiff() + yRotDelta, new Vec3(renderable.absoluteX(this) + 0.5, renderable.absoluteY(this) + 1.0, renderable.absoluteZ(this) + 0.5));
                Vec3 vectorToNewPosition = rotPos.m_82546_(currentPos);
                Vec3 vectorToOldPosition = currentPos.m_82546_(rotPos);
                Vec3 farAwayToNewPosVector = rotPos.m_82546_(rotPosFarAway);
                Vec3 diffToFarAway = currentPos.m_82546_(rotPosFarAway);
                if (!this.hasBlockCollisionForOneRenderable(renderable, diffToFarAway, farAwayToNewPosVector.m_82542_(1.1, 1.1, 1.1), this.blockCollisionInflation, true)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasBlockCollisions(Vec3 delta) {
        double lenSqr = delta.m_82556_();
        LOGGER.trace("check for collisions based off delta=" + delta + " from position=" + this.m_20182_() + " with lenSqr=" + lenSqr);
        if (lenSqr <= 1.0E-6) {
            return false;
        }
        if (!this.renderables.isEmpty()) {
            for (RenderableBlock renderable : this.renderables) {
                if (!this.hasBlockCollisionForOneRenderable(renderable, delta.m_82542_(-1.0, -1.0, -1.0), delta.m_82542_(2.1, 2.1, 2.1), this.blockCollisionInflation, false)) continue;
                return true;
            }
        }
        return false;
    }

    public void m_142036_() {
        this.onRemovedFromWorld();
        super.m_142036_();
    }

    public boolean isEntityStandingOnSolidGround(Entity e) {
        for (RenderableBlock renderable : this.renderables) {
            BlockPos dummyPos = this.m_20183_();
            double x = (double)dummyPos.m_123341_() + renderable.relativeX;
            double y = (double)dummyPos.m_123342_() + renderable.relativeY;
            double z = (double)dummyPos.m_123343_() + renderable.relativeZ;
            int blockX = (int)x;
            int blockY = (int)y;
            int blockZ = (int)z;
            HBlockPos renderablePos = new HBlockPos(blockX, 0, blockZ);
            HBlockPos entityPos = new HBlockPos(e.m_20183_().m_123341_(), 0, e.m_20183_().m_123343_());
            if (!renderable.state.m_60638_((BlockGetter)this.m_9236_(), (BlockPos)renderablePos, e, Direction.UP) || !renderablePos.equals((Object)entityPos) || !(e.m_20275_(x, y, z) <= 2.25)) continue;
            return true;
        }
        return false;
    }

    public Vec3 getEntitySolidGround(Entity e) {
        for (RenderableBlock renderable : this.renderables) {
            double yDiff;
            Vec3 dummyPos = this.m_20182_();
            double x = dummyPos.f_82479_ + renderable.relativeX;
            double y = dummyPos.f_82480_ + renderable.relativeY;
            double z = dummyPos.f_82481_ + renderable.relativeZ;
            int blockX = (int)x;
            int blockY = (int)y;
            int blockZ = (int)z;
            HBlockPos renderablePos = new HBlockPos(blockX, 0, blockZ);
            HBlockPos entityPos = new HBlockPos(e.m_20183_().m_123341_(), 0, e.m_20183_().m_123343_());
            if (!renderable.state.m_60638_((BlockGetter)this.m_9236_(), (BlockPos)entityPos, e, Direction.UP) || !renderablePos.equals((Object)entityPos) || !((yDiff = e.m_20186_() - y) > 0.0) || !(yDiff <= 1.0)) continue;
            return new Vec3(x, y + 1.0, z);
        }
        return null;
    }

    public boolean m_7337_(Entity p_20303_) {
        return false;
    }

    public boolean m_5829_() {
        return false;
    }

    public boolean m_6087_() {
        return !this.m_213877_();
    }

    public Vec3 m_7371_(float p_241842_1_) {
        Vec3 superPos = super.m_7371_(p_241842_1_);
        return new Vec3(superPos.f_82479_, superPos.f_82480_, superPos.f_82481_);
    }

    public Vec3 m_7688_(LivingEntity entity) {
        double yAdd = 0.7;
        entity.f_19794_ = false;
        this.m_20242_(false);
        double riderDismountDistance = 0.6;
        if (this.isNotShip() && this.getMountedGunType() == 1) {
            riderDismountDistance = 0.0;
        }
        return this.getRidingPosition(riderDismountDistance).m_82520_(0.0, yAdd, 0.0);
    }

    protected void m_20348_(Entity e) {
        LOGGER.trace("Add passenger");
        if (!this.isNotShip()) {
            e.m_146922_(this.m_146908_());
        }
        super.m_20348_(e);
        this.recentlyChangedPilotingStaus = true;
        if (e instanceof Villager) {
            Villager villager = (Villager)e;
            this.villagerRidingTicks = 0;
        } else if (e instanceof Player) {
            Player player = (Player)e;
            this.playerRidingTicks = 0;
            if (player.m_7578_()) {
                DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> new Runnable(){

                    @Override
                    public void run() {
                        XenoTechClient.isLeftMouseDown = false;
                        XenoTechClient.isRightMouseDown = false;
                    }
                });
            }
        }
        this.updateDriverSeatPosition();
    }

    private void updateDriverSeatPosition() {
        if (this.m_9236_().f_46443_) {
            BlockPos terminalPos = null;
            ArrayList<RenderableBlock> allSeats = new ArrayList<RenderableBlock>();
            terminalPos = this.scanShipBlocks(allSeats);
            if (terminalPos != null && !allSeats.isEmpty()) {
                for (RenderableBlock seat : allSeats) {
                    if (!seat.pos.m_121945_((Direction)seat.state.m_61143_((Property)DriverSeatBlock.f_54117_)).equals((Object)terminalPos)) continue;
                    this.hasDriverSeat = true;
                    if (this.m_146895_() != null) {
                        BlockPos diff = terminalPos.m_121996_((Vec3i)seat.pos);
                        float distDiff = pilotingWindshieldDistance;
                        seat.xOffset = (float)diff.m_123341_() / 1.0f;
                        seat.yOffset = (float)diff.m_123342_() / 1.0f;
                        seat.zOffset = (float)diff.m_123343_() / 1.0f;
                        float angle = this.getSanitizedStartingAngle();
                        if (angle == 90.0f || angle == 180.0f) {
                            distDiff = -distDiff;
                        }
                        if (seat.xOffset != 0.0f) {
                            seat.xOffset -= distDiff;
                        }
                        if (seat.zOffset != 0.0f) {
                            seat.zOffset -= distDiff;
                        }
                    } else {
                        seat.xOffset = 0.0f;
                        seat.yOffset = 0.0f;
                        seat.zOffset = 0.0f;
                    }
                    seat.lastRenderState = null;
                    break;
                }
            }
        }
    }

    public BlockPos scanShipBlocks(List<RenderableBlock> allSeats) {
        BlockPos terminalPos = null;
        this.hasBuzzsaw = false;
        this.hasDrill = false;
        for (RenderableBlock renderable : this.renderables) {
            if (renderable.state.m_60713_((Block)XenoBlocks.BLOCK_SHIP_TERMINAL.get())) {
                terminalPos = renderable.pos;
                continue;
            }
            if (renderable.state.m_60734_() instanceof DriverSeatBlock) {
                allSeats.add(renderable);
                continue;
            }
            if (renderable.state.m_60734_() instanceof BuzzsawBlock) {
                this.hasBuzzsaw = true;
                continue;
            }
            if (!(renderable.state.m_60734_() instanceof PrecisionDrillBlock) && !(renderable.state.m_60734_() instanceof MiningDrillBlock)) continue;
            this.hasDrill = true;
        }
        return terminalPos;
    }

    protected void m_20351_(Entity e) {
        if (this.isNotShip() && this.thisMountedGun != null) {
            this.killMountedGunDummy(e);
        }
        this.forwardCommandActive = false;
        this.reverseCommandActive = false;
        this.autopilotWantToAscend = false;
        this.autopilotWantToDescend = false;
        this.autopilotAutoAscendTicks = 0;
        this.autopilotAutoDescendTicks = 0;
        super.m_20351_(e);
        this.recentlyChangedPilotingStaus = true;
        this.updateDriverSeatPosition();
        this.resetActionList();
        if (e instanceof Player) {
            Player player = (Player)e;
            this.refreshCaptureTimestampForPlayer((Entity)player);
        }
    }

    public void killMountedGunDummy(Entity e) {
        BlockState blockState;
        Block block;
        LOGGER.debug("Kill mounted gun for entity=" + e);
        this.makeThisMountedGunRideable();
        if (e != null) {
            Vec3 pos = e.m_20182_();
            if (e instanceof Player) {
                Player pl = (Player)e;
                Entity entity = this.thisMountedGun.carrier;
                if (entity instanceof DummyEntity) {
                    DummyEntity dummyCarrier = (DummyEntity)entity;
                    dummyCarrier.refreshCaptureTimestampForPlayer((Entity)pl);
                    double ridingDismountDistance = 1.0;
                    if (this.isNotShip() && this.getMountedGunType() == 1) {
                        ridingDismountDistance = 0.0;
                    }
                    Vec3 dismountPos = this.getRidingPosition(ridingDismountDistance).m_82520_(0.0, 0.7, 0.0);
                    e.m_146884_(dismountPos);
                }
            }
        }
        if (!this.m_9236_().f_46443_ && this.thisMountedGun.carrier == null && this.thisMountedGun.initialBlockPos != null && (block = (blockState = this.m_9236_().m_8055_(this.thisMountedGun.initialBlockPos)).m_60734_()) instanceof MountedGunBlock) {
            MountedGunBlock mgb = (MountedGunBlock)block;
            this.m_9236_().m_7731_(this.thisMountedGun.initialBlockPos, (BlockState)blockState.m_61124_((Property)MountedGunBlock.MOUNTED, (Comparable)Boolean.valueOf(false)), 2);
        }
        if (this.thisMountedGun != null) {
            this.thisMountedGun.resetMountVariables();
        }
        if (!this.m_9236_().f_46443_) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    private void makeThisMountedGunRideable() {
        if (this.thisMountedGun != null) {
            Block block;
            this.thisMountedGun.mountedTo = null;
            if (this.thisMountedGun.renderable != null && this.thisMountedGun.renderable.state != null && (block = this.thisMountedGun.renderable.state.m_60734_()) instanceof MountedGunBlock) {
                MountedGunBlock mgb = (MountedGunBlock)block;
                this.thisMountedGun.renderable.state = (BlockState)this.thisMountedGun.renderable.state.m_61124_((Property)MountedGunBlock.MOUNTED, (Comparable)Boolean.valueOf(false));
            }
        }
    }

    public void removeRenderableBlockEntities() {
        for (RenderableBlock renderable : this.renderables) {
            if (renderable.tempBlockEntity == null) continue;
            LOGGER.debug("remove block entity: " + renderable.tempBlockEntity);
            LevelChunk chunk = this.m_9236_().m_46745_(renderable.tempBlockEntity.f_58858_);
            if (chunk.m_62954_().get(renderable.tempBlockEntity.f_58858_) == renderable.tempBlockEntity) {
                chunk.m_62954_().remove(renderable.tempBlockEntity.f_58858_);
            }
            renderable.tempBlockEntity.m_7651_();
            renderable.tempBlockEntity = null;
        }
    }

    public void onRemovedFromWorld() {
        updateInProgress = false;
        DummyEntity.removeUniqueGlobalDummy(this);
        super.onRemovedFromWorld();
    }

    public static void removeUniqueGlobalDummy(DummyEntity dummy) {
        dummiesGlobal.remove(new DummyEntityHolder(dummy));
        invalidateCachedDummyListServer = true;
        invalidateCachedDummyListClient = true;
        LOGGER.debug("unique global dummy removed: " + dummy);
        final DummyEntity thisDummy = dummy;
        if (dummy.bufferBuilderPack != null) {
            DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> new Runnable(){

                @Override
                public void run() {
                    ((ChunkBufferBuilderPack)thisDummy.bufferBuilderPack).m_108841_();
                }
            });
            dummy.bufferBuilderPack = null;
        }
    }

    public double m_6048_() {
        return ((Float)this.f_19804_.m_135370_(DATA_ID_RIDE_HEIGHT)).floatValue();
    }

    public Double getTerminalLocationY() {
        if (this.renderables != null && !this.renderables.isEmpty()) {
            Vec3 initialLoc = new Vec3(this.renderables.get(0).absoluteX(this), this.renderables.get(0).absoluteY(this), this.renderables.get(0).absoluteZ(this));
            BlockPos initialPos = BlockPos.m_274446_((Position)initialLoc);
            int minX = initialPos.m_123341_();
            int minY = initialPos.m_123342_();
            int minZ = initialPos.m_123343_();
            int maxX = initialPos.m_123341_();
            int maxY = initialPos.m_123342_();
            int maxZ = initialPos.m_123343_();
            Double terminalYAbsolute = null;
            for (RenderableBlock renderable : this.renderables) {
                Vec3 location = new Vec3(renderable.absoluteX(this), renderable.absoluteY(this), renderable.absoluteZ(this));
                BlockPos current = BlockPos.m_274446_((Position)location);
                if (renderable.state.m_60713_((Block)XenoBlocks.BLOCK_SHIP_TERMINAL.get())) {
                    terminalYAbsolute = location.f_82480_;
                }
                if (current.m_123341_() < minX) {
                    minX = current.m_123341_();
                }
                if (current.m_123342_() < minY) {
                    minY = current.m_123342_();
                }
                if (current.m_123343_() < minZ) {
                    minZ = current.m_123343_();
                }
                if (current.m_123341_() > maxX) {
                    maxX = current.m_123341_();
                }
                if (current.m_123342_() > maxY) {
                    maxY = current.m_123342_();
                }
                if (current.m_123343_() <= maxZ) continue;
                maxZ = current.m_123343_();
            }
            if (terminalYAbsolute != null) {
                return terminalYAbsolute - (double)minY;
            }
        }
        return null;
    }

    public Vec3 getPivotPoint() {
        AABB renderableAABB = this.getRenderablesAABB(false);
        if (renderableAABB != null) {
            renderableAABB.m_82383_(this.m_20182_());
            double xDiff = renderableAABB.f_82291_ - renderableAABB.f_82288_;
            double yDiff = renderableAABB.f_82292_ - renderableAABB.f_82289_;
            double zDiff = renderableAABB.f_82293_ - renderableAABB.f_82290_;
            Vec3 pivot = new Vec3(renderableAABB.f_82288_ + xDiff / 2.0, this.m_20186_(), renderableAABB.f_82290_ + zDiff / 2.0);
            return pivot;
        }
        return this.m_20182_();
    }

    public AABB getRenderablesAABB(boolean onlyConsiderColliders) {
        if (onlyConsiderColliders && this.lastAabbCollidersOnly != null) {
            return this.lastAabbCollidersOnly;
        }
        if (!onlyConsiderColliders && this.lastAabbAll != null) {
            return this.lastAabbAll;
        }
        if (this.renderables != null && !this.renderables.isEmpty() && this.doneWithSetup) {
            Vec3 initialLoc = new Vec3(this.renderables.get(0).absoluteX(this), this.renderables.get(0).absoluteY(this), this.renderables.get(0).absoluteZ(this));
            BlockPos initialPos = XenoTechUtils.blockPosFromRotPos(initialLoc);
            int minX = initialPos.m_123341_();
            int minY = initialPos.m_123342_();
            int minZ = initialPos.m_123343_();
            int maxX = initialPos.m_123341_();
            int maxY = initialPos.m_123342_();
            int maxZ = initialPos.m_123343_();
            for (RenderableBlock renderable : this.renderables) {
                Vec3 location = new Vec3(renderable.absoluteX(this), renderable.absoluteY(this), renderable.absoluteZ(this));
                BlockPos current = XenoTechUtils.blockPosFromRotPos(location);
                if (onlyConsiderColliders && renderable.state.m_60812_((BlockGetter)this.m_9236_(), current).m_83281_()) continue;
                if (current.m_123341_() < minX) {
                    minX = current.m_123341_();
                }
                if (current.m_123342_() < minY) {
                    minY = current.m_123342_();
                }
                if (current.m_123343_() < minZ) {
                    minZ = current.m_123343_();
                }
                if (current.m_123341_() > maxX) {
                    maxX = current.m_123341_();
                }
                if (current.m_123342_() > maxY) {
                    maxY = current.m_123342_();
                }
                if (current.m_123343_() <= maxZ) continue;
                maxZ = current.m_123343_();
            }
            AABB result = new AABB((double)minX - this.m_20185_(), (double)minY - this.m_20186_(), (double)minZ - this.m_20189_(), (double)maxX - this.m_20185_(), (double)maxY - this.m_20186_(), (double)maxZ - this.m_20189_());
            if (onlyConsiderColliders) {
                this.lastAabbCollidersOnly = result;
                return result;
            }
            this.lastAabbAll = result;
            return result;
        }
        this.lastAabbAll = null;
        this.lastAabbCollidersOnly = null;
        return null;
    }

    public static DummyEntity getEntity(float rideHeight, Level world, BlockPos pos, boolean oppositeFacing, boolean ship) {
        return DummyEntity.getEntity(rideHeight, world, new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5), oppositeFacing, ship);
    }

    public static DummyEntity getEntity(float rideHeight, Level world, Vec3 pos, boolean oppositeFacing, boolean ship) {
        List dummies;
        BlockPos blockPos = BlockPos.m_274561_((double)pos.f_82479_, (double)pos.f_82480_, (double)pos.f_82481_);
        if (dummyShouldScanForPreexisting && !(dummies = world.m_142425_(DUMMY_ENTITY, new AABB(blockPos), e -> true)).isEmpty()) {
            LOGGER.trace("Found dummy");
            return (DummyEntity)((Object)dummies.get(0));
        }
        LOGGER.trace("New dummy");
        DummyEntity dummy = (DummyEntity)DUMMY_ENTITY.m_20615_(world);
        if (ship) {
            dummy.shouldConstructNewShip = true;
        }
        dummy.m_6034_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
        dummy.setRideHeight(rideHeight);
        BlockState state = world.m_8055_(blockPos);
        LOGGER.info("Make dummy with state=" + state);
        if (state.m_61145_((Property)BlockStateProperties.f_61374_).isPresent()) {
            Direction facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
            LOGGER.info("Facing is=" + facing);
            if (oppositeFacing) {
                facing = facing.m_122424_();
            }
            LOGGER.info("Set yRot to " + facing.m_122435_());
            dummy.m_146922_(facing.m_122435_());
            dummy.f_19804_.m_135381_(STARTING_ANGLE, (Object)Float.valueOf(dummy.m_146908_()));
        } else {
            dummy.m_146922_(-1.0f);
        }
        if (!world.f_46443_) {
            world.m_7967_((Entity)dummy);
        }
        return dummy;
    }

    public void turn(float yRotRelative) {
        this.f_19804_.m_135381_(Y_ROT_REQUEST, (Object)Float.valueOf(((Float)this.f_19804_.m_135370_(Y_ROT_REQUEST)).floatValue() + yRotRelative));
    }

    public void zeroYRotRequest() {
        this.f_19804_.m_135381_(Y_ROT_REQUEST, (Object)Float.valueOf(0.0f));
    }

    public static CompoundTag entityToNbt(Entity e) {
        CompoundTag result = new CompoundTag();
        if (e == null) {
            return result;
        }
        CompoundTag entityNbt = new CompoundTag();
        e.m_20086_(entityNbt);
        entityNbt.m_128376_("HurtTime", (short)0);
        result.m_128356_("EntityTimestamp", System.currentTimeMillis());
        result.m_128365_("StoredEntity", (Tag)entityNbt);
        return result;
    }

    public static Entity entityFromNbt(Level level, CompoundTag tag) {
        CompoundTag entityTag;
        String entityTypeText;
        Optional optType;
        if (tag == null) {
            return null;
        }
        if (tag.m_128441_("StoredEntity") && (optType = EntityType.m_20632_((String)(entityTypeText = (entityTag = tag.m_128469_("StoredEntity")).m_128461_("id")))) != null && optType.isPresent()) {
            EntityType type = (EntityType)optType.get();
            Entity e = null;
            Optional optEntity = EntityType.m_20642_((CompoundTag)entityTag, (Level)level);
            if (optEntity != null && optEntity.isPresent()) {
                e = (Entity)optEntity.get();
            }
            return e;
        }
        return null;
    }

    public static DummyEntity getEntityForEntityType(Level world, Vec3 pos, Entity e) {
        LOGGER.trace("New dummy");
        LOGGER.trace("e = " + e);
        if (e instanceof LivingEntity) {
            DummyEntity dummy = (DummyEntity)DUMMY_ENTITY.m_20615_(world);
            dummy.m_6034_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
            if (!world.f_46443_) {
                dummy.setStoredEntityId(e.m_19879_());
                dummy.setRideHeight(-9999.0f);
                world.m_7967_((Entity)dummy);
                if (e instanceof Mob) {
                    Mob mob = (Mob)e;
                }
            }
            return dummy;
        }
        return null;
    }

    public void setStoredEntityId(int entityId) {
        this.f_19804_.m_135381_(TARGET_ENTITY_ID, (Object)entityId);
    }

    public Integer getStoredEntityId() {
        return (Integer)this.f_19804_.m_135370_(TARGET_ENTITY_ID);
    }

    public void setMountedGunType(int mountedGunType) {
        this.f_19804_.m_135381_(MOUNTED_GUN_TYPE, (Object)mountedGunType);
    }

    public Integer getMountedGunType() {
        return (Integer)this.f_19804_.m_135370_(MOUNTED_GUN_TYPE);
    }

    public boolean hasStoredEntityId() {
        Integer stored = this.getStoredEntityId();
        return stored != null && stored != -1;
    }

    public boolean isNotShip() {
        return this.thisMountedGun != null || this.uniqueId == -1L || this.hasStoredEntityId();
    }

    public Entity getStoredEntity() {
        Integer entityId = (Integer)this.f_19804_.m_135370_(TARGET_ENTITY_ID);
        if (entityId == null) {
            return null;
        }
        Entity e = this.m_9236_().m_6815_(entityId.intValue());
        if (e instanceof DummyEntity) {
            return null;
        }
        return e;
    }

    public static Iterable<Field> getFieldsUpTo(@Nonnull Class<?> startClass, @Nullable Class<?> exclusiveParent) {
        ArrayList currentClassFields = Lists.newArrayList((Object[])startClass.getDeclaredFields());
        Class<?> parentClass = startClass.getSuperclass();
        if (!(parentClass == null || exclusiveParent != null && parentClass.equals(exclusiveParent))) {
            List parentClassFields = (List)DummyEntity.getFieldsUpTo(parentClass, exclusiveParent);
            currentClassFields.addAll(parentClassFields);
        }
        return currentClassFields;
    }

    private Entity shallowCopy(Entity in) {
        if (in == null) {
            return null;
        }
        Class<?> cls = in.getClass();
        if (cls != null) {
            Iterable<Field> allData = DummyEntity.getFieldsUpTo(in.getClass(), Object.class);
            try {
                Constructor<?> cons = cls.getConstructor(EntityType.class, Level.class);
                Entity newEntity = (Entity)cons.newInstance(in.m_6095_(), in.m_9236_());
                for (Field f : allData) {
                    f.setAccessible(true);
                    Field toModify = null;
                    try {
                        toModify = newEntity.getClass().getDeclaredField(f.getName());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (toModify == null) continue;
                    toModify.setAccessible(true);
                    if (Modifier.isFinal(toModify.getModifiers())) continue;
                    toModify.set(newEntity, f.get(in));
                }
                SynchedEntityData sed = in.m_20088_();
                newEntity.m_20088_().m_135356_(sed.m_252804_());
                return newEntity;
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Entity getStoredEntityCopy() {
        Entity stored;
        ItemStack itemStack = Minecraft.m_91087_().f_91074_.m_21205_();
        if (!itemStack.m_150930_((Item)XenoBlocks.ITEM_STASIS_GUN.get())) {
            itemStack = Minecraft.m_91087_().f_91074_.m_21206_();
        }
        if ((stored = DummyEntity.entityFromNbt(this.m_9236_(), itemStack.m_41783_())) != null) {
            this.entityCopy = stored;
            this.entityCopy.m_146926_(stored.m_146909_());
            this.entityCopy.m_146922_(stored.m_146908_());
            this.entityCopy.m_5618_(stored.m_146908_());
            this.entityCopy.m_5616_(stored.m_6080_());
            if (this.entityCopy instanceof LivingEntity) {
                ((LivingEntity)this.entityCopy).f_20883_ = stored.m_146908_();
                ((LivingEntity)this.entityCopy).f_20884_ = stored.m_146908_() + 5.0f;
                ((LivingEntity)this.entityCopy).f_20885_ = stored.m_6080_();
                ((LivingEntity)this.entityCopy).f_20886_ = stored.m_6080_() + 5.0f;
            }
            return this.entityCopy;
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static long getTimestampDiff() {
        long timestamp = System.currentTimeMillis();
        long entityTimestamp = 0L;
        ItemStack itemStack = Minecraft.m_91087_().f_91074_.m_21205_();
        if (!itemStack.m_150930_((Item)XenoBlocks.ITEM_STASIS_GUN.get())) {
            itemStack = Minecraft.m_91087_().f_91074_.m_21206_();
        }
        if (itemStack.m_41783_().m_128441_("EntityTimestamp")) {
            entityTimestamp = itemStack.m_41783_().m_128454_("EntityTimestamp");
        }
        return timestamp - entityTimestamp;
    }

    public void ride(Player player) {
        if (!this.isNotShip()) {
            player.m_146922_(this.m_146908_());
        }
        player.m_20329_((Entity)this);
    }

    public void setRideHeight(float h) {
        this.f_19804_.m_135381_(DATA_ID_RIDE_HEIGHT, (Object)Float.valueOf(h));
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_ID_RIDE_HEIGHT, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(TARGET_ENTITY_ID, (Object)-1);
        this.f_19804_.m_135372_(RENDERABLE_BLOCKLIST, (Object)"");
        this.f_19804_.m_135372_(Y_ROT_REQUEST, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(STARTING_ANGLE, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(SHIP_NAME, (Object)"Unnamed");
        this.f_19804_.m_135372_(UNIQUE_ID, (Object)this.uniqueId);
        this.f_19804_.m_135372_(OUT_OF_FUEL, (Object)false);
        this.f_19804_.m_135372_(SERVER_ADDED_ASCENT, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(BUZZSAW_ENABLED, (Object)true);
        this.f_19804_.m_135372_(DRILL_ENABLED, (Object)true);
        this.f_19804_.m_135372_(WEAPONS_ENABLED, (Object)true);
        this.f_19804_.m_135372_(ANY_DRILL_ACTIVE, (Object)false);
        this.f_19804_.m_135372_(MOUNTED_GUN_TYPE, (Object)-1);
        this.f_19804_.m_135372_(METRICS_BLOCKS_TRAVELLED, (Object)0L);
        this.f_19804_.m_135372_(METRICS_TIME_SPENT_CONSUMING_FUEL_SEC, (Object)0L);
        this.f_19804_.m_135372_(METRICS_TIME_UNTIL_EMPTY_SEC, (Object)0L);
        this.f_19804_.m_135372_(METRICS_CREATION_DATE, (Object)"");
        this.f_19804_.m_135372_(METRICS_CREATOR_NAME, (Object)"");
    }

    public void m_269505_(List<SynchedEntityData.DataValue<?>> dataValues) {
        if (this.m_9236_().f_46443_) {
            for (SynchedEntityData.DataValue<?> dataValue : dataValues) {
                if (dataValue == null) continue;
            }
        }
        super.m_269505_(dataValues);
    }

    public void m_7350_(EntityDataAccessor<?> accessor) {
        if (this.m_9236_().f_46443_ || accessor != RENDERABLE_BLOCKLIST || this.uniqueId != -1L) {
            // empty if block
        }
        if (this.m_9236_().f_46443_) {
            if (accessor == UNIQUE_ID) {
                this.uniqueId = (Long)this.f_19804_.m_135370_(UNIQUE_ID);
            }
            if (accessor == SHIP_NAME) {
                this.updateDefaultNameStatus();
                LOGGER.debug("hasDefaultName=" + this.hasDefaultName);
                LOGGER.debug("Update teleportation transponder with new name '" + this.getShipName() + "' for uniqueId=" + this.uniqueId);
                if (this.uniqueId != -1L) {
                    for (ItemStack itemStack : Minecraft.m_91087_().f_91074_.m_150109_().f_35974_) {
                        String shipName;
                        long uniqueId;
                        if (!itemStack.m_150930_((Item)XenoBlocks.ITEM_TELEPORTATION_TRANSPONDER.get()) || itemStack == null || itemStack.m_41783_() == null || (uniqueId = itemStack.m_41783_().m_128454_("UniqueId")) != this.uniqueId || (shipName = this.getShipName()) == null || shipName.isBlank() || shipName.equals("Unnamed")) continue;
                        itemStack.m_41783_().m_128359_("ShipName", shipName);
                        itemStack.m_41714_((Component)Component.m_237113_((String)("Teleportation Transponder: " + shipName)));
                    }
                }
            }
        }
        super.m_7350_(accessor);
    }

    public void m_7378_(CompoundTag var1) {
        try {
            this.f_19804_.m_135381_(DATA_ID_RIDE_HEIGHT, (Object)Float.valueOf(var1.m_128457_("RideHeight")));
            this.f_19804_.m_135381_(TARGET_ENTITY_ID, (Object)var1.m_128451_("TargetEntityId"));
            this.f_19804_.m_135381_(RENDERABLE_BLOCKLIST, (Object)var1.m_128461_("RenderableBlocklist"));
            this.f_19804_.m_135381_(Y_ROT_REQUEST, (Object)Float.valueOf(var1.m_128457_("YRotRequest")));
            this.f_19804_.m_135381_(STARTING_ANGLE, (Object)Float.valueOf(var1.m_128457_("StartingAngle")));
            this.f_19804_.m_135381_(SHIP_NAME, (Object)var1.m_128461_("ShipName"));
            this.f_19804_.m_135381_(OUT_OF_FUEL, (Object)var1.m_128471_("OutOfFuel"));
            this.f_19804_.m_135381_(SERVER_ADDED_ASCENT, (Object)Float.valueOf(var1.m_128457_("ServerAddedAscent")));
            this.hasBuzzsaw = var1.m_128471_("HasBuzzsaw");
            this.hasDrill = var1.m_128471_("HasDrill");
            this.f_19804_.m_135381_(BUZZSAW_ENABLED, (Object)var1.m_128471_("BuzzsawEnabled"));
            this.f_19804_.m_135381_(DRILL_ENABLED, (Object)var1.m_128471_("DrillEnabled"));
            this.f_19804_.m_135381_(WEAPONS_ENABLED, (Object)var1.m_128471_("WeaponsEnabled"));
            this.f_19804_.m_135381_(ANY_DRILL_ACTIVE, (Object)var1.m_128471_("AnyDrillActive"));
            this.f_19804_.m_135381_(MOUNTED_GUN_TYPE, (Object)var1.m_128451_("MountedGunType"));
            this.f_19804_.m_135381_(METRICS_BLOCKS_TRAVELLED, (Object)var1.m_128454_("Metrics_BlocksTravelled"));
            this.f_19804_.m_135381_(METRICS_TIME_SPENT_CONSUMING_FUEL_SEC, (Object)var1.m_128454_("Metrics_TimeSpentConsumingFuel"));
            this.f_19804_.m_135381_(METRICS_TIME_UNTIL_EMPTY_SEC, (Object)var1.m_128454_("Metrics_TimeUntilEmpty"));
            this.f_19804_.m_135381_(METRICS_CREATION_DATE, (Object)var1.m_128461_("Metrics_CreationDate"));
            this.f_19804_.m_135381_(METRICS_CREATOR_NAME, (Object)var1.m_128461_("Metrics_CreatorName"));
        }
        catch (Exception e) {
            LOGGER.warn("Failed to set entity data", (Throwable)e);
        }
    }

    public void m_7380_(CompoundTag var1) {
        try {
            var1.m_128350_("RideHeight", ((Float)this.f_19804_.m_135370_(DATA_ID_RIDE_HEIGHT)).floatValue());
            var1.m_128405_("TargetEntityId", ((Integer)this.f_19804_.m_135370_(TARGET_ENTITY_ID)).intValue());
            var1.m_128359_("RenderableBlocklist", (String)this.f_19804_.m_135370_(RENDERABLE_BLOCKLIST));
            var1.m_128350_("YRotRequest", ((Float)this.f_19804_.m_135370_(Y_ROT_REQUEST)).floatValue());
            var1.m_128350_("StartingAngle", ((Float)this.f_19804_.m_135370_(STARTING_ANGLE)).floatValue());
            var1.m_128359_("ShipName", (String)this.f_19804_.m_135370_(SHIP_NAME));
            var1.m_128379_("OutOfFuel", ((Boolean)this.f_19804_.m_135370_(OUT_OF_FUEL)).booleanValue());
            var1.m_128350_("ServerAddedAscent", ((Float)this.f_19804_.m_135370_(SERVER_ADDED_ASCENT)).floatValue());
            var1.m_128379_("HasBuzzsaw", this.hasBuzzsaw);
            var1.m_128379_("HasDrill", this.hasDrill);
            var1.m_128379_("BuzzsawEnabled", ((Boolean)this.f_19804_.m_135370_(BUZZSAW_ENABLED)).booleanValue());
            var1.m_128379_("DrillEnabled", ((Boolean)this.f_19804_.m_135370_(DRILL_ENABLED)).booleanValue());
            var1.m_128379_("WeaponsEnabled", ((Boolean)this.f_19804_.m_135370_(WEAPONS_ENABLED)).booleanValue());
            var1.m_128379_("AnyDrillActive", ((Boolean)this.f_19804_.m_135370_(ANY_DRILL_ACTIVE)).booleanValue());
            var1.m_128405_("MountedGunType", ((Integer)this.f_19804_.m_135370_(MOUNTED_GUN_TYPE)).intValue());
            var1.m_128356_("Metrics_BlocksTravelled", ((Long)this.f_19804_.m_135370_(METRICS_BLOCKS_TRAVELLED)).longValue());
            var1.m_128356_("Metrics_TimeSpentConsumingFuel", ((Long)this.f_19804_.m_135370_(METRICS_TIME_SPENT_CONSUMING_FUEL_SEC)).longValue());
            var1.m_128356_("Metrics_TimeUntilEmpty", ((Long)this.f_19804_.m_135370_(METRICS_TIME_UNTIL_EMPTY_SEC)).longValue());
            var1.m_128359_("Metrics_CreationDate", (String)this.f_19804_.m_135370_(METRICS_CREATION_DATE));
            var1.m_128359_("Metrics_CreatorName", (String)this.f_19804_.m_135370_(METRICS_CREATOR_NAME));
        }
        catch (Exception e) {
            LOGGER.warn("Failed to save entity data", (Throwable)e);
        }
    }

    public void m_6457_(ServerPlayer player) {
        if (player != null) {
            LOGGER.debug("server: send ClientboundShipDataPacket for entityId=" + this.m_19879_() + " with uniqueId=" + this.uniqueId);
            if (this.uniqueId != -1L) {
                byte[] shipRecordData = this.shipRenderableStorage.recordsToBytes(this);
                int MAX_RECORD_PART_LEN = 80000;
                ArrayList<byte[]> parts = new ArrayList<byte[]>();
                int i = 0;
                while ((double)i < Math.ceil((float)shipRecordData.length / (float)MAX_RECORD_PART_LEN)) {
                    ByteArrayOutputStream stream = new ByteArrayOutputStream();
                    int startIndex = i * MAX_RECORD_PART_LEN;
                    int bytesToWrite = Math.min(shipRecordData.length - startIndex, MAX_RECORD_PART_LEN);
                    stream.write(shipRecordData, startIndex, bytesToWrite);
                    byte[] part = stream.toByteArray();
                    parts.add(part);
                    ++i;
                }
                int series = ClientboundMultipartShipDataPacket.seriesCounter.incrementAndGet();
                for (int i2 = 0; i2 < parts.size(); ++i2) {
                    int seqNo = i2 + 1;
                    boolean last = false;
                    if (seqNo == parts.size()) {
                        last = true;
                    }
                    PacketDistributor.PacketTarget target = PacketDistributor.ALL.noArg();
                    if (player != null) {
                        target = PacketDistributor.PLAYER.with(() -> player);
                    }
                    XenoTechNetwork.INSTANCE.send(target, (Object)new ClientboundMultipartShipDataPacket(this.m_19879_(), this.uniqueId, (byte[])parts.get(i2), series, seqNo, last));
                }
                try {
                    XenoTechNetwork.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new ClientboundTasklistPacket(this, this.taskList));
                }
                catch (Exception ex) {
                    LOGGER.error("Error sending ClientboundTasklistPacket", (Throwable)ex);
                }
            }
        }
        super.m_6457_(player);
    }

    public void assemblyRemoveRealBlocks(Set<BlockPos> blocks) {
        LOGGER.debug("Remove " + blocks.size() + " blocks");
        blockPosToRemoveForAssembly.addAll(blocks);
        assemblyInProgress = true;
        FakePlayer fp = null;
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel sLevel = (ServerLevel)level;
            if (fp == null) {
                Object genUuid = null;
                while (genUuid == null || ManipulatorBlockEntity.uuidList.contains(genUuid)) {
                    genUuid = UUID.randomUUID();
                }
                ManipulatorBlockEntity.uuidList.add((UUID)genUuid);
                this.f_19820_ = genUuid;
                GameProfile gp = new GameProfile((UUID)genUuid, null);
                fp = FakePlayerFactory.get((ServerLevel)sLevel, (GameProfile)gp);
                fp.m_143403_(GameType.CREATIVE);
                LOGGER.debug("create fakePlayer=" + fp + " with uuid=" + (UUID)genUuid + " for dummy=" + this + " at location=" + this.m_20183_());
            }
        }
        HashSet<BlockPos> preliminaryRemovedBlocks = new HashSet<BlockPos>();
        for (BlockPos pos : blocks) {
            BlockState state;
            if (!this.isFaceAttachedBlock(pos, state = this.m_9236_().m_8055_(pos))) continue;
            this.assemblyRemoveOneBlock(fp, pos);
            preliminaryRemovedBlocks.add(pos);
        }
        if (preliminaryRemovedBlocks.size() > 0) {
            LOGGER.debug("removed " + preliminaryRemovedBlocks.size() + " preliminary blocks: " + this);
        }
        blocks.removeAll(preliminaryRemovedBlocks);
        int remainingRemoved = 0;
        for (BlockPos pos : blocks) {
            ++remainingRemoved;
            this.assemblyRemoveOneBlock(fp, pos);
        }
        LOGGER.debug("removed " + remainingRemoved + " remaining blocks: " + this);
        fp = null;
        assemblyInProgress = false;
        blockPosToRemoveForAssembly.removeAll(blocks);
        LOGGER.debug("Finished remove blocks");
    }

    private boolean isFaceAttachedBlock(BlockPos pos, BlockState state) {
        return state.m_60734_() instanceof FaceAttachedHorizontalDirectionalBlock || state.m_60734_() instanceof LadderBlock || state.m_60734_() instanceof DoorBlock || state.m_60734_() instanceof RailBlock || state.m_60734_() instanceof CarpetBlock || state.m_60734_() instanceof TorchBlock || state.m_60734_() instanceof LanternBlock || state.m_60734_() instanceof AbstractBannerBlock || !state.m_60734_().m_7898_(state, (LevelReader)this.m_9236_(), pos);
    }

    private void assemblyRemoveOneBlock(FakePlayer fp, BlockPos pos) {
        if (fp != null) {
            fp.f_8941_.m_9280_(pos);
        }
        this.m_9236_().m_46747_(pos);
        this.m_9236_().m_7731_(pos, Blocks.f_50016_.m_49966_(), 2);
    }

    private void assemblyRemoveOneBlockOld(BlockPos pos) {
        this.m_9236_().m_46747_(pos);
        this.m_9236_().m_7731_(pos, Blocks.f_50016_.m_49966_(), 2);
    }

    public boolean canReassemble() {
        LOGGER.debug("check for reassembly with uniqueId=" + this.uniqueId);
        int matchCount = 0;
        this.shipRenderableStorage.readAllRecordsFromFile(this.uniqueId, this);
        if (this.renderables != null && !this.renderables.isEmpty()) {
            for (RenderableBlock renderable : this.renderables) {
                BlockPos pos = BlockPos.m_274561_((double)renderable.absoluteX(this), (double)renderable.absoluteY(this), (double)renderable.absoluteZ(this));
                BlockState state = this.m_9236_().m_8055_(pos);
                if (!state.m_60734_().equals(renderable.state.m_60734_())) {
                    LOGGER.warn("Missing block during reassembly!  Expected " + renderable.state + " but got " + state);
                    if (allowMissingBlocksDuringReassembly) continue;
                    return false;
                }
                ++matchCount;
            }
        }
        return matchCount != 0;
    }

    public boolean reassemble(ReassemblyFailureInfo rfi) {
        LOGGER.debug("reassemble with uniqueId=" + this.uniqueId + " from entity=" + this);
        HashSet<BlockPos> blocks = new HashSet<BlockPos>();
        int matchCount = 0;
        this.shipRenderableStorage.readAllRecordsFromFile(this.uniqueId, this);
        float reassemblyAngle = this.get90DegreeReassemblyAngle();
        LOGGER.debug("Reassemble with angle diff=" + reassemblyAngle);
        if (this.renderables != null && !this.renderables.isEmpty()) {
            for (RenderableBlock renderable : this.renderables) {
                Vec3 rotPos = XenoTechUtils.revolve(this, new Vec3(renderable.absoluteX(this), renderable.absoluteY(this), renderable.absoluteZ(this)));
                Vec3 roundedPos = new Vec3((double)Math.round(rotPos.f_82479_), (double)Math.round(rotPos.f_82480_), (double)Math.round(rotPos.f_82481_));
                BlockPos pos = XenoTechUtils.blockPosRotate(this, renderable.pos);
                LOGGER.debug("rotPos = " + rotPos + " for state=" + renderable.state + " with roundedPos=" + roundedPos + " and pos=" + pos + " having renderablePos=" + renderable.pos + " and terminalPos=" + this.startingTerminalPos);
                BlockState state = this.m_9236_().m_8055_(pos);
                BlockEntity blockEntity = this.m_9236_().m_7702_(pos);
                if (!state.m_60734_().equals(renderable.state.m_60734_())) {
                    String logText = "Missing block during reassembly!  Expected " + renderable.state.m_60734_().m_49954_().getString() + " but got " + state.m_60734_().m_49954_().getString() + " at " + pos;
                    LOGGER.warn(logText);
                    if (!allowMissingBlocksDuringReassembly) {
                        if (rfi != null) {
                            rfi.failureCode = 1;
                            rfi.failureText = logText;
                        }
                        return false;
                    }
                    renderable.state = Blocks.f_50016_.m_49966_();
                    continue;
                }
                ++matchCount;
                blocks.add(pos);
                if (blockEntity == null) continue;
                renderable.tag = blockEntity.m_187482_();
            }
        } else {
            LOGGER.warn("Renderables were empty!");
        }
        if (matchCount == 0) {
            return false;
        }
        this.assemblyRemoveRealBlocks(blocks);
        this.f_19804_.m_135381_(UNIQUE_ID, (Object)this.uniqueId);
        ArrayList<RenderableBlock> allSeats = new ArrayList<RenderableBlock>();
        BlockPos terminalPos = this.scanShipBlocks(allSeats);
        LOGGER.debug("reassembled with starting angle=" + this.getSanitizedStartingAngle());
        return true;
    }

    public void assemble() {
        this.shouldConstructNewShip = false;
        XenoTechUtils.CompositionInfo composition = new XenoTechUtils.CompositionInfo();
        Set<BlockPos> blocks = XenoTechUtils.getNewShipBlocks(this.m_9236_(), this.m_20183_(), null, composition);
        if (blocks != null) {
            this.startingTerminalPos = this.m_20183_();
            long deleteId = -1L;
            for (BlockPos pos : blocks) {
                int skyLight;
                BlockState state = this.m_9236_().m_8055_(pos);
                BlockEntity blockEntity = this.m_9236_().m_7702_(pos);
                int blockLight = this.m_9236_().m_45517_(LightLayer.BLOCK, pos);
                if (blockLight == 0) {
                    blockLight = this.getMaximumNearbyLight(pos, LightLayer.BLOCK);
                }
                if ((skyLight = this.m_9236_().m_45517_(LightLayer.SKY, pos)) == 0) {
                    skyLight = this.getMaximumNearbyLight(pos, LightLayer.SKY);
                }
                LOGGER.debug("Add " + state + " at " + pos + " with blockLight=" + blockLight + " and skyLight=" + skyLight);
                this.renderables.add(new RenderableBlock(this, pos, state, blockEntity, blockLight, skyLight));
                if (blockEntity == null || !(blockEntity instanceof ShipTerminalBlockEntity)) continue;
                ShipTerminalBlockEntity terminal = (ShipTerminalBlockEntity)blockEntity;
                if (terminal.reassemblyUniqueId == -1L) continue;
                deleteId = terminal.reassemblyUniqueId;
            }
            this.doneWithSetup = true;
            this.weight = composition.weight;
            this.vehicleType = composition.vehicleType;
            float weightInThousands = this.weight / 1000.0f;
            if (weightInThousands < 1.0f) {
                weightInThousands = 1.0f;
            }
            this.moverStats = composition.fwdMoverStats;
            this.moverStats.acceleration /= weightInThousands;
            this.moverStats.topSpeed /= weightInThousands;
            XenoTechUtils.limitMaxPowerForMover(this.moverStats, false, this.vehicleType);
            LOGGER.debug("construct ship with engineAccel=" + this.moverStats.acceleration + " and engineTopSpeed=" + this.moverStats.topSpeed);
            this.liftMoverStats = composition.liftMoverStats;
            this.liftMoverStats.acceleration /= weightInThousands;
            this.liftMoverStats.topSpeed /= weightInThousands;
            XenoTechUtils.limitMaxPowerForMover(this.liftMoverStats, true, this.vehicleType);
            LOGGER.debug("construct ship with liftEngineAccel=" + this.liftMoverStats.acceleration + " and liftEngineTopSpeed=" + this.liftMoverStats.topSpeed);
            this.isBoat = composition.isBoat;
            this.isGroundVehicle = composition.isGroundVehicle;
            this.uniqueId = XenoTechCommon.getNextShipId();
            this.f_19804_.m_135381_(UNIQUE_ID, (Object)this.uniqueId);
            this.f_19804_.m_135381_(RENDERABLE_BLOCKLIST, (Object)"abc");
            this.f_19804_.m_135381_(STARTING_ANGLE, (Object)Float.valueOf(this.m_146908_()));
            this.assemblyRemoveRealBlocks(blocks);
            this.saveData();
            if (deleteId != -1L) {
                this.shipRenderableStorage.deleteRecord(deleteId);
            }
            ArrayList<RenderableBlock> allSeats = new ArrayList<RenderableBlock>();
            BlockPos terminalPos = this.scanShipBlocks(allSeats);
            LOGGER.debug("assembled with starting angle=" + this.getSanitizedStartingAngle());
        }
    }

    private int getMaximumNearbyLight(BlockPos pos, LightLayer layer) {
        int lightLevel = 0;
        List<BlockPos> toCheck = List.of(pos.m_7495_(), pos.m_7494_(), pos.m_122029_(), pos.m_122024_(), pos.m_122012_(), pos.m_122019_());
        for (BlockPos blockPos : toCheck) {
            int nearbyBlockLight = this.m_9236_().m_45517_(layer, blockPos);
            if (nearbyBlockLight <= lightLevel) continue;
            lightLevel = nearbyBlockLight;
        }
        if (lightLevel > 0) {
            --lightLevel;
        }
        return lightLevel;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        LOGGER.debug("getAddEntityPacket for entity: " + this);
        if (this.shouldConstructNewShip && this.renderables.isEmpty() && !this.m_9236_().f_46443_) {
            this.assemble();
        }
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    private /* synthetic */ Runnable lambda$tick$22(final Entity thisEntity, final Vec3 newPosCopy) {
        return new Runnable(){

            @Override
            public void run() {
                if (thisEntity.m_9236_().f_46443_ && Minecraft.m_91087_().m_91091_() && Minecraft.m_91087_().f_91073_ != null) {
                    Entity serverEntity;
                    ServerLevel serverLevel = Minecraft.m_91087_().m_91092_().m_129880_(Minecraft.m_91087_().f_91073_.m_46472_());
                    LOGGER.trace("serverLevel=" + (Level)serverLevel);
                    if (serverLevel != null && (serverEntity = serverLevel.m_6815_(thisEntity.m_19879_())) != null) {
                        LOGGER.trace("serverEntity=" + serverEntity + " for level=" + thisEntity.m_9236_());
                        serverEntity.m_20343_(newPosCopy.f_82479_, newPosCopy.f_82480_, newPosCopy.f_82481_);
                    }
                }
            }
        };
    }

    private /* synthetic */ Runnable lambda$tick$21(final Entity thisEntity, final boolean clientDoesServerUpdates, final Vec3 newPosCopy) {
        return new Runnable(){

            @Override
            public void run() {
                if (thisEntity.m_9236_().f_46443_) {
                    // empty if block
                }
            }
        };
    }

    private /* synthetic */ Runnable lambda$tick$20(final DummyEntity thisEntity) {
        return new Runnable(){

            @Override
            public void run() {
                if ((double)DummyEntity.this.liftMoverStats.acceleration != 0.0) {
                    --DummyEntity.this.soundTicksLeft;
                    if (DummyEntity.this.soundTicksLeft <= 0 && !(DummyEntity.this.liftMoverStats.moverBlockType instanceof BalloonBlock) && DummyEntity.this.isHoveringInAir() && Boolean.TRUE.equals(enableHelicopterHoverSound)) {
                        if (useOldHelicopterHoverSound) {
                            float lastVerticalSpinSpeedPct = DummyEntity.this.lastVerticalSpinSpeed / 800.0f;
                            if (lastVerticalSpinSpeedPct > 1.0f) {
                                lastVerticalSpinSpeedPct = 1.0f;
                            }
                            if (lastVerticalSpinSpeedPct <= 0.2f) {
                                lastVerticalSpinSpeedPct = 0.0f;
                            }
                            float configVolumeMod = helicopterHoverSoundVolume / 100.0f;
                            float volume = lastVerticalSpinSpeedPct * 0.8f * configVolumeMod;
                            float pitchPct = (float)Math.abs(DummyEntity.this.m_20184_().f_82480_) / DummyEntity.this.liftMoverStats.topSpeed;
                            float pitchMin = 1.0f;
                            float pitchMax = 1.2f;
                            float pitch = pitchMin * (1.0f - pitchPct) + pitchMax * pitchPct;
                            pitch = 1.0f;
                            DummyEntity.this.m_9236_().m_6269_((Player)Minecraft.m_91087_().f_91074_, (Entity)thisEntity, (SoundEvent)XenoBlocks.SOUND_EVENT_HELICOPTER_HOVER.get(), SoundSource.BLOCKS, volume, pitch);
                            DummyEntity.this.soundTicksLeft = 14;
                        } else {
                            float lastVerticalSpinSpeedPct = DummyEntity.this.lastVerticalSpinSpeed / 800.0f;
                            if (lastVerticalSpinSpeedPct > 1.0f) {
                                lastVerticalSpinSpeedPct = 1.0f;
                            }
                            if (lastVerticalSpinSpeedPct <= 0.2f) {
                                lastVerticalSpinSpeedPct = 0.0f;
                            }
                            float configVolumeMod = helicopterHoverSoundVolume / 100.0f;
                            float volume = lastVerticalSpinSpeedPct * 1.2f * configVolumeMod;
                            float pitchPct = (float)Math.abs(DummyEntity.this.m_20184_().f_82480_) / DummyEntity.this.liftMoverStats.topSpeed;
                            float pitchMin = 1.0f;
                            float pitchMax = 1.2f;
                            float pitch = pitchMin * (1.0f - pitchPct) + pitchMax * pitchPct;
                            pitch = 1.0f;
                            int soundIdx = DummyEntity.this.newHoverSoundIndex % newHoverSounds.length;
                            DummyEntity.this.m_9236_().m_6269_((Player)Minecraft.m_91087_().f_91074_, (Entity)thisEntity, newHoverSounds[soundIdx], SoundSource.BLOCKS, volume, pitch);
                            DummyEntity.this.soundTicksLeft = (int)(newHoverSoundLengths[soundIdx] * 20.0f);
                            ++DummyEntity.this.newHoverSoundIndex;
                        }
                    }
                }
            }
        };
    }

    static {
        ignorePersistentLeaves = buzzsawIgnorePersistentLeaves;
        serverReachScaleMult = 1.0f;
        buzzsawReachScale = 1.4f;
        drillReachScale = 1.2f;
        axeMineableSpeedScale = 0.3f;
        shovelMineableSpeedScale = 0.25f;
        serverInflateBoundingBoxes = true;
        serverBoundingBoxInflateFactor = 2.0;
        checkForNewEntitiesTickPeriod = 2;
        blacklistedProjectileKillEntities = new HashSet<String>();
        blacklistedProjectileKillEntities.add("quark:pickarang");
        blacklistedProjectileKillEntities.add("quark:flamerang");
        blacklistedCarryEntities = new HashSet<String>();
        blacklistedCarryEntities.add("create:stationary_contraption");
        blacklistedCarryEntities.add("create:super_glue");
        blacklistedCarryEntities.add("iceandfire:fire_dragon");
        blacklistedCarryEntities.add("iceandfire:ice_dragon");
        blacklistedCarryEntities.add("iceandfire:lightning_dragon");
        blacklistedCarryEntities.add("iceandfire:dragon_multipart");
        blacklistedCarryEntities.add("iceandfire:dragon_egg");
        blacklistedCarryEntities.add("iceandfire:dragon_skull");
        blacklistedCarryEntities.add("quark:pickarang");
        blacklistedCarryEntities.add("quark:flamerang");
        blacklistedCarryEntities.add("immersive_portals:*");
        playerTemporarilyIgnoreCollision = false;
        drillKillsFallingBlock = true;
        localPlayerBeingCarriedByDummy = false;
        updateInProgress = false;
        dummyMovementVec = null;
        newlyLoggedIn = new ArrayList<Player>();
        currentlyTickingDummyEntity = null;
        MIN_SPEED_FOR_TAKEOFF = 0.36;
        MIN_SPEED_FOR_TAKEOFF_SQR = MIN_SPEED_FOR_TAKEOFF * MIN_SPEED_FOR_TAKEOFF;
        planeAscentAccelScaleFactor = 1.6f;
        planeAscentSpeedScaleFactor = 0.4f;
        TAKEOFF_ASCENT_VALUE = 0.02f;
        TAKEOFF_ASCENT_MAX_VALUE = 0.2f;
        enableBlockEntitiesOnboard = true;
        usePlayerGradualTurning = true;
        playerFlyerTurnValueIncreaseMagnitude = 0.04f;
        playerFlyerTurnDecayFactorMin = 0.58f;
        playerFlyerTurnDecayFactorMax = 0.5f;
        playerFlyerTurnAdditiveDecay = 0.167f;
        playerFlyerTurnValue = 0.0f;
        turningScaleForPlayerFlyerMin = 0.5f;
        turningScaleForPlayerFlyerMax = 1.0f;
        playerFlyerFreeFlightPitchValue = 0.0f;
        turningScaleForBalloon = 0.275f;
        turningScaleForSportTire = 2.2f;
        turningScaleForJetThruster = 1.65f;
        turningScaleForSailboat = 0.77f;
        turningScaleGeneric = 1.1f;
        reverseSpeedFactor = 2.3f;
        FURNANCE_BURN_TIME_MULT = 1.0f;
        FURNANCE_BURN_TIME_MAX_SECONDS = 800;
        REFINED_OIL_BURN_MINUTES = 10;
        modifyHoverName = true;
        dummyShouldScanForPreexisting = false;
        blockPosToRemoveForAssembly = ConcurrentHashMap.newKeySet();
        allowMissingBlocksDuringReassembly = false;
        assemblyInProgress = false;
    }

    public static class DummyEntityHolder {
        public DummyEntity dummy;
        public Integer levelClass;

        public String toString() {
            return "DummyEntityHolder [dummy=" + this.dummy + ", levelClass=" + this.levelClass + "]";
        }

        public DummyEntityHolder(DummyEntity dummy) {
            this.dummy = dummy;
            this.levelClass = dummy.m_9236_() instanceof ServerLevel ? 1 : 0;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.dummy == null ? 0 : this.dummy.hashCode());
            result = 31 * result + (this.levelClass == null ? 0 : this.levelClass.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DummyEntityHolder other = (DummyEntityHolder)obj;
            if (this.dummy == null ? other.dummy != null : !this.dummy.equals((Object)other.dummy)) {
                return false;
            }
            return !(this.levelClass == null ? other.levelClass != null : !this.levelClass.equals(other.levelClass));
        }
    }

    public static enum VehicleType {
        GROUND,
        BOAT,
        HELICOPTER,
        PLANE,
        SUBMARINE,
        BALLOON;

    }

    public static class TeleportLocation {
        public Level destLevel;
        public Vec3 loc;
        public float yRot;
        public Direction direction;
        public DummyEntity entity;
        public boolean digitized;

        public String toString() {
            return "(loc=" + this.loc + ", direction=" + this.direction + ")";
        }
    }

    private static class DrillInfo {
        public boolean didDestroy = false;
        public boolean updatedProgressThisTick = false;

        private DrillInfo() {
        }
    }

    private static class MiningProgress {
        BlockPos target;
        int progress = 0;

        MiningProgress(BlockPos target) {
            this.target = target;
        }
    }

    public static class LogoutPositionInfo {
        public UUID dummyId;
        public Vec3 relativePos;

        public LogoutPositionInfo(DummyEntity dummy, Vec3 relativePos) {
            this.dummyId = dummy.m_20148_();
            this.relativePos = relativePos;
        }
    }

    private static class BoatWaterInfo {
        public boolean forceAscent = false;
        public double gravity = 0.0;

        private BoatWaterInfo() {
        }
    }

    public static class IntegratedWeaponInfo {
        public IntegratedGunBlockEntity blockEntity = null;
        public BlockPos renderablePos;
        public RenderableBlock renderable;

        public int hashCode() {
            return Objects.hash(this.renderablePos);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            IntegratedWeaponInfo other = (IntegratedWeaponInfo)obj;
            return Objects.equals(this.renderablePos, other.renderablePos);
        }

        public String toString() {
            return "[" + this.blockEntity + "/" + this.blockEntity.m_58904_() + ", " + this.renderablePos + "]";
        }
    }

    public static class ReassemblyFailureInfo {
        public int failureCode;
        public String failureText;
    }

    private static class DiffHolder {
        double xDiff = 0.0;
        double yDiff = 0.0;
        double zDiff = 0.0;

        private DiffHolder() {
        }
    }

    public static enum Status {
        IN_WATER,
        UNDER_WATER,
        UNDER_FLOWING_WATER,
        ON_LAND,
        IN_AIR;

    }
}

