/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.xenotech.entity;

import com.dairymoose.xenotech.XenoBlocks;
import com.dairymoose.xenotech.XenoTechClient;
import com.dairymoose.xenotech.XenoTechUtils;
import com.dairymoose.xenotech.block.BuzzsawBlock;
import com.dairymoose.xenotech.block.CombineHarvesterBlock;
import com.dairymoose.xenotech.block.HelicopterRotor;
import com.dairymoose.xenotech.block.JetThrusterBlock;
import com.dairymoose.xenotech.block.PropellerBlock;
import com.dairymoose.xenotech.block.TractorWheelBlock;
import com.dairymoose.xenotech.client.model.CrossModel;
import com.dairymoose.xenotech.entity.DummyEntity;
import com.dairymoose.xenotech.entity.RenderableBlock;
import com.dairymoose.xenotech.world.level.block.entity.BaseDrillBlockEntity;
import com.mojang.blaze3d.shaders.Uniform;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ChunkBufferBuilderPack;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.StainedGlassBlock;
import net.minecraft.world.level.block.StainedGlassPaneBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.model.data.ModelData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DummyRenderer
extends EntityRenderer<DummyEntity> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ResourceLocation JET_TEXTURE = new ResourceLocation("xenotech", "textures/entity/jet_entity.png");
    public static boolean useBlockLightingForShip = true;
    private CrossModel crossModel;
    public static final float NOSE_ANGLE_ZP = 3.0f;
    public static final float TURN_ROTATION_ZP = 5.0f;
    public static EntityRenderer rendererLast = null;
    public static Entity lastEntity = null;
    public static boolean isDummyRender = false;
    private static boolean useBatchRender = true;
    private static boolean batchRenderAsync = true;
    private static boolean batchRenderSyncGlass = false;
    private static boolean batchRenderGlassAsCutout = true;
    public static boolean gameWasReloaded = false;
    private final Executor executor = Executors.newCachedThreadPool();
    public static float currentSpeedPercent = 0.0f;
    private boolean buzzsawSpinsWhileMoving = false;

    public DummyRenderer(EntityRendererProvider.Context ctx) {
        super(ctx);
        this.crossModel = new CrossModel(ctx.m_174023_(CrossModel.LAYER_LOCATION));
    }

    public boolean shouldRender(DummyEntity dummyEntity, Frustum p_225626_2_, double p_225626_3_, double p_225626_5_, double p_225626_7_) {
        if (DummyEntity.doNotRender) {
            return false;
        }
        if (!dummyEntity.renderables.isEmpty() || dummyEntity.hasStoredEntityId()) {
            return true;
        }
        return dummyEntity.isNotShip();
    }

    private static ChunkBufferBuilderPack bufferBuilderPack(DummyEntity dummy) {
        if (dummy.bufferBuilderPack == null) {
            dummy.bufferBuilderPack = new ChunkBufferBuilderPack();
        }
        return (ChunkBufferBuilderPack)dummy.bufferBuilderPack;
    }

    private static boolean isHiddenTerminal(DummyEntity dummyEntity, RenderableBlock renderable) {
        if (Boolean.TRUE.equals(DummyEntity.terminalVisibleWhilePiloted)) {
            return false;
        }
        return renderable.state.m_60713_((Block)XenoBlocks.BLOCK_SHIP_TERMINAL.get()) && dummyEntity.m_146895_() != null;
    }

    private void renderBatched(BlockState blockState, BlockPos blockPos, BlockAndTintGetter level, PoseStack p_234359_, VertexConsumer p_234360_, boolean p_234361_, RandomSource p_234362_, ModelData modelData, RenderType renderType) {
        Block block;
        if (blockState.m_60734_() instanceof StainedGlassBlock) {
            blockState = Blocks.f_50058_.m_49966_();
        }
        if ((block = blockState.m_60734_()) instanceof StainedGlassPaneBlock) {
            StainedGlassPaneBlock sgp = (StainedGlassPaneBlock)block;
            blockState = (BlockState)((BlockState)((BlockState)((BlockState)Blocks.f_50185_.m_49966_().m_61124_((Property)PipeBlock.f_55148_, (Comparable)((Boolean)blockState.m_61143_((Property)PipeBlock.f_55148_)))).m_61124_((Property)PipeBlock.f_55149_, (Comparable)((Boolean)blockState.m_61143_((Property)PipeBlock.f_55149_)))).m_61124_((Property)PipeBlock.f_55150_, (Comparable)((Boolean)blockState.m_61143_((Property)PipeBlock.f_55150_)))).m_61124_((Property)PipeBlock.f_55151_, (Comparable)((Boolean)blockState.m_61143_((Property)PipeBlock.f_55151_)));
        }
        try {
            RenderShape rendershape = blockState.m_60799_();
            if (rendershape == RenderShape.MODEL) {
                Minecraft.m_91087_().m_91289_().m_110937_().tesselateBlock(level, Minecraft.m_91087_().m_91289_().m_110910_(blockState), blockState, blockPos, p_234359_, p_234360_, p_234361_, p_234362_, 0L, OverlayTexture.f_118083_, modelData, renderType);
            }
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.m_127521_((Throwable)throwable, (String)"Tesselating block in world");
            CrashReportCategory crashreportcategory = crashreport.m_127514_("Block being tesselated");
            CrashReportCategory.m_178950_((CrashReportCategory)crashreportcategory, (LevelHeightAccessor)level, (BlockPos)blockPos, (BlockState)blockState);
            throw new ReportedException(crashreport);
        }
    }

    private CompletableFuture<Boolean> doBatchRender(DummyEntity dummyEntity, ChunkBufferBuilderPack bufferBuilderPack) {
        ModelBlockRenderer.m_111000_();
        PoseStack poseStack = new PoseStack();
        HashSet<RenderType> renderSet = new HashSet<RenderType>();
        HashMap<RenderType, BufferBuilder.RenderedBuffer> cachedRenders = new HashMap<RenderType, BufferBuilder.RenderedBuffer>();
        HashSet<RenderType> dirtyRenderTypes = new HashSet<RenderType>();
        HashMap<RenderType, Integer> countsByRenderType = new HashMap<RenderType, Integer>();
        dummyEntity.batchRenderRandom.m_188584_(0L);
        if (gameWasReloaded) {
            LOGGER.error("Discarding all batch render buffers due to reload");
            bufferBuilderPack.m_108841_();
        }
        if (cachedRenders != null && dummyEntity.renderables != null && !dummyEntity.renderables.isEmpty()) {
            RenderableLightLevel rbll = new RenderableLightLevel((BlockAndTintGetter)dummyEntity.m_9236_());
            Object lightLevel = dummyEntity.m_9236_();
            if (dummyEntity.doneWithSetup && useBlockLightingForShip) {
                lightLevel = rbll;
            }
            for (RenderableBlock renderable : dummyEntity.renderables) {
                if (renderable.state.m_60799_() == RenderShape.INVISIBLE) continue;
                poseStack.m_85836_();
                poseStack.m_85837_(renderable.relativeX, renderable.relativeY, renderable.relativeZ);
                if (renderable.xOffset != 0.0f || (double)renderable.yOffset != 0.0 || renderable.zOffset != 0.0f) {
                    poseStack.m_252880_(renderable.xOffset, renderable.yOffset, renderable.zOffset);
                }
                this.doAnimatedBlockRotations(dummyEntity, renderable, poseStack);
                boolean isDirty = false;
                if (renderable.state != renderable.lastRenderState || renderable.visualRotation != renderable.lastVisualRotation || gameWasReloaded) {
                    isDirty = true;
                }
                BakedModel model = Minecraft.m_91087_().m_91289_().m_110910_(renderable.state);
                ModelData modelData = model.getModelData((BlockAndTintGetter)dummyEntity.m_9236_(), dummyEntity.m_20183_(), renderable.state, ModelData.EMPTY);
                if (renderable.state.m_60713_((Block)XenoBlocks.BLOCK_SHIP_TERMINAL.get()) && (XenoTechClient.recentlyToggledInvis || dummyEntity.recentlyChangedPilotingStaus)) {
                    XenoTechClient.recentlyToggledInvis = false;
                    dummyEntity.recentlyChangedPilotingStaus = false;
                    isDirty = true;
                }
                ModelData blockentityModelData = ModelData.EMPTY;
                if (renderable.tempBlockEntity != null) {
                    modelData = blockentityModelData = renderable.tempBlockEntity.getModelData();
                }
                for (RenderType rendertype2 : model.getRenderTypes(renderable.state, dummyEntity.batchRenderRandom, modelData)) {
                    if (!DummyRenderer.isHiddenTerminal(dummyEntity, renderable)) {
                        Integer countForThisRenderType = (Integer)countsByRenderType.get(rendertype2);
                        if (countForThisRenderType == null) {
                            countForThisRenderType = 0;
                        }
                        countForThisRenderType = countForThisRenderType + 1;
                        countsByRenderType.put(rendertype2, countForThisRenderType);
                        try {
                            BufferBuilder bufferbuilder2 = bufferBuilderPack.m_108839_(rendertype2);
                            if (bufferbuilder2 != null) {
                                if (renderSet.add(rendertype2)) {
                                    bufferbuilder2.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85811_);
                                }
                                BlockPos initialPos = renderable.pos;
                                rbll.renderable = renderable;
                                this.renderBatched(renderable.state, initialPos, (BlockAndTintGetter)lightLevel, poseStack, (VertexConsumer)bufferbuilder2, false, dummyEntity.batchRenderRandom, blockentityModelData, rendertype2);
                            }
                        }
                        catch (Exception ex) {
                            LOGGER.error("batch render error for state=" + renderable.state, (Throwable)ex);
                            return CompletableFuture.completedFuture(Boolean.FALSE);
                        }
                    }
                    if (!isDirty) continue;
                    dirtyRenderTypes.add(rendertype2);
                }
                renderable.lastRenderState = renderable.state;
                poseStack.m_85849_();
            }
        }
        try {
            if (cachedRenders != null) {
                for (RenderType rendertype1 : renderSet) {
                    BufferBuilder.RenderedBuffer bufferbuilder$renderedbuffer = bufferBuilderPack.m_108839_(rendertype1).m_231168_();
                    if (bufferbuilder$renderedbuffer == null) continue;
                    cachedRenders.put(rendertype1, bufferbuilder$renderedbuffer);
                }
                for (RenderType renderType : renderSet) {
                    if (dirtyRenderTypes.contains(renderType)) {
                        if (dummyEntity.uploadedBuffers == null) continue;
                        dummyEntity.uploadedBuffers.remove(renderType);
                        continue;
                    }
                    BufferBuilder.RenderedBuffer rendered = (BufferBuilder.RenderedBuffer)cachedRenders.get(renderType);
                    if (rendered == null) continue;
                    rendered.m_231200_();
                }
                dummyEntity.cachedRenders = cachedRenders;
            }
        }
        catch (Exception ex) {
            LOGGER.error("batch render error for cachedRenders=" + cachedRenders, (Throwable)ex);
            return CompletableFuture.completedFuture(Boolean.FALSE);
        }
        gameWasReloaded = false;
        ModelBlockRenderer.m_111077_();
        return CompletableFuture.completedFuture(Boolean.TRUE);
    }

    public void render(DummyEntity dummyEntity, float yRot, float partialTick, PoseStack poseStack, MultiBufferSource mbs, int combinedLight) {
        long timestamp = System.currentTimeMillis();
        if (dummyEntity.lastRenderTimestamp == 0L) {
            dummyEntity.lastRenderTimestamp = timestamp;
        }
        long timeDiff = timestamp - dummyEntity.lastRenderTimestamp;
        if (!dummyEntity.renderables.isEmpty() && dummyEntity.doneWithSetup) {
            poseStack.m_85836_();
            float renderYRot = dummyEntity.yRotForRender(yRot);
            poseStack.m_252781_(Axis.f_252436_.m_252977_(-renderYRot));
            if (dummyEntity.vehicleType == DummyEntity.VehicleType.PLANE || dummyEntity.vehicleType == DummyEntity.VehicleType.HELICOPTER) {
                if (dummyEntity.isHoveringInAir()) {
                    DummyRenderer.doTurnRotation(dummyEntity, poseStack);
                    DummyRenderer.doStrafeRotation(dummyEntity, poseStack);
                }
                if (dummyEntity.isFreeFlightMode() && dummyEntity.isHoveringInAir()) {
                    Axis noseTiltAxis = Axis.f_252403_;
                    if (dummyEntity.getSanitizedStartingAngle() % 180.0f == 0.0f) {
                        noseTiltAxis = Axis.f_252529_;
                    }
                    poseStack.m_252781_(noseTiltAxis.m_252977_(-dummyEntity.m_146909_()));
                }
                if ((double)dummyEntity.liftMoverStats.acceleration > 0.0 && dummyEntity.isHoveringInAir() && dummyEntity.liftMoverStats.moverBlockType instanceof HelicopterRotor) {
                    float horizontalSpeedPct = (float)dummyEntity.currentHorizontalSpeed / dummyEntity.moverStats.topSpeed;
                    if (horizontalSpeedPct > 1.0f) {
                        horizontalSpeedPct = 1.0f;
                    }
                    if (dummyEntity.speedVectorIsPositive) {
                        horizontalSpeedPct = -horizontalSpeedPct;
                    }
                    float newNoseTilt = horizontalSpeedPct * dummyEntity.noseTiltMax;
                    Axis noseTiltAxis = Axis.f_252403_;
                    if (dummyEntity.getSanitizedStartingAngle() % 180.0f == 0.0f) {
                        noseTiltAxis = Axis.f_252529_;
                        if (dummyEntity.getSanitizedStartingAngle() == 0.0f) {
                            newNoseTilt = -newNoseTilt;
                        }
                    } else if (dummyEntity.getSanitizedStartingAngle() == 90.0f) {
                        newNoseTilt = -newNoseTilt;
                    }
                    dummyEntity.noseTilt = newNoseTilt;
                    poseStack.m_252781_(noseTiltAxis.m_252977_(dummyEntity.noseTilt));
                }
            }
            if (useBatchRender = DummyEntity.doBatchRendering) {
                // empty if block
            }
            for (RenderableBlock renderable : dummyEntity.renderables) {
                float spinSpeed;
                poseStack.m_85836_();
                poseStack.m_85837_(renderable.relativeX, renderable.relativeY, renderable.relativeZ);
                if (renderable.xOffset != 0.0f || (double)renderable.yOffset != 0.0 || renderable.zOffset != 0.0f) {
                    poseStack.m_252880_(renderable.xOffset, renderable.yOffset, renderable.zOffset);
                }
                boolean isVertical = false;
                isVertical = this.doAnimatedBlockRotations(dummyEntity, renderable, poseStack);
                if (this.isPropellerBlock(renderable)) {
                    spinSpeed = 0.0f;
                    spinSpeed = !isVertical ? (float)Math.min(0.0 + dummyEntity.currentHorizontalSpeed * 1550.0, 600.0) : (float)Math.min(80.0 + dummyEntity.m_20184_().f_82480_ * 4500.0, 800.0) + (dummyEntity.isHoveringInAir() ? 0.0f : (float)dummyEntity.ascendingTicks / 15.0f * 150.0f);
                    if (dummyEntity.isHoveringInAir()) {
                        if (isVertical) {
                            dummyEntity.lastVerticalSpinSpeed = spinSpeed = Math.max(spinSpeed, 800.0f);
                        }
                    } else if (isVertical) {
                        dummyEntity.lastVerticalSpinSpeed = spinSpeed = Math.max(spinSpeed, 60.0f);
                    }
                    if (!Minecraft.m_91087_().m_91104_()) {
                        if (!dummyEntity.hasForwardMotion) {
                            spinSpeed = -spinSpeed;
                        }
                        renderable.visualRotation += this.rotation(spinSpeed, dummyEntity);
                    }
                }
                if (renderable.state.m_60713_((Block)XenoBlocks.BLOCK_TRACTOR_WHEEL.get()) || renderable.state.m_60713_((Block)XenoBlocks.BLOCK_SPORT_TIRE.get())) {
                    spinSpeed = 0.0f;
                    spinSpeed = (float)Math.min(0.0 + dummyEntity.currentHorizontalSpeed * 1950.0, 2000.0);
                    if (!Minecraft.m_91087_().m_91104_()) {
                        if (!dummyEntity.hasForwardMotion) {
                            spinSpeed = -spinSpeed;
                        }
                        renderable.visualRotation += this.rotation(spinSpeed, dummyEntity);
                    }
                }
                if (renderable.state.m_60713_((Block)XenoBlocks.BLOCK_COMBINE_HARVESTER.get())) {
                    spinSpeed = 0.0f;
                    spinSpeed = (float)Math.min(0.0 + dummyEntity.currentHorizontalSpeed * 1950.0, 400.0);
                    if (!Minecraft.m_91087_().m_91104_()) {
                        if (!dummyEntity.hasForwardMotion) {
                            spinSpeed = -spinSpeed;
                        }
                        renderable.visualRotation += -spinSpeed * (float)timeDiff / 1000.0f;
                    }
                }
                if (renderable.state.m_60734_() instanceof JetThrusterBlock) {
                    poseStack.m_85836_();
                    Direction facing = (Direction)renderable.state.m_61143_((Property)JetThrusterBlock.f_52588_);
                    float thrusterInsetDepth = 0.85f;
                    float jetTailGrowth = 2.03f;
                    float jetTailMax = 1.24f;
                    if (facing == Direction.UP) {
                        boolean up = facing == Direction.UP;
                        poseStack.m_85837_(0.5, 0.5, 0.5);
                        float verticalRot = 270.0f;
                        if (up) {
                            verticalRot = 90.0f;
                        }
                        poseStack.m_252781_(Axis.f_252403_.m_252977_(verticalRot));
                        lenVariance = 0.09f;
                        lenRand = 2.0f * lenVariance * (float)Math.random() - lenVariance;
                        renderable.visualRotation = (float)((double)renderable.visualRotation + (double)(lenRand * (float)timeDiff) / 15.0);
                        double horizontalSpeedPct = dummyEntity.currentHorizontalSpeed / (double)dummyEntity.moverStats.topSpeed;
                        double speedPct = dummyEntity.m_20184_().f_82480_ / (double)dummyEntity.liftMoverStats.topSpeed;
                        if (speedPct < 0.0) {
                            speedPct = 0.0;
                        }
                        if (dummyEntity.isHoveringInAir() && horizontalSpeedPct <= 0.2) {
                            if (speedPct < 0.38) {
                                speedPct = 0.38;
                            }
                        } else if (dummyEntity.isHoveringInAir()) {
                            if (horizontalSpeedPct <= 0.45) {
                                if (speedPct < 0.35) {
                                    speedPct = 0.35;
                                }
                            } else if (speedPct < 0.32) {
                                speedPct = 0.32;
                            }
                        }
                        float fSpeedPct = (float)speedPct;
                        float lenScaleMin = 0.0f;
                        float lenScaleMax = 0.4f;
                        if (renderable.visualRotation < lenScaleMin) {
                            renderable.visualRotation = lenScaleMin;
                        } else if (renderable.visualRotation > lenScaleMax) {
                            renderable.visualRotation = lenScaleMax;
                        }
                        float widthRand = renderable.visualRotation * fSpeedPct * 0.09f;
                        float lengthScale = Math.min(jetTailGrowth * fSpeedPct, jetTailMax);
                        float lengthRand = renderable.visualRotation * fSpeedPct;
                        float computedYScale = lengthScale + lengthRand;
                        float baseWidth = 0.43f;
                        float computedWidth = baseWidth + widthRand;
                        poseStack.m_85837_(0.5, 0.0, 0.0);
                        poseStack.m_85841_(computedYScale, computedWidth, computedWidth);
                        poseStack.m_85837_(-0.5, 0.0, 0.0);
                        poseStack.m_85837_(-0.5, -0.5, -0.5);
                        poseStack.m_85837_((double)(-thrusterInsetDepth / computedYScale), 0.0, 0.0);
                        currentSpeedPercent = fSpeedPct;
                        this.renderEmissiveLayer(poseStack, mbs, RenderType.m_234338_((ResourceLocation)JET_TEXTURE), 1.0f, 1.0f, 1.0f, 1.0f);
                    } else {
                        float startingAngle = dummyEntity.getSanitizedStartingAngle();
                        float jetRot = 0.0f;
                        if (startingAngle == 0.0f) {
                            jetRot = 270.0f;
                        } else if (startingAngle == 90.0f) {
                            jetRot = 180.0f;
                        } else if (startingAngle == 180.0f) {
                            jetRot = 90.0f;
                        } else if (startingAngle == 270.0f) {
                            jetRot = 0.0f;
                        }
                        poseStack.m_85837_(0.5, 0.5, 0.5);
                        if (jetRot != 0.0f) {
                            poseStack.m_252781_(Axis.f_252436_.m_252977_(jetRot));
                        }
                        poseStack.m_85837_(-0.5, -0.5, -0.5);
                        poseStack.m_85837_(1.0, 0.5, 0.5);
                        lenVariance = 0.09f;
                        lenRand = 2.0f * lenVariance * (float)Math.random() - lenVariance;
                        renderable.visualRotation = (float)((double)renderable.visualRotation + (double)(lenRand * (float)timeDiff) / 15.0);
                        double speedPct = dummyEntity.currentHorizontalSpeed / (double)dummyEntity.moverStats.topSpeed;
                        if (speedPct < 0.0) {
                            speedPct = 0.0;
                        }
                        float fSpeedPct = (float)speedPct;
                        float lenScaleMin = 0.0f;
                        float lenScaleMax = 0.4f;
                        if (renderable.visualRotation < lenScaleMin) {
                            renderable.visualRotation = lenScaleMin;
                        } else if (renderable.visualRotation > lenScaleMax) {
                            renderable.visualRotation = lenScaleMax;
                        }
                        float widthRand = renderable.visualRotation * fSpeedPct * 0.09f;
                        float lengthScale = Math.min(jetTailGrowth * fSpeedPct, jetTailMax);
                        float lengthRand = renderable.visualRotation * fSpeedPct;
                        float computedZScale = lengthScale + lengthRand;
                        float baseWidth = 0.43f;
                        float computedWidth = baseWidth + widthRand;
                        poseStack.m_85841_(computedZScale, computedWidth, computedWidth);
                        poseStack.m_85837_(-1.0, -0.5, -0.5);
                        poseStack.m_85837_((double)(-thrusterInsetDepth / computedZScale), 0.0, 0.0);
                        currentSpeedPercent = fSpeedPct;
                        float rMin = 1.0f;
                        float gMin = 1.0f;
                        float bMin = 0.0f;
                        float rMax = 0.6f;
                        float gMax = 0.6f;
                        float bMax = 1.0f;
                        float fSpeedPctInv = 1.0f - fSpeedPct;
                        float r = rMin * fSpeedPctInv + rMax * fSpeedPct;
                        float g = gMin * fSpeedPctInv + gMax * fSpeedPct;
                        float b = bMin * fSpeedPctInv + bMax * fSpeedPct;
                        this.renderEmissiveLayer(poseStack, mbs, RenderType.m_234338_((ResourceLocation)JET_TEXTURE), 1.0f, 1.0f, 1.0f, 1.0f);
                    }
                    poseStack.m_85849_();
                }
                if (this.isHelicopterRotorBlock(renderable)) {
                    poseStack.m_85837_(0.5, 0.5, 0.5);
                    poseStack.m_252781_(Axis.f_252436_.m_252977_(renderable.visualRotation));
                    poseStack.m_85837_(-0.5, -0.5, -0.5);
                    float heliMax = 900.0f;
                    float spinSpeed2 = (float)Math.min(40.0 + dummyEntity.m_20184_().f_82480_ * 4000.0, (double)heliMax) + (dummyEntity.isHoveringInAir() ? 0.0f : (float)dummyEntity.ascendingTicks / 15.0f * 200.0f);
                    dummyEntity.lastVerticalSpinSpeed = dummyEntity.isHoveringInAir() ? (spinSpeed2 = Math.max(spinSpeed2, heliMax)) : (spinSpeed2 = Math.max(spinSpeed2, 30.0f));
                    if (!Minecraft.m_91087_().m_91104_()) {
                        renderable.visualRotation += this.rotation(spinSpeed2, dummyEntity);
                    }
                }
                if (useBatchRender) {
                    if (this.isCustomRendered(renderable)) {
                        this.doCustomRender(dummyEntity, poseStack, mbs, partialTick, renderable);
                    } else if (batchRenderSyncGlass) {
                        BakedModel model = Minecraft.m_91087_().m_91289_().m_110910_(renderable.state);
                        ModelData modelData = model.getModelData((BlockAndTintGetter)dummyEntity.m_9236_(), dummyEntity.m_20183_(), renderable.state, ModelData.EMPTY);
                        for (RenderType rendertype2 : model.getRenderTypes(renderable.state, dummyEntity.f_19796_, modelData)) {
                            if (rendertype2 != RenderType.m_110466_()) continue;
                            if (useBlockLightingForShip) {
                                combinedLight = this.getCombinedLight(dummyEntity, renderable);
                            }
                            Minecraft.m_91087_().m_91289_().renderSingleBlock(renderable.state, poseStack, mbs, combinedLight, OverlayTexture.f_118083_, ModelData.EMPTY, null);
                            break;
                        }
                    }
                } else {
                    if (this.isCustomRendered(renderable)) {
                        this.doCustomRender(dummyEntity, poseStack, mbs, partialTick, renderable);
                    }
                    if (renderable.state.m_60799_() != RenderShape.ENTITYBLOCK_ANIMATED && !DummyRenderer.isHiddenTerminal(dummyEntity, renderable)) {
                        ModelData modelData = ModelData.EMPTY;
                        if (renderable.tempBlockEntity != null) {
                            modelData = renderable.tempBlockEntity.getModelData();
                        }
                        if (useBlockLightingForShip) {
                            combinedLight = this.getCombinedLight(dummyEntity, renderable);
                        }
                        Minecraft.m_91087_().m_91289_().renderSingleBlock(renderable.state, poseStack, mbs, combinedLight, OverlayTexture.f_118083_, modelData, null);
                    }
                }
                poseStack.m_85849_();
            }
            if (useBatchRender) {
                if (dummyEntity.renderFuture == null) {
                    if (dummyEntity.buffers == null) {
                        dummyEntity.buffers = RenderType.m_110506_().stream().filter(renderType -> true).collect(Collectors.toMap(renderType -> renderType, p_286178_ -> new VertexBuffer(VertexBuffer.Usage.STATIC)));
                    }
                    if (batchRenderAsync) {
                        dummyEntity.renderFuture = ((CompletableFuture)CompletableFuture.supplyAsync(Util.m_183946_((String)"CompileDummy", () -> this.doBatchRender(dummyEntity, DummyRenderer.bufferBuilderPack(dummyEntity))), this.executor).thenCompose(future -> future)).whenComplete((result, throwable) -> {
                            if (result == Boolean.FALSE) {
                                LOGGER.error("Error during batch render, discarding buffers");
                                DummyRenderer.bufferBuilderPack(dummyEntity).m_108841_();
                                dummyEntity.cachedRenders = null;
                                dummyEntity.renderFuture = null;
                            }
                        });
                    } else {
                        this.doBatchRender(dummyEntity, DummyRenderer.bufferBuilderPack(dummyEntity));
                    }
                }
                if (dummyEntity.cachedRenders != null) {
                    boolean didUpload;
                    RenderType translucent;
                    BufferBuilder.RenderedBuffer translucentBuffer;
                    int initialUploadedSize = dummyEntity.uploadedBuffers.size();
                    dummyEntity.cachedRenders.forEach((renderType, renderedBuffer) -> {
                        if (renderType != RenderType.m_110466_() && !dummyEntity.uploadedBuffers.contains(renderType)) {
                            this.uploadRenderToVertexBuffer(dummyEntity, (RenderType)renderType, (BufferBuilder.RenderedBuffer)renderedBuffer);
                        }
                    });
                    if (!batchRenderSyncGlass && (translucentBuffer = dummyEntity.cachedRenders.get(translucent = RenderType.m_110466_())) != null && !dummyEntity.uploadedBuffers.contains(translucent)) {
                        this.uploadRenderToVertexBuffer(dummyEntity, translucent, translucentBuffer);
                    }
                    boolean bl = didUpload = dummyEntity.uploadedBuffers.size() > initialUploadedSize;
                    if (didUpload) {
                        DummyRenderer.bufferBuilderPack(dummyEntity).m_108838_();
                    }
                    dummyEntity.cachedRenders = null;
                    dummyEntity.renderFuture = null;
                }
                if (dummyEntity.buffers != null) {
                    boolean didDraw = true;
                    ShaderInstance oldShader = RenderSystem.getShader();
                    RenderType drawRenderType = null;
                    VertexBuffer vertexBuffer = null;
                    drawRenderType = RenderType.m_110451_();
                    vertexBuffer = dummyEntity.buffers.get(drawRenderType);
                    this.drawFromBuffer(dummyEntity, poseStack, drawRenderType, vertexBuffer);
                    drawRenderType = RenderType.m_110457_();
                    vertexBuffer = dummyEntity.buffers.get(drawRenderType);
                    this.drawFromBuffer(dummyEntity, poseStack, drawRenderType, vertexBuffer);
                    drawRenderType = RenderType.m_110463_();
                    vertexBuffer = dummyEntity.buffers.get(drawRenderType);
                    this.drawFromBuffer(dummyEntity, poseStack, drawRenderType, vertexBuffer);
                    drawRenderType = RenderType.m_110466_();
                    vertexBuffer = dummyEntity.buffers.get(drawRenderType);
                    this.drawFromBuffer(dummyEntity, poseStack, drawRenderType, vertexBuffer);
                    drawRenderType = RenderType.m_110503_();
                    vertexBuffer = dummyEntity.buffers.get(drawRenderType);
                    this.drawFromBuffer(dummyEntity, poseStack, drawRenderType, vertexBuffer);
                    if (didDraw) {
                        VertexBuffer.m_85931_();
                        RenderSystem.setShader(() -> oldShader);
                        oldShader.m_173363_();
                    }
                }
            }
            poseStack.m_85849_();
        }
        if (dummyEntity.renderables.isEmpty()) {
            if (dummyEntity.getStoredEntityCopy() != null) {
                EntityRenderer renderer = (EntityRenderer)Minecraft.m_91087_().m_91290_().f_114362_.get(dummyEntity.getStoredEntityCopy().m_6095_());
                dummyEntity.storedEntityRenderer = renderer;
            }
            if (dummyEntity.storedEntityRenderer != null && dummyEntity.storedEntityRenderer instanceof DummyRenderer) {
                dummyEntity.storedEntityRenderer = null;
            }
            rendererLast = (EntityRenderer)dummyEntity.storedEntityRenderer;
            lastEntity = dummyEntity.getStoredEntityCopy();
            if (dummyEntity.storedEntityRenderer != null) {
                float scaledSize = dummyEntity.renderSize;
                if (scaledSize > 1.0f) {
                    scaledSize = 1.0f;
                }
                poseStack.m_85841_(scaledSize, scaledSize, scaledSize);
                if (dummyEntity.renderSize >= 0.0f) {
                    isDummyRender = true;
                    if (dummyEntity.storedEntityRenderer != null && dummyEntity.getStoredEntityCopy() != null) {
                        try {
                            ((EntityRenderer)dummyEntity.storedEntityRenderer).m_7392_(dummyEntity.getStoredEntityCopy(), yRot, partialTick, poseStack, mbs, combinedLight);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    isDummyRender = false;
                    if (!Minecraft.m_91087_().m_91104_()) {
                        dummyEntity.renderSize -= (float)timeDiff / 1000.0f * 0.5f;
                    }
                }
            }
        }
        dummyEntity.lastRenderTimestamp = timestamp;
        super.m_7392_((Entity)dummyEntity, yRot, partialTick, poseStack, mbs, combinedLight);
    }

    private int getCombinedLight(DummyEntity dummyEntity, RenderableBlock renderable) {
        BlockPos renderablePos = BlockPos.m_274446_((Position)dummyEntity.m_20182_().m_82520_(renderable.relativeX, renderable.relativeY, renderable.relativeZ));
        int blockLight = this.m_6086_(dummyEntity, renderablePos);
        int skyLight = this.m_114508_(dummyEntity, renderablePos);
        if (renderable.blockLight != -1 && renderable.skyLight != -1) {
            if (renderable.blockLight > blockLight) {
                blockLight = renderable.blockLight;
            }
            if (renderable.skyLight < skyLight) {
                skyLight = renderable.skyLight;
            }
        }
        int combinedLight = LightTexture.m_109885_((int)blockLight, (int)skyLight);
        return combinedLight;
    }

    private boolean isHelicopterRotorBlock(RenderableBlock renderable) {
        return renderable.state.m_60713_((Block)XenoBlocks.BLOCK_HELICOPTER_ROTOR.get()) || renderable.state.m_60713_((Block)XenoBlocks.BLOCK_FLAGSHIP_HELICOPTER_ROTOR.get());
    }

    public static void doTurnRotation(DummyEntity dummyEntity, PoseStack poseStack) {
        float yRotRequest = dummyEntity.getYRotRequest();
        float yRotRequestPct = Mth.m_14154_((float)(yRotRequest / 45.0f));
        if (yRotRequestPct > 1.0f) {
            yRotRequestPct = 1.0f;
        }
        Axis turnAxis = Axis.f_252529_;
        if (dummyEntity.getSanitizedStartingAngle() % 180.0f == 0.0f) {
            turnAxis = Axis.f_252403_;
            if (dummyEntity.getSanitizedStartingAngle() == 0.0f) {
                yRotRequest = -yRotRequest;
            }
        } else if (dummyEntity.getSanitizedStartingAngle() == 270.0f) {
            yRotRequest = -yRotRequest;
        }
        float flyerTurnValue = 1.0f;
        if (dummyEntity.m_6109_()) {
            flyerTurnValue = dummyEntity.getAbsPlayerFlyerTurnValue();
        } else if (yRotRequestPct == 0.0f) {
            yRotRequest = 1.0f;
            float yRotDiff = dummyEntity.observedYRotAccumulator;
            yRotRequestPct = yRotDiff * 0.15f;
        }
        if (dummyEntity.isFreeFlightMode()) {
            flyerTurnValue *= 2.0f;
        }
        if ((double)yRotRequest > 0.0) {
            poseStack.m_252781_(turnAxis.m_252977_(yRotRequestPct * -5.0f * flyerTurnValue));
        } else if ((double)yRotRequest < 0.0) {
            poseStack.m_252781_(turnAxis.m_252977_(yRotRequestPct * 5.0f * flyerTurnValue));
        }
    }

    public static void doStrafeRotation(DummyEntity dummyEntity, PoseStack poseStack) {
        float strafeZpModifier = 1.2f;
        float strafePct = dummyEntity.getAbsStrafeSpeed() / dummyEntity.getStrafeSpeedMax();
        if (dummyEntity.strafeLeft && dummyEntity.strafeRight) {
            return;
        }
        float strafeSpeed = dummyEntity.getStrafeSpeed();
        Axis turnAxis = Axis.f_252529_;
        if (dummyEntity.getSanitizedStartingAngle() % 180.0f == 0.0f) {
            turnAxis = Axis.f_252403_;
            if (dummyEntity.getSanitizedStartingAngle() == 0.0f) {
                strafeSpeed = -strafeSpeed;
            }
        } else if (dummyEntity.getSanitizedStartingAngle() == 270.0f) {
            strafeSpeed = -strafeSpeed;
        }
        if (strafeSpeed > 0.0f) {
            poseStack.m_252781_(turnAxis.m_252977_(strafePct * -5.0f * 1.2f));
        } else if (strafeSpeed < 0.0f) {
            poseStack.m_252781_(turnAxis.m_252977_(strafePct * 5.0f * 1.2f));
        }
    }

    private void doCustomRender(DummyEntity dummy, PoseStack poseStack, MultiBufferSource mbs, float partialTick, RenderableBlock renderable) {
        try {
            double xOffset = 0.0;
            double yOffset = 0.0;
            double zOffset = 0.0;
            Minecraft.m_91087_().m_167982_().m_112267_(renderable.tempBlockEntity, partialTick, poseStack, mbs);
        }
        catch (Exception ex) {
            LOGGER.error("Error rendering block entity with custom renderer: " + renderable.state + "/" + renderable.tempBlockEntity, (Throwable)ex);
        }
    }

    private boolean isCustomRendered(RenderableBlock renderable) {
        return renderable.tempBlockEntity != null && Minecraft.m_91087_().m_167982_().m_112265_(renderable.tempBlockEntity) != null;
    }

    private void renderEmissiveLayer(PoseStack poseStack, MultiBufferSource mbs, RenderType renderType, float r, float g, float b, float a) {
        VertexConsumer vertexconsumer = mbs.m_6299_(renderType);
        this.crossModel.m_7695_(poseStack, vertexconsumer, 0xF000F0, OverlayTexture.f_118083_, r, g, b, a);
    }

    private float rotation(float spinSpeed, DummyEntity dummyEntity) {
        long timestamp = System.currentTimeMillis();
        if (dummyEntity.lastRenderTimestamp == 0L) {
            dummyEntity.lastRenderTimestamp = timestamp;
        }
        long timeDiff = timestamp - dummyEntity.lastRenderTimestamp;
        return spinSpeed * (float)timeDiff / 1000.0f;
    }

    private void drawFromBuffer(DummyEntity dummyEntity, PoseStack poseStack, RenderType renderType, VertexBuffer vertexBuffer) {
        if (vertexBuffer != null && dummyEntity.uploadedBuffers.contains(renderType) && !vertexBuffer.m_231230_()) {
            if (batchRenderGlassAsCutout && renderType == RenderType.m_110466_()) {
                renderType = RenderType.m_110463_();
            }
            renderType.m_110185_();
            vertexBuffer.m_85921_();
            vertexBuffer.m_253207_(poseStack.m_85850_().m_252922_(), RenderSystem.getProjectionMatrix(), RenderSystem.getShader());
            renderType.m_110188_();
        }
    }

    private void uploadRenderToVertexBuffer(DummyEntity dummyEntity, RenderType renderType, BufferBuilder.RenderedBuffer renderedBuffer) {
        VertexBuffer buffer = dummyEntity.buffers.get(renderType);
        if (buffer != null && !buffer.m_231230_() && !renderedBuffer.f_231191_) {
            buffer.m_85921_();
            buffer.m_231221_(renderedBuffer);
            VertexBuffer.m_85931_();
            dummyEntity.uploadedBuffers.add(renderType);
        }
    }

    private void updateLocationForUniform(ShaderInstance shader, Uniform uniform) {
        int k = Uniform.m_85624_((int)shader.m_108943_(), (CharSequence)uniform.m_85599_());
        if (k == -1) {
            LOGGER.warn("Shader {} could not find uniform named {} in the specified shader program.", (Object)shader.m_173365_(), (Object)uniform.m_85599_());
            return;
        }
        uniform.m_85614_(k);
    }

    private boolean doAnimatedBlockRotations(DummyEntity dummy, RenderableBlock renderable, PoseStack poseStack) {
        boolean isVertical = false;
        if (this.isPropellerBlock(renderable)) {
            poseStack.m_85837_(0.5, 0.5, 0.5);
            if (renderable.state.m_61143_((Property)PropellerBlock.f_52588_) == Direction.NORTH) {
                poseStack.m_252781_(Axis.f_252403_.m_252977_(renderable.visualRotation));
            } else if (renderable.state.m_61143_((Property)PropellerBlock.f_52588_) == Direction.EAST) {
                poseStack.m_252781_(Axis.f_252529_.m_252977_(renderable.visualRotation));
            } else if (renderable.state.m_61143_((Property)PropellerBlock.f_52588_) == Direction.SOUTH) {
                poseStack.m_252781_(Axis.f_252393_.m_252977_(renderable.visualRotation));
            } else if (renderable.state.m_61143_((Property)PropellerBlock.f_52588_) == Direction.WEST) {
                poseStack.m_252781_(Axis.f_252495_.m_252977_(renderable.visualRotation));
            } else if (renderable.state.m_61143_((Property)PropellerBlock.f_52588_) == Direction.UP) {
                isVertical = true;
                poseStack.m_252781_(Axis.f_252392_.m_252977_(renderable.visualRotation));
            }
            poseStack.m_85837_(-0.5, -0.5, -0.5);
        } else if (renderable.state.m_60713_((Block)XenoBlocks.BLOCK_TRACTOR_WHEEL.get()) || renderable.state.m_60713_((Block)XenoBlocks.BLOCK_SPORT_TIRE.get())) {
            poseStack.m_85837_(0.5, 0.5, 0.5);
            if (renderable.state.m_61143_((Property)TractorWheelBlock.f_54117_) == Direction.NORTH) {
                poseStack.m_252781_(Axis.f_252495_.m_252977_(renderable.visualRotation));
            } else if (renderable.state.m_61143_((Property)TractorWheelBlock.f_54117_) == Direction.EAST) {
                poseStack.m_252781_(Axis.f_252393_.m_252977_(renderable.visualRotation));
            } else if (renderable.state.m_61143_((Property)TractorWheelBlock.f_54117_) == Direction.SOUTH) {
                poseStack.m_252781_(Axis.f_252529_.m_252977_(renderable.visualRotation));
            } else if (renderable.state.m_61143_((Property)TractorWheelBlock.f_54117_) == Direction.WEST) {
                poseStack.m_252781_(Axis.f_252403_.m_252977_(renderable.visualRotation));
            }
            poseStack.m_85837_(-0.5, -0.5, -0.5);
        } else if (renderable.state.m_60713_((Block)XenoBlocks.BLOCK_COMBINE_HARVESTER.get())) {
            poseStack.m_85837_(0.5, 0.5, 0.5);
            if (renderable.state.m_61143_((Property)CombineHarvesterBlock.f_54117_) == Direction.NORTH) {
                poseStack.m_252781_(Axis.f_252529_.m_252977_(renderable.visualRotation));
            } else if (renderable.state.m_61143_((Property)CombineHarvesterBlock.f_54117_) == Direction.EAST) {
                poseStack.m_252781_(Axis.f_252403_.m_252977_(renderable.visualRotation));
            } else if (renderable.state.m_61143_((Property)CombineHarvesterBlock.f_54117_) == Direction.SOUTH) {
                poseStack.m_252781_(Axis.f_252529_.m_252977_(renderable.visualRotation));
            } else if (renderable.state.m_61143_((Property)CombineHarvesterBlock.f_54117_) == Direction.WEST) {
                poseStack.m_252781_(Axis.f_252403_.m_252977_(renderable.visualRotation));
            }
            poseStack.m_85837_(-0.5, -0.5, -0.5);
        } else if (renderable.state.m_60713_((Block)XenoBlocks.BLOCK_PRECISION_DRILL.get()) || renderable.state.m_60713_((Block)XenoBlocks.BLOCK_MINING_DRILL.get())) {
            BlockEntity blockEntity = renderable.tempBlockEntity;
            if (blockEntity instanceof BaseDrillBlockEntity) {
                BaseDrillBlockEntity drill = (BaseDrillBlockEntity)blockEntity;
                if (drill.active) {
                    float maxSpinSpeed;
                    float spinSpeed = maxSpinSpeed = 900.0f;
                    if (drill.deactivationTicks > 0) {
                        spinSpeed = (float)drill.deactivationTicks / 40.0f * maxSpinSpeed * 1.0f;
                    }
                    renderable.visualRotation += this.rotation(spinSpeed, dummy);
                }
            }
            poseStack.m_85837_(0.5, 0.5, 0.5);
            if (renderable.state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == Direction.NORTH) {
                poseStack.m_252781_(Axis.f_252403_.m_252977_(renderable.visualRotation));
            } else if (renderable.state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == Direction.EAST) {
                poseStack.m_252781_(Axis.f_252529_.m_252977_(renderable.visualRotation));
            } else if (renderable.state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == Direction.SOUTH) {
                poseStack.m_252781_(Axis.f_252393_.m_252977_(renderable.visualRotation));
            } else if (renderable.state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == Direction.WEST) {
                poseStack.m_252781_(Axis.f_252495_.m_252977_(renderable.visualRotation));
            } else if (renderable.state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_) == Direction.UP) {
                isVertical = true;
                poseStack.m_252781_(Axis.f_252392_.m_252977_(renderable.visualRotation));
            }
            poseStack.m_85837_(-0.5, -0.5, -0.5);
        } else if (renderable.state.m_60713_((Block)XenoBlocks.BLOCK_BUZZSAW.get()) && this.buzzsawSpinsWhileMoving) {
            if (dummy.currentHorizontalSpeed >= 0.015) {
                if (!((Boolean)renderable.state.m_61143_((Property)BuzzsawBlock.ACTIVE)).booleanValue()) {
                    renderable.state = (BlockState)renderable.state.m_61124_((Property)BuzzsawBlock.ACTIVE, (Comparable)Boolean.valueOf(true));
                }
            } else if (((Boolean)renderable.state.m_61143_((Property)BuzzsawBlock.ACTIVE)).booleanValue()) {
                renderable.state = (BlockState)renderable.state.m_61124_((Property)BuzzsawBlock.ACTIVE, (Comparable)Boolean.valueOf(false));
            }
        }
        return isVertical;
    }

    private boolean isPropellerBlock(RenderableBlock renderable) {
        return renderable.state.m_60713_((Block)XenoBlocks.BLOCK_PROPELLER.get()) || renderable.state.m_60713_((Block)XenoBlocks.BLOCK_HEAVY_DUTY_PROPELLER.get()) || renderable.state.m_60713_((Block)XenoBlocks.BLOCK_FLAGSHIP_PROPELLER.get());
    }

    public ResourceLocation getTextureLocation(DummyEntity dummyEntity) {
        if (dummyEntity.storedEntityRenderer != null) {
            return ((EntityRenderer)dummyEntity.storedEntityRenderer).m_5478_(dummyEntity.getStoredEntityCopy());
        }
        return null;
    }

    static class RenderableLightLevel
    implements BlockAndTintGetter {
        private BlockAndTintGetter level;
        public RenderableBlock renderable = null;

        public RenderableLightLevel(BlockAndTintGetter level) {
            this.level = level;
        }

        public int m_45517_(LightLayer lightLayer, BlockPos blockPos) {
            int levelLight = lightLayer == LightLayer.BLOCK ? 0 : 15;
            RenderableBlock renderableLookup = null;
            if (this.renderable != null && this.renderable.blockLight != -1 && this.renderable.skyLight != -1) {
                DummyEntity dummy = (DummyEntity)this.renderable.parent;
                if (dummy.f_19797_ < 3) {
                    return levelLight;
                }
                if (!dummy.renderableLookup.isEmpty()) {
                    List<BlockPos> toCheck = List.of(blockPos.m_7495_(), blockPos.m_7494_(), blockPos.m_122029_(), blockPos.m_122024_(), blockPos.m_122012_(), blockPos.m_122019_());
                    boolean first = true;
                    boolean adjustedLight = false;
                    for (BlockPos checkBlockPos : toCheck) {
                        renderableLookup = dummy.fixedInitialPosRenderableLookup.get(checkBlockPos);
                        if (renderableLookup == null || renderableLookup.blockLight == -1 || renderableLookup.skyLight == -1) continue;
                        adjustedLight = true;
                        if (first) {
                            int originalLevelLight;
                            first = false;
                            Vec3 realRotPos = XenoTechUtils.getRotPosForRenderable(dummy, renderableLookup);
                            BlockPos realBlockPos = XenoTechUtils.blockPosFromRotPos(realRotPos);
                            levelLight = originalLevelLight = this.level.m_45517_(lightLayer, realBlockPos);
                        }
                        int renderableLight = this.getLightLevelForRenderable(lightLayer, levelLight, renderableLookup);
                        if (lightLayer == LightLayer.BLOCK && renderableLight > levelLight) {
                            levelLight = renderableLight;
                            continue;
                        }
                        if (lightLayer != LightLayer.SKY || renderableLight >= levelLight) continue;
                        levelLight = renderableLight;
                    }
                    if (adjustedLight) {
                        levelLight = lightLayer == LightLayer.BLOCK ? --levelLight : ++levelLight;
                    }
                    if (levelLight > 15) {
                        levelLight = 15;
                    } else if (levelLight < 0) {
                        levelLight = 0;
                    }
                }
            }
            return levelLight;
        }

        private int getLightLevelForRenderable(LightLayer lightLayer, int levelLight, RenderableBlock renderable) {
            if (renderable != null && renderable.blockLight != -1 && renderable.skyLight != -1) {
                if (lightLayer == LightLayer.BLOCK) {
                    if (renderable.blockLight > levelLight) {
                        levelLight = renderable.blockLight;
                    }
                } else if (lightLayer == LightLayer.SKY && renderable.skyLight < levelLight) {
                    levelLight = renderable.skyLight;
                }
            }
            return levelLight;
        }

        public int m_45524_(BlockPos blockPos, int skyDarken) {
            int levelRawLight = this.level.m_45524_(blockPos, skyDarken);
            return levelRawLight;
        }

        public BlockEntity m_7702_(BlockPos p_45570_) {
            return this.level.m_7702_(p_45570_);
        }

        public BlockState m_8055_(BlockPos blockPos) {
            return this.level.m_8055_(blockPos);
        }

        public FluidState m_6425_(BlockPos p_45569_) {
            return this.level.m_6425_(p_45569_);
        }

        public int m_141928_() {
            return this.level.m_141928_();
        }

        public int m_141937_() {
            return this.level.m_141937_();
        }

        public float m_7717_(Direction p_45522_, boolean p_45523_) {
            return this.level.m_7717_(p_45522_, p_45523_);
        }

        public LevelLightEngine m_5518_() {
            return this.level.m_5518_();
        }

        public int m_6171_(BlockPos p_45520_, ColorResolver p_45521_) {
            return this.level.m_6171_(p_45520_, p_45521_);
        }
    }
}

