/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.xenotech.entity;

import com.dairymoose.xenotech.world.level.block.entity.FluidShippingTankBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FluidShippingTankRenderer
implements BlockEntityRenderer<FluidShippingTankBlockEntity> {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final float HORZ_FACE_WIDTH_SCALE = 0.33f;
    public static final float VERT_FACE_WIDTH_SCALE = 0.33f;
    public static final float VERT_FACE_DEPTH_SCALE = 0.86f;
    public static final float VERT_FACE_ANTI_Z_FIGHTING_OFFSET = 0.004f;
    public static final float HORZ_FACE_INSET_DEPTH = 0.065f;
    public static final float TANK_BOTTOM_SIZE = 0.15f;
    public static final float TANK_TOP_SIZE = 0.15f;
    public static final float HORZ_FACE_HEIGHT = 0.7f;
    public static final int HORZ_FACE_COUNT = 8;
    public static final float HORZ_FACE_ROTATION_DEGREES = 45.0f;
    public static final int VERT_FACE_COUNT = 8;
    public static final float VERT_FACE_ROTATION_DEGREES = 45.0f;

    public FluidShippingTankRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    private void add(VertexConsumer builder, PoseStack stack, float x, float y, float z, float u, float v, int lightmap, float r, float g, float b, float a) {
        builder.m_252986_(stack.m_85850_().m_252922_(), x, y, z).m_85950_(r, g, b, a).m_7421_(u, v).m_85969_(lightmap).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
    }

    public void render(FluidShippingTankBlockEntity tank, float paramFloat, PoseStack poseStack, MultiBufferSource paramMultiBufferSource, int lightmap, int i1) {
        poseStack.m_85836_();
        if (tank != null && !tank.m_58901_() && !tank.getFluidInventory().getFluid().isEmpty()) {
            FluidStack fluid = tank.getFluidInventory().getFluid();
            if (fluid == null) {
                return;
            }
            Fluid renderFluid = fluid.getFluid();
            if (renderFluid == null) {
                return;
            }
            IClientFluidTypeExtensions ext = IClientFluidTypeExtensions.of((Fluid)tank.getFluidInventory().getFluid().getFluid());
            if (ext != null) {
                int i;
                ResourceLocation fluidStill = ext.getStillTexture(fluid);
                TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(fluidStill);
                VertexConsumer builder = paramMultiBufferSource.m_6299_(RenderType.m_110466_());
                float u0 = sprite.m_118409_();
                float v0 = sprite.m_118411_();
                float u1 = sprite.m_118410_();
                float v1 = sprite.m_118412_();
                int color = ext.getTintColor();
                float a = 1.0f;
                float r = (float)(color >> 16 & 0xFF) / 255.0f;
                float g = (float)(color >> 8 & 0xFF) / 255.0f;
                float b = (float)(color & 0xFF) / 255.0f;
                Minecraft.m_91087_().m_91097_().m_174784_(new ResourceLocation(fluidStill.m_135827_(), "textures/" + fluidStill.m_135815_() + ".png"));
                float fluidPct = (float)tank.getFluidInventory().getFluidAmount() / (float)tank.getFluidInventory().getCapacity();
                float rotation = 0.0f;
                for (i = 0; i < 8; ++i) {
                    this.renderVerticalFace(poseStack, lightmap, builder, u0, v0, u1, v1, a, r, g, b, fluidPct, rotation, true);
                    this.renderVerticalFace(poseStack, lightmap, builder, u0, v0, u1, v1, a, r, g, b, fluidPct, rotation, false);
                    rotation += 45.0f;
                }
                rotation = 0.0f;
                for (i = 0; i < 8; ++i) {
                    this.renderHorizontalFace(poseStack, lightmap, builder, u0, v0, u1, v1, a, r, g, b, fluidPct, rotation);
                    rotation += 45.0f;
                }
            }
        }
        poseStack.m_85849_();
    }

    private void renderVerticalFace(PoseStack poseStack, int lightmap, VertexConsumer builder, float u0, float v0, float u1, float v1, float a, float r, float g, float b, float fluidPct, float rotationDegrees, boolean top) {
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 0.5, 0.5);
        float verticalRot = 90.0f;
        if (top) {
            verticalRot = 270.0f;
        }
        poseStack.m_252781_(Axis.f_252529_.m_252977_(verticalRot));
        if (rotationDegrees != 0.0f) {
            poseStack.m_252781_(Axis.f_252403_.m_252977_(rotationDegrees));
        }
        if (top) {
            fluidPct = 1.0f - fluidPct;
            float scaledDepth = 0.15f + fluidPct * 0.7f;
            poseStack.m_85837_(0.0, 0.0, (double)(-scaledDepth));
        } else {
            poseStack.m_85837_(0.0, 0.0, (double)-0.15f);
        }
        poseStack.m_85837_(0.0, 0.0, (double)(-0.004f * (rotationDegrees / 45.0f)));
        poseStack.m_85841_(0.33f, 0.86f, 1.0f);
        poseStack.m_85837_(-0.5, -0.5, -0.5);
        this.renderQuadFace(poseStack, lightmap, builder, u0, v0, u1, v1, a, r, g, b);
        poseStack.m_85849_();
    }

    private void renderHorizontalFace(PoseStack poseStack, int lightmap, VertexConsumer builder, float u0, float v0, float u1, float v1, float a, float r, float g, float b, float fluidPct, float rotationDegrees) {
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 0.0, 0.5);
        if (rotationDegrees != 0.0f) {
            poseStack.m_252781_(Axis.f_252436_.m_252977_(rotationDegrees));
        }
        poseStack.m_85837_(0.0, (double)0.15f, 0.0);
        poseStack.m_85837_(0.0, 0.0, (double)-0.065f);
        float scaledHeight = fluidPct * 0.7f;
        poseStack.m_85841_(0.33f, scaledHeight, 1.0f);
        poseStack.m_85837_(-0.5, 0.0, -0.5);
        this.renderQuadFace(poseStack, lightmap, builder, u0, v0, u1, v1, a, r, g, b);
        poseStack.m_85849_();
    }

    private void renderQuadFace(PoseStack poseStack, int lightmap, VertexConsumer builder, float u0, float v0, float u1, float v1, float a, float r, float g, float b) {
        this.add(builder, poseStack, 1.0f, 1.0f, 1.0f, u0, v0, lightmap, r, g, b, a);
        this.add(builder, poseStack, 0.0f, 1.0f, 1.0f, u1, v0, lightmap, r, g, b, a);
        this.add(builder, poseStack, 0.0f, 0.0f, 1.0f, u1, v1, lightmap, r, g, b, a);
        this.add(builder, poseStack, 1.0f, 0.0f, 1.0f, u0, v1, lightmap, r, g, b, a);
    }
}

