/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.xenotech.entity;

import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Kinematics {
    private static final Logger LOGGER = LogManager.getLogger();

    static double distFromVelocity(double vInitial, double vFinal, double t) {
        return 0.5 * (vInitial + vFinal) * t;
    }

    static double dist(double vInitial, double t, double a) {
        return vInitial * t + 0.5 * a * t * t;
    }

    static double time(double d, double a) {
        return Math.sqrt(2.0 * d / a);
    }

    static double vFinal(double vInitial, double a, double t) {
        return vInitial + a * t;
    }

    static double time(double vInitial, double vFinal, double a) {
        return (vFinal - vInitial) / a;
    }

    static double vAvg(double vInitial, double vFinal) {
        return (vInitial + vFinal) / 2.0;
    }

    static double vFinalFromAvg(double vAvg, double vInitial) {
        return vAvg * 2.0 - vInitial;
    }

    static double timeToReachLocation(Vec3 start, Vec3 end, double velocityBpt) {
        double dist = start.m_82554_(end);
        double currentSpeedBps = velocityBpt * 20.0;
        return dist / currentSpeedBps;
    }

    static int timeToReachLocationInTicks(Vec3 start, Vec3 end, double velocityBpt) {
        double t = Kinematics.timeToReachLocation(start, end, velocityBpt);
        return (int)Math.round(t * 20.0);
    }

    static double timeRequiredToStop(double velocityBpt, double accelPerTick, double decelPowerMult) {
        double brakeAccelPerTick = -accelPerTick * decelPowerMult;
        return Kinematics.time(velocityBpt, 0.0, brakeAccelPerTick);
    }

    static double timeRequiredToStopInSeconds(double velocityBpt, double accelPerTick, double decelPowerMult) {
        double velocityBps = velocityBpt * 20.0;
        double brakeAccelPerTick = -accelPerTick * decelPowerMult;
        double brakeAccelPerSec = brakeAccelPerTick * 20.0 * 20.0;
        return Kinematics.time(velocityBps, 0.0, brakeAccelPerSec);
    }

    static int timeRequiredToStopInTicks(double velocityBpt, double accelPerTick, double decelPowerMult) {
        double t = Kinematics.timeRequiredToStopInSeconds(velocityBpt, accelPerTick, decelPowerMult);
        return (int)Math.round(t * 20.0);
    }

    public static MovementInfo computeMovements(double targetDist, double maxSpeed, double accel, double decelPowerMult) {
        double accelBps = accel;
        double decelPower = decelPowerMult;
        double decelBps = accelBps * decelPower;
        double acelTimePct = decelBps / (accelBps + decelBps);
        double decelTimePct = accelBps / (accelBps + decelBps);
        double accelTargetDist = targetDist * acelTimePct;
        double decelTargetDist = targetDist * decelTimePct;
        double t1 = Kinematics.time(accelTargetDist, accelBps);
        double t2 = Kinematics.time(decelTargetDist, decelBps);
        double vf = Kinematics.vFinal(0.0, accelBps, t1);
        if (vf <= maxSpeed) {
            MovementInfo mi = new MovementInfo();
            mi.wouldReachMaxSpeed = false;
            mi.forwardTime = t1;
            mi.brakeTime = t2;
            mi.computeTicks();
            return mi;
        }
        LOGGER.debug("Reached max speed while accelerating");
        double timeToReachMaxSpeed = Kinematics.time(0.0, maxSpeed, accelBps);
        double distanceCoveredReachingMaxSpeed = Kinematics.dist(0.0, timeToReachMaxSpeed, accelBps);
        double timeToBrakeFromMaxSpeed = Kinematics.time(maxSpeed, 0.0, -decelBps);
        double distanceCoveredBrakingFromMaxSpeed = Kinematics.dist(maxSpeed, timeToBrakeFromMaxSpeed, -decelBps);
        double cruiseDist = targetDist - distanceCoveredReachingMaxSpeed - distanceCoveredBrakingFromMaxSpeed;
        double cruiseTime = cruiseDist / maxSpeed;
        LOGGER.debug("timeToReachMaxSpeed=" + timeToReachMaxSpeed + ", timeToBrakeFromMaxSpeed=" + timeToBrakeFromMaxSpeed);
        LOGGER.debug("distanceCoveredReachingMaxSpeed=" + distanceCoveredReachingMaxSpeed + ", distanceCoveredBrakingFromMaxSpeed=" + distanceCoveredBrakingFromMaxSpeed);
        LOGGER.debug("cruiseDist=" + cruiseDist);
        MovementInfo mi = new MovementInfo();
        mi.wouldReachMaxSpeed = true;
        mi.forwardTime = timeToReachMaxSpeed + cruiseTime;
        mi.brakeTime = timeToBrakeFromMaxSpeed;
        mi.computeTicks();
        return mi;
    }

    public static double travelDistanceFwd(double forwardTime, double maxSpeed, double accel) {
        double timeToReachMaxSpeed = Kinematics.time(0.0, maxSpeed, accel);
        if (forwardTime > timeToReachMaxSpeed) {
            double distanceCoveredReachingMaxSpeed = Kinematics.dist(0.0, timeToReachMaxSpeed, accel);
            double remainingTime = forwardTime - timeToReachMaxSpeed;
            return distanceCoveredReachingMaxSpeed + maxSpeed * remainingTime;
        }
        return Kinematics.dist(0.0, forwardTime, accel);
    }

    public static double travelDistanceBrake(double vInitial, double brakeTime, double accel) {
        return Kinematics.dist(vInitial, brakeTime, accel);
    }

    public static void main(String[] args) {
        double absDiffMax = 0.0;
        double maxSpeed = 4.0;
        double accel = 0.3f;
        double decelMult = 2.0;
        double decel = -accel * 2.0;
        int bMin = 1;
        int bMax = 4;
        for (int i = bMin; i <= bMax; ++i) {
            double dist = 1.0f * (float)i;
            MovementInfo mi = Kinematics.computeMovements(dist, maxSpeed, accel, decelMult);
            LOGGER.debug("Dist=" + dist + ", forward=" + mi.forwardTime + "/" + mi.forwardTicks + ", brake=" + mi.brakeTime + "/" + mi.brakeTicks);
            double forwardTime = (float)mi.forwardTicks / 20.0f;
            double brakeTime = (float)mi.brakeTicks / 20.0f;
            double travelDist = Kinematics.travelDistanceFwd(forwardTime, maxSpeed, accel);
            double vf = Math.min(maxSpeed, Kinematics.vFinal(0.0, accel, forwardTime));
            double travelDistBrake = Kinematics.travelDistanceBrake(vf, brakeTime, decel);
            double travelDistTotal = travelDist + travelDistBrake;
            LOGGER.debug("travelDist=" + travelDist + ", travelDistBrake=" + travelDistBrake + ", travelDistTotal=" + travelDistTotal);
            LOGGER.debug((Object)Character.valueOf('\n'));
            double absDiff = Math.abs(travelDistTotal - dist);
            if (!(absDiff > absDiffMax)) continue;
            absDiffMax = absDiff;
        }
        LOGGER.debug("absDiffMax=" + absDiffMax);
    }

    public static class MovementInfo {
        public double forwardTime;
        public int forwardTicks;
        public double brakeTime;
        public int brakeTicks;
        public boolean wouldReachMaxSpeed;

        public void computeTicks() {
            this.forwardTicks = (int)Math.round(20.0 * this.forwardTime);
            this.brakeTicks = (int)Math.round(20.0 * this.brakeTime);
        }
    }
}

