/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.xenotech.entity;

import com.dairymoose.xenotech.XenoTechUtils;
import com.dairymoose.xenotech.block.MountedGunBlock;
import com.dairymoose.xenotech.client.model.SquareModel;
import com.dairymoose.xenotech.entity.DummyEntity;
import com.dairymoose.xenotech.world.level.block.entity.MountedGunBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.model.data.ModelData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MinigunRenderer
implements BlockEntityRenderer<MountedGunBlockEntity> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ResourceLocation[] GUNSHOT_TEXTURES = new ResourceLocation[]{new ResourceLocation("xenotech", "textures/entity/gunshot_0.png"), new ResourceLocation("xenotech", "textures/entity/gunshot_1.png"), new ResourceLocation("xenotech", "textures/entity/gunshot_2.png"), new ResourceLocation("xenotech", "textures/entity/gunshot_3.png")};
    private SquareModel squareModel;

    public MinigunRenderer(BlockEntityRendererProvider.Context ctx) {
        this.squareModel = new SquareModel(ctx.m_173582_(SquareModel.LAYER_LOCATION));
    }

    private void renderEmissiveLayer(PoseStack poseStack, MultiBufferSource mbs, RenderType renderType, float r, float g, float b, float a) {
        VertexConsumer vertexconsumer = mbs.m_6299_(renderType);
        this.squareModel.m_7695_(poseStack, vertexconsumer, 0xF000F0, OverlayTexture.f_118083_, r, g, b, a);
    }

    public int m_142163_() {
        return 128;
    }

    public void render(MountedGunBlockEntity paramT, float partialTick, PoseStack poseStack, MultiBufferSource paramMultiBufferSource, int paramInt1, int paramInt2) {
        if (paramT.mountedTo != null && !paramT.mountedTo.m_213877_()) {
            Vec3 mountLocation = paramT.mountedTo.m_20318_(partialTick);
            float gunYRot = paramT.mountedTo.m_146908_();
            float gunXRot = paramT.mountedTo.m_146909_();
            this.renderWithLocationAndRotation(paramT, partialTick, poseStack, paramMultiBufferSource, paramInt1, paramInt2, mountLocation, gunYRot, gunXRot);
        }
    }

    protected void renderWithLocationAndRotation(MountedGunBlockEntity paramT, float partialTick, PoseStack poseStack, MultiBufferSource paramMultiBufferSource, int paramInt1, int paramInt2, Vec3 mountLocation, float gunYRot, float gunXRot) {
        Entity vecToCarrier;
        Entity xOffset2;
        DummyEntity carrier;
        if (paramT.carrier != null && paramT.renderable == null) {
            LOGGER.warn("Carrier exists but renderable is null: " + paramT.carrier);
            return;
        }
        poseStack.m_85836_();
        Entity entity = paramT.carrier;
        if (entity instanceof DummyEntity) {
            carrier = (DummyEntity)entity;
            double xOffset2 = 0.0;
            double yOffset = 0.0;
            double zOffset = 0.0;
            float maxOffset = 0.25f;
            float yRotDiff = carrier.getYRotDiff() % 90.0f;
            float distFrom45 = Mth.m_14154_((float)(45.0f - yRotDiff));
            float angularOffset = 45.0f - distFrom45;
            double radians = Math.toRadians(angularOffset);
            xOffset2 = Math.cos(radians) * (double)(-maxOffset);
            yOffset = -0.25;
            zOffset = Math.sin(radians) * (double)(-maxOffset);
            xOffset2 = 0.0;
            yOffset = 0.0;
            zOffset = 0.0;
            poseStack.m_85837_(xOffset2, yOffset, zOffset);
            poseStack.m_166856_();
            Camera cam = Minecraft.m_91087_().f_91063_.m_109153_();
            Vec3 camPos = cam.m_90583_();
            poseStack.m_252781_(Axis.f_252403_.m_252977_(cam.m_253121_().w));
            poseStack.m_252781_(Axis.f_252529_.m_252977_(cam.m_90589_()));
            poseStack.m_252781_(Axis.f_252436_.m_252977_(cam.m_90590_() + 180.0f));
            Vec3 entityPos = mountLocation;
            poseStack.m_85837_(entityPos.f_82479_ - camPos.f_82479_ - 0.5, entityPos.f_82480_ - camPos.f_82480_, entityPos.f_82481_ - camPos.f_82481_ - 0.5);
        }
        if ((xOffset2 = paramT.carrier) instanceof DummyEntity) {
            carrier = (DummyEntity)xOffset2;
            Vec3 tickRotPos = XenoTechUtils.getRotPosForRenderable(carrier, paramT.renderable);
            Vec3 tickMountLocation = tickRotPos.m_82520_(0.5, 0.0, 0.5);
            Vec3 carrierLoc = carrier.m_20182_();
            vecToCarrier = carrierLoc.m_82546_(tickMountLocation);
            if ((carrier.vehicleType == DummyEntity.VehicleType.PLANE || carrier.vehicleType == DummyEntity.VehicleType.HELICOPTER) && carrier.isHoveringInAir()) {
                this.doTurnRotation((Vec3)vecToCarrier, poseStack, carrier);
            }
        }
        poseStack.m_85837_(0.5, 0.5, 0.5);
        float blockYRot = 180.0f;
        float entityYRot = Mth.m_14177_((float)gunYRot);
        float yResult = Mth.m_14177_((float)(blockYRot - entityYRot));
        vecToCarrier = paramT.carrier;
        if (vecToCarrier instanceof DummyEntity) {
            DummyEntity carrierLoc = (DummyEntity)vecToCarrier;
        }
        poseStack.m_252781_(Axis.f_252436_.m_252977_(yResult));
        vecToCarrier = paramT.carrier;
        if (vecToCarrier instanceof DummyEntity) {
            DummyEntity carrierLoc = (DummyEntity)vecToCarrier;
        }
        poseStack.m_252781_(Axis.f_252529_.m_252977_(-gunXRot));
        poseStack.m_85837_(-0.5, -0.5, -0.5);
        vecToCarrier = paramT.m_58900_().m_60734_();
        if (vecToCarrier instanceof MountedGunBlock) {
            MountedGunBlock mgb = (MountedGunBlock)vecToCarrier;
            if (mgb.getStaticBlock() != null) {
                Minecraft.m_91087_().m_91289_().renderSingleBlock(mgb.getStaticBlock().m_49966_(), poseStack, paramMultiBufferSource, paramInt1, paramInt2, ModelData.EMPTY, null);
            }
            if (mgb.getAnimatedBlock() != null) {
                poseStack.m_252880_(0.5f, -mgb.animatedBlockCenterOffset(), 0.5f);
                long timestamp = System.currentTimeMillis();
                long timeDiff = timestamp - paramT.lastRenderTimestamp;
                paramT.barrelRotation += paramT.barrelRotationSpeed * (float)timeDiff;
                if (paramT.barrelRotation >= 360.0f) {
                    paramT.barrelRotation -= 360.0f;
                }
                poseStack.m_252781_(Axis.f_252403_.m_252977_(paramT.barrelRotation));
                poseStack.m_252880_(-0.5f, mgb.animatedBlockCenterOffset(), -0.5f);
                paramT.lastRenderTimestamp = timestamp;
                Minecraft.m_91087_().m_91289_().renderSingleBlock(mgb.getAnimatedBlock().m_49966_(), poseStack, paramMultiBufferSource, paramInt1, paramInt2, ModelData.EMPTY, null);
                poseStack.m_252880_(0.0f, -0.90625f, 0.0f);
                poseStack.m_252880_(0.0f, -mgb.animatedBlockCenterOffset(), 0.0f);
            }
            if (paramT.isFiring) {
                poseStack.m_252880_(0.0f, 0.0f, 0.3f);
                int idx = (int)(Math.random() * (double)GUNSHOT_TEXTURES.length);
                this.renderEmissiveLayer(poseStack, paramMultiBufferSource, RenderType.m_234338_((ResourceLocation)GUNSHOT_TEXTURES[idx]), 1.0f, 1.0f, 1.0f, 1.0f);
            }
        }
        poseStack.m_85849_();
    }

    private boolean angleIsRightOf(float angle1, float angle2) {
        float angleDiff = angle1 - angle2;
        if (angleDiff < -180.0f) {
            angleDiff += 360.0f;
        }
        if (angleDiff > 180.0f) {
            angleDiff -= 360.0f;
        }
        if (angleDiff > 0.0f) {
            return true;
        }
        if (angleDiff < 0.0f) {
            return false;
        }
        return false;
    }

    private void doTurnRotation(Vec3 vecToCarrier, PoseStack poseStack, DummyEntity carrier) {
        float yRotRequest = carrier.getYRotRequest();
        float yRotRequestPct = Mth.m_14154_((float)(yRotRequest / 45.0f));
        if (yRotRequestPct > 1.0f) {
            yRotRequestPct = 1.0f;
        }
        poseStack.m_85837_(0.5, 0.5, 0.5);
        float carrierRot = Mth.m_14177_((float)(-carrier.m_146908_()));
        poseStack.m_252781_(Axis.f_252436_.m_252977_(carrierRot));
        double xDiff = vecToCarrier.f_82479_;
        double zDiff = vecToCarrier.f_82481_;
        float gunYRot = (float)Math.toDegrees(Math.atan2(zDiff, xDiff)) - 90.0f;
        gunYRot %= 360.0f;
        float carrierYRot = carrier.m_146908_();
        carrierYRot %= 360.0f;
        float relativeYRot = (carrierYRot += 360.0f) - (gunYRot += 360.0f);
        float flipFactor = 1.0f;
        if (this.angleIsRightOf(gunYRot, carrierYRot)) {
            flipFactor = -1.0f;
        }
        double xTranslate = (double)flipFactor * (vecToCarrier.m_82553_() * Math.cos(Math.toRadians(relativeYRot)));
        poseStack.m_85837_(xTranslate, 0.0, 0.0);
        if ((double)yRotRequest > 0.0) {
            poseStack.m_252781_(Axis.f_252403_.m_252977_(yRotRequestPct * 5.0f));
        } else if ((double)yRotRequest < 0.0) {
            poseStack.m_252781_(Axis.f_252403_.m_252977_(yRotRequestPct * -5.0f));
        }
        poseStack.m_85837_(-xTranslate, 0.0, 0.0);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(-carrierRot));
        poseStack.m_85837_(-0.5, -0.5, -0.5);
    }
}

