/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.xenotech.entity;

import com.dairymoose.xenotech.block.CombineHarvesterBlock;
import com.dairymoose.xenotech.entity.ShipRenderableStorage;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RenderableBlock {
    private static final Logger LOGGER = LogManager.getLogger();
    public Entity parent;
    public BlockPos pos;
    public double relativeX;
    public double relativeY;
    public double relativeZ;
    public BlockState state;
    public float xOffset = 0.0f;
    public float yOffset = 0.0f;
    public float zOffset = 0.0f;
    public CompoundTag tag;
    public int blockLight = -1;
    public int skyLight = -1;
    public float visualRotation;
    public float lastVisualRotation = this.visualRotation = (float)Math.random() * 360.0f;
    public BlockEntity tempBlockEntity = null;
    public BlockState lastRenderState = null;
    public BlockState lastCarriedEntityCollisionState = null;
    public boolean lastCarriedEntityEmptyShape = false;

    public RenderableBlock(Entity e, BlockPos pos, BlockState state, BlockEntity blockEntity, int blockLight, int skyLight) {
        this.parent = e;
        this.pos = pos;
        this.relativeX = (double)pos.m_123341_() - e.m_20185_();
        this.relativeY = (double)pos.m_123342_() - e.m_20186_();
        this.relativeZ = (double)pos.m_123343_() - e.m_20189_();
        this.state = state;
        if (blockEntity != null) {
            this.tag = blockEntity.m_187482_();
        }
        this.blockLight = blockLight;
        this.skyLight = skyLight;
    }

    public double absoluteX(Entity e) {
        return this.relativeX + e.m_20185_();
    }

    public double absoluteY(Entity e) {
        return this.relativeY + e.m_20186_();
    }

    public double absoluteZ(Entity e) {
        return this.relativeZ + e.m_20189_();
    }

    public double absoluteXplusDelta(Entity e) {
        return this.relativeX + e.m_20185_() + e.m_20184_().f_82479_;
    }

    public double absoluteYplusDelta(Entity e) {
        return this.relativeY + e.m_20186_() + e.m_20184_().f_82480_;
    }

    public double absoluteZplusDelta(Entity e) {
        return this.relativeZ + e.m_20189_() + e.m_20184_().f_82481_;
    }

    public static byte[] serialize(RenderableBlock renderable) {
        ByteArrayOutputStream baosBlockState = new ByteArrayOutputStream();
        Tag blockStateTag = null;
        try {
            blockStateTag = (Tag)BlockState.f_61039_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)renderable.state).getOrThrow(false, null);
        }
        catch (RuntimeException e) {
            LOGGER.error("Runtime exception while encoding BlockState=" + renderable.state);
        }
        if (blockStateTag != null) {
            try {
                NbtIo.m_128947_((CompoundTag)((CompoundTag)blockStateTag), (OutputStream)baosBlockState);
            }
            catch (IOException e) {
                LOGGER.error("IOException while writing compressed BlockState=" + renderable.state);
            }
        }
        CompoundTag serializeTag = null;
        if (renderable.tempBlockEntity != null) {
            try {
                serializeTag = renderable.tempBlockEntity.m_187482_();
            }
            catch (Exception ex) {
                LOGGER.error("Error saving tempBlockEntity tags: " + ex);
            }
        }
        if (serializeTag != null) {
            LOGGER.debug("Updated blockEntity: " + renderable.state + ", tag=" + serializeTag);
            renderable.tag = serializeTag;
        }
        ByteArrayOutputStream baosBlockEntityTag = new ByteArrayOutputStream();
        Tag blockEntityTag = null;
        if (renderable.tag != null) {
            try {
                blockEntityTag = (Tag)CompoundTag.f_128325_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)renderable.tag).getOrThrow(false, null);
            }
            catch (RuntimeException e) {
                LOGGER.error("Runtime exception while encoding CompoundTag=" + renderable.tag);
            }
        }
        if (blockEntityTag != null) {
            try {
                NbtIo.m_128947_((CompoundTag)((CompoundTag)blockEntityTag), (OutputStream)baosBlockEntityTag);
            }
            catch (IOException e) {
                LOGGER.error("IOException while writing compressed blockEntity tag=" + blockEntityTag);
            }
        }
        int bonusBytes = 0;
        if (ShipRenderableStorage.SAVE_FORMAT_VERSION >= 6) {
            bonusBytes += 2;
        }
        ByteBuffer bb = ByteBuffer.allocate(44 + bonusBytes + baosBlockState.size() + baosBlockEntityTag.size());
        bb.putInt(renderable.pos.m_123341_());
        bb.putInt(renderable.pos.m_123342_());
        bb.putInt(renderable.pos.m_123343_());
        if (ShipRenderableStorage.SAVE_FORMAT_VERSION >= 6) {
            bb.put((byte)renderable.blockLight);
            bb.put((byte)renderable.skyLight);
        }
        bb.putDouble(renderable.relativeX);
        bb.putDouble(renderable.relativeY);
        bb.putDouble(renderable.relativeZ);
        bb.putInt(baosBlockState.size());
        bb.put(baosBlockState.toByteArray());
        bb.putInt(baosBlockEntityTag.size());
        bb.put(baosBlockEntityTag.toByteArray());
        return bb.array();
    }

    public RenderableBlock(byte[] data, int saveFormatVersion) {
        ByteBuffer buffer = ByteBuffer.wrap(data);
        try {
            int x = buffer.getInt();
            int y = buffer.getInt();
            int z = buffer.getInt();
            int blockLight = -1;
            int skyLight = -1;
            if (saveFormatVersion >= 6) {
                blockLight = buffer.get();
                skyLight = buffer.get();
            }
            double relX = buffer.getDouble();
            double relY = buffer.getDouble();
            double relZ = buffer.getDouble();
            int blockstateByteSize = buffer.getInt();
            byte[] blockstateBytes = new byte[blockstateByteSize];
            buffer.get(blockstateBytes);
            int blockEntityTagByteSize = buffer.getInt();
            byte[] blockEntityTagBytes = new byte[blockEntityTagByteSize];
            buffer.get(blockEntityTagBytes);
            CompoundTag blockStateTag = null;
            if (blockstateByteSize > 0) {
                ByteArrayInputStream bais = new ByteArrayInputStream(blockstateBytes);
                try {
                    blockStateTag = NbtIo.m_128939_((InputStream)bais);
                }
                catch (IOException e) {
                    LOGGER.error("IOException while reading compressed BlockState with bytes=" + blockstateBytes);
                }
            }
            CompoundTag blockEntityTag = null;
            if (blockEntityTagByteSize > 0) {
                ByteArrayInputStream bais = new ByteArrayInputStream(blockEntityTagBytes);
                try {
                    blockEntityTag = NbtIo.m_128939_((InputStream)bais);
                }
                catch (IOException e) {
                    LOGGER.error("IOException while reading compressed blockEntity tag with bytes=" + blockEntityTagBytes);
                }
            }
            this.pos = new BlockPos(x, y, z);
            this.blockLight = blockLight;
            this.skyLight = skyLight;
            this.relativeX = relX;
            this.relativeY = relY;
            this.relativeZ = relZ;
            BlockState loadedState = null;
            if (blockStateTag != null) {
                try {
                    Pair pair = (Pair)BlockState.f_61039_.decode((DynamicOps)NbtOps.f_128958_, (Object)blockStateTag).getOrThrow(false, null);
                    loadedState = (BlockState)pair.getFirst();
                }
                catch (RuntimeException e) {
                    LOGGER.error("Runtime exception while decoding BlockState=" + blockEntityTag);
                }
            }
            CompoundTag loadedBlockEntityTag = null;
            if (blockEntityTag != null) {
                try {
                    Pair pair = (Pair)CompoundTag.f_128325_.decode((DynamicOps)NbtOps.f_128958_, (Object)blockEntityTag).getOrThrow(false, null);
                    loadedBlockEntityTag = (CompoundTag)pair.getFirst();
                }
                catch (RuntimeException e) {
                    LOGGER.error("Runtime exception while decoding blockEntity tag=" + blockEntityTag);
                }
            }
            this.state = loadedState;
            this.tag = loadedBlockEntityTag;
        }
        catch (BufferUnderflowException e) {
            LOGGER.error("Buffer underflow for renderable at data position=" + buffer.position() + " vs capacity=" + buffer.capacity());
            throw e;
        }
    }

    public static RenderableBlock deserialize(byte[] data, int saveFormatVersion) {
        RenderableBlock renderable = new RenderableBlock(data, saveFormatVersion);
        if (renderable.state != null && renderable.state.m_60734_() instanceof CombineHarvesterBlock) {
            renderable.visualRotation = 0.0f;
        }
        return renderable;
    }

    public String toString() {
        return "RenderableBlock [pos=" + this.pos + ", state=" + this.state + ", (" + this.relativeX + ", " + this.relativeY + ", " + this.relativeZ + ")]";
    }
}

