/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.xenotech.entity;

import com.dairymoose.xenotech.XenoBlocks;
import com.dairymoose.xenotech.XenoTechCommon;
import com.dairymoose.xenotech.block.ShipTeleportationModuleBlock;
import com.dairymoose.xenotech.entity.DummyEntity;
import com.dairymoose.xenotech.entity.RenderableBlock;
import com.google.common.io.Files;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ShipRenderableStorage {
    public static int SAVE_FORMAT_VERSION = 6;
    public static final Logger LOGGER = LogManager.getLogger();
    public int METADATA_FORMAT_VERSION = 1;

    public void readAllRecordsFromData(byte[] data, DummyEntity dummy) {
        int liftBlockRegistryBytesLen;
        int engineCount;
        byte vehicleType;
        ArrayList<RenderableBlock> allRecords = new ArrayList<RenderableBlock>();
        ByteBuffer dataBuf = ByteBuffer.wrap(data);
        int saveFormatVersion = dataBuf.getInt();
        LOGGER.debug("SAVE FORMAT VERSION=" + saveFormatVersion);
        dummy.weight = dataBuf.getFloat();
        LOGGER.debug("weight=" + dummy.weight);
        dummy.moverStats.acceleration = dataBuf.getFloat();
        dummy.moverStats.topSpeed = dataBuf.getFloat();
        if (saveFormatVersion >= 3) {
            dummy.liftMoverStats.acceleration = dataBuf.getFloat();
            dummy.liftMoverStats.topSpeed = dataBuf.getFloat();
            dummy.setInAirTicks(dataBuf.getInt());
        }
        boolean bl = dummy.isBoat = dataBuf.get() == 1;
        if (saveFormatVersion >= 4) {
            boolean bl2 = dummy.isGroundVehicle = dataBuf.get() == 1;
        }
        if (saveFormatVersion >= 5 && (vehicleType = dataBuf.get()) < DummyEntity.VehicleType.values().length) {
            dummy.vehicleType = DummyEntity.VehicleType.values()[vehicleType];
            LOGGER.debug("assigned vehicleType=" + dummy.vehicleType.name());
        }
        dummy.moverStats.moverCount = engineCount = dataBuf.getInt();
        LOGGER.debug("engineCount=" + engineCount);
        if (saveFormatVersion >= 3) {
            int liftEngineCount;
            dummy.liftMoverStats.moverCount = liftEngineCount = dataBuf.getInt();
        }
        dummy.setStartingAngle(dataBuf.getFloat());
        int terminalX = dataBuf.getInt();
        int terminalY = dataBuf.getInt();
        int terminalZ = dataBuf.getInt();
        dummy.startingTerminalPos = new BlockPos(terminalX, terminalY, terminalZ);
        if (saveFormatVersion >= 2) {
            int shipNameBytesLen = dataBuf.getInt();
            byte[] shipNameBytes = new byte[shipNameBytesLen];
            dataBuf.get(shipNameBytes);
            dummy.setShipName(new String(shipNameBytes));
        }
        byte[] filler = new byte[20];
        dataBuf.get(filler);
        int blockRegistryBytesLen = dataBuf.getInt();
        if (blockRegistryBytesLen > 0) {
            String[] tokens;
            byte[] blockRegistryBytes = new byte[blockRegistryBytesLen];
            dataBuf.get(blockRegistryBytes);
            String blockRegistryText = new String(blockRegistryBytes);
            if (blockRegistryText.length() > 0 && (tokens = blockRegistryText.split(":")) != null && tokens.length == 2) {
                dummy.moverStats.moverBlockType = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(tokens[0], tokens[1]));
            }
        }
        if (saveFormatVersion >= 3 && (liftBlockRegistryBytesLen = dataBuf.getInt()) > 0) {
            String[] tokens;
            byte[] liftBlockRegistryBytes = new byte[liftBlockRegistryBytesLen];
            dataBuf.get(liftBlockRegistryBytes);
            String liftBlockRegistryText = new String(liftBlockRegistryBytes);
            if (liftBlockRegistryText.length() > 0 && (tokens = liftBlockRegistryText.split(":")) != null && tokens.length == 2) {
                dummy.liftMoverStats.moverBlockType = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(tokens[0], tokens[1]));
            }
        }
        int recordCount = dataBuf.getInt();
        LOGGER.debug("Got file with record count=" + recordCount);
        for (int i = 0; i < recordCount; ++i) {
            int recordLength = 0;
            try {
                recordLength = dataBuf.getInt();
                byte[] alloc = new byte[recordLength];
                dataBuf.get(alloc);
                RenderableBlock record = RenderableBlock.deserialize(alloc, saveFormatVersion);
                record.parent = dummy;
                allRecords.add(record);
                continue;
            }
            catch (Exception e) {
                LOGGER.error("Error deserializing renderable record #" + i + " with expected length=" + recordLength + " at filePos=" + dataBuf.position());
                throw e;
            }
        }
        dummy.renderables = allRecords;
        dummy.doneWithSetup = true;
    }

    public void readAllRecordsFromFile(long uniqueId, DummyEntity dummy) {
        String subFolder = XenoTechCommon.getSubFolderPrepend();
        LOGGER.debug("read all records with folder=" + subFolder);
        File shipData = new File(subFolder + "ship_data_" + uniqueId + ".bin");
        LOGGER.debug("Open file with id=" + uniqueId);
        if (shipData.exists()) {
            try {
                byte[] data = Files.toByteArray((File)shipData);
                this.readAllRecordsFromData(data, dummy);
            }
            catch (IOException | NumberFormatException e) {
                LOGGER.error("ship_data_" + uniqueId + ".bin not found", (Throwable)e);
            }
        } else {
            LOGGER.warn("No ship exists with uniqueId=" + uniqueId);
        }
    }

    public byte[] recordsToBytes(DummyEntity dummy) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        List<RenderableBlock> allRecords = dummy.renderables;
        ResourceLocation resource = ForgeRegistries.BLOCKS.getKey((Object)dummy.moverStats.moverBlockType);
        Object blockRegistryText = "";
        if (resource != null) {
            blockRegistryText = resource.m_135827_() + ":" + resource.m_135815_();
        }
        byte[] blockRegistryBytes = ((String)blockRegistryText).getBytes();
        ResourceLocation liftResource = ForgeRegistries.BLOCKS.getKey((Object)dummy.liftMoverStats.moverBlockType);
        Object liftBlockRegistryText = "";
        if (liftResource != null) {
            liftBlockRegistryText = liftResource.m_135827_() + ":" + liftResource.m_135815_();
        }
        byte[] liftBlockRegistryBytes = ((String)liftBlockRegistryText).getBytes();
        int byteAllocSize = 65 + blockRegistryBytes.length;
        byte[] shipNameBytes = dummy.getShipName().getBytes();
        if (SAVE_FORMAT_VERSION >= 2) {
            byteAllocSize += 4 + shipNameBytes.length;
        }
        if (SAVE_FORMAT_VERSION >= 3) {
            byteAllocSize += 8;
            byteAllocSize += 4 + liftBlockRegistryBytes.length;
            byteAllocSize += 4;
            byteAllocSize += 4;
        }
        if (SAVE_FORMAT_VERSION >= 4) {
            ++byteAllocSize;
        }
        if (SAVE_FORMAT_VERSION >= 5) {
            ++byteAllocSize;
        }
        ByteBuffer headerBuf = ByteBuffer.allocate(byteAllocSize);
        headerBuf.putInt(SAVE_FORMAT_VERSION);
        headerBuf.putFloat(dummy.weight);
        headerBuf.putFloat(dummy.moverStats.acceleration);
        headerBuf.putFloat(dummy.moverStats.topSpeed);
        if (SAVE_FORMAT_VERSION >= 3) {
            headerBuf.putFloat(dummy.liftMoverStats.acceleration);
            headerBuf.putFloat(dummy.liftMoverStats.topSpeed);
            headerBuf.putInt(dummy.getInAirTicks());
        }
        headerBuf.put(dummy.isBoat ? (byte)1 : 0);
        if (SAVE_FORMAT_VERSION >= 4) {
            headerBuf.put(dummy.isGroundVehicle ? (byte)1 : 0);
        }
        if (SAVE_FORMAT_VERSION >= 5) {
            headerBuf.put((byte)dummy.vehicleType.ordinal());
        }
        headerBuf.putInt(dummy.moverStats.moverCount);
        if (SAVE_FORMAT_VERSION >= 3) {
            headerBuf.putInt(dummy.liftMoverStats.moverCount);
        }
        headerBuf.putFloat(dummy.getStartingAngle());
        headerBuf.putInt(dummy.startingTerminalPos.m_123341_());
        headerBuf.putInt(dummy.startingTerminalPos.m_123342_());
        headerBuf.putInt(dummy.startingTerminalPos.m_123343_());
        if (SAVE_FORMAT_VERSION >= 2) {
            headerBuf.putInt(shipNameBytes.length);
            headerBuf.put(shipNameBytes);
        }
        byte[] filler = new byte[20];
        headerBuf.put(filler);
        headerBuf.putInt(blockRegistryBytes.length);
        if (blockRegistryBytes.length > 0) {
            headerBuf.put(blockRegistryBytes);
        }
        if (SAVE_FORMAT_VERSION >= 3) {
            headerBuf.putInt(liftBlockRegistryBytes.length);
            if (liftBlockRegistryBytes.length > 0) {
                headerBuf.put(liftBlockRegistryBytes);
            }
        }
        headerBuf.putInt(allRecords.size());
        baos.writeBytes(headerBuf.array());
        for (RenderableBlock renderable : allRecords) {
            ByteBuffer recordHeaderBuf = ByteBuffer.allocate(4);
            byte[] recordData = RenderableBlock.serialize(renderable);
            recordHeaderBuf.putInt(recordData.length);
            baos.writeBytes(recordHeaderBuf.array());
            baos.writeBytes(recordData);
        }
        byte[] toWrite = baos.toByteArray();
        return toWrite;
    }

    public void saveAllRecordsToFile(long uniqueId, DummyEntity dummy) {
        String subFolder = XenoTechCommon.getSubFolderPrepend();
        LOGGER.debug("save all records with folder=" + subFolder + " with uniqueId=" + uniqueId);
        if (dummy.renderables == null || dummy.renderables.isEmpty()) {
            LOGGER.warn("Ship has no blocks, skipping save for entityId=" + dummy.m_19879_() + " with uniqueId=" + uniqueId);
            return;
        }
        File shipData = new File(subFolder + "ship_data_" + uniqueId + ".bin");
        try {
            byte[] toWrite = this.recordsToBytes(dummy);
            LOGGER.debug("Saving " + dummy.renderables.size() + " records with byte size=" + toWrite.length);
            Files.write((byte[])toWrite, (File)shipData);
        }
        catch (IOException e) {
            LOGGER.error("Error writing to ship_data");
        }
    }

    public void deleteRecord(long uniqueId) {
        String subFolder = XenoTechCommon.getSubFolderPrepend();
        LOGGER.debug("delete records with folder=" + subFolder + " with uniqueId=" + uniqueId);
        File shipData = new File(subFolder + "ship_data_" + uniqueId + ".bin");
        if (shipData.delete()) {
            LOGGER.debug("delete success with uniqueId=" + uniqueId);
            this.deleteMetadataForOneRecord(uniqueId);
        }
    }

    public static String dimensionNameFromLevel(Level level) {
        return level.m_46472_().m_135782_().toString();
    }

    public static Level levelFromDimensionName(String dimensionName) {
        if (dimensionName == null) {
            return null;
        }
        String[] tokens = dimensionName.split(":");
        if (tokens.length == 2) {
            return ServerLifecycleHooks.getCurrentServer().m_129880_(ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(tokens[0], tokens[1])));
        }
        return null;
    }

    public static List<RecordMetadata> readMetadataBytes(byte[] data) {
        ArrayList<RecordMetadata> records = new ArrayList<RecordMetadata>();
        LOGGER.debug("read metadata of size=" + data.length);
        ByteBuffer headerBuf = ByteBuffer.wrap(data);
        int formatVersion = headerBuf.getInt();
        int entityCount = headerBuf.getInt();
        for (int i = 0; i < entityCount; ++i) {
            long uniqueId = headerBuf.getLong();
            double x = headerBuf.getDouble();
            double y = headerBuf.getDouble();
            double z = headerBuf.getDouble();
            float yRotDiff = headerBuf.getFloat();
            float yRot = headerBuf.getFloat();
            double tx = headerBuf.getDouble();
            double ty = headerBuf.getDouble();
            double tz = headerBuf.getDouble();
            byte direction = headerBuf.get();
            byte digitized = headerBuf.get();
            int dimBytesLength = headerBuf.getInt();
            byte[] dimBytes = new byte[dimBytesLength];
            headerBuf.get(dimBytes);
            records.add(new RecordMetadata(uniqueId, new Vec3(x, y, z), new Vec3(tx, ty, tz), direction, yRotDiff, yRot, digitized, new String(dimBytes)));
        }
        return records;
    }

    public static List<RecordMetadata> readMetadataFromFile() {
        String subFolder = XenoTechCommon.getSubFolderPrepend();
        LOGGER.debug("read metadata with folder=" + subFolder);
        File metaData = new File(subFolder + "metadata_ships.bin");
        List<RecordMetadata> records = new ArrayList<RecordMetadata>();
        if (metaData.exists()) {
            try {
                byte[] data = Files.toByteArray((File)metaData);
                records = ShipRenderableStorage.readMetadataBytes(data);
                LOGGER.debug("Found " + records.size() + " existing metadata records");
            }
            catch (IOException e) {
                LOGGER.error("metadata_ships.bin not found", (Throwable)e);
            }
        } else {
            LOGGER.error("metadata_ships.bin not found");
        }
        return records;
    }

    public byte[] generateMetadataBytes(List<RecordMetadata> records) {
        int dimBytesSum = 0;
        for (RecordMetadata record : records) {
            byte[] dimBytes = record.dimension.getBytes();
            dimBytesSum += dimBytes.length;
        }
        ByteBuffer headerBuf = ByteBuffer.allocate(8 + 70 * records.size() + dimBytesSum);
        headerBuf.putInt(this.METADATA_FORMAT_VERSION);
        int entityCount = records.size();
        headerBuf.putInt(entityCount);
        for (RecordMetadata record : records) {
            headerBuf.putLong(record.uniqueId);
            Vec3 pos = record.pos;
            headerBuf.putDouble(pos.f_82479_);
            headerBuf.putDouble(pos.f_82480_);
            headerBuf.putDouble(pos.f_82481_);
            headerBuf.putFloat(record.yRotDiff);
            headerBuf.putFloat(record.yRot);
            Vec3 telePos = record.teleporterRelativeOffset;
            headerBuf.putDouble(telePos.f_82479_);
            headerBuf.putDouble(telePos.f_82480_);
            headerBuf.putDouble(telePos.f_82481_);
            headerBuf.put(record.direction);
            headerBuf.put(record.digitized);
            byte[] dimBytes = record.dimension.getBytes();
            headerBuf.putInt(dimBytes.length);
            headerBuf.put(dimBytes);
        }
        return headerBuf.array();
    }

    public void updateMetadataForEntity(List<RecordMetadata> records, DummyEntity entity) {
        if (entity.uniqueId == -1L) {
            return;
        }
        for (RecordMetadata record : records) {
            if (record.uniqueId != entity.uniqueId) continue;
            LOGGER.debug("Updated ship metadata for uniqueId=" + entity.uniqueId);
            record.pos = entity.m_20182_();
            record.yRotDiff = entity.getYRotDiff();
            record.yRot = entity.m_146908_();
            record.digitized = entity.isDigitized() ? (byte)1 : 0;
            record.dimension = ShipRenderableStorage.dimensionNameFromLevel(entity.m_9236_());
            return;
        }
        records.add(new RecordMetadata(entity));
    }

    public void deleteMetadataForOneRecord(long uniqueId) {
        String subFolder = XenoTechCommon.getSubFolderPrepend();
        LOGGER.debug("delete metadata with folder=" + subFolder + " with uniqueId=" + uniqueId);
        ArrayList<RecordMetadata> records = new ArrayList();
        try {
            records = ShipRenderableStorage.readMetadataFromFile();
        }
        catch (Exception e) {
            LOGGER.error("saveMetadataToFile: error reading existing metadata entries", (Throwable)e);
        }
        if (this.deleteMetaDataForId(records, uniqueId)) {
            LOGGER.debug("found existing metadata record for uniqueId=" + uniqueId + ", saving");
            File metaData = new File(subFolder + "metadata_ships.bin");
            try {
                byte[] toWrite = this.generateMetadataBytes(records);
                LOGGER.debug("Saving " + records.size() + " metadata records with byte size=" + toWrite.length);
                Files.write((byte[])toWrite, (File)metaData);
            }
            catch (IOException e) {
                LOGGER.error("Error writing to metadata_ships");
            }
        } else {
            LOGGER.warn("Could not find ship in metadata file! uniqueId=" + uniqueId);
        }
    }

    private boolean deleteMetaDataForId(List<RecordMetadata> records, long uniqueId) {
        RecordMetadata toDelete = null;
        for (RecordMetadata record : records) {
            if (record.uniqueId != uniqueId) continue;
            toDelete = record;
            break;
        }
        if (toDelete != null) {
            records.remove(toDelete);
            return true;
        }
        return false;
    }

    public void saveMetadataToFile(long uniqueId, DummyEntity dummy) {
        String subFolder = XenoTechCommon.getSubFolderPrepend();
        LOGGER.debug("save metadata with folder=" + subFolder + " with uniqueId=" + uniqueId);
        if (dummy.renderables == null || dummy.renderables.isEmpty()) {
            LOGGER.warn("Ship has no blocks, skipping save for entityId=" + dummy.m_19879_() + " with uniqueId=" + uniqueId);
            return;
        }
        ArrayList<RecordMetadata> records = new ArrayList();
        try {
            records = ShipRenderableStorage.readMetadataFromFile();
        }
        catch (Exception e) {
            LOGGER.error("saveMetadataToFile: error reading existing metadata entries", (Throwable)e);
        }
        this.updateMetadataForEntity(records, dummy);
        File metaData = new File(subFolder + "metadata_ships.bin");
        try {
            byte[] toWrite = this.generateMetadataBytes(records);
            LOGGER.debug("Saving " + records.size() + " metadata records with byte size=" + toWrite.length);
            Files.write((byte[])toWrite, (File)metaData);
        }
        catch (IOException e) {
            LOGGER.error("Error writing to metadata_ships");
        }
    }

    public static class RecordMetadata {
        long uniqueId;
        Vec3 pos;
        Vec3 teleporterRelativeOffset;
        byte direction = (byte)122;
        byte digitized = 0;
        float yRotDiff = 0.0f;
        float yRot = 0.0f;
        String dimension;

        public RecordMetadata(DummyEntity entity) {
            this.uniqueId = entity.uniqueId;
            this.pos = entity.m_20182_();
            for (RenderableBlock renderable : entity.renderables) {
                if (!renderable.state.m_60713_((Block)XenoBlocks.BLOCK_SHIP_TELEPORTATION_MODULE.get())) continue;
                this.teleporterRelativeOffset = new Vec3(renderable.relativeX + 0.5, renderable.relativeY, renderable.relativeZ + 0.5);
                Direction dir = (Direction)renderable.state.m_61143_((Property)ShipTeleportationModuleBlock.f_54117_);
                if (dir == Direction.NORTH) {
                    this.direction = (byte)110;
                    break;
                }
                if (dir == Direction.EAST) {
                    this.direction = (byte)101;
                    break;
                }
                if (dir == Direction.SOUTH) {
                    this.direction = (byte)115;
                    break;
                }
                if (dir != Direction.WEST) break;
                this.direction = (byte)119;
                break;
            }
            if (this.teleporterRelativeOffset == null) {
                this.teleporterRelativeOffset = new Vec3(0.0, 0.0, 0.0);
            }
            this.yRotDiff = entity.getYRotDiff();
            this.yRot = entity.m_146908_();
            this.digitized = entity.isDigitized() ? (byte)1 : 0;
            this.dimension = ShipRenderableStorage.dimensionNameFromLevel(entity.m_9236_());
        }

        public RecordMetadata(long uniqueId, Vec3 pos, Vec3 teleporterRelativeOffset, byte direction, float yRotDiff, float yRot, byte digitized, String dimension) {
            this.uniqueId = uniqueId;
            if (pos == null) {
                pos = new Vec3(0.0, 0.0, 0.0);
            }
            this.pos = pos;
            if (teleporterRelativeOffset == null) {
                teleporterRelativeOffset = new Vec3(0.0, 0.0, 0.0);
            }
            this.teleporterRelativeOffset = teleporterRelativeOffset;
            this.direction = direction;
            this.yRotDiff = yRotDiff;
            this.yRot = yRot;
            this.digitized = digitized;
            this.dimension = dimension;
        }
    }
}

