/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.xenotech.fluids;

import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.Consumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class RefinedOilFluidType
extends FluidType {
    public RefinedOilFluidType(FluidType.Properties properties) {
        super(properties.viscosity(25000).canSwim(true).canPushEntity(true).canHydrate(false).canDrown(true).density(1100).motionScale(0.009).supportsBoating(true).temperature(300));
    }

    public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
        super.initializeClient(consumer);
        consumer.accept(new IClientFluidTypeExtensions(){

            public ResourceLocation getFlowingTexture() {
                return new ResourceLocation("xenotech", "block/crude_oil_flow");
            }

            public ResourceLocation getStillTexture() {
                return new ResourceLocation("xenotech", "block/crude_oil_still");
            }

            @Nullable
            public ResourceLocation getOverlayTexture() {
                return new ResourceLocation("xenotech", "block/crude_oil_overlay");
            }

            public int getTintColor() {
                return -15724528;
            }

            @NotNull
            public Vector3f modifyFogColor(Camera camera, float partialTick, ClientLevel level, int renderDistance, float darkenWorldAmount, Vector3f fluidFogColor) {
                return new Vector3f(0.07f, 0.07f, 0.07f);
            }

            public void modifyFogRender(Camera camera, FogRenderer.FogMode mode, float renderDistance, float partialTick, float nearDistance, float farDistance, FogShape shape) {
                RenderSystem.setShaderFogStart((float)0.05f);
                RenderSystem.setShaderFogEnd((float)2.5f);
            }
        });
    }
}

