/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.xenotech.item;

import com.dairymoose.xenotech.entity.DummyEntity;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DigitizedShipItem
extends Item {
    private static final Predicate<Entity> ENTITY_PREDICATE = EntitySelector.f_20408_.and(Entity::m_6087_);
    private static final Logger LOGGER = LogManager.getLogger();

    public DigitizedShipItem(Item.Properties p_41383_) {
        super(p_41383_);
    }

    public void m_7373_(ItemStack itemStack, Level p_41422_, List<Component> components, TooltipFlag p_41424_) {
        CompoundTag tag;
        if (itemStack != null && (tag = itemStack.m_41783_()) != null) {
            if (tag.m_128441_("UniqueId")) {
                long uniqueId = tag.m_128454_("UniqueId");
                components.add((Component)Component.m_237115_((String)"xenotech.digitized_ship.tip1").m_130946_(": " + uniqueId));
            }
            if (tag.m_128441_("ShipName")) {
                String shipName = tag.m_128461_("ShipName");
                components.add((Component)Component.m_237115_((String)"xenotech.digitized_ship.tip2").m_130946_(": " + shipName));
            }
        }
        super.m_7373_(itemStack, p_41422_, components, p_41424_);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        CompoundTag tag;
        long uniqueId = -1L;
        ItemStack itemStack = player.m_21120_(hand);
        if (itemStack != null && (tag = itemStack.m_41783_()) != null && tag.m_128441_("UniqueId")) {
            uniqueId = tag.m_128454_("UniqueId");
        }
        if (uniqueId != -1L) {
            BlockHitResult hitResult = DigitizedShipItem.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.ANY);
            if (hitResult.m_6662_() == HitResult.Type.MISS) {
                return InteractionResultHolder.m_19098_((Object)itemStack);
            }
            Vec3 vec3 = player.m_20252_(1.0f);
            double d0 = 5.0;
            List list = level.m_6249_((Entity)player, player.m_20191_().m_82369_(vec3.m_82490_(5.0)).m_82400_(1.0), ENTITY_PREDICATE);
            if (!list.isEmpty()) {
                Vec3 vec31 = player.m_146892_();
                for (Entity entity : list) {
                    AABB aabb = entity.m_20191_().m_82400_((double)entity.m_6143_());
                    if (!aabb.m_82390_(vec31)) continue;
                    return InteractionResultHolder.m_19098_((Object)itemStack);
                }
            }
            if (hitResult.m_6662_() == HitResult.Type.BLOCK) {
                DummyEntity dummy = (DummyEntity)DummyEntity.DUMMY_ENTITY.m_20615_(level);
                dummy.uniqueId = uniqueId;
                dummy.m_146922_(player.m_146908_());
                if (!level.f_46443_) {
                    dummy.loadSavedData();
                    if (dummy.renderables != null && !dummy.renderables.isEmpty()) {
                        Double terminalY = dummy.getTerminalLocationY();
                        double addY = 0.0;
                        if (terminalY != null) {
                            addY = terminalY;
                        }
                        Vec3 spawnLocation = hitResult.m_82450_().m_82520_(0.0, addY, 0.0);
                        dummy.m_146884_(spawnLocation);
                        dummy.setDigitized(false);
                        LOGGER.debug("Spawn from digitized ship at location: " + spawnLocation + " with addY=" + addY + " with uniqueId=" + uniqueId);
                        level.m_7967_((Entity)dummy);
                        LOGGER.debug("un-digitized with starting angle=" + dummy.getSanitizedStartingAngle());
                        level.m_220400_((Entity)player, GameEvent.f_157810_, hitResult.m_82450_());
                        this.applyLongTagToShip(dummy, itemStack, "Metrics_BlocksTravelled", DummyEntity::setMetric_BlocksTravelled);
                        this.applyLongTagToShip(dummy, itemStack, "Metrics_TimeSpentConsumingFuel", DummyEntity::setMetric_TimeSpentConsumingFuel);
                        this.applyLongTagToShip(dummy, itemStack, "Metrics_TimeUntilEmpty", DummyEntity::setMetric_TimeUntilEmpty);
                        this.applyStringTagToShip(dummy, itemStack, "Metrics_CreationDate", DummyEntity::setMetric_CreationDate);
                        this.applyStringTagToShip(dummy, itemStack, "Metrics_CreatorName", DummyEntity::setMetric_CreatorName);
                        itemStack.m_41774_(1);
                        player.m_20329_((Entity)dummy);
                    } else {
                        dummy.m_6074_();
                    }
                }
                player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                return InteractionResultHolder.m_19092_((Object)itemStack, (boolean)level.m_5776_());
            }
            return InteractionResultHolder.m_19098_((Object)itemStack);
        }
        return InteractionResultHolder.m_19098_((Object)itemStack);
    }

    private void applyLongTagToShip(DummyEntity dummy, ItemStack itemStack, String tagName, BiConsumer<DummyEntity, Long> fn) {
        if (itemStack.m_41783_() != null && itemStack.m_41783_().m_128441_(tagName)) {
            long value = itemStack.m_41783_().m_128454_(tagName);
            fn.accept(dummy, value);
        }
    }

    private void applyStringTagToShip(DummyEntity dummy, ItemStack itemStack, String tagName, BiConsumer<DummyEntity, String> fn) {
        if (itemStack.m_41783_() != null && itemStack.m_41783_().m_128441_(tagName)) {
            String value = itemStack.m_41783_().m_128461_(tagName);
            fn.accept(dummy, value);
        }
    }
}

