/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.xenotech.item;

import com.dairymoose.xenotech.XenoTechClient;
import com.dairymoose.xenotech.entity.DummyEntity;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StasisGunItem
extends Item {
    private static final Logger LOGGER = LogManager.getLogger();
    boolean isSingleplayer = false;
    public Map<Player, Integer> lastTargetedEntityIdMap = new HashMap<Player, Integer>();
    public Map<Player, Integer> entityHealthRemainingMap = new HashMap<Player, Integer>();
    public Map<Player, Integer> entityMaxHealthMap = new HashMap<Player, Integer>();

    public StasisGunItem(Item.Properties props) {
        super(props);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> new Runnable(){

            @Override
            public void run() {
                if (Minecraft.m_91087_().m_91091_()) {
                    StasisGunItem.this.isSingleplayer = true;
                }
            }
        });
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void m_7373_(ItemStack itemStack, Level level, List<Component> components, TooltipFlag p_41424_) {
        CompoundTag tag = itemStack.m_41783_();
        if (tag != null && tag.m_128441_("StoredEntity")) {
            Entity stored = null;
            try {
                stored = DummyEntity.entityFromNbt(level, tag);
                components.add((Component)Component.m_237113_((String)("\"" + stored.m_7755_().getString() + "\"")));
                components.add((Component)Component.m_237113_((String)""));
            }
            finally {
                if (stored != null) {
                    stored.m_146870_();
                }
            }
        }
        components.add((Component)Component.m_237115_((String)"xenotech.stasis_gun.tip1"));
        components.add((Component)Component.m_237115_((String)"xenotech.stasis_gun.tip2"));
        super.m_7373_(itemStack, level, components, p_41424_);
    }

    public void processHitResult(Player player, EntityHitResult hitResult) {
        Integer lastTargetedEntityId = -1;
        Integer entityHealthRemaining = -1;
        Integer entityMaxHealth = -1;
        if (hitResult != null) {
            Entity e = hitResult.m_82443_();
            if (e != null && !(e instanceof DummyEntity)) {
                int id = hitResult.m_82443_().m_19879_();
                lastTargetedEntityId = this.lastTargetedEntityIdMap.get(player);
                if (lastTargetedEntityId == null || id != lastTargetedEntityId) {
                    lastTargetedEntityId = id;
                    int healthMult = 3;
                    entityHealthRemaining = 20 * healthMult;
                    entityMaxHealth = 20 * healthMult;
                    if (e instanceof LivingEntity) {
                        LivingEntity living = (LivingEntity)e;
                        entityHealthRemaining = healthMult * (int)(living.m_21223_() + 0.5f);
                        entityMaxHealth = healthMult * (int)(living.m_21233_() + 0.5f);
                    }
                } else {
                    entityHealthRemaining = this.entityHealthRemainingMap.get(player);
                    entityMaxHealth = this.entityMaxHealthMap.get(player);
                }
                int decrementValue = 10;
                if (this.isSingleplayer) {
                    decrementValue = 5;
                }
                if ((entityHealthRemaining = Integer.valueOf(entityHealthRemaining - decrementValue)) < 0) {
                    entityHealthRemaining = 0;
                }
            } else {
                lastTargetedEntityId = -1;
            }
        } else {
            lastTargetedEntityId = -1;
        }
        this.lastTargetedEntityIdMap.put(player, lastTargetedEntityId);
        this.entityHealthRemainingMap.put(player, entityHealthRemaining);
        this.entityMaxHealthMap.put(player, entityMaxHealth);
    }

    public InteractionResult m_6880_(ItemStack itemStack, Player player, LivingEntity livingEntity, InteractionHand hand) {
        return InteractionResult.SUCCESS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entity spawnEntityAtLocation(Level level, ItemStack itemStack, Vec3 location, Predicate<EntityType> predicate) {
        CompoundTag tag = itemStack.m_41783_();
        if (tag != null && tag.m_128441_("StoredEntity")) {
            Entity stored = DummyEntity.entityFromNbt(level, tag);
            try {
                EntityType type = stored.m_6095_();
                if (predicate == null || predicate.test(type)) {
                    stored.m_6095_();
                    Optional created = EntityType.m_20642_((CompoundTag)((CompoundTag)tag.m_128423_("StoredEntity")), (Level)level);
                    if (created.isPresent()) {
                        itemStack.m_41783_().m_128473_("StoredEntity");
                        itemStack.m_41783_().m_128473_("HurtTime");
                        itemStack.m_41783_().m_128473_("EntityTimestamp");
                        ((Entity)created.get()).m_146884_(location);
                        level.m_7967_((Entity)created.get());
                        Entity entity = (Entity)created.get();
                        return entity;
                    }
                }
            }
            finally {
                if (stored != null) {
                    stored.m_146870_();
                }
            }
        }
        return null;
    }

    public InteractionResult m_6225_(UseOnContext ctx) {
        if (!ctx.m_43725_().f_46443_) {
            BlockPos blockPos = ctx.m_8083_();
            BlockState blockState = ctx.m_43725_().m_8055_(blockPos);
            if (ctx.m_43723_().m_6047_()) {
                this.spawnEntityAtLocation(ctx.m_43725_(), ctx.m_43722_(), ctx.m_43720_(), null);
            }
        }
        return super.m_6225_(ctx);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, final InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        if (player.m_6047_()) {
            return InteractionResultHolder.m_19098_((Object)itemStack);
        }
        CompoundTag tag = itemStack.m_41783_();
        if (tag != null && tag.m_128441_("StoredEntity")) {
            return InteractionResultHolder.m_19098_((Object)itemStack);
        }
        Vec3 vec3 = player.m_146892_();
        Vec3 vec31 = player.m_20252_(1.0f);
        Vec3 vec32 = vec3.m_82520_(vec31.f_82479_ * 8.0, vec31.f_82480_ * 8.0, vec31.f_82481_ * 8.0);
        final EntityHitResult entityhitresult = ProjectileUtil.m_150175_((Level)level, (Entity)player, (Vec3)vec3, (Vec3)vec32, (AABB)new AABB(vec3, vec32).m_82400_(6.0), p_156765_ -> !p_156765_.m_5833_(), (float)0.0f);
        if (!level.f_46443_) {
            Entity e;
            if (entityhitresult != null && (e = entityhitresult.m_82443_()) != null && !(e instanceof DummyEntity) && !(e instanceof Player)) {
                this.processHitResult(player, entityhitresult);
                if (this.lastTargetedEntityIdMap.get(player) != null && this.lastTargetedEntityIdMap.get(player) != -1 && this.entityHealthRemainingMap.get(player) <= 0) {
                    this.lastTargetedEntityIdMap.put(player, -1);
                    DummyEntity result = DummyEntity.getEntityForEntityType(level, e.m_20182_(), e);
                    if (result != null) {
                        CompoundTag entityNbtTag = DummyEntity.entityToNbt(e);
                        itemStack.m_41751_(entityNbtTag);
                        e.m_146870_();
                    }
                }
            }
        } else if (entityhitresult != null) {
            this.processHitResult(player, entityhitresult);
            Integer entityId = this.lastTargetedEntityIdMap.get(player);
            Integer hpLeft = this.entityHealthRemainingMap.get(player);
            if (hpLeft != null && hpLeft > 0 && entityId != null && entityId != -1) {
                float pitch = (float)Math.random() * 0.5f + 0.0f;
                player.m_5496_(SoundEvents.f_144242_, 0.5f, pitch);
                DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> new Runnable(){

                    @Override
                    public void run() {
                        if (entityhitresult != null) {
                            XenoTechClient.spellRenderStart = System.currentTimeMillis();
                            XenoTechClient.xInitial = 0.0;
                            XenoTechClient.yInitial = 0.0;
                            XenoTechClient.zInitial = 0.0;
                            XenoTechClient.mirrorSpellRenderX = hand != InteractionHand.MAIN_HAND;
                            XenoTechClient.spellRenderStep = 0L;
                            LOGGER.debug("spellRenderStep = " + XenoTechClient.spellRenderStep);
                        }
                    }
                });
            }
        }
        return InteractionResultHolder.m_19098_((Object)itemStack);
    }
}

