/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.xenotech.item;

import com.dairymoose.xenotech.XenoTechClient;
import com.dairymoose.xenotech.XenoTechCommon;
import com.dairymoose.xenotech.entity.DummyEntity;
import com.mojang.logging.LogUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.slf4j.Logger;

public class TeleportationTransponder
extends Item {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static Map<Long, Long> nextUseTickClientSide = new HashMap<Long, Long>();
    private static final int COOLDOWN_SEC = 10;
    private static final int TICKS_PER_SEC = 20;
    private static final long COOLDOWN_TICKS = 200L;

    public TeleportationTransponder(Item.Properties p_41383_) {
        super(p_41383_);
    }

    public int m_8105_(ItemStack p_41454_) {
        return 40;
    }

    public UseAnim m_6164_(ItemStack p_41452_) {
        return UseAnim.BOW;
    }

    public void m_5929_(Level level, LivingEntity player, ItemStack stack, int count) {
        if (!player.m_9236_().f_46443_ && count % 1 == 0) {
            float pitch = 0.15f * (float)count;
            player.m_9236_().m_5594_(null, player.m_20183_(), SoundEvents.f_215678_, SoundSource.PLAYERS, 1.0f, pitch);
        }
        super.m_5929_(level, player, stack, count);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        DummyEntity carrier = DummyEntity.getDummyEntityForCarried((Entity)player);
        ItemStack itemStack = player.m_21120_(hand);
        boolean hasUniqueIdTag = false;
        boolean hasMatchingTag = false;
        if (itemStack.m_41783_() != null && itemStack.m_41783_().m_128441_("UniqueId")) {
            hasUniqueIdTag = true;
            if (carrier != null && carrier.uniqueId != -1L && itemStack.m_41783_().m_128454_("UniqueId") == carrier.uniqueId) {
                hasMatchingTag = true;
            }
        }
        if (carrier == null || hasUniqueIdTag) {
            boolean canUse = true;
            if (itemStack.m_41783_() != null && itemStack.m_41783_().m_128441_("NextUseTick")) {
                long tickDiff = this.getCooldownTickDiff(level, itemStack);
                if (tickDiff > 0L && tickDiff <= 200L) {
                    canUse = false;
                } else if (!level.f_46443_) {
                    itemStack.m_41783_().m_128473_("NextUseTick");
                }
            }
            if (!level.f_46443_) {
                if (canUse && hasUniqueIdTag) {
                    player.m_6672_(hand);
                }
            } else if (canUse && hasUniqueIdTag) {
                return InteractionResultHolder.m_19096_((Object)itemStack);
            }
            return InteractionResultHolder.m_19098_((Object)itemStack);
        }
        LOGGER.debug("else");
        if (carrier.uniqueId != -1L && !level.f_46443_ && !hasMatchingTag) {
            DummyEntity.TeleportLocation tele = DummyEntity.getTeleportLocationForDummyByUniqueId(level, carrier.uniqueId);
            if (tele != null && tele.loc != null && !tele.digitized) {
                boolean isBadLocation;
                boolean bl = isBadLocation = tele.loc.f_82479_ == 0.0 && tele.loc.f_82480_ == 0.0 && tele.loc.f_82481_ == 0.0;
                if (!isBadLocation) {
                    itemStack.m_41784_().m_128356_("UniqueId", carrier.uniqueId);
                    String shipName = carrier.getShipName();
                    if (shipName != null && !shipName.isBlank() && !shipName.equals("Unnamed")) {
                        itemStack.m_41783_().m_128359_("ShipName", shipName);
                        itemStack.m_41714_((Component)Component.m_237113_((String)("Teleportation Transponder: " + shipName)));
                    }
                    player.m_213846_((Component)Component.m_237113_((String)"Successfully bound transponder to ship"));
                    LOGGER.debug("Bound transponder to ship=" + carrier.uniqueId + " for player=" + player.m_7755_().getString() + " with info=" + tele);
                } else {
                    LOGGER.debug("Failed to bind transponder to ship=" + carrier.uniqueId + " for player=" + player.m_7755_().getString() + " with info=" + tele + " and location=" + tele.loc);
                }
            } else {
                player.m_213846_((Component)Component.m_237113_((String)"Cannot bind transponder to ship: No teleportation module!"));
                LOGGER.debug("Failed to bind transponder to ship=" + carrier.uniqueId + " for player=" + player.m_7755_().getString() + " with info=" + tele + ", no teleporter module?");
            }
        }
        return InteractionResultHolder.m_19098_((Object)itemStack);
    }

    private long getCooldownTickDiff(Level level, ItemStack itemStack) {
        try {
            if (level.f_46443_) {
                Long clientNextUse = nextUseTickClientSide.get(itemStack.m_41783_().m_128454_("UniqueId"));
                if (clientNextUse != null) {
                    return clientNextUse - XenoTechClient.clientTick;
                }
                return 0L;
            }
            long cooldownTicks = itemStack.m_41783_().m_128454_("NextUseTick") - XenoTechCommon.serverTick;
            if (cooldownTicks > 200L) {
                return 0L;
            }
            return cooldownTicks;
        }
        catch (Exception ex) {
            return 0L;
        }
    }

    public ItemStack m_5922_(ItemStack itemStack, Level level, LivingEntity living) {
        if (level.f_46443_) {
            nextUseTickClientSide.put(itemStack.m_41783_().m_128454_("UniqueId"), XenoTechClient.clientTick + 200L);
        }
        if (!level.f_46443_ && itemStack.m_41783_() != null && itemStack.m_41783_().m_128441_("UniqueId")) {
            long uniqueId = itemStack.m_41783_().m_128454_("UniqueId");
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (living instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)living;
                    DummyEntity.TeleportLocation tele = DummyEntity.getTeleportLocationForDummyByUniqueId(level, uniqueId);
                    LOGGER.debug("Use transponder for ship=" + uniqueId + " for player=" + player.m_7755_().getString() + " with info=" + tele);
                    if (tele != null && tele.loc != null && !tele.digitized) {
                        boolean isBadLocation;
                        boolean bl = isBadLocation = tele.loc.f_82479_ == 0.0 && tele.loc.f_82480_ == 0.0 && tele.loc.f_82481_ == 0.0 && tele.destLevel != null;
                        if (!isBadLocation) {
                            Level level2;
                            String shipName;
                            level.m_5594_(null, living.m_20183_(), SoundEvents.f_11852_, SoundSource.PLAYERS, 1.0f, 1.0f);
                            for (int i = 0; i < 35; ++i) {
                                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123810_, living.m_20185_() + (Math.random() - 0.5) * 4.0, living.m_20188_() - 0.1, living.m_20189_() + (Math.random() - 0.5) * 4.0, 1, 0.0, 0.0, 0.0, 1.0);
                            }
                            itemStack.m_41783_().m_128356_("NextUseTick", XenoTechCommon.serverTick + 200L);
                            if (tele.entity != null && (shipName = tele.entity.getShipName()) != null && !shipName.isBlank() && !shipName.equals("Unnamed")) {
                                itemStack.m_41783_().m_128359_("ShipName", shipName);
                                itemStack.m_41714_((Component)Component.m_237113_((String)("Teleportation Transponder: " + shipName)));
                            }
                            if ((level2 = tele.destLevel) instanceof ServerLevel) {
                                ServerLevel destServerLevel = (ServerLevel)level2;
                                player.m_8999_(destServerLevel, tele.loc.f_82479_, tele.loc.f_82480_, tele.loc.f_82481_, tele.yRot, player.m_146909_());
                            }
                            if (tele.entity == null) {
                                player.m_7292_(new MobEffectInstance(MobEffects.f_19620_, 60, 255));
                            } else {
                                tele.entity.refreshCaptureTimestampForPlayer((Entity)player);
                                player.m_7292_(new MobEffectInstance(MobEffects.f_19620_, 20, 255));
                            }
                        }
                    } else if (tele != null && tele.digitized) {
                        player.m_213846_((Component)Component.m_237113_((String)"Ship is currently digitized!"));
                    }
                }
            }
        }
        return super.m_5922_(itemStack, level, living);
    }

    public void m_7373_(ItemStack itemStack, Level p_41422_, List<Component> components, TooltipFlag p_41424_) {
        if (itemStack.m_41783_() != null) {
            if (itemStack.m_41783_().m_128441_("UniqueId")) {
                String shipName = "Unnamed";
                if (itemStack.m_41783_().m_128441_("ShipName")) {
                    shipName = itemStack.m_41783_().m_128461_("ShipName");
                }
                long uniqueId = itemStack.m_41783_().m_128454_("UniqueId");
                components.add((Component)Component.m_237113_((String)("Bound to " + shipName + " (" + uniqueId + ")")));
            }
        } else {
            components.add((Component)Component.m_237113_((String)"Unbound"));
        }
        super.m_7373_(itemStack, p_41422_, components, p_41424_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int m_142158_(ItemStack itemStack) {
        if (itemStack.m_41783_() == null) {
            return 0;
        }
        if (!itemStack.m_41783_().m_128441_("NextUseTick")) {
            return 0;
        }
        long tickDiff = this.getCooldownTickDiff((Level)Minecraft.m_91087_().f_91073_, itemStack);
        if (tickDiff > 200L) {
            return 0;
        }
        float remainPct = (float)tickDiff / 200.0f;
        if (tickDiff <= 0L) {
            return 0;
        }
        int retVal = (int)Math.ceil(remainPct * 13.0f);
        return retVal;
    }

    public boolean m_142522_(ItemStack itemStack) {
        return this.m_142158_(itemStack) > 0;
    }

    public int getMaxStackSize(ItemStack stack) {
        return 1;
    }
}

