/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.xenotech.mixins;

import com.dairymoose.xenotech.entity.DummyEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BlockBehaviour.BlockStateBase.class})
public abstract class BlockStateBaseOnRemoveHeadMixin {
    private static final Logger LOGGER = LogManager.getLogger();

    @Inject(method={"onRemove(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Z)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void adjustOnRemove(Level level, BlockPos pos, BlockState newState, boolean b, CallbackInfo ci) {
        try {
            if (!level.f_46443_ && DummyEntity.assemblyInProgress && DummyEntity.blockPosToRemoveForAssembly.contains(pos)) {
                LOGGER.debug("skip onRemove for oldState=" + newState);
                ci.cancel();
            }
        }
        catch (Exception e) {
            LOGGER.error("adjustOnRemove mixin error", (Throwable)e);
        }
    }
}

