/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.xenotech.mixins;

import com.dairymoose.xenotech.entity.DummyEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundMoveEntityPacket;
import net.minecraft.network.protocol.game.VecDeltaCodec;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ClientboundMoveEntityPacket.class})
public abstract class ClientboundMoveEntityPacketMixin {
    private static final Logger LOGGER = LogManager.getLogger();
    @Shadow
    @Final
    private int f_132499_;
    @Shadow
    @Final
    protected short f_132500_;
    @Shadow
    @Final
    protected short f_132501_;
    @Shadow
    @Final
    protected short f_132502_;

    @Inject(method={"handle"}, at={@At(value="HEAD")}, cancellable=true)
    public void handle(ClientGamePacketListener listener, CallbackInfo cir) {
        if (!DummyEntity.clientControlled) {
            return;
        }
        try {
            ClientPacketListener cpl;
            ClientLevel level;
            if (listener instanceof ClientPacketListener && (level = (cpl = (ClientPacketListener)listener).m_105147_()) != null) {
                Entity e = level.m_6815_(this.f_132499_);
                if (e != null) {
                    float DIST_IGNORE_THRESHOLD = 5.0f;
                    float DIST_IGNORE_THRESHOLD_SQR = DIST_IGNORE_THRESHOLD * DIST_IGNORE_THRESHOLD;
                    VecDeltaCodec vecdeltacodec = e.m_217001_();
                    Vec3 entityNewPos = vecdeltacodec.m_238021_((long)this.f_132500_, (long)this.f_132501_, (long)this.f_132502_);
                    if (e instanceof DummyEntity) {
                        Vec3 entityPositionDifference = entityNewPos.m_82546_(e.m_20182_());
                        double distToNewPosSqr = entityNewPos.m_82557_(e.m_20182_());
                        if (distToNewPosSqr <= (double)DIST_IGNORE_THRESHOLD_SQR || e.m_146895_() != null) {
                            LOGGER.info("DummyEntity CANCEL with position=" + e.m_20182_() + ", newPos=" + entityNewPos + ", diff=" + entityPositionDifference + ", dist=" + Math.sqrt(distToNewPosSqr) + " with id=" + this.f_132499_);
                            cir.cancel();
                        } else {
                            LOGGER.info("DummyEntity relocate to: " + entityNewPos);
                            if (DummyEntity.localPlayerBeingCarriedByDummy) {
                                Vec3 calcPlayerPos = Minecraft.m_91087_().f_91074_.m_20182_().m_82549_(entityPositionDifference);
                                Minecraft.m_91087_().f_91074_.m_20343_(calcPlayerPos.f_82479_, calcPlayerPos.f_82480_, calcPlayerPos.f_82481_);
                            }
                        }
                    } else if (e instanceof DummyEntity && !DummyEntity.localPlayerBeingCarriedByDummy) {
                        LOGGER.trace("DummyEntity proceed due to FALSE for localPlayerBeingCarriedByDummy");
                    }
                }
                if (e instanceof DummyEntity) {
                    DummyEntity dummy = (DummyEntity)e;
                    if (dummy.thisMountedGun != null) {
                        LOGGER.error("Mounted gun moved! ignoring");
                        cir.cancel();
                    }
                }
            }
        }
        catch (Exception ex) {
            LOGGER.error("error during ClientboundPlayerPositionPacketMixin mixin", (Throwable)ex);
        }
    }
}

