/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.xenotech.mixins;

import com.dairymoose.xenotech.XenoTechUtils;
import com.dairymoose.xenotech.entity.DummyEntity;
import com.dairymoose.xenotech.entity.RenderableBlock;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public abstract class EntityMoveMixin {
    private static final Logger LOGGER = LogManager.getLogger();
    boolean stepUpFixHeight = true;
    boolean serverInflateBoundingBoxes = false;
    double serverBoundingBoxInflate = 2.0;
    private static boolean serverChecksPlayerCollisions = false;

    @Shadow
    private Vec3 m_20272_(Vec3 input) {
        return null;
    }

    @Shadow
    private static Vec3 m_198900_(Vec3 p_198901_, AABB p_198902_, List<VoxelShape> p_198903_) {
        return null;
    }

    @Shadow
    protected Vec3 m_5763_(Vec3 p_20019_, MoverType p_20020_) {
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private Vec3 getCollisionResult(Entity e, DummyEntity dummyEntity, Vec3 input, List<VoxelShape> shapes) {
        block11: {
            boundingBox = e.m_20191_();
            zero = new Point2D.Double(0.0, 0.0);
            if (dummyEntity.getYRotDiff() != 0.0f) {
                minY = boundingBox.f_82289_;
                xSize = boundingBox.m_82362_();
                ySize = boundingBox.m_82376_();
                zSize = boundingBox.m_82385_();
                center = boundingBox.m_82399_();
                origin = new Point2D.Double(dummyEntity.m_20185_(), dummyEntity.m_20189_());
                rotCenter = XenoTechUtils.revolve(origin, -dummyEntity.getYRotDiff(), center);
                rx = rotCenter.f_82479_ - xSize / 2.0;
                ry = minY;
                rz = rotCenter.f_82481_ - zSize / 2.0;
                boundingBox = new AABB(rx, ry, rz, rx + xSize, ry + ySize, rz + zSize);
                input = rotatedMoveVec = XenoTechUtils.revolve(zero, -dummyEntity.getYRotDiff(), input);
                DummyEntity.movedEntity = e;
            }
            if (this.serverInflateBoundingBoxes && !e.m_9236_().f_46443_) {
                boundingBox = boundingBox.m_82377_(this.serverBoundingBoxInflate, 0.0, this.serverBoundingBoxInflate);
            }
            if (this.shouldHaltMovementSteppingCarefully(e, input, result = EntityMoveMixin.m_198900_(input, boundingBox, shapes), shapes, boundingBox)) {
                e.m_20334_(0.0, 0.0, 0.0);
                result = new Vec3(0.0, 0.0, 0.0);
                return result;
            }
            if (!DummyEntity.enableStepUp || result.f_82479_ == input.f_82479_ && result.f_82481_ == input.f_82481_) break block11;
            maxStepUp = 0.6f;
            steppedUpResult = null;
            if (e.m_20184_().f_82480_ > 0.0 && e.m_20184_().f_82480_ <= 0.42) ** GOTO lbl-1000
            if (e instanceof Player) {
                p = (Player)e;
                ** if (!p.m_150110_().f_35935_) goto lbl-1000
            }
            ** GOTO lbl-1000
lbl-1000:
            // 2 sources

            {
                v0 = true;
                ** GOTO lbl36
            }
lbl-1000:
            // 2 sources

            {
                v0 = false;
            }
lbl36:
            // 2 sources

            isJumping = v0;
            steppedUpBoundingBox = boundingBox.m_82386_(0.0, (double)maxStepUp, 0.0);
            if (!isJumping) {
                steppedUpResult = EntityMoveMixin.m_198900_(input, steppedUpBoundingBox, shapes);
            }
            if (steppedUpResult != null && steppedUpResult.f_82479_ == input.f_82479_ && steppedUpResult.f_82481_ == input.f_82481_) {
                if (this.stepUpFixHeight) {
                    downwardInput = new Vec3(0.0, -1.0, 0.0);
                    vecToFinalPos = this.calcFinalPosFromStepUpVector(e.m_20182_(), maxStepUp, steppedUpResult);
                    finalPosBb = boundingBox.m_82383_(vecToFinalPos);
                    steppedUpResult = EntityMoveMixin.m_198900_(downwardInput, finalPosBb, shapes);
                    finalLoc = e.m_20182_().m_82549_(vecToFinalPos).m_82549_(steppedUpResult);
                    result = finalLoc.m_82546_(e.m_20182_());
                } else {
                    result = vecToFinalPos = this.calcFinalPosFromStepUpVector(e.m_20182_(), maxStepUp, steppedUpResult);
                }
            }
        }
        if (dummyEntity.getYRotDiff() != 0.0f) {
            result = XenoTechUtils.revolve(zero, dummyEntity.getYRotDiff(), result);
        }
        return this.originalCollide(result);
    }

    private boolean shouldHaltMovementSteppingCarefully(Entity e, Vec3 input, Vec3 collideResult, List<VoxelShape> shapes, AABB boundingBox) {
        block6: {
            DummyEntity carrier;
            block7: {
                if (!e.m_20161_() || !e.m_20096_()) break block6;
                if (!(e instanceof Player)) break block7;
                Player p = (Player)e;
                if (p.m_150110_().f_35935_) break block6;
            }
            if ((carrier = DummyEntity.getDummyEntityForCarried(e)) != null) {
                if (this.hasDropoffForInputVector(input.m_82541_(), shapes, boundingBox, 1.3)) {
                    return true;
                }
                if ((input.f_82479_ != collideResult.f_82479_ || input.f_82481_ != collideResult.f_82481_) && this.hasDropoffForInputVector(collideResult, shapes, boundingBox, 1.5)) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean hasDropoffForInputVector(Vec3 input, List<VoxelShape> shapes, AABB boundingBox, double checkAheadScale) {
        double upwardVal = 0.7;
        double checkDepth = 1.2;
        Vec3 downVector = new Vec3(0.0, -(upwardVal + checkDepth), 0.0);
        Vec3 rotVec = input;
        Vec3 bbMove = new Vec3(rotVec.f_82479_ * checkAheadScale, upwardVal, rotVec.f_82481_ * checkAheadScale);
        Vec3 simulated = EntityMoveMixin.m_198900_(downVector, boundingBox.m_82383_(bbMove), shapes);
        return simulated.f_82479_ == downVector.f_82479_ && simulated.f_82480_ == downVector.f_82480_ && simulated.f_82481_ == downVector.f_82481_;
    }

    private Vec3 calcFinalPosFromStepUpVector(Vec3 startPos, float heightBoost, Vec3 steppedUpResult) {
        Vec3 desiredFinalPos = startPos.m_82520_(0.0, (double)heightBoost, 0.0).m_82549_(steppedUpResult);
        Vec3 vecToFinalPos = desiredFinalPos.m_82546_(startPos);
        return vecToFinalPos;
    }

    @Redirect(method={"move"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;maybeBackOffFromEdge(Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/entity/MoverType;)Lnet/minecraft/world/phys/Vec3;", ordinal=0))
    private Vec3 adjustMaybeBackOffFromEdge(Entity e, Vec3 input, MoverType moverType) {
        if (e instanceof Player) {
            Player p = (Player)e;
            DummyEntity carrier = DummyEntity.getDummyEntityForCarried(e);
            if (carrier != null && p.m_20161_()) {
                return input;
            }
        }
        return this.m_5763_(input, moverType);
    }

    private Vec3 originalCollide(Vec3 p_20273_) {
        Entity e = (Entity)this;
        AABB aabb = e.m_20191_();
        List list = e.m_9236_().m_183134_(e, aabb.m_82369_(p_20273_));
        Vec3 vec3 = p_20273_.m_82556_() == 0.0 ? p_20273_ : Entity.m_198894_((Entity)e, (Vec3)p_20273_, (AABB)aabb, (Level)e.m_9236_(), (List)list);
        boolean flag = p_20273_.f_82479_ != vec3.f_82479_;
        boolean flag1 = p_20273_.f_82480_ != vec3.f_82480_;
        boolean flag2 = p_20273_.f_82481_ != vec3.f_82481_;
        boolean flag3 = e.m_20096_() || flag1 && p_20273_.f_82480_ < 0.0;
        float stepHeight = e.getStepHeight();
        if (stepHeight > 0.0f && flag3 && (flag || flag2)) {
            Vec3 vec31 = Entity.m_198894_((Entity)e, (Vec3)new Vec3(p_20273_.f_82479_, (double)stepHeight, p_20273_.f_82481_), (AABB)aabb, (Level)e.m_9236_(), (List)list);
            Vec3 vec32 = Entity.m_198894_((Entity)e, (Vec3)new Vec3(0.0, (double)stepHeight, 0.0), (AABB)aabb.m_82363_(p_20273_.f_82479_, 0.0, p_20273_.f_82481_), (Level)e.m_9236_(), (List)list);
            if (vec32.f_82480_ < (double)stepHeight) {
                Vec3 vec33 = Entity.m_198894_((Entity)e, (Vec3)new Vec3(p_20273_.f_82479_, 0.0, p_20273_.f_82481_), (AABB)aabb.m_82383_(vec32), (Level)e.m_9236_(), (List)list).m_82549_(vec32);
                if (vec33.m_165925_() > vec31.m_165925_()) {
                    vec31 = vec33;
                }
            }
            if (vec31.m_165925_() > vec3.m_165925_()) {
                return vec31.m_82549_(Entity.m_198894_((Entity)e, (Vec3)new Vec3(0.0, -vec31.f_82480_ + p_20273_.f_82480_, 0.0), (AABB)aabb.m_82383_(vec31), (Level)e.m_9236_(), (List)list));
            }
        }
        return vec3;
    }

    @Inject(method={"Lnet/minecraft/world/entity/Entity;collide(Lnet/minecraft/world/phys/Vec3;)Lnet/minecraft/world/phys/Vec3;"}, at={@At(value="HEAD")}, cancellable=true)
    private void adjustCollide(Vec3 input, CallbackInfoReturnable<Vec3> ci) {
        Entity e = (Entity)this;
        if (!DummyEntity.playerTemporarilyIgnoreCollision && input.m_82556_() != 0.0) {
            DummyEntity closest = null;
            DummyEntity carrier = DummyEntity.getDummyEntityForCarried(e);
            closest = carrier == null ? DummyEntity.getNearestDummyEntityConsideringBoundingBox(e) : carrier;
            boolean localPlayerCondition = e instanceof Player && e.m_9236_().f_46443_;
            boolean remoteNonPlayerCondition = !(e instanceof Player) && !e.m_9236_().f_46443_ || e instanceof Player && serverChecksPlayerCollisions;
            DummyEntity dummyEntity = closest;
            if (dummyEntity != null && (localPlayerCondition || remoteNonPlayerCondition)) {
                if (e.m_9236_().f_46443_) {
                    DummyEntity.movedEntity = null;
                }
                ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
                try {
                    boolean nearby;
                    if (dummyEntity != null && !dummyEntity.m_213877_() && (e instanceof Player || !(e instanceof Player) && dummyEntity.carried.contains(e.m_19879_())) && (nearby = dummyEntity.entityIsNearby(e))) {
                        List<RenderableBlock> renderables;
                        if (e instanceof LivingEntity) {
                            LivingEntity living = (LivingEntity)e;
                            if (carrier != null && (input.f_82479_ != 0.0 || input.f_82481_ != 0.0)) {
                                living.m_21195_(MobEffects.f_19620_);
                            }
                        }
                        if ((renderables = dummyEntity.renderables) != null && !renderables.isEmpty()) {
                            XenoTechUtils.getCollisionShapesForDummy(e, dummyEntity, shapes, renderables);
                            Vec3 ret = this.getCollisionResult(e, dummyEntity, input, shapes);
                            ci.setReturnValue((Object)ret);
                            ci.cancel();
                        } else {
                            if (e instanceof Player) {
                                LOGGER.debug("not carried");
                            }
                            if (dummyEntity != null && dummyEntity.m_213877_()) {
                                LOGGER.trace("lastDummy is removed");
                            }
                        }
                    }
                }
                catch (Exception ex) {
                    LOGGER.error("EntityMoveMixin mixin error", (Throwable)ex);
                }
            }
        }
    }
}

