/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.xenotech.mixins;

import com.dairymoose.xenotech.entity.DummyEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={ClientPacketListener.class})
public abstract class HandleMoveEntityMixin {
    private static final Logger LOGGER = LogManager.getLogger();

    @Redirect(method={"handleMoveEntity"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;lerpTo(DDDFFIZ)V", ordinal=0))
    public void lerpTo(Entity entity, double x, double y, double z, float yRot, float xRot, int p_19901_, boolean p_19902_) {
        try {
            if (entity instanceof DummyEntity && DummyEntity.localPlayerBeingCarriedByDummy) {
                double xDiff = x - entity.m_20185_();
                double yDiff = y - entity.m_20186_();
                double zDiff = z - entity.m_20189_();
                if (xDiff != 0.0 || yDiff != 0.0 || zDiff != 0.0) {
                    if (yDiff != 0.0) {
                        LOGGER.debug("lerp player, yDiff=" + yDiff);
                        Vec3 vec3 = new Vec3(Minecraft.m_91087_().f_91074_.m_20185_(), Minecraft.m_91087_().f_91074_.m_20186_() + Math.abs(yDiff), Minecraft.m_91087_().f_91074_.m_20189_());
                    }
                    Vec3 beforeDistance = Minecraft.m_91087_().f_91074_.m_20182_().m_82546_(entity.m_20182_());
                    LOGGER.info("lerp player, yDiff=" + yDiff);
                    Vec3 newPos = new Vec3(x + beforeDistance.f_82479_, y + beforeDistance.f_82480_, z + beforeDistance.f_82481_);
                    Minecraft.m_91087_().f_91074_.m_146884_(newPos);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("lerpTo mixin error", (Throwable)e);
        }
        entity.m_6453_(x, y, z, yRot, xRot, p_19901_, p_19902_);
    }
}

