/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.xenotech.mixins;

import com.dairymoose.xenotech.entity.DummyEntity;
import com.dairymoose.xenotech.entity.RenderableBlock;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={LevelChunk.class})
public class LevelChunkFakeBlockMixin {
    private static final Logger LOGGER = LogManager.getLogger();

    @Redirect(method={"setBlockState"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/chunk/LevelChunk;getBlockEntity(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/chunk/LevelChunk$EntityCreationType;)Lnet/minecraft/world/level/block/entity/BlockEntity;", ordinal=0))
    public BlockEntity handleGetBlockEntity(LevelChunk levelChunk, BlockPos blockPos, LevelChunk.EntityCreationType creationType) {
        if (DummyEntity.doBlockEntityOverride) {
            LOGGER.debug("check at blockPos=" + blockPos);
            List<DummyEntity> dummies = DummyEntity.getAllDummies(levelChunk.m_62953_());
            for (DummyEntity dummy : dummies) {
                RenderableBlock renderable;
                if (dummy.disassemblyInProgress) continue;
                if (DummyEntity.assemblyInProgress || (renderable = dummy.renderableLookup.get(blockPos)) == null) continue;
                LOGGER.debug("got match at blockPos=" + blockPos);
                return renderable.tempBlockEntity;
            }
        }
        return levelChunk.m_5685_(blockPos, creationType);
    }
}

