/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.xenotech.mixins;

import com.dairymoose.xenotech.BlockEntityUtils;
import com.dairymoose.xenotech.XenoTechUtils;
import com.dairymoose.xenotech.entity.DummyEntity;
import com.dairymoose.xenotech.entity.RenderableBlock;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={Level.class})
public class LevelFakeBlockMixin {
    private static final Logger LOGGER = LogManager.getLogger();

    @Redirect(method={"getBlockState"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/chunk/LevelChunk;getBlockState (Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/level/block/state/BlockState;", ordinal=0))
    public BlockState handleGetBlockState(LevelChunk levelChunk, BlockPos blockPos) {
        if (DummyEntity.doBlockStateOverride && (!levelChunk.m_62953_().f_46443_ || DummyEntity.showBlockStateOverridesOnClient)) {
            List<DummyEntity> dummies = DummyEntity.getAllDummies(levelChunk.m_62953_());
            for (DummyEntity dummy : dummies) {
                RenderableBlock renderable;
                if (dummy.disassemblyCheckInProgress || dummy.disassemblyInProgress || (renderable = dummy.renderableLookup.get(blockPos)) == null) continue;
                LOGGER.debug("got match at blockPos=" + blockPos);
                BlockEntityUtils.populateBlockEntity(renderable, levelChunk.m_62953_(), blockPos);
                BlockState rotated = XenoTechUtils.getRotatedBlockState(dummy, renderable);
                return rotated;
            }
        }
        return levelChunk.m_8055_(blockPos);
    }

    @Redirect(method={"getBlockEntity"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/chunk/LevelChunk;getBlockEntity(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/chunk/LevelChunk$EntityCreationType;)Lnet/minecraft/world/level/block/entity/BlockEntity;", ordinal=0))
    public BlockEntity handleGetBlockEntity(LevelChunk levelChunk, BlockPos blockPos, LevelChunk.EntityCreationType creationType) {
        if (DummyEntity.doBlockEntityOverride) {
            List<DummyEntity> dummies = DummyEntity.getAllDummies(levelChunk.m_62953_());
            for (DummyEntity dummy : dummies) {
                RenderableBlock renderable;
                if (dummy.disassemblyInProgress) continue;
                if (DummyEntity.assemblyInProgress || (renderable = dummy.renderableLookup.get(blockPos)) == null) continue;
                LOGGER.debug("got match at blockPos=" + blockPos);
                return renderable.tempBlockEntity;
            }
        }
        return levelChunk.m_5685_(blockPos, creationType);
    }
}

