/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.xenotech.mixins;

import com.dairymoose.xenotech.entity.DummyEntity;
import com.dairymoose.xenotech.entity.RenderableBlock;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Level.class})
public abstract class LevelGetFluidStateMixin {
    private static final Logger LOGGER = LogManager.getLogger();

    @Inject(method={"Lnet/minecraft/world/level/Level;getFluidState(Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/level/material/FluidState;"}, at={@At(value="HEAD")}, cancellable=true)
    public void adjustgetFluidState(BlockPos blockPos, CallbackInfoReturnable<FluidState> cir) {
        List<DummyEntity> dummies = DummyEntity.getAllDummies((Level)this);
        for (DummyEntity dummy : dummies) {
            RenderableBlock renderable;
            if (dummy.vehicleType != DummyEntity.VehicleType.SUBMARINE || (renderable = dummy.renderableLookup.get(blockPos)) == null) continue;
            cir.setReturnValue((Object)Fluids.f_76191_.m_76145_());
            cir.cancel();
        }
    }
}

