/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.xenotech.mixins;

import com.dairymoose.xenotech.entity.DummyEntity;
import com.dairymoose.xenotech.entity.RenderableBlock;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={Level.class})
public class LevelSetBlockMixin {
    private static final Logger LOGGER = LogManager.getLogger();

    @Redirect(method={"setBlock"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;setBlock(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;II)Z", ordinal=0))
    public boolean adjustSetBlock(Level level, BlockPos blockPos, BlockState state, int i, int x) {
        if (DummyEntity.doSetBlockOverride) {
            List<DummyEntity> dummies = DummyEntity.getAllDummies(level);
            for (DummyEntity dummy : dummies) {
                RenderableBlock renderable;
                if (dummy.disassemblyInProgress || (renderable = dummy.renderableLookup.get(blockPos)) == null) continue;
                String incomingMod = ForgeRegistries.BLOCKS.getKey((Object)state.m_60734_()).m_135827_();
                String renderableMod = ForgeRegistries.BLOCKS.getKey((Object)renderable.state.m_60734_()).m_135827_();
                if ((state.m_60734_() == renderable.state.m_60734_() || i != 11 && !"minecraft".equals(incomingMod) && incomingMod.length() == renderableMod.length() && incomingMod.equals(renderableMod)) && !(state.m_60734_() instanceof BedBlock)) {
                    LOGGER.debug("set renderable to new state: " + state + " from old state: " + renderable.state + " with i/x=" + i + "," + x + " with namespace=" + incomingMod);
                    renderable.state = state;
                    return true;
                }
                if (!level.f_46443_ && !state.m_155947_()) continue;
                LOGGER.debug("return client side for state=" + renderable.state + " with i/x=" + i + "," + x + " with namespace=" + incomingMod);
                return true;
            }
        }
        return level.m_6933_(blockPos, state, i, x);
    }
}

