/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.xenotech.mixins;

import com.dairymoose.xenotech.entity.DummyEntity;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityEyeHeightMixin {
    private static final Logger LOGGER = LogManager.getLogger();

    @Shadow
    protected abstract float m_6431_(Pose var1, EntityDimensions var2);

    @Inject(method={"Lnet/minecraft/world/entity/LivingEntity;getEyeHeight(Lnet/minecraft/world/entity/Pose;Lnet/minecraft/world/entity/EntityDimensions;)F"}, at={@At(value="HEAD")}, cancellable=true)
    private void adjustGetEyeHeight(Pose pose, EntityDimensions dim, CallbackInfoReturnable<Float> cir) {
        LivingEntity living = (LivingEntity)this;
        DummyEntity carrier = DummyEntity.getDummyEntityForCarried((Entity)living);
        Entity entity = living.m_275832_();
        if (entity instanceof DummyEntity) {
            DummyEntity dummy;
            carrier = dummy = (DummyEntity)entity;
        }
        if (carrier != null && pose != Pose.SLEEPING) {
            Vec3 carrierPos = carrier.m_20182_();
            Vec3 livingPos = living.m_20182_();
            Vec3 posDiff = carrierPos.m_82546_(livingPos);
            float noseTilt = Math.abs(carrier.noseTilt);
            if (!carrier.speedVectorIsPositive) {
                noseTilt = -noseTilt;
            }
            float addedHeight = (float)(posDiff.m_165924_() * (double)Mth.m_14031_((float)((float)Math.PI / 180 * noseTilt)));
            float ret = this.m_6431_(pose, dim) + addedHeight;
            cir.setReturnValue((Object)Float.valueOf(ret));
            cir.cancel();
        }
    }
}

