/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.xenotech.mixins;

import com.dairymoose.xenotech.CollisionUtils;
import com.dairymoose.xenotech.XenoTechUtils;
import com.dairymoose.xenotech.entity.DummyEntity;
import com.dairymoose.xenotech.entity.RenderableBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownEnderpearl;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Projectile.class})
public abstract class ProjectileCollisionMixin
extends Entity {
    private static final Logger LOGGER = LogManager.getLogger();
    private double inflationAmount = 0.0;

    public ProjectileCollisionMixin(EntityType<?> p_19870_, Level p_19871_) {
        super(p_19870_, p_19871_);
    }

    @Redirect(method={"tick"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;tick()V", ordinal=0))
    private void adjustSuperTick(Entity e) {
        DummyEntity nearest;
        if (!e.m_9236_().f_46443_ && DummyEntity.killProjectilesUsingMixin && !e.m_213877_() && (nearest = DummyEntity.getNearestDummyEntityConsideringBoundingBox(e)) != null) {
            Vec3 arrowPos = this.m_20182_();
            BlockPos blockPos = this.m_20183_();
            Vec3 viewVec = this.m_20252_(1.0f);
            double negScale = 0.0;
            double posScale = 0.0;
            double scaleInc = 1.0;
            BlockPos northPos = blockPos.m_122012_();
            BlockPos eastPos = blockPos.m_122029_();
            BlockPos southPos = blockPos.m_122019_();
            BlockPos westPos = blockPos.m_122024_();
            BlockPos upPos = blockPos.m_7494_();
            BlockPos downPos = blockPos.m_7495_();
            int w = 3;
            int h = 3;
            boolean collide = false;
            for (int x = -(w / 2); x <= w / 2; ++x) {
                for (int z = -(w / 2); z <= w / 2; ++z) {
                    for (int y = -(h / 2); y <= h / 2; ++y) {
                        if (!this.checkForProjectileCollision(nearest, arrowPos, blockPos.m_122030_(x).m_122013_(z).m_6630_(y))) continue;
                        collide = true;
                        break;
                    }
                    if (collide) break;
                }
                if (collide) break;
            }
        }
        super.m_8119_();
    }

    private boolean checkForProjectileCollision(DummyEntity nearest, Vec3 arrowPos, BlockPos blockPos) {
        if (this.m_213877_()) {
            return true;
        }
        if ((Projectile)this instanceof ThrownEnderpearl) {
            return false;
        }
        RenderableBlock lookup = nearest.renderableLookup.get(blockPos);
        if (lookup != null) {
            VoxelShape shape = lookup.state.m_60812_((BlockGetter)this.m_9236_(), blockPos);
            if (lookup.state.m_60734_() instanceof DoorBlock && ((Boolean)lookup.state.m_61143_((Property)DoorBlock.f_52727_)).booleanValue()) {
                return false;
            }
            if (!shape.m_83281_()) {
                for (AABB aabb : shape.m_83299_()) {
                    AABB arrowBb = this.m_20191_();
                    double xzInflation = 0.2;
                    arrowBb = arrowBb.m_82377_(0.0, -arrowBb.m_82376_() / 4.0, 0.0);
                    arrowBb = arrowBb.m_82377_(arrowBb.m_82362_() * xzInflation, 0.0, arrowBb.m_82385_() * xzInflation);
                    aabb = aabb.m_82386_(-aabb.m_82362_() / 2.0, 0.0, -aabb.m_82385_() / 2.0);
                    Vec3 rotPos = XenoTechUtils.getRotPosForRenderable(nearest, lookup);
                    rotPos = new Vec3(rotPos.f_82479_ + 0.5, rotPos.f_82480_, rotPos.f_82481_ + 0.5);
                    AABB toRotate = aabb.m_82383_(rotPos);
                    LOGGER.trace("Projectile check for state=" + lookup.state + " at rotPos=" + rotPos + " and original BB=" + aabb);
                    boolean intersect = CollisionUtils.rotatedIntersects(nearest.getYRotDiff(), toRotate, arrowBb, rotPos);
                    if (!intersect || DummyEntity.blacklistedProjectileKillEntities.contains(ForgeRegistries.ENTITY_TYPES.getKey((Object)this.m_6095_()).toString())) continue;
                    LOGGER.error("Projectile killed: " + this + " by dummy=" + nearest + " from state=" + lookup.state);
                    Projectile projectile = (Projectile)this;
                    if (projectile instanceof AbstractArrow) {
                        AbstractArrow aa = (AbstractArrow)projectile;
                        this.m_6074_();
                    } else {
                        this.m_6074_();
                    }
                    return true;
                }
            }
        }
        return false;
    }

    @Inject(method={"shootFromRotation"}, at={@At(value="HEAD")}, cancellable=false)
    private void adjustShootFromRotation(Entity e, float p_37253_, float p_37254_, float p_37255_, float p_37256_, float p_37257_, CallbackInfo ci) {
        DummyEntity carrier = DummyEntity.getDummyEntityForCarried(e);
        if (carrier != null) {
            e.m_6853_(true);
        }
    }
}

