/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.xenotech.mixins;

import com.dairymoose.xenotech.block.SnowBlockerBlock;
import com.dairymoose.xenotech.world.level.block.entity.SnowBlockerBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.IceBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={ServerLevel.class})
public class ServerLevelSnowBlockerMixin {
    private static final Logger LOGGER = LogManager.getLogger();

    @Redirect(method={"tickChunk"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerLevel;setBlockAndUpdate(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)Z", ordinal=-1))
    public boolean handleSetBlockAndUpdate(ServerLevel serverLevel, BlockPos blockPos, BlockState blockState) {
        if (blockState != null && (blockState.m_60734_() instanceof SnowLayerBlock || blockState.m_60734_() instanceof IceBlock) && SnowBlockerBlockEntity.snowBlockers != null) {
            for (SnowBlockerBlockEntity snowBlocker : SnowBlockerBlockEntity.snowBlockers) {
                BlockPos snowBlockerPos = snowBlocker.m_58899_();
                if (!serverLevel.isAreaLoaded(snowBlockerPos, 1)) continue;
                int snowBlockerRadius = SnowBlockerBlock.snowBlockerRadius;
                int snowBlockerRadiusSqr = snowBlockerRadius * snowBlockerRadius;
                if (!(blockPos.m_123331_((Vec3i)snowBlockerPos) <= (double)snowBlockerRadiusSqr)) continue;
                return true;
            }
        }
        return serverLevel.m_46597_(blockPos, blockState);
    }
}

