/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.xenotech.network;

import com.dairymoose.xenotech.entity.DummyEntity;
import com.dairymoose.xenotech.entity.RenderableBlock;
import java.util.function.Supplier;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClientboundBlockEntitySyncPacket
implements Packet<ClientGamePacketListener> {
    private int dummyId;
    private BlockPos pos;
    private CompoundTag tag;
    private static final Logger LOGGER = LogManager.getLogger();

    public ClientboundBlockEntitySyncPacket() {
    }

    public ClientboundBlockEntitySyncPacket(DummyEntity dummy, BlockPos pos, CompoundTag tag) {
        Integer dummyId = null;
        dummyId = dummy == null ? Integer.valueOf(0) : Integer.valueOf(dummy.m_19879_());
        this.dummyId = dummyId;
        this.pos = pos;
        this.tag = tag;
    }

    public ClientboundBlockEntitySyncPacket(FriendlyByteBuf buffer) {
        this.read(buffer);
    }

    public void read(FriendlyByteBuf buffer) {
        this.dummyId = buffer.readInt();
        this.pos = buffer.m_130135_();
        this.tag = buffer.m_130260_();
    }

    public void m_5779_(FriendlyByteBuf buffer) {
        buffer.writeInt(this.dummyId);
        buffer.m_130064_(this.pos);
        buffer.m_130079_(this.tag);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> this.handle((ClientGamePacketListener)((NetworkEvent.Context)ctx.get()).getNetworkManager().m_129538_()));
        ctx.get().setPacketHandled(true);
    }

    public void handle(final ClientGamePacketListener handler) {
        LOGGER.trace("Handle ClientboundBlockEntitySyncPacket");
        if (handler instanceof ClientPacketListener) {
            DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> new Runnable(){

                @Override
                public void run() {
                    ClientPacketListener clientHandler = (ClientPacketListener)handler;
                    ClientLevel world = clientHandler.m_105147_();
                    Entity e = world.m_6815_(ClientboundBlockEntitySyncPacket.this.dummyId);
                    if (e instanceof DummyEntity) {
                        DummyEntity dummy = (DummyEntity)e;
                        for (RenderableBlock renderable : dummy.renderables) {
                            if (!renderable.pos.equals((Object)ClientboundBlockEntitySyncPacket.this.pos)) continue;
                            if (renderable.tempBlockEntity != null) {
                                renderable.tempBlockEntity.handleUpdateTag(ClientboundBlockEntitySyncPacket.this.tag);
                            }
                            return;
                        }
                    } else {
                        LOGGER.debug("Failed to find valid-typed client-side entity with id=" + ClientboundBlockEntitySyncPacket.this.dummyId);
                    }
                }
            });
        }
    }
}

