/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.xenotech.network;

import com.dairymoose.xenotech.XenoTechClient;
import com.dairymoose.xenotech.world.level.block.entity.MountedGunBlockEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClientboundBulletHoleArrayPacket
implements Packet<ClientGamePacketListener> {
    private List<SingleBulletHole> bulletHoles;
    private static final Logger LOGGER = LogManager.getLogger();

    public ClientboundBulletHoleArrayPacket() {
    }

    public ClientboundBulletHoleArrayPacket(FriendlyByteBuf buffer) {
        this.read(buffer);
    }

    public ClientboundBulletHoleArrayPacket(List<SingleBulletHole> bulletHoles) {
        this.bulletHoles = bulletHoles;
    }

    public void read(FriendlyByteBuf byteBuf) {
        int size = byteBuf.readInt();
        this.bulletHoles = new ArrayList<SingleBulletHole>();
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                SingleBulletHole sbh = new SingleBulletHole();
                sbh.playerId = byteBuf.readInt();
                sbh.x = byteBuf.readDouble();
                sbh.y = byteBuf.readDouble();
                sbh.z = byteBuf.readDouble();
                sbh.pos = byteBuf.m_130135_();
                sbh.holeNo = byteBuf.readInt();
                sbh.facing = Direction.m_122376_((int)byteBuf.readInt());
                sbh.dim = byteBuf.m_130277_();
                this.bulletHoles.add(sbh);
            }
        }
    }

    public void m_5779_(FriendlyByteBuf byteBuf) {
        int size = 0;
        if (this.bulletHoles != null) {
            size = this.bulletHoles.size();
        }
        byteBuf.writeInt(size);
        for (int i = 0; i < size; ++i) {
            SingleBulletHole sbh = this.bulletHoles.get(i);
            byteBuf.writeInt(sbh.playerId);
            byteBuf.writeDouble(sbh.x);
            byteBuf.writeDouble(sbh.y);
            byteBuf.writeDouble(sbh.z);
            byteBuf.m_130064_(sbh.pos);
            byteBuf.writeInt(sbh.holeNo);
            byteBuf.writeInt(sbh.facing.m_122411_());
            byteBuf.m_130070_(sbh.dim);
        }
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> this.handle((ClientGamePacketListener)((NetworkEvent.Context)ctx.get()).getNetworkManager().m_129538_()));
        ctx.get().setPacketHandled(true);
    }

    public void handle(final ClientGamePacketListener handler) {
        LOGGER.trace("Handle ClientboundBulletHoleArrayPacket");
        if (handler instanceof ClientPacketListener) {
            DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> new Runnable(){

                @Override
                public void run() {
                    if (ClientboundBulletHoleArrayPacket.this.bulletHoles != null) {
                        for (int i = 0; i < ClientboundBulletHoleArrayPacket.this.bulletHoles.size(); ++i) {
                            SingleBulletHole sbh = ClientboundBulletHoleArrayPacket.this.bulletHoles.get(i);
                            this.processBulletHole(handler, sbh);
                        }
                    }
                }

                public void processBulletHole(ClientGamePacketListener handler2, SingleBulletHole sbh) {
                    Player Player2;
                    ClientPacketListener clientHandler = (ClientPacketListener)handler2;
                    ClientLevel world = clientHandler.m_105147_();
                    Entity e = world.m_6815_(sbh.playerId);
                    if (e instanceof Player && (Player2 = (Player)e).m_19879_() != Minecraft.m_91087_().f_91074_.m_19879_()) {
                        MountedGunBlockEntity.firingTickMap.put(Player2, 6);
                    }
                    XenoTechClient.BulletHoleInfo bulletHole = new XenoTechClient.BulletHoleInfo();
                    bulletHole.dim = sbh.dim;
                    bulletHole.facing = sbh.facing;
                    bulletHole.holeNo = sbh.holeNo;
                    bulletHole.loc = new Vec3(sbh.x, sbh.y, sbh.z);
                    bulletHole.pos = sbh.pos;
                    bulletHole.timestamp = System.currentTimeMillis();
                    XenoTechClient.bulletHoles.add(bulletHole);
                }
            });
        }
    }

    public static class SingleBulletHole {
        public int playerId;
        public double x;
        public double y;
        public double z;
        public BlockPos pos;
        public int holeNo;
        public Direction facing;
        public String dim;
    }
}

