/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.xenotech.network;

import com.dairymoose.xenotech.XenoTechClient;
import com.dairymoose.xenotech.world.level.block.entity.MountedGunBlockEntity;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClientboundBulletHolePacket
implements Packet<ClientGamePacketListener> {
    private int playerId;
    private double x;
    private double y;
    private double z;
    private BlockPos pos;
    private int holeNo;
    private Direction facing;
    private String dim;
    private static final Logger LOGGER = LogManager.getLogger();

    public ClientboundBulletHolePacket() {
    }

    public ClientboundBulletHolePacket(FriendlyByteBuf buffer) {
        this.read(buffer);
    }

    public ClientboundBulletHolePacket(int playerId, Vec3 vec, BlockPos pos, int holeNo, Direction facing, String dim) {
        this.playerId = playerId;
        this.x = vec.f_82479_;
        this.y = vec.f_82480_;
        this.z = vec.f_82481_;
        this.pos = pos;
        this.holeNo = holeNo;
        this.facing = facing;
        this.dim = dim;
    }

    public void read(FriendlyByteBuf p_148837_1_) {
        this.playerId = p_148837_1_.readInt();
        this.x = p_148837_1_.readDouble();
        this.y = p_148837_1_.readDouble();
        this.z = p_148837_1_.readDouble();
        this.pos = p_148837_1_.m_130135_();
        this.holeNo = p_148837_1_.readInt();
        this.facing = Direction.m_122376_((int)p_148837_1_.readInt());
        this.dim = p_148837_1_.m_130277_();
    }

    public void m_5779_(FriendlyByteBuf p_148840_1_) {
        p_148840_1_.writeInt(this.playerId);
        p_148840_1_.writeDouble(this.x);
        p_148840_1_.writeDouble(this.y);
        p_148840_1_.writeDouble(this.z);
        p_148840_1_.m_130064_(this.pos);
        p_148840_1_.writeInt(this.holeNo);
        p_148840_1_.writeInt(this.facing.m_122411_());
        p_148840_1_.m_130070_(this.dim);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> this.handle((ClientGamePacketListener)((NetworkEvent.Context)ctx.get()).getNetworkManager().m_129538_()));
        ctx.get().setPacketHandled(true);
    }

    public void handle(final ClientGamePacketListener handler) {
        LOGGER.trace("Handle ClientboundBulletHolePacket");
        if (handler instanceof ClientPacketListener) {
            DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> new Runnable(){

                @Override
                public void run() {
                    Player Player2;
                    ClientPacketListener clientHandler = (ClientPacketListener)handler;
                    ClientLevel world = clientHandler.m_105147_();
                    Entity e = world.m_6815_(ClientboundBulletHolePacket.this.playerId);
                    if (e instanceof Player && (Player2 = (Player)e).m_19879_() != Minecraft.m_91087_().f_91074_.m_19879_()) {
                        MountedGunBlockEntity.firingTickMap.put(Player2, 6);
                    }
                    XenoTechClient.BulletHoleInfo bulletHole = new XenoTechClient.BulletHoleInfo();
                    bulletHole.dim = ClientboundBulletHolePacket.this.dim;
                    bulletHole.facing = ClientboundBulletHolePacket.this.facing;
                    bulletHole.holeNo = ClientboundBulletHolePacket.this.holeNo;
                    bulletHole.loc = new Vec3(ClientboundBulletHolePacket.this.x, ClientboundBulletHolePacket.this.y, ClientboundBulletHolePacket.this.z);
                    bulletHole.pos = ClientboundBulletHolePacket.this.pos;
                    bulletHole.timestamp = System.currentTimeMillis();
                    XenoTechClient.bulletHoles.add(bulletHole);
                }
            });
        }
    }
}

