/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.xenotech.network;

import com.dairymoose.xenotech.entity.DummyEntity;
import com.dairymoose.xenotech.entity.RenderableBlock;
import com.dairymoose.xenotech.world.level.block.entity.MountedGunBlockEntity;
import java.util.function.Supplier;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClientboundGunMountPacket
implements Packet<ClientGamePacketListener> {
    private int dummyId;
    private int carrierId;
    private BlockPos pos;
    private boolean renderablePos;
    private static final Logger LOGGER = LogManager.getLogger();

    public ClientboundGunMountPacket() {
    }

    public ClientboundGunMountPacket(DummyEntity dummy, DummyEntity carrier, BlockPos pos, boolean renderablePos) {
        Integer dummyId = null;
        dummyId = dummy == null ? Integer.valueOf(0) : Integer.valueOf(dummy.m_19879_());
        this.dummyId = dummyId;
        Integer carrierId = null;
        carrierId = carrier == null ? Integer.valueOf(0) : Integer.valueOf(carrier.m_19879_());
        this.carrierId = carrierId;
        this.pos = pos;
        this.renderablePos = renderablePos;
    }

    public ClientboundGunMountPacket(FriendlyByteBuf buffer) {
        this.read(buffer);
    }

    public void read(FriendlyByteBuf buffer) {
        this.dummyId = buffer.readInt();
        this.carrierId = buffer.readInt();
        this.pos = buffer.m_130135_();
        this.renderablePos = buffer.readBoolean();
    }

    public void m_5779_(FriendlyByteBuf buffer) {
        buffer.writeInt(this.dummyId);
        buffer.writeInt(this.carrierId);
        buffer.m_130064_(this.pos);
        buffer.writeBoolean(this.renderablePos);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> this.handle((ClientGamePacketListener)((NetworkEvent.Context)ctx.get()).getNetworkManager().m_129538_()));
        ctx.get().setPacketHandled(true);
    }

    public void handle(final ClientGamePacketListener handler) {
        LOGGER.debug("Handle ClientboundGunMountPacket");
        if (handler instanceof ClientPacketListener) {
            DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> new Runnable(){

                @Override
                public void run() {
                    ClientPacketListener clientHandler = (ClientPacketListener)handler;
                    ClientLevel world = clientHandler.m_105147_();
                    Entity e = world.m_6815_(ClientboundGunMountPacket.this.dummyId);
                    LOGGER.debug("Got mount entity: " + e + " and blockPos=" + ClientboundGunMountPacket.this.pos);
                    if (e instanceof DummyEntity) {
                        DummyEntity dummy = (DummyEntity)e;
                        Entity carrier = world.m_6815_(ClientboundGunMountPacket.this.carrierId);
                        LOGGER.debug("Got carrier: " + carrier);
                        if (ClientboundGunMountPacket.this.renderablePos) {
                            if (carrier instanceof DummyEntity) {
                                DummyEntity dummyCarrier = (DummyEntity)carrier;
                                for (RenderableBlock renderable : dummyCarrier.renderables) {
                                    if (!renderable.pos.equals((Object)ClientboundGunMountPacket.this.pos)) continue;
                                    BlockEntity blockEntity = renderable.tempBlockEntity;
                                    if (blockEntity instanceof MountedGunBlockEntity) {
                                        MountedGunBlockEntity mounted = (MountedGunBlockEntity)blockEntity;
                                        mounted.assignMountVariables(ClientboundGunMountPacket.this.pos, dummy, carrier);
                                    }
                                    return;
                                }
                            }
                            LOGGER.debug("Failed to find matching renderable for pos=" + ClientboundGunMountPacket.this.pos);
                        } else {
                            BlockEntity blockEntity = world.m_7702_(ClientboundGunMountPacket.this.pos);
                            if (blockEntity instanceof MountedGunBlockEntity) {
                                MountedGunBlockEntity mounted = (MountedGunBlockEntity)blockEntity;
                                mounted.assignMountVariables(ClientboundGunMountPacket.this.pos, dummy, carrier);
                            } else {
                                LOGGER.debug("Failed to find matching blockEntity for pos=" + ClientboundGunMountPacket.this.pos);
                            }
                        }
                    } else {
                        LOGGER.debug("Failed to find valid-typed client-side entity with id=" + ClientboundGunMountPacket.this.dummyId);
                    }
                }
            });
        }
    }
}

