/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.xenotech.network;

import com.dairymoose.xenotech.entity.DummyEntity;
import com.dairymoose.xenotech.entity.DummyRenderer;
import com.dairymoose.xenotech.entity.RenderableBlock;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClientboundMultipartShipDataPacket
implements Packet<ClientGamePacketListener> {
    private int entityId;
    private long uniqueId;
    private byte[] data;
    private int seqNo;
    private int series;
    private boolean last;
    private static final Logger LOGGER = LogManager.getLogger();
    public static AtomicInteger seriesCounter = new AtomicInteger(0);
    private static Map<DualKey, List<ClientboundMultipartShipDataPacket>> shipPackets = new ConcurrentHashMap<DualKey, List<ClientboundMultipartShipDataPacket>>();

    public ClientboundMultipartShipDataPacket() {
    }

    public ClientboundMultipartShipDataPacket(FriendlyByteBuf buffer) {
        this.read(buffer);
    }

    public ClientboundMultipartShipDataPacket(int entityId, long uniqueId, byte[] data, int series, int seqNo, boolean last) {
        this.entityId = entityId;
        this.uniqueId = uniqueId;
        this.data = data;
        this.series = series;
        this.seqNo = seqNo;
        this.last = last;
    }

    public void read(FriendlyByteBuf byteBuf) {
        this.entityId = byteBuf.readInt();
        this.uniqueId = byteBuf.readLong();
        this.data = byteBuf.m_130052_();
        this.series = byteBuf.readInt();
        this.seqNo = byteBuf.readInt();
        this.last = byteBuf.readBoolean();
    }

    public void m_5779_(FriendlyByteBuf byteBuf) {
        byteBuf.writeInt(this.entityId);
        byteBuf.writeLong(this.uniqueId);
        byteBuf.m_130087_(this.data);
        byteBuf.writeInt(this.series);
        byteBuf.writeInt(this.seqNo);
        byteBuf.writeBoolean(this.last);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> this.handle((ClientGamePacketListener)((NetworkEvent.Context)ctx.get()).getNetworkManager().m_129538_()));
        ctx.get().setPacketHandled(true);
    }

    public static void handlePacketData(final ClientGamePacketListener handler, final int entityId, final long uniqueId, final byte[] data) {
        LOGGER.debug("Handle ClientboundShipDataPacket");
        if (handler instanceof ClientPacketListener) {
            DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> new Runnable(){

                @Override
                public void run() {
                    ClientPacketListener clientHandler = (ClientPacketListener)handler;
                    ClientLevel world = clientHandler.m_105147_();
                    Entity e = world.m_6815_(entityId);
                    if (e instanceof DummyEntity) {
                        DummyEntity dummy = (DummyEntity)e;
                        try {
                            LOGGER.debug("Client-side ship data update for entityId=" + entityId + " with uniqueId=" + uniqueId);
                            dummy.shipRenderableStorage.readAllRecordsFromData(data, dummy);
                            dummy.uniqueId = uniqueId;
                            if (DummyRenderer.useBlockLightingForShip) {
                                ModelBlockRenderer.m_111077_();
                                ModelBlockRenderer.m_111000_();
                            }
                            ArrayList<RenderableBlock> allSeats = new ArrayList<RenderableBlock>();
                            BlockPos terminalPos = dummy.scanShipBlocks(allSeats);
                            DummyEntity.DummyEntityHolder thisHolder = new DummyEntity.DummyEntityHolder(dummy);
                            DummyEntity.addUniqueGlobalDummy(thisHolder);
                            LOGGER.debug("Finished adding ship");
                        }
                        catch (Exception ex) {
                            LOGGER.error("Error reading clientbound ship data", (Throwable)ex);
                        }
                    } else {
                        LOGGER.debug("Failed to find valid-typed client-side entity with id=" + entityId);
                    }
                }
            });
        }
    }

    private ClientboundMultipartShipDataPacket getLastPacket(List<ClientboundMultipartShipDataPacket> packets) {
        for (ClientboundMultipartShipDataPacket packet : packets) {
            if (!packet.last) continue;
            return packet;
        }
        return null;
    }

    public static synchronized void syncHandle(ClientboundMultipartShipDataPacket thisPacket, ClientGamePacketListener handler) {
        LOGGER.debug("Handle ClientboundMultipartShipDataPacket for series = " + thisPacket.series + " with unique ID = " + thisPacket.uniqueId);
        DualKey dk = new DualKey(Minecraft.m_91087_().f_91074_, thisPacket.series);
        List<ClientboundMultipartShipDataPacket> packets = shipPackets.get(dk);
        if (packets == null) {
            packets = new ArrayList<ClientboundMultipartShipDataPacket>();
            shipPackets.put(dk, packets);
        }
        packets.add(thisPacket);
        ClientboundMultipartShipDataPacket lastPacket = thisPacket.getLastPacket(packets);
        byte[] stitchedShipData = null;
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        if (lastPacket != null && packets.size() == lastPacket.seqNo) {
            packets.sort(new Comparator<ClientboundMultipartShipDataPacket>(){

                @Override
                public int compare(ClientboundMultipartShipDataPacket var1, ClientboundMultipartShipDataPacket var2) {
                    return var1.seqNo - var2.seqNo;
                }
            });
            for (ClientboundMultipartShipDataPacket packet : packets) {
                try {
                    stream.write(packet.data);
                }
                catch (IOException e) {
                    LOGGER.debug("error writing image part", (Throwable)e);
                }
            }
            stitchedShipData = stream.toByteArray();
        }
        if (stitchedShipData != null) {
            LOGGER.debug("image length = " + stitchedShipData.length + " for series = " + thisPacket.series);
        }
        if (stitchedShipData != null && stitchedShipData.length != 0) {
            packets.clear();
            LOGGER.debug("Got ship update with ID = " + thisPacket.uniqueId);
            ClientboundMultipartShipDataPacket.handlePacketData(handler, thisPacket.entityId, thisPacket.uniqueId, stitchedShipData);
        } else if (stitchedShipData != null) {
            packets.clear();
            LOGGER.debug("incoming ship is too big");
        }
    }

    public void handle(ClientGamePacketListener handler) {
        ClientboundMultipartShipDataPacket.syncHandle(this, handler);
    }

    private static class DualKey {
        public Player player;
        public int series;

        public DualKey(Object player, int series) {
            this.player = (Player)player;
            this.series = series;
        }

        public int hashCode() {
            return 31 + 7 * this.player.hashCode() + 11 * Integer.hashCode(this.series);
        }

        public boolean equals(Object var1) {
            if (var1 instanceof DualKey) {
                if (this.player != ((DualKey)var1).player) {
                    return false;
                }
                return this.series == ((DualKey)var1).series;
            }
            return false;
        }
    }
}

