/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.xenotech.network;

import com.dairymoose.xenotech.entity.DummyEntity;
import com.dairymoose.xenotech.entity.RenderableBlock;
import java.util.function.Supplier;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClientboundRenderableInteractPacket
implements Packet<ClientGamePacketListener> {
    private int dummyId;
    private BlockPos pos;
    private BlockState newState;
    private static final Logger LOGGER = LogManager.getLogger();

    public ClientboundRenderableInteractPacket() {
    }

    public ClientboundRenderableInteractPacket(DummyEntity dummy, BlockPos pos, BlockState newState) {
        Integer dummyId = null;
        dummyId = dummy == null ? Integer.valueOf(0) : Integer.valueOf(dummy.m_19879_());
        this.dummyId = dummyId;
        this.pos = pos;
        this.newState = newState;
    }

    public ClientboundRenderableInteractPacket(FriendlyByteBuf buffer) {
        this.read(buffer);
    }

    public void read(FriendlyByteBuf buffer) {
        this.dummyId = buffer.readInt();
        this.pos = buffer.m_130135_();
        this.newState = (BlockState)buffer.m_271872_(BlockState.f_61039_);
    }

    public void m_5779_(FriendlyByteBuf buffer) {
        buffer.writeInt(this.dummyId);
        buffer.m_130064_(this.pos);
        buffer.m_272073_(BlockState.f_61039_, (Object)this.newState);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> this.handle((ClientGamePacketListener)((NetworkEvent.Context)ctx.get()).getNetworkManager().m_129538_()));
        ctx.get().setPacketHandled(true);
    }

    public void handle(final ClientGamePacketListener handler) {
        LOGGER.debug("Handle ClientboundRenderableInteractPacket");
        if (handler instanceof ClientPacketListener) {
            DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> new Runnable(){

                @Override
                public void run() {
                    ClientPacketListener clientHandler = (ClientPacketListener)handler;
                    ClientLevel world = clientHandler.m_105147_();
                    Entity e = world.m_6815_(ClientboundRenderableInteractPacket.this.dummyId);
                    if (e instanceof DummyEntity) {
                        DummyEntity dummy = (DummyEntity)e;
                        for (RenderableBlock renderable : dummy.renderables) {
                            if (!renderable.pos.equals((Object)ClientboundRenderableInteractPacket.this.pos)) continue;
                            renderable.state = ClientboundRenderableInteractPacket.this.newState;
                            return;
                        }
                    } else {
                        LOGGER.debug("Failed to find valid-typed client-side entity with id=" + ClientboundRenderableInteractPacket.this.dummyId);
                    }
                }
            });
        }
    }
}

