/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.xenotech.network;

import com.dairymoose.xenotech.entity.DummyEntity;
import com.dairymoose.xenotech.entity.RenderableBlock;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClientboundShipDataPacket
implements Packet<ClientGamePacketListener> {
    private int entityId;
    private long uniqueId;
    private byte[] data;
    private static final Logger LOGGER = LogManager.getLogger();

    public ClientboundShipDataPacket() {
    }

    public ClientboundShipDataPacket(FriendlyByteBuf buffer) {
        this.read(buffer);
    }

    public ClientboundShipDataPacket(int entityId, long uniqueId, byte[] data) {
        this.entityId = entityId;
        this.uniqueId = uniqueId;
        this.data = data;
    }

    public void read(FriendlyByteBuf byteBuf) {
        this.entityId = byteBuf.readInt();
        this.uniqueId = byteBuf.readLong();
        this.data = byteBuf.m_130052_();
    }

    public void m_5779_(FriendlyByteBuf byteBuf) {
        byteBuf.writeInt(this.entityId);
        byteBuf.writeLong(this.uniqueId);
        byteBuf.m_130087_(this.data);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> this.handle((ClientGamePacketListener)((NetworkEvent.Context)ctx.get()).getNetworkManager().m_129538_()));
        ctx.get().setPacketHandled(true);
    }

    public void handle(final ClientGamePacketListener handler) {
        LOGGER.debug("Handle ClientboundShipDataPacket");
        if (handler instanceof ClientPacketListener) {
            DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> new Runnable(){

                @Override
                public void run() {
                    ClientPacketListener clientHandler = (ClientPacketListener)handler;
                    ClientLevel world = clientHandler.m_105147_();
                    Entity e = world.m_6815_(ClientboundShipDataPacket.this.entityId);
                    if (e instanceof DummyEntity) {
                        DummyEntity dummy = (DummyEntity)e;
                        try {
                            LOGGER.debug("Client-side ship data update for entityId=" + ClientboundShipDataPacket.this.entityId + " with uniqueId=" + ClientboundShipDataPacket.this.uniqueId);
                            dummy.shipRenderableStorage.readAllRecordsFromData(ClientboundShipDataPacket.this.data, dummy);
                            dummy.uniqueId = ClientboundShipDataPacket.this.uniqueId;
                            ArrayList<RenderableBlock> allSeats = new ArrayList<RenderableBlock>();
                            BlockPos terminalPos = dummy.scanShipBlocks(allSeats);
                            DummyEntity.DummyEntityHolder thisHolder = new DummyEntity.DummyEntityHolder(dummy);
                            DummyEntity.addUniqueGlobalDummy(thisHolder);
                            LOGGER.debug("Finished adding ship");
                        }
                        catch (Exception ex) {
                            LOGGER.error("Error reading clientbound ship data", (Throwable)ex);
                        }
                    } else {
                        LOGGER.debug("Failed to find valid-typed client-side entity with id=" + ClientboundShipDataPacket.this.entityId);
                    }
                }
            });
        }
    }
}

