/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.xenotech.network;

import com.dairymoose.xenotech.client.gui.screens.TerminalScreen;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClientboundShipTerminalPacket
implements Packet<ClientGamePacketListener> {
    public static final int TERMINAL_CODE_REASSEMBLY_FAILED = 1;
    private int terminalCode;
    private String terminalText;
    private static final Logger LOGGER = LogManager.getLogger();

    public ClientboundShipTerminalPacket() {
    }

    public ClientboundShipTerminalPacket(FriendlyByteBuf buffer) {
        this.read(buffer);
    }

    public ClientboundShipTerminalPacket(int terminalCode, String terminalText) {
        this.terminalCode = terminalCode;
        if (terminalText == null) {
            terminalText = "";
        }
        this.terminalText = terminalText;
    }

    public void read(FriendlyByteBuf byteBuf) {
        this.terminalCode = byteBuf.readInt();
        this.terminalText = byteBuf.m_130277_();
    }

    public void m_5779_(FriendlyByteBuf byteBuf) {
        byteBuf.writeInt(this.terminalCode);
        byteBuf.m_130070_(this.terminalText);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> this.handle((ClientGamePacketListener)((NetworkEvent.Context)ctx.get()).getNetworkManager().m_129538_()));
        ctx.get().setPacketHandled(true);
    }

    public void handle(final ClientGamePacketListener handler) {
        LOGGER.debug("Handle ClientboundShipTerminalPacket");
        if (handler instanceof ClientPacketListener) {
            DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> new Runnable(){

                @Override
                public void run() {
                    ClientPacketListener clientHandler = (ClientPacketListener)handler;
                    try {
                        if (ClientboundShipTerminalPacket.this.terminalCode == 1) {
                            TerminalScreen terminal = new TerminalScreen(Minecraft.m_91087_().f_91074_.m_20183_());
                            terminal.setTerminalData(new TerminalScreen.TerminalData(ClientboundShipTerminalPacket.this.terminalText, List.of(new TerminalScreen.TerminalButton(Component.m_237115_((String)"terminal.xenotech.exit"), TerminalScreen.onPress_exit(terminal)))));
                            Minecraft.m_91087_().m_91152_((Screen)terminal);
                        }
                    }
                    catch (Exception ex) {
                        LOGGER.error("Error during client terminal packet", (Throwable)ex);
                    }
                }
            });
        }
    }
}

