/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.xenotech.network;

import com.dairymoose.xenotech.entity.DummyEntity;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerGamePacketListener;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerboundAdjustVehicleDeltaPacket
implements Packet<ServerGamePacketListener> {
    private Vec3 delta;
    private boolean speedVectorIsPositive;
    private int inAirTicks;
    private Integer dummyId;
    private static final Logger LOGGER = LogManager.getLogger();
    public static long lastValidTimestamp = 0L;

    public ServerboundAdjustVehicleDeltaPacket() {
    }

    public ServerboundAdjustVehicleDeltaPacket(DummyEntity dummy, Vec3 delta, boolean speedVectorIsPositive, int inAirTicks) {
        Integer dummyId = null;
        dummyId = dummy == null ? Integer.valueOf(0) : Integer.valueOf(dummy.m_19879_());
        this.dummyId = dummyId;
        this.delta = delta;
        this.speedVectorIsPositive = speedVectorIsPositive;
        this.inAirTicks = inAirTicks;
    }

    public ServerboundAdjustVehicleDeltaPacket(FriendlyByteBuf buffer) {
        this.read(buffer);
    }

    public void read(FriendlyByteBuf buffer) {
        this.dummyId = buffer.readInt();
        double x = buffer.readDouble();
        double y = buffer.readDouble();
        double z = buffer.readDouble();
        this.delta = new Vec3(x, y, z);
        this.speedVectorIsPositive = buffer.readBoolean();
        this.inAirTicks = buffer.readInt();
    }

    public void m_5779_(FriendlyByteBuf buffer) {
        buffer.writeInt(this.dummyId.intValue());
        buffer.writeDouble(this.delta.f_82479_);
        buffer.writeDouble(this.delta.f_82480_);
        buffer.writeDouble(this.delta.f_82481_);
        buffer.writeBoolean(this.speedVectorIsPositive);
        buffer.writeInt(this.inAirTicks);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
            this.handle((ServerGamePacketListener)((NetworkEvent.Context)ctx.get()).getNetworkManager().m_129538_());
        });
        ctx.get().setPacketHandled(true);
    }

    public void handle(ServerGamePacketListener gamePacketListener) {
        LOGGER.trace("Handle ServerboundAdjustVehicleDeltaPacket");
        long timestamp = System.currentTimeMillis();
        if (gamePacketListener instanceof ServerGamePacketListenerImpl) {
            ServerGamePacketListenerImpl serverHandler = (ServerGamePacketListenerImpl)gamePacketListener;
            Level world = serverHandler.f_9743_.m_9236_();
            boolean isValidDummyEntity = false;
            DummyEntity dummy = null;
            if (world != null) {
                Entity testEntity = world.m_6815_(this.dummyId.intValue());
                boolean bl = isValidDummyEntity = testEntity instanceof DummyEntity && !testEntity.m_213877_();
                if (isValidDummyEntity) {
                    dummy = (DummyEntity)testEntity;
                }
            }
            if (isValidDummyEntity) {
                long timeDiff = timestamp - lastValidTimestamp;
                if (serverHandler.f_9743_.m_20202_() == dummy || timeDiff <= 500L) {
                    if (serverHandler.f_9743_.m_20202_() != dummy) {
                        LOGGER.warn("Adjusting movement even though player " + serverHandler.f_9743_ + " was not riding vehicle: " + dummy);
                    }
                    dummy.m_20256_(this.delta);
                    dummy.speedVectorIsPositive = this.speedVectorIsPositive;
                    dummy.setInAirTicks(this.inAirTicks);
                    lastValidTimestamp = timestamp;
                } else {
                    LOGGER.warn("Player " + serverHandler.f_9743_ + " was not riding vehicle: " + dummy);
                }
            } else {
                LOGGER.warn("Invalid entity: " + dummy);
            }
        }
    }
}

