/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.xenotech.network;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerGamePacketListener;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerboundDismountVillagerPacket
implements Packet<ServerGamePacketListener> {
    private int villagerId;
    private static final Logger LOGGER = LogManager.getLogger();

    public ServerboundDismountVillagerPacket() {
    }

    public ServerboundDismountVillagerPacket(Villager villager) {
        Integer villagerId = null;
        villagerId = villager == null ? Integer.valueOf(0) : Integer.valueOf(villager.m_19879_());
        this.villagerId = villagerId;
    }

    public ServerboundDismountVillagerPacket(FriendlyByteBuf buffer) {
        this.read(buffer);
    }

    public void read(FriendlyByteBuf buffer) {
        this.villagerId = buffer.readInt();
    }

    public void m_5779_(FriendlyByteBuf buffer) {
        buffer.writeInt(this.villagerId);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
            this.handle((ServerGamePacketListener)((NetworkEvent.Context)ctx.get()).getNetworkManager().m_129538_());
        });
        ctx.get().setPacketHandled(true);
    }

    public void handle(ServerGamePacketListener gamePacketListener) {
        LOGGER.debug("Handle ServerboundDismountVillagerPacket");
        if (gamePacketListener instanceof ServerGamePacketListenerImpl) {
            ServerGamePacketListenerImpl serverHandler = (ServerGamePacketListenerImpl)gamePacketListener;
            Level world = serverHandler.f_9743_.m_9236_();
            boolean isValidVillager = false;
            Villager villager = null;
            if (world != null) {
                Entity testEntity = world.m_6815_(this.villagerId);
                boolean bl = isValidVillager = testEntity instanceof Villager && !testEntity.m_213877_();
                if (isValidVillager) {
                    villager = (Villager)testEntity;
                }
            }
            if (isValidVillager) {
                villager.m_8127_();
            } else {
                LOGGER.warn("Invalid entity: " + villager);
            }
        }
    }
}

