/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.xenotech.network;

import com.dairymoose.xenotech.XenoTechCommon;
import com.dairymoose.xenotech.block.MountedGunBlock;
import com.dairymoose.xenotech.network.ClientboundBulletHoleArrayPacket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerGamePacketListener;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerboundHitscanArrayPacket
implements Packet<ServerGamePacketListener> {
    private List<SingleHitscanResult> hitscanResults;
    public static boolean bulletsCanHeadshot;
    public static double bulletDamage;
    public static double bulletHeadshotDamageMultiplier;
    public static double integratedGunDamageMultiplier;
    public static boolean bulletsCanDestroyBlocks;
    public static float bulletBlockDestroySpeed;
    public static boolean bulletsCreateBulletHoles;
    private static final Logger LOGGER;
    public static Map<Player, MiningInfo> mineMap;

    public ServerboundHitscanArrayPacket() {
    }

    public ServerboundHitscanArrayPacket(FriendlyByteBuf buffer) {
        this.read(buffer);
    }

    public ServerboundHitscanArrayPacket(List<SingleHitscanResult> hitscanResults) {
        this.hitscanResults = hitscanResults;
    }

    public void read(FriendlyByteBuf byteBuf) {
        int size = byteBuf.readInt();
        this.hitscanResults = new ArrayList<SingleHitscanResult>();
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                SingleHitscanResult shr = new SingleHitscanResult();
                shr.blockPos = byteBuf.m_130135_();
                shr.entityId = byteBuf.readInt();
                shr.location = new Vec3(byteBuf.readDouble(), byteBuf.readDouble(), byteBuf.readDouble());
                int dirValue = byteBuf.readInt();
                shr.direction = dirValue == -1 ? null : Direction.m_122376_((int)dirValue);
                shr.isIntegratedGun = byteBuf.readBoolean();
                this.hitscanResults.add(shr);
            }
        }
    }

    public void m_5779_(FriendlyByteBuf byteBuf) {
        int size = 0;
        if (this.hitscanResults != null) {
            size = this.hitscanResults.size();
        }
        byteBuf.writeInt(size);
        for (int i = 0; i < size; ++i) {
            SingleHitscanResult shr = this.hitscanResults.get(i);
            byteBuf.m_130064_(shr.blockPos);
            byteBuf.writeInt(shr.entityId);
            byteBuf.writeDouble(shr.location.f_82479_);
            byteBuf.writeDouble(shr.location.f_82480_);
            byteBuf.writeDouble(shr.location.f_82481_);
            if (shr.direction == null) {
                byteBuf.writeInt(-1);
            } else {
                byteBuf.writeInt(shr.direction.m_122411_());
            }
            byteBuf.writeBoolean(shr.isIntegratedGun);
        }
    }

    public static void playGunSound(Level world, Player player, BlockPos pos) {
        if (world == null) {
            return;
        }
        float volume = 2.0f;
        float pitch = 1.2f;
        float pitchRange = 0.6f;
        float pitchRand = (float)((double)pitchRange * Math.random());
        pitch += (pitchRand -= pitchRange / 2.0f);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
            this.handle((ServerGamePacketListener)((NetworkEvent.Context)ctx.get()).getNetworkManager().m_129538_());
        });
        ctx.get().setPacketHandled(true);
    }

    public void handle(ServerGamePacketListener p_148833_1_) {
        LOGGER.trace("Handle ServerboundHitscanArrayPacket");
        if (p_148833_1_ instanceof ServerGamePacketListenerImpl) {
            ServerGamePacketListenerImpl serverHandler = (ServerGamePacketListenerImpl)p_148833_1_;
            ServerLevel world = serverHandler.f_9743_.m_284548_();
            if (world != null && world instanceof ServerLevel && this.hitscanResults != null) {
                ItemStack itemStack = serverHandler.f_9743_.m_21205_();
                for (int i = 0; i < this.hitscanResults.size(); ++i) {
                    SingleHitscanResult shr = this.hitscanResults.get(i);
                    this.processHitscanResult(serverHandler, (Level)world, itemStack, shr);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processHitscanResult(ServerGamePacketListenerImpl serverHandler, Level world, ItemStack itemStack, SingleHitscanResult shr) {
        Entity entity;
        ServerLevel ServerLevel2 = (ServerLevel)world;
        SimpleParticleType particleType = ParticleTypes.f_123796_;
        ParticleType particles = (ParticleType)ForgeRegistries.PARTICLE_TYPES.getValue(ForgeRegistries.PARTICLE_TYPES.getKey((Object)ParticleTypes.f_123794_));
        BlockState state = world.m_8055_(shr.blockPos);
        if (!state.m_60795_()) {
            BlockParticleOption blockParticle = new BlockParticleOption(particles, state);
            ServerLevel2.m_8767_((ParticleOptions)blockParticle, shr.location.f_82479_, shr.location.f_82480_, shr.location.f_82481_, 30, 0.1, 0.1, 0.1, 0.1);
        }
        if ((entity = world.m_6815_(shr.entityId)) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            float foreheadHeight = entity.m_20206_() - entity.m_20192_();
            boolean headShot = shr.location.f_82480_ >= entity.m_20188_() - (double)foreheadHeight;
            int particleCount = 1;
            int initialInvulnerableTime = entity.f_19802_;
            AttributeInstance kbResist = living.m_21051_(Attributes.f_22278_);
            double kbResistInitial = kbResist.m_22115_();
            try {
                entity.f_19802_ = 0;
                kbResist.m_22100_(1.0);
                double baseDamage = bulletDamage;
                double critMultiplier = bulletHeadshotDamageMultiplier;
                boolean canHeadshot = bulletsCanHeadshot;
                if (shr.isIntegratedGun) {
                    baseDamage *= integratedGunDamageMultiplier;
                }
                if (!canHeadshot) {
                    headShot = false;
                }
                if (headShot) {
                    entity.m_6469_(world.m_269111_().m_269075_((Player)serverHandler.f_9743_), (float)(baseDamage * critMultiplier));
                    particleCount = 60;
                } else {
                    entity.m_6469_(world.m_269111_().m_269075_((Player)serverHandler.f_9743_), (float)baseDamage);
                }
                if (shr.entityId != -1 && !living.m_21224_()) {
                    particleType = ParticleTypes.f_123797_;
                    ServerLevel2.m_8767_((ParticleOptions)particleType, shr.location.f_82479_, shr.location.f_82480_, shr.location.f_82481_, particleCount, 0.1, 0.1, 0.1, 0.1);
                }
            }
            finally {
                entity.f_19802_ = initialInvulnerableTime;
                kbResist.m_22100_(kbResistInitial);
            }
        }
        if (shr.entityId == -1) {
            this.hitBlockPos((Player)serverHandler.f_9743_, (Level)ServerLevel2, itemStack, shr.blockPos, shr.location, shr.direction);
        }
        ServerboundHitscanArrayPacket.playGunSound(world, (Player)serverHandler.f_9743_, serverHandler.f_9743_.m_20183_());
    }

    public void hitBlockPos(Player player, Level world, ItemStack itemStack, BlockPos pos, Vec3 loc, Direction direction) {
        BlockState state = world.m_8055_(pos);
        if (state.m_60734_() instanceof MountedGunBlock || state.m_60795_()) {
            return;
        }
        boolean destroyed = false;
        if (bulletsCanDestroyBlocks) {
            ItemStack stoneSword = new ItemStack(new ItemLike(){

                public Item m_5456_() {
                    return Items.f_42425_;
                }
            });
            float speed = ((SwordItem)stoneSword.m_41720_()).m_8102_(stoneSword, state);
            if (speed >= 1.5f || state.m_204336_(BlockTags.f_13047_)) {
                world.m_46961_(pos, true);
                destroyed = true;
            } else {
                float destroySpeed = state.m_60800_((BlockGetter)world, pos);
                MiningInfo mInfo = mineMap.get(player);
                if (mInfo == null) {
                    mInfo = new MiningInfo();
                    mineMap.put(player, mInfo);
                }
                if (!pos.equals((Object)mInfo.pos)) {
                    mInfo.pos = pos;
                    if (destroySpeed < 0.0f) {
                        mInfo.pos = null;
                    }
                    mInfo.miningValue = destroySpeed;
                    mInfo.miningInitialValue = destroySpeed;
                }
                if (mInfo.miningInitialValue > 0.0f) {
                    mInfo.miningValue -= bulletBlockDestroySpeed;
                }
                if (mInfo.miningInitialValue > 0.0f) {
                    if (mInfo.miningValue <= 0.0f) {
                        world.m_6801_(-1, pos, 10);
                        world.m_46961_(pos, true);
                        destroyed = true;
                        mInfo.pos = null;
                        mInfo.miningInitialValue = -1.0f;
                    } else {
                        int progressVal = (int)(10.0 * (1.0 - (double)(mInfo.miningValue / mInfo.miningInitialValue)));
                        world.m_6801_(-1, pos, progressVal);
                    }
                }
            }
        }
        if (bulletsCreateBulletHoles && !destroyed) {
            int holeNo = (int)(Math.random() * 3.0);
            ClientboundBulletHoleArrayPacket.SingleBulletHole sbh = new ClientboundBulletHoleArrayPacket.SingleBulletHole();
            sbh.playerId = player.m_19879_();
            sbh.x = loc.f_82479_;
            sbh.y = loc.f_82480_;
            sbh.z = loc.f_82481_;
            sbh.pos = pos;
            sbh.holeNo = holeNo;
            sbh.facing = direction;
            sbh.dim = player.m_9236_().m_46472_().m_135782_().toString();
            XenoTechCommon.pendingBulletHoleUpdates.add(sbh);
        }
    }

    static {
        LOGGER = LogManager.getLogger();
        mineMap = new HashMap<Player, MiningInfo>();
    }

    public static class SingleHitscanResult {
        public BlockPos blockPos;
        public int entityId;
        public Vec3 location;
        public Direction direction;
        public boolean isIntegratedGun;
    }

    public static class MiningInfo {
        public float miningInitialValue;
        public float miningValue;
        public BlockPos pos;
    }
}

