/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.xenotech.network;

import com.dairymoose.xenotech.XenoBlocks;
import com.dairymoose.xenotech.XenoTechUtils;
import com.dairymoose.xenotech.block.DriverSeatBlock;
import com.dairymoose.xenotech.entity.DummyEntity;
import com.dairymoose.xenotech.entity.RenderableBlock;
import com.dairymoose.xenotech.item.StasisGunItem;
import com.dairymoose.xenotech.network.ClientboundRenderableInteractPacket;
import com.dairymoose.xenotech.network.XenoTechNetwork;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerGamePacketListener;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerboundRenderableInteractPacket
implements Packet<ServerGamePacketListener> {
    private int dummyId;
    private BlockPos pos;
    private static final Logger LOGGER = LogManager.getLogger();

    public ServerboundRenderableInteractPacket() {
    }

    public ServerboundRenderableInteractPacket(DummyEntity dummy, BlockPos pos) {
        Integer dummyId = null;
        dummyId = dummy == null ? Integer.valueOf(0) : Integer.valueOf(dummy.m_19879_());
        this.dummyId = dummyId;
        this.pos = pos;
    }

    public ServerboundRenderableInteractPacket(FriendlyByteBuf buffer) {
        this.read(buffer);
    }

    public void read(FriendlyByteBuf buffer) {
        this.dummyId = buffer.readInt();
        this.pos = buffer.m_130135_();
    }

    public void m_5779_(FriendlyByteBuf buffer) {
        buffer.writeInt(this.dummyId);
        buffer.m_130064_(this.pos);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
            this.handle((ServerGamePacketListener)((NetworkEvent.Context)ctx.get()).getNetworkManager().m_129538_());
        });
        ctx.get().setPacketHandled(true);
    }

    private RenderableBlock findBlockAtOriginalPosition(DummyEntity dummy, BlockPos originalPos) {
        if (dummy == null) {
            return null;
        }
        if (dummy.renderables != null && !dummy.renderables.isEmpty()) {
            for (RenderableBlock renderable : dummy.renderables) {
                if (!renderable.pos.equals((Object)originalPos)) continue;
                return renderable;
            }
        }
        return null;
    }

    public void handle(ServerGamePacketListener gamePacketListener) {
        LOGGER.debug("Handle ServerboundRenderableInteractPacket");
        if (gamePacketListener instanceof ServerGamePacketListenerImpl) {
            ServerGamePacketListenerImpl serverHandler = (ServerGamePacketListenerImpl)gamePacketListener;
            Level world = serverHandler.f_9743_.m_9236_();
            boolean isValidDummyEntity = false;
            DummyEntity dummy = null;
            if (world != null) {
                Entity testEntity = world.m_6815_(this.dummyId);
                boolean bl = isValidDummyEntity = testEntity instanceof DummyEntity && !testEntity.m_213877_();
                if (isValidDummyEntity) {
                    dummy = (DummyEntity)testEntity;
                }
            }
            if (isValidDummyEntity) {
                if (dummy.renderables != null && !dummy.renderables.isEmpty()) {
                    for (RenderableBlock renderable : dummy.renderables) {
                        if (!renderable.pos.equals((Object)this.pos)) continue;
                        Vec3 rotPos = XenoTechUtils.getRotPosForRenderable(dummy, renderable);
                        BlockPos blockRotPos = XenoTechUtils.blockPosFromRotPos(rotPos);
                        LOGGER.debug("float rotPos=" + rotPos + " with angle=" + dummy.getYRotDiff());
                        BlockHitResult bhr = new BlockHitResult(rotPos, serverHandler.f_9743_.m_6350_(), blockRotPos, false);
                        Block block = renderable.state.m_60734_();
                        if (block instanceof DoorBlock) {
                            RenderableBlock upper;
                            RenderableBlock lower;
                            DoorBlock door = (DoorBlock)block;
                            boolean isOpen = (Boolean)renderable.state.m_61143_((Property)DoorBlock.f_52727_);
                            isOpen = !isOpen;
                            renderable.state = (BlockState)renderable.state.m_61124_((Property)DoorBlock.f_52727_, (Comparable)Boolean.valueOf(isOpen));
                            BlockPos otherPos = null;
                            RenderableBlock other = null;
                            if (renderable.state.m_61143_((Property)DoorBlock.f_52730_) == DoubleBlockHalf.UPPER && (lower = this.findBlockAtOriginalPosition(dummy, this.pos.m_7495_())) != null && lower.state.m_60734_() instanceof DoorBlock) {
                                lower.state = (BlockState)lower.state.m_61124_((Property)DoorBlock.f_52727_, (Comparable)Boolean.valueOf(isOpen));
                                other = lower;
                                otherPos = this.pos.m_7495_();
                            }
                            if (renderable.state.m_61143_((Property)DoorBlock.f_52730_) == DoubleBlockHalf.LOWER && (upper = this.findBlockAtOriginalPosition(dummy, this.pos.m_7494_())) != null && upper.state.m_60734_() instanceof DoorBlock) {
                                upper.state = (BlockState)upper.state.m_61124_((Property)DoorBlock.f_52727_, (Comparable)Boolean.valueOf(isOpen));
                                other = upper;
                                otherPos = this.pos.m_7494_();
                            }
                            XenoTechNetwork.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new ClientboundRenderableInteractPacket(dummy, this.pos, renderable.state));
                            if (other != null && otherPos != null) {
                                if (door.m_278711_() != null) {
                                    float pitch = (float)Math.random() * 0.1f + 0.9f;
                                    dummy.m_9236_().m_5594_(null, blockRotPos, isOpen ? door.m_278711_().f_271141_() : door.m_278711_().f_271502_(), SoundSource.BLOCKS, 1.0f, pitch);
                                }
                                XenoTechNetwork.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new ClientboundRenderableInteractPacket(dummy, otherPos, other.state));
                            }
                            return;
                        }
                        Block isOpen = renderable.state.m_60734_();
                        if (isOpen instanceof TrapDoorBlock) {
                            TrapDoorBlock door = (TrapDoorBlock)isOpen;
                            boolean isOpen2 = (Boolean)renderable.state.m_61143_((Property)DoorBlock.f_52727_);
                            isOpen2 = !isOpen2;
                            renderable.state = (BlockState)renderable.state.m_61124_((Property)DoorBlock.f_52727_, (Comparable)Boolean.valueOf(isOpen2));
                            if (door.f_271458_ != null) {
                                float pitch = (float)Math.random() * 0.1f + 0.9f;
                                dummy.m_9236_().m_5594_(null, blockRotPos, isOpen2 ? door.f_271458_.f_271258_() : door.f_271458_.f_271425_(), SoundSource.BLOCKS, 1.0f, pitch);
                            }
                            XenoTechNetwork.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new ClientboundRenderableInteractPacket(dummy, this.pos, renderable.state));
                            return;
                        }
                        try {
                            boolean blockStateMismatch;
                            LOGGER.debug("use block at networkPos=" + this.pos + ", rotPos=" + blockRotPos + " with state=" + renderable.state);
                            DummyEntity.doBlockStateOverride = true;
                            DummyEntity.doSetBlockOverride = true;
                            LevelChunk levelChunk = serverHandler.f_9743_.m_9236_().m_46745_(blockRotPos);
                            BlockState realState = levelChunk.m_8055_(blockRotPos);
                            BlockEntity realBlockEntity = levelChunk.m_5685_(blockRotPos, LevelChunk.EntityCreationType.CHECK);
                            BlockEntity fakeBlockEntity = serverHandler.f_9743_.m_9236_().m_7702_(blockRotPos);
                            BlockState fakeBlockState = serverHandler.f_9743_.m_9236_().m_8055_(blockRotPos);
                            LOGGER.debug("realState=" + realState);
                            LOGGER.debug("realBlockEntity=" + realBlockEntity);
                            LOGGER.debug("fakeBlockState=" + fakeBlockState);
                            LOGGER.debug("fakeBlockEntity=" + fakeBlockEntity);
                            boolean bl = blockStateMismatch = renderable.state.m_60734_() != fakeBlockState.m_60734_();
                            if (fakeBlockEntity == null && renderable.tempBlockEntity != null || blockStateMismatch) {
                                dummy.renderableLookup.put(blockRotPos, renderable);
                                fakeBlockEntity = serverHandler.f_9743_.m_9236_().m_7702_(blockRotPos);
                                LOGGER.debug("fakeBlockEntity after relocate=" + fakeBlockEntity);
                                if (blockStateMismatch) {
                                    LOGGER.warn("blockState mismatch, " + renderable.state + " vs " + fakeBlockState + ", relocate blockEntity: " + fakeBlockEntity);
                                }
                            }
                            renderable.state.m_60664_(serverHandler.f_9743_.m_9236_(), (Player)serverHandler.f_9743_, InteractionHand.MAIN_HAND, bhr);
                            ItemStack stasisGun = null;
                            ItemStack mainHand = serverHandler.f_9743_.m_21205_();
                            if (mainHand.m_150930_((Item)XenoBlocks.ITEM_STASIS_GUN.get())) {
                                stasisGun = mainHand;
                            } else {
                                ItemStack offHand = serverHandler.f_9743_.m_21206_();
                                if (offHand.m_150930_((Item)XenoBlocks.ITEM_STASIS_GUN.get())) {
                                    stasisGun = offHand;
                                }
                            }
                            if (renderable.state.m_60734_() instanceof DriverSeatBlock && dummy.m_146895_() == null && stasisGun != null) {
                                try {
                                    Item item = stasisGun.m_41720_();
                                    if (item instanceof StasisGunItem) {
                                        Entity spawned;
                                        StasisGunItem stasis = (StasisGunItem)item;
                                        CompoundTag tag = stasisGun.m_41783_();
                                        if (tag != null && tag.m_128441_("StoredEntity") && (spawned = stasis.spawnEntityAtLocation(world, stasisGun, rotPos, type -> type == EntityType.f_20492_)) != null) {
                                            spawned.m_20329_((Entity)dummy);
                                        }
                                    }
                                }
                                catch (Exception ex) {
                                    LOGGER.error("Error while spawning villager", (Throwable)ex);
                                }
                            }
                            DummyEntity.doBlockStateOverride = DummyEntity.debug_alwaysShowBlockState;
                            DummyEntity.doSetBlockOverride = DummyEntity.alwaysDoSetBlockOverride;
                        }
                        catch (Exception e) {
                            LOGGER.error("Exception on server while using block: " + renderable.state, (Throwable)e);
                        }
                        return;
                    }
                }
            } else {
                LOGGER.warn("Invalid entity: " + dummy);
            }
        }
    }
}

