/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.xenotech.network;

import com.dairymoose.xenotech.entity.DummyEntity;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerGamePacketListener;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerboundRequestRepositionPacket
implements Packet<ServerGamePacketListener> {
    private Integer dummyId;
    private Vec3 entityPositionDifference;
    private static final Logger LOGGER = LogManager.getLogger();

    public ServerboundRequestRepositionPacket() {
    }

    public ServerboundRequestRepositionPacket(DummyEntity dummy, Vec3 entityPositionDifference) {
        Integer dummyId = null;
        dummyId = dummy == null ? Integer.valueOf(0) : Integer.valueOf(dummy.m_19879_());
        this.dummyId = dummyId;
        this.entityPositionDifference = entityPositionDifference;
    }

    public ServerboundRequestRepositionPacket(FriendlyByteBuf buffer) {
        this.read(buffer);
    }

    public void read(FriendlyByteBuf buffer) {
        this.dummyId = buffer.readInt();
        double x = buffer.readDouble();
        double y = buffer.readDouble();
        double z = buffer.readDouble();
        this.entityPositionDifference = new Vec3(x, y, z);
    }

    public void m_5779_(FriendlyByteBuf buffer) {
        buffer.writeInt(this.dummyId.intValue());
        buffer.writeDouble(this.entityPositionDifference.f_82479_);
        buffer.writeDouble(this.entityPositionDifference.f_82480_);
        buffer.writeDouble(this.entityPositionDifference.f_82481_);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
            this.handle((ServerGamePacketListener)((NetworkEvent.Context)ctx.get()).getNetworkManager().m_129538_());
        });
        ctx.get().setPacketHandled(true);
    }

    public void handle(ServerGamePacketListener gamePacketListener) {
        LOGGER.trace("Handle ServerboundRequestRepositionPacket");
        if (gamePacketListener instanceof ServerGamePacketListenerImpl) {
            ServerGamePacketListenerImpl serverHandler = (ServerGamePacketListenerImpl)gamePacketListener;
            Level world = serverHandler.f_9743_.m_9236_();
            boolean isValidDummyEntity = false;
            DummyEntity dummy = null;
            if (world != null) {
                Entity testEntity = world.m_6815_(this.dummyId.intValue());
                boolean bl = isValidDummyEntity = testEntity instanceof DummyEntity && !testEntity.m_213877_();
                if (isValidDummyEntity) {
                    dummy = (DummyEntity)testEntity;
                }
            }
            if (isValidDummyEntity) {
                if (serverHandler.f_9743_.m_20202_() == null && dummy.carried.contains(serverHandler.f_9743_.m_19879_())) {
                    Vec3 calcPlayerPos = dummy.m_20182_().m_82549_(this.entityPositionDifference);
                    LOGGER.info("move player " + serverHandler.f_9743_.m_7755_().getString() + " by: " + this.entityPositionDifference + " to location " + calcPlayerPos);
                    serverHandler.f_9743_.m_6021_(calcPlayerPos.f_82479_, calcPlayerPos.f_82480_, calcPlayerPos.f_82481_);
                }
            } else {
                LOGGER.warn("Invalid entity: " + dummy);
            }
        }
    }
}

