/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.xenotech.network;

import com.dairymoose.xenotech.entity.DummyEntity;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerGamePacketListener;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerboundShipNamePacket
implements Packet<ServerGamePacketListener> {
    public static int SHIP_NAME_MAX_LENGTH = 60;
    private int dummyId;
    private String shipName;
    private static final Logger LOGGER = LogManager.getLogger();

    public ServerboundShipNamePacket() {
    }

    public ServerboundShipNamePacket(DummyEntity dummy, String shipName) {
        Integer dummyId = null;
        dummyId = dummy == null ? Integer.valueOf(0) : Integer.valueOf(dummy.m_19879_());
        this.dummyId = dummyId;
        this.shipName = shipName;
    }

    public ServerboundShipNamePacket(FriendlyByteBuf buffer) {
        this.read(buffer);
    }

    public void read(FriendlyByteBuf buffer) {
        this.dummyId = buffer.readInt();
        this.shipName = buffer.m_130277_();
    }

    public void m_5779_(FriendlyByteBuf buffer) {
        buffer.writeInt(this.dummyId);
        buffer.m_130070_(this.shipName);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
            this.handle((ServerGamePacketListener)((NetworkEvent.Context)ctx.get()).getNetworkManager().m_129538_());
        });
        ctx.get().setPacketHandled(true);
    }

    public void handle(ServerGamePacketListener gamePacketListener) {
        LOGGER.trace("Handle ServerboundShipNamePacket");
        if (gamePacketListener instanceof ServerGamePacketListenerImpl) {
            ServerGamePacketListenerImpl serverHandler = (ServerGamePacketListenerImpl)gamePacketListener;
            Level world = serverHandler.f_9743_.m_9236_();
            boolean isValidDummyEntity = false;
            DummyEntity dummy = null;
            if (world != null) {
                Entity testEntity = world.m_6815_(this.dummyId);
                boolean bl = isValidDummyEntity = testEntity instanceof DummyEntity && !testEntity.m_213877_();
                if (isValidDummyEntity) {
                    dummy = (DummyEntity)testEntity;
                }
            }
            if (isValidDummyEntity) {
                if (this.shipName.length() <= SHIP_NAME_MAX_LENGTH) {
                    LOGGER.debug("Server set name to: " + this.shipName + " with entityId=" + this.dummyId + " and uniqueId=" + dummy.uniqueId);
                    dummy.setShipName(this.shipName);
                }
            } else {
                LOGGER.warn("Invalid entity: " + dummy);
            }
        }
    }
}

