/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.xenotech.network;

import com.dairymoose.xenotech.client.gui.screens.TaskList;
import com.dairymoose.xenotech.entity.DummyEntity;
import com.dairymoose.xenotech.network.ClientboundTasklistPacket;
import com.dairymoose.xenotech.network.XenoTechNetwork;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerGamePacketListener;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerboundTasklistPacket
implements Packet<ServerGamePacketListener> {
    private int dummyId;
    private TaskList taskList;
    private static final Logger LOGGER = LogManager.getLogger();

    public ServerboundTasklistPacket() {
    }

    public ServerboundTasklistPacket(DummyEntity dummy, TaskList taskList) {
        Integer dummyId = null;
        dummyId = dummy == null ? Integer.valueOf(0) : Integer.valueOf(dummy.m_19879_());
        this.dummyId = dummyId;
        this.taskList = taskList;
    }

    public ServerboundTasklistPacket(FriendlyByteBuf buffer) {
        this.read(buffer);
    }

    public void read(FriendlyByteBuf buffer) {
        this.dummyId = buffer.readInt();
        TaskList taskList = new TaskList();
        try {
            CompoundTag tag = buffer.m_130260_();
            taskList.fromNbt(tag, Optional.empty());
        }
        catch (Exception ex) {
            LOGGER.error("Error reading TaskList", (Throwable)ex);
        }
        this.taskList = taskList;
    }

    public void m_5779_(FriendlyByteBuf buffer) {
        buffer.writeInt(this.dummyId);
        buffer.m_130079_(this.taskList.toNbt());
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
            this.handle((ServerGamePacketListener)((NetworkEvent.Context)ctx.get()).getNetworkManager().m_129538_());
        });
        ctx.get().setPacketHandled(true);
    }

    public void handle(ServerGamePacketListener gamePacketListener) {
        LOGGER.debug("Handle ServerboundTasklistPacket");
        if (gamePacketListener instanceof ServerGamePacketListenerImpl) {
            ServerGamePacketListenerImpl serverHandler = (ServerGamePacketListenerImpl)gamePacketListener;
            Level world = serverHandler.f_9743_.m_9236_();
            boolean isValidDummyEntity = false;
            DummyEntity dummy = null;
            if (world != null) {
                Entity testEntity = world.m_6815_(this.dummyId);
                boolean bl = isValidDummyEntity = testEntity instanceof DummyEntity && !testEntity.m_213877_();
                if (isValidDummyEntity) {
                    dummy = (DummyEntity)testEntity;
                }
            }
            if (isValidDummyEntity) {
                dummy.taskList = this.taskList;
                DummyEntity thisDummy = dummy;
                try {
                    XenoTechNetwork.INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> thisDummy), (Object)new ClientboundTasklistPacket(dummy, dummy.taskList));
                }
                catch (Exception ex) {
                    LOGGER.error("Error sending ClientboundTasklistPacket", (Throwable)ex);
                }
            } else {
                LOGGER.warn("Invalid entity: " + dummy);
            }
        }
    }
}

