/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.xenotech.network;

import com.dairymoose.xenotech.XenoBlocks;
import com.dairymoose.xenotech.entity.DummyEntity;
import com.dairymoose.xenotech.network.ClientboundShipTerminalPacket;
import com.dairymoose.xenotech.network.XenoTechNetwork;
import com.dairymoose.xenotech.world.level.block.entity.ShipTerminalBlockEntity;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerGamePacketListener;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerboundTerminalSelectionPacket
implements Packet<ServerGamePacketListener> {
    private BlockPos terminalPos;
    private Integer dummyId;
    private TerminalCommand terminalCommand;
    private static final Logger LOGGER = LogManager.getLogger();
    private static final float ASCENT_SPEED = 0.15f;
    private static final float DESCENT_SPEED = 0.15f;
    public static float backupThreshold = 0.01f;
    public static float backupThresholdSqr = backupThreshold * backupThreshold;
    public static int AUTOPILOT_ASCEND_TICKS = 100;

    public ServerboundTerminalSelectionPacket() {
    }

    public ServerboundTerminalSelectionPacket(TerminalCommand terminalCommand, DummyEntity dummy, BlockPos terminalPos) {
        this.terminalPos = terminalPos;
        this.terminalCommand = terminalCommand;
        Integer dummyId = null;
        dummyId = dummy == null ? Integer.valueOf(0) : Integer.valueOf(dummy.m_19879_());
        this.dummyId = dummyId;
    }

    public ServerboundTerminalSelectionPacket(FriendlyByteBuf buffer) {
        this.read(buffer);
    }

    public void read(FriendlyByteBuf buffer) {
        this.terminalPos = buffer.m_130135_();
        this.terminalCommand = (TerminalCommand)buffer.m_130066_(TerminalCommand.class);
        this.dummyId = buffer.readInt();
    }

    public void m_5779_(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.terminalPos);
        buffer.m_130068_((Enum)this.terminalCommand);
        buffer.writeInt(this.dummyId.intValue());
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
            this.handle((ServerGamePacketListener)((NetworkEvent.Context)ctx.get()).getNetworkManager().m_129538_());
        });
        ctx.get().setPacketHandled(true);
    }

    public static void shipHoverLogic(DummyEntity dummy) {
        dummy.autopilotAutoAscendTicks = 0;
        dummy.autopilotAutoDescendTicks = 0;
        dummy.autopilotWantToAscend = false;
        dummy.autopilotWantToDescend = false;
    }

    public static void shipAscendLogic(DummyEntity dummy, boolean longAscend) {
        if (dummy.vehicleType != DummyEntity.VehicleType.BOAT) {
            Vec3 delta = dummy.m_20184_();
            if (longAscend) {
                dummy.autopilotAutoAscendTicks = AUTOPILOT_ASCEND_TICKS;
                dummy.autopilotAutoDescendTicks = 0;
            } else {
                dummy.autopilotAutoAscendTicks = 0;
                dummy.autopilotAutoDescendTicks = 0;
            }
            dummy.autopilotWantToAscend = true;
            dummy.autopilotWantToDescend = false;
        }
    }

    public static void shipDescendLogic(DummyEntity dummy, boolean longDescend) {
        if (dummy.vehicleType != DummyEntity.VehicleType.BOAT) {
            Vec3 delta = dummy.m_20184_();
            if (longDescend) {
                dummy.autopilotAutoAscendTicks = 0;
                dummy.autopilotAutoDescendTicks = AUTOPILOT_ASCEND_TICKS;
            } else {
                dummy.autopilotAutoAscendTicks = 0;
                dummy.autopilotAutoDescendTicks = 0;
            }
            dummy.autopilotWantToAscend = false;
            dummy.autopilotWantToDescend = true;
        }
    }

    public static void shipForwardLogic(DummyEntity dummy) {
        dummy.reverseCommandActive = false;
        dummy.wantToBrake = false;
        dummy.forwardCommandActive = true;
    }

    public static void shipWantToBrakeLogic(DummyEntity dummy) {
        dummy.forwardCommandActive = false;
        dummy.reverseCommandActive = false;
        dummy.wantToBrake = true;
    }

    public static void shipBrakeOrReverseLogic(DummyEntity dummy) {
        if (dummy.m_20184_().m_165925_() <= (double)backupThresholdSqr) {
            if (dummy.wantToBrake || !dummy.forwardCommandActive) {
                dummy.forwardCommandActive = false;
                dummy.wantToBrake = false;
                dummy.reverseCommandActive = true;
            } else {
                dummy.forwardCommandActive = false;
                dummy.wantToBrake = true;
            }
        } else if (dummy.forwardCommandActive) {
            dummy.forwardCommandActive = false;
        } else {
            dummy.wantToBrake = true;
        }
    }

    public void handle(ServerGamePacketListener gamePacketListener) {
        LOGGER.debug("Handle ServerboundTerminalSelectionPacket");
        if (this.terminalPos == null) {
            LOGGER.warn("terminalPos was null!");
            return;
        }
        if (gamePacketListener instanceof ServerGamePacketListenerImpl) {
            try {
                ServerGamePacketListenerImpl serverHandler = (ServerGamePacketListenerImpl)gamePacketListener;
                CompoundTag nbt = new CompoundTag();
                Level world = serverHandler.f_9743_.m_9236_();
                boolean terminalPosLoaded = false;
                boolean isValidDummyEntity = false;
                DummyEntity dummy = null;
                if (world != null) {
                    Entity testEntity = world.m_6815_(this.dummyId.intValue());
                    boolean bl = isValidDummyEntity = testEntity instanceof DummyEntity && !testEntity.m_213877_();
                    if (isValidDummyEntity) {
                        dummy = (DummyEntity)testEntity;
                        LOGGER.debug("Server Update Dummy: " + dummy + " with ID=" + this.dummyId + " and uniqueId=" + dummy.uniqueId);
                    }
                    terminalPosLoaded = world.m_46749_(this.terminalPos);
                }
                if (terminalPosLoaded || isValidDummyEntity) {
                    boolean isShipTerminal;
                    BlockState terminalState = null;
                    if (terminalPosLoaded) {
                        terminalState = world.m_8055_(this.terminalPos);
                    }
                    boolean bl = isShipTerminal = terminalState != null && terminalState.m_60713_((Block)XenoBlocks.BLOCK_SHIP_TERMINAL.get());
                    if (isShipTerminal || isValidDummyEntity) {
                        BlockEntity blockEntity;
                        LOGGER.debug("Got terminal selection for command: " + this.terminalCommand.name());
                        if (this.terminalCommand == TerminalCommand.CONSTRUCT_NEW_SHIP) {
                            DummyEntity newDummy = DummyEntity.getEntity(0.0f, world, this.terminalPos, true, true);
                            this.addCreationMetrics(serverHandler, newDummy);
                        } else if (this.terminalCommand == TerminalCommand.REASSEMBLE && terminalPosLoaded && (blockEntity = world.m_7702_(this.terminalPos)) instanceof ShipTerminalBlockEntity) {
                            ShipTerminalBlockEntity terminalEntity = (ShipTerminalBlockEntity)blockEntity;
                            LOGGER.debug("begin reassembly with terminalPos=" + this.terminalPos);
                            DummyEntity newDummy = (DummyEntity)DummyEntity.DUMMY_ENTITY.m_20615_(world);
                            newDummy.m_146884_(new Vec3((double)this.terminalPos.m_123341_() + 0.5, (double)this.terminalPos.m_123342_(), (double)this.terminalPos.m_123343_() + 0.5));
                            if (terminalState.m_61145_((Property)BlockStateProperties.f_61374_).isPresent()) {
                                Direction facing = (Direction)terminalState.m_61143_((Property)BlockStateProperties.f_61374_);
                                facing = facing.m_122424_();
                                LOGGER.debug("Set yRot to " + facing.m_122435_());
                                newDummy.m_146922_(facing.m_122435_());
                            }
                            newDummy.uniqueId = terminalEntity.reassemblyUniqueId;
                            newDummy.setMetric_BlocksTravelled(terminalEntity.metricsBlocksTravelled);
                            newDummy.setMetric_TimeSpentConsumingFuel(terminalEntity.metricsTimeSpentConsumingFuelSec);
                            newDummy.setMetric_TimeUntilEmpty(terminalEntity.metricsTimeUntilEmptySec);
                            newDummy.setMetric_CreationDate(terminalEntity.metricsCreationDate);
                            newDummy.setMetric_CreatorName(terminalEntity.metricsCreatorName);
                            DummyEntity.ReassemblyFailureInfo rfi = new DummyEntity.ReassemblyFailureInfo();
                            if (newDummy.reassemble(rfi)) {
                                world.m_7967_((Entity)newDummy);
                                if (StringUtils.isEmpty((CharSequence)newDummy.getMetric_CreationDate()) && StringUtils.isEmpty((CharSequence)newDummy.getMetric_CreatorName())) {
                                    this.addCreationMetrics(serverHandler, newDummy);
                                }
                            } else {
                                newDummy.m_6074_();
                                if (rfi.failureText != null) {
                                    rfi.failureText = rfi.failureText + " \n \n Replace this block to proceed.";
                                    XenoTechNetwork.INSTANCE.send(PacketDistributor.PLAYER.with(() -> serverHandler.f_9743_), (Object)new ClientboundShipTerminalPacket(1, rfi.failureText));
                                }
                            }
                        }
                        if (isValidDummyEntity) {
                            if (this.terminalCommand == TerminalCommand.SHIP_HOVER) {
                                dummy.wantToBrake = true;
                                dummy.forwardCommandActive = false;
                                ServerboundTerminalSelectionPacket.shipHoverLogic(dummy);
                            } else if (this.terminalCommand == TerminalCommand.SHIP_ASCEND_LONG) {
                                ServerboundTerminalSelectionPacket.shipAscendLogic(dummy, true);
                            } else if (this.terminalCommand == TerminalCommand.SHIP_DESCEND_LONG) {
                                ServerboundTerminalSelectionPacket.shipDescendLogic(dummy, true);
                            } else if (this.terminalCommand == TerminalCommand.SHIP_ASCEND) {
                                ServerboundTerminalSelectionPacket.shipAscendLogic(dummy, false);
                            } else if (this.terminalCommand == TerminalCommand.SHIP_DESCEND) {
                                ServerboundTerminalSelectionPacket.shipDescendLogic(dummy, false);
                            } else if (this.terminalCommand == TerminalCommand.SHIP_RIGHT45) {
                                dummy.turn(45.0f);
                            } else if (this.terminalCommand == TerminalCommand.SHIP_LEFT45) {
                                dummy.turn(-45.0f);
                            } else if (this.terminalCommand == TerminalCommand.SHIP_FORWARD) {
                                ServerboundTerminalSelectionPacket.shipForwardLogic(dummy);
                            } else if (this.terminalCommand == TerminalCommand.SHIP_SCUTTLE) {
                                dummy.m_6074_();
                            } else if (this.terminalCommand == TerminalCommand.SHIP_DIGITIZE) {
                                dummy.digitize(serverHandler.f_9743_);
                            } else if (this.terminalCommand == TerminalCommand.SHIP_DISABLE_DRILL) {
                                dummy.setDrillEnabled(false);
                            } else if (this.terminalCommand == TerminalCommand.SHIP_DISABLE_BUZZSAW) {
                                dummy.setBuzzsawEnabled(false);
                            } else if (this.terminalCommand == TerminalCommand.SHIP_DISABLE_WEAPONS) {
                                dummy.setWeaponsEnabled(false);
                            } else if (this.terminalCommand == TerminalCommand.SHIP_ENABLE_DRILL) {
                                dummy.setDrillEnabled(true);
                            } else if (this.terminalCommand == TerminalCommand.SHIP_ENABLE_BUZZSAW) {
                                dummy.setBuzzsawEnabled(true);
                            } else if (this.terminalCommand == TerminalCommand.SHIP_ENABLE_WEAPONS) {
                                dummy.setWeaponsEnabled(true);
                            } else if (this.terminalCommand == TerminalCommand.SHIP_DISASSEMBLE) {
                                dummy.disassemble();
                            } else if (this.terminalCommand == TerminalCommand.SHIP_TAKE_CONTROL) {
                                dummy.forwardCommandActive = false;
                                serverHandler.f_9743_.m_20329_((Entity)dummy);
                            } else if (this.terminalCommand == TerminalCommand.SHIP_LEFT5) {
                                dummy.turn(-5.0f);
                            } else if (this.terminalCommand == TerminalCommand.SHIP_RIGHT5) {
                                dummy.turn(5.0f);
                            } else if (this.terminalCommand == TerminalCommand.SHIP_STOP_TURNING) {
                                dummy.zeroYRotRequest();
                            } else if (this.terminalCommand == TerminalCommand.SHIP_STOP_AUTOPILOT) {
                                dummy.forwardCommandActive = false;
                            } else if (this.terminalCommand == TerminalCommand.SHIP_WANT_TO_BRAKE) {
                                ServerboundTerminalSelectionPacket.shipWantToBrakeLogic(dummy);
                            } else if (this.terminalCommand == TerminalCommand.SHIP_STOP_AUTOPILOT_OR_BRAKE_OR_REVERSE) {
                                ServerboundTerminalSelectionPacket.shipBrakeOrReverseLogic(dummy);
                            }
                        }
                    }
                } else {
                    LOGGER.warn("Invalid world or position: world=" + world + ", pos=" + this.terminalPos);
                }
            }
            catch (Exception ex) {
                LOGGER.error("Got error handling ServerboundTerminalSelectionPacket", (Throwable)ex);
            }
        }
    }

    private void addCreationMetrics(ServerGamePacketListenerImpl serverHandler, DummyEntity newDummy) {
        ZonedDateTime zonedDt = ZonedDateTime.now();
        String dateText = zonedDt.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm O"));
        newDummy.setMetric_CreationDate(dateText);
        newDummy.setMetric_CreatorName(serverHandler.f_9743_.m_7755_().getString());
    }

    public static enum TerminalCommand {
        CONSTRUCT_NEW_SHIP,
        REASSEMBLE,
        SHIP_HOVER,
        SHIP_ASCEND_LONG,
        SHIP_DESCEND_LONG,
        SHIP_ASCEND,
        SHIP_DESCEND,
        SHIP_FORWARD,
        SHIP_RIGHT45,
        SHIP_LEFT45,
        SHIP_SCUTTLE,
        SHIP_DIGITIZE,
        SHIP_DISABLE_DRILL,
        SHIP_ENABLE_DRILL,
        SHIP_DISABLE_BUZZSAW,
        SHIP_ENABLE_BUZZSAW,
        SHIP_DISABLE_WEAPONS,
        SHIP_ENABLE_WEAPONS,
        SHIP_DISASSEMBLE,
        SHIP_TAKE_CONTROL,
        SHIP_LEFT5,
        SHIP_RIGHT5,
        SHIP_STOP_TURNING,
        SHIP_STOP_AUTOPILOT,
        SHIP_WANT_TO_BRAKE,
        SHIP_STOP_AUTOPILOT_OR_BRAKE_OR_REVERSE;

    }
}

