/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.xenotech.spellrenderer;

import com.dairymoose.xenotech.spellrenderer.SpellRenderer;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;

public class SparkRenderer
extends SpellRenderer {
    private float[] rands;
    private int segments;
    private static final float RAND_DEGREES_MAX = 45.0f;
    public static final int SPELL_ID_SPARK = 1;
    float randDegreesXpLast;
    float randDegreesYpLast;

    @Override
    public void init() {
        this.segments = 15;
        this.rands = new float[this.segments * 3];
        for (int i = 0; i < this.segments * 3; ++i) {
            this.rands[i] = (float)Math.random();
        }
    }

    @Override
    public int getSpellId() {
        return 1;
    }

    @Override
    public int getSpellRenderTimeMs() {
        return 600;
    }

    private void applyRandomRotations(PoseStack matrixStack, float randA, float randB, boolean invertLast) {
        if (invertLast) {
            matrixStack.m_252781_(Axis.f_252436_.m_252977_(-this.randDegreesYpLast));
            matrixStack.m_252781_(Axis.f_252529_.m_252977_(-this.randDegreesXpLast));
        } else {
            float randDegreesXp = randA * 45.0f - 22.5f;
            matrixStack.m_252781_(Axis.f_252529_.m_252977_(randDegreesXp));
            float randDegreesYp = randB * 45.0f - 22.5f;
            matrixStack.m_252781_(Axis.f_252436_.m_252977_(randDegreesYp));
            this.randDegreesXpLast = randDegreesXp;
            this.randDegreesYpLast = randDegreesYp;
        }
    }

    @Override
    public void renderSpell(PoseStack matrixStack, float progress) {
        matrixStack.m_85836_();
        float boltWidth = 0.015f;
        float boltLength = 0.25f;
        float boltRandomLengthFactor = 0.12f;
        progress /= 0.25f;
        matrixStack.m_252781_(Axis.f_252495_.m_252977_(5.0f));
        float calculatedLength = 0.0f;
        for (int i = 0; i < this.segments; ++i) {
            float oneSegment = 1.0f / (float)this.segments;
            float requiredProgress = (float)i * oneSegment;
            if (!(progress >= requiredProgress)) continue;
            matrixStack.m_252880_(0.0f, 0.0f, calculatedLength);
            calculatedLength = boltLength + this.rands[i * 3 + 0] * boltRandomLengthFactor - boltRandomLengthFactor / 2.0f;
            boolean invert = i % 2 == 1;
            this.applyRandomRotations(matrixStack, this.rands[i * 3 + 1], this.rands[i * 3 + 2], invert);
            this.renderGlowingCuboid(matrixStack, boltWidth, calculatedLength *= Math.min((progress - requiredProgress) / oneSegment, 1.0f), 0xAAD2D2, 0.45f);
        }
        matrixStack.m_85849_();
    }
}

