/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.xenotech.spellrenderer;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.GameRenderer;
import org.joml.Matrix4f;

public abstract class SpellRenderer {
    public abstract int getSpellRenderTimeMs();

    public abstract int getSpellId();

    protected void renderFace(BufferBuilder bufferbuilder, PoseStack matrixStack, float width, float height, int rgb, float alpha) {
        Matrix4f matrix = matrixStack.m_85850_().m_252922_();
        int rI = (rgb & 0xFF0000) >> 16;
        int gI = (rgb & 0xFF00) >> 8;
        int bI = (rgb & 0xFF) >> 0;
        float r = (float)rI / 255.0f;
        float g = (float)gI / 255.0f;
        float b = (float)bI / 255.0f;
        bufferbuilder.m_252986_(matrix, 0.0f, height, 0.0f).m_85950_(r, g, b, alpha).m_5752_();
        bufferbuilder.m_252986_(matrix, width, height, 0.0f).m_85950_(r, g, b, alpha).m_5752_();
        bufferbuilder.m_252986_(matrix, width, 0.0f, 0.0f).m_85950_(r, g, b, alpha).m_5752_();
        bufferbuilder.m_252986_(matrix, 0.0f, 0.0f, 0.0f).m_85950_(r, g, b, alpha).m_5752_();
    }

    protected void renderCuboid(PoseStack matrixStack, float smallFace, float longFace, int rgb, float alpha) {
        matrixStack.m_85836_();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        RenderSystem.setShader(GameRenderer::m_172811_);
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        this.renderFace(bufferbuilder, matrixStack, smallFace, smallFace, rgb, alpha);
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
        matrixStack.m_252880_(-longFace, 0.0f, 0.0f);
        this.renderFace(bufferbuilder, matrixStack, longFace, smallFace, rgb, alpha);
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
        matrixStack.m_252880_(-smallFace, 0.0f, 0.0f);
        this.renderFace(bufferbuilder, matrixStack, smallFace, smallFace, rgb, alpha);
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
        matrixStack.m_252880_(-longFace, 0.0f, 0.0f);
        this.renderFace(bufferbuilder, matrixStack, longFace, smallFace, rgb, alpha);
        matrixStack.m_252880_(0.0f, 0.0f, smallFace);
        matrixStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
        this.renderFace(bufferbuilder, matrixStack, longFace, smallFace, rgb, alpha);
        matrixStack.m_252781_(Axis.f_252529_.m_252977_(180.0f));
        matrixStack.m_252880_(0.0f, -smallFace, -smallFace);
        this.renderFace(bufferbuilder, matrixStack, longFace, smallFace, rgb, alpha);
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
        RenderSystem.disableBlend();
        matrixStack.m_85849_();
    }

    protected void renderGlowingCuboid(PoseStack matrixStack, float smallFace, float longFace, int rgb, float alpha) {
        matrixStack.m_85836_();
        float scaleFactor = 1.03f;
        float translateValue = -(0.02f * scaleFactor);
        for (int j = 0; j < 3; ++j) {
            this.renderCuboid(matrixStack, smallFace, longFace, rgb, alpha);
            alpha /= 1.3f;
            matrixStack.m_252880_(translateValue * smallFace, translateValue * smallFace, translateValue * longFace);
            matrixStack.m_85841_(scaleFactor, scaleFactor, scaleFactor);
        }
        matrixStack.m_85849_();
    }

    public abstract void renderSpell(PoseStack var1, float var2);

    public void init() {
    }
}

