/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.xenotech.world.level.block;

import com.dairymoose.xenotech.XenoBlocks;
import com.dairymoose.xenotech.XenoTechUtils;
import com.dairymoose.xenotech.client.gui.screens.TerminalScreen;
import com.dairymoose.xenotech.network.ServerboundTerminalSelectionPacket;
import com.dairymoose.xenotech.network.XenoTechNetwork;
import com.dairymoose.xenotech.world.level.block.entity.ShipTerminalBlockEntity;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.IModFileInfo;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ShipTerminalBlock
extends BaseEntityBlock {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final DirectionProperty FACING;
    protected static final VoxelShape SHAPE_NORTH;
    protected static final VoxelShape SHAPE_EAST;
    protected static final VoxelShape SHAPE_SOUTH;
    protected static final VoxelShape SHAPE_WEST;

    public ShipTerminalBlock(BlockBehaviour.Properties p_i48413_1_) {
        super(p_i48413_1_);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public VoxelShape m_5940_(BlockState bs, BlockGetter reader, BlockPos pos, CollisionContext sel) {
        switch ((Direction)bs.m_61143_((Property)FACING)) {
            case NORTH: {
                return SHAPE_NORTH;
            }
            case SOUTH: {
                return SHAPE_SOUTH;
            }
            case EAST: {
                return SHAPE_EAST;
            }
            case WEST: {
                return SHAPE_WEST;
            }
        }
        return SHAPE_NORTH;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static Button.OnPress onPress_airVehicleButton(final TerminalScreen thisTerminal) {
        return new Button.OnPress(){

            public void m_93750_(Button arg0) {
                thisTerminal.setTerminalData(new TerminalScreen.TerminalData(Component.m_237115_((String)"terminal.xenotech.air_vehicle_more_details"), List.of(new TerminalScreen.TerminalButton(Component.m_237115_((String)"terminal.xenotech.back"), TerminalScreen.onPress_back(thisTerminal)), new TerminalScreen.TerminalButton(Component.m_237115_((String)"terminal.xenotech.exit"), TerminalScreen.onPress_exit(thisTerminal)))));
                thisTerminal.reinit();
            }
        };
    }

    @OnlyIn(value=Dist.CLIENT)
    public static Button.OnPress onPress_waterVehicleButton(final TerminalScreen thisTerminal) {
        return new Button.OnPress(){

            public void m_93750_(Button arg0) {
                thisTerminal.setTerminalData(new TerminalScreen.TerminalData(Component.m_237115_((String)"terminal.xenotech.water_vehicle_more_details"), List.of(new TerminalScreen.TerminalButton(Component.m_237115_((String)"terminal.xenotech.back"), TerminalScreen.onPress_back(thisTerminal)), new TerminalScreen.TerminalButton(Component.m_237115_((String)"terminal.xenotech.exit"), TerminalScreen.onPress_exit(thisTerminal)))));
                thisTerminal.reinit();
            }
        };
    }

    @OnlyIn(value=Dist.CLIENT)
    public static Button.OnPress onPress_groundVehicleButton(final TerminalScreen thisTerminal) {
        return new Button.OnPress(){

            public void m_93750_(Button arg0) {
                thisTerminal.setTerminalData(new TerminalScreen.TerminalData(Component.m_237115_((String)"terminal.xenotech.ground_vehicle_more_details"), List.of(new TerminalScreen.TerminalButton(Component.m_237115_((String)"terminal.xenotech.back"), TerminalScreen.onPress_back(thisTerminal)), new TerminalScreen.TerminalButton(Component.m_237115_((String)"terminal.xenotech.exit"), TerminalScreen.onPress_exit(thisTerminal)))));
                thisTerminal.reinit();
            }
        };
    }

    @OnlyIn(value=Dist.CLIENT)
    public static Button.OnPress onPress_moreDetails(final TerminalScreen thisTerminal) {
        return new Button.OnPress(){

            public void m_93750_(Button arg0) {
                thisTerminal.setTerminalData(new TerminalScreen.TerminalData(Component.m_237115_((String)"terminal.xenotech.no_locomotion_more_details"), List.of(new TerminalScreen.TerminalButton(Component.m_237115_((String)"terminal.xenotech.ground_vehicle"), ShipTerminalBlock.onPress_groundVehicleButton(thisTerminal)), new TerminalScreen.TerminalButton(Component.m_237115_((String)"terminal.xenotech.water_vehicle"), ShipTerminalBlock.onPress_waterVehicleButton(thisTerminal)), new TerminalScreen.TerminalButton(Component.m_237115_((String)"terminal.xenotech.airship"), ShipTerminalBlock.onPress_airVehicleButton(thisTerminal)), new TerminalScreen.TerminalButton(), new TerminalScreen.TerminalButton(Component.m_237115_((String)"terminal.xenotech.back"), TerminalScreen.onPress_back(thisTerminal)), new TerminalScreen.TerminalButton(Component.m_237115_((String)"terminal.xenotech.exit"), TerminalScreen.onPress_exit(thisTerminal)))));
                thisTerminal.reinit();
            }
        };
    }

    @OnlyIn(value=Dist.CLIENT)
    public static Button.OnPress onPress_yesBuildShip(final TerminalScreen thisTerminal) {
        return new Button.OnPress(){

            public void m_93750_(Button arg0) {
                thisTerminal.setTerminalData(new TerminalScreen.TerminalData(Component.m_237115_((String)"terminal.xenotech.constructed"), List.of(new TerminalScreen.TerminalButton(Component.m_237115_((String)"terminal.xenotech.exit"), TerminalScreen.onPress_exit(thisTerminal)))));
                thisTerminal.reinit();
                XenoTechNetwork.INSTANCE.sendToServer((Object)new ServerboundTerminalSelectionPacket(ServerboundTerminalSelectionPacket.TerminalCommand.CONSTRUCT_NEW_SHIP, null, thisTerminal.pos));
            }
        };
    }

    @OnlyIn(value=Dist.CLIENT)
    public static Button.OnPress onPress_reassembleShip(final TerminalScreen thisTerminal) {
        return new Button.OnPress(){

            public void m_93750_(Button arg0) {
                thisTerminal.setTerminalData(new TerminalScreen.TerminalData(Component.m_237115_((String)"terminal.xenotech.reassembly_in_progress"), List.of(new TerminalScreen.TerminalButton(Component.m_237115_((String)"terminal.xenotech.exit"), TerminalScreen.onPress_exit(thisTerminal)))));
                thisTerminal.reinit();
                XenoTechNetwork.INSTANCE.sendToServer((Object)new ServerboundTerminalSelectionPacket(ServerboundTerminalSelectionPacket.TerminalCommand.REASSEMBLE, null, thisTerminal.pos));
            }
        };
    }

    @OnlyIn(value=Dist.CLIENT)
    public static Button.OnPress onPress_newShipButton(final TerminalScreen thisTerminal) {
        return new Button.OnPress(){

            public void m_93750_(Button arg0) {
                XenoTechUtils.FailureInfo failure = new XenoTechUtils.FailureInfo();
                XenoTechUtils.CompositionInfo composition = new XenoTechUtils.CompositionInfo();
                Set<BlockPos> blocks = XenoTechUtils.getNewShipBlocks((Level)Minecraft.m_91087_().f_91073_, thisTerminal.pos, failure, composition);
                if (blocks == null) {
                    if (failure.code == XenoTechUtils.FailureCode.NO_MOVER_AND_NO_STEERING || failure.code == XenoTechUtils.FailureCode.NO_STEERING || failure.code == XenoTechUtils.FailureCode.NO_MOVER) {
                        thisTerminal.setTerminalData(new TerminalScreen.TerminalData(Component.m_237115_((String)"terminal.xenotech.diagnostic_error").getString() + failure.text, List.of(new TerminalScreen.TerminalButton(Component.m_237115_((String)"terminal.xenotech.more_details"), ShipTerminalBlock.onPress_moreDetails(thisTerminal)), new TerminalScreen.TerminalButton(), new TerminalScreen.TerminalButton(Component.m_237115_((String)"terminal.xenotech.back"), TerminalScreen.onPress_back(thisTerminal)), new TerminalScreen.TerminalButton(Component.m_237115_((String)"terminal.xenotech.exit"), TerminalScreen.onPress_exit(thisTerminal)))));
                        thisTerminal.reinit();
                    } else {
                        thisTerminal.setTerminalData(new TerminalScreen.TerminalData(Component.m_237115_((String)"terminal.xenotech.diagnostic_error").getString() + failure.text, List.of(new TerminalScreen.TerminalButton(Component.m_237115_((String)"terminal.xenotech.back"), TerminalScreen.onPress_back(thisTerminal)), new TerminalScreen.TerminalButton(Component.m_237115_((String)"terminal.xenotech.exit"), TerminalScreen.onPress_exit(thisTerminal)))));
                        thisTerminal.reinit();
                    }
                } else {
                    thisTerminal.setTerminalData(new TerminalScreen.TerminalData(Component.m_237115_((String)"terminal.xenotech.construction_is_possible").getString() + failure.text, List.of(new TerminalScreen.TerminalButton(Component.m_237115_((String)"terminal.xenotech.yes"), ShipTerminalBlock.onPress_yesBuildShip(thisTerminal)), new TerminalScreen.TerminalButton(Component.m_237115_((String)"terminal.xenotech.no"), TerminalScreen.onPress_exit(thisTerminal)), new TerminalScreen.TerminalButton(), new TerminalScreen.TerminalButton(Component.m_237115_((String)"terminal.xenotech.back"), TerminalScreen.onPress_back(thisTerminal)), new TerminalScreen.TerminalButton(Component.m_237115_((String)"terminal.xenotech.exit"), TerminalScreen.onPress_exit(thisTerminal)))));
                    thisTerminal.reinit();
                }
            }
        };
    }

    public InteractionResult m_6227_(BlockState state, Level level, final BlockPos pos, Player p_60506_, InteractionHand p_60507_, BlockHitResult p_60508_) {
        if (level.f_46443_) {
            IModFileInfo modFileInfo = ModList.get().getModFileById("xenotech");
            final String version = modFileInfo.versionString();
            BlockEntity blockEntity = level.m_7702_(pos);
            long reassemblyUniqueId = -1L;
            if (blockEntity instanceof ShipTerminalBlockEntity) {
                ShipTerminalBlockEntity terminalEntity = (ShipTerminalBlockEntity)blockEntity;
                reassemblyUniqueId = terminalEntity.reassemblyUniqueId;
            }
            final long reassemblyUIDFinal = reassemblyUniqueId;
            LOGGER.info("pos = " + pos + " with state=" + level.m_8055_(pos));
            DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> new Runnable(){

                @Override
                public void run() {
                    TerminalScreen terminal = new TerminalScreen(pos);
                    terminal.setTerminalData(new TerminalScreen.TerminalData(Component.m_237110_((String)"terminal.xenotech.booted", (Object[])new Object[]{version}), List.of(reassemblyUIDFinal != -1L ? new TerminalScreen.TerminalButton(Component.m_237115_((String)"terminal.xenotech.reassemble_ship"), ShipTerminalBlock.onPress_reassembleShip(terminal)) : new TerminalScreen.TerminalButton(), new TerminalScreen.TerminalButton(Component.m_237115_((String)"terminal.xenotech.construct_new_ship"), ShipTerminalBlock.onPress_newShipButton(terminal)), new TerminalScreen.TerminalButton(Component.m_237115_((String)"terminal.xenotech.exit"), TerminalScreen.onPress_exit(terminal)))));
                    Minecraft.m_91087_().m_91152_((Screen)terminal);
                }
            });
        }
        return InteractionResult.CONSUME;
    }

    public BlockState m_6843_(BlockState p_52790_, Rotation p_52791_) {
        return (BlockState)p_52790_.m_61124_((Property)FACING, (Comparable)p_52791_.m_55954_((Direction)p_52790_.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState p_52787_, Mirror p_52788_) {
        return p_52788_ == Mirror.NONE ? p_52787_ : p_52787_.m_60717_(p_52788_.m_54846_((Direction)p_52787_.m_61143_((Property)FACING)));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_206840_1_) {
        p_206840_1_.m_61104_(new Property[]{FACING});
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockEntity m_142194_(BlockPos paramBlockPos, BlockState paramBlockState) {
        return ((BlockEntityType)XenoBlocks.BLOCK_ENTITY_SHIP_TERMINAL.get()).m_155264_(paramBlockPos, paramBlockState);
    }

    static {
        SHAPE_NORTH = Stream.of(Block.m_49796_((double)1.25, (double)0.0, (double)-0.5, (double)14.75, (double)2.25, (double)6.0), Block.m_49796_((double)1.0, (double)2.25, (double)5.0, (double)15.0, (double)5.0, (double)16.0), Block.m_49796_((double)13.0, (double)0.0, (double)14.0, (double)15.0, (double)2.25, (double)16.0), Block.m_49796_((double)1.0, (double)0.0, (double)14.0, (double)3.0, (double)2.25, (double)16.0), Block.m_49796_((double)1.6250000000000002, (double)1.0, (double)0.3749999999999999, (double)1.7250000000000003, (double)1.075, (double)0.47499999999999987), Block.m_49796_((double)1.4999999999999998, (double)1.0, (double)0.3749999999999999, (double)1.5999999999999999, (double)1.075, (double)0.47499999999999987), Block.m_49796_((double)1.6250000000000002, (double)1.0, (double)0.25, (double)1.7250000000000003, (double)1.075, (double)0.35), Block.m_49796_((double)1.4999999999999998, (double)1.0, (double)0.25, (double)1.5999999999999999, (double)1.075, (double)0.35), Block.m_49796_((double)14.275, (double)1.0, (double)0.3749999999999999, (double)14.375, (double)1.075, (double)0.47499999999999987), Block.m_49796_((double)14.4, (double)1.0, (double)0.3749999999999999, (double)14.500000000000002, (double)1.075, (double)0.47499999999999987), Block.m_49796_((double)14.275, (double)1.0, (double)0.25, (double)14.375, (double)1.075, (double)0.35), Block.m_49796_((double)14.4, (double)1.0, (double)0.25, (double)14.500000000000002, (double)1.075, (double)0.35), Block.m_49796_((double)14.4, (double)1.0, (double)5.25, (double)14.500000000000002, (double)1.075, (double)5.35), Block.m_49796_((double)14.275, (double)1.0, (double)5.25, (double)14.375, (double)1.075, (double)5.35), Block.m_49796_((double)14.4, (double)1.0, (double)5.375, (double)14.500000000000002, (double)1.075, (double)5.475), Block.m_49796_((double)14.275, (double)1.0, (double)5.375, (double)14.375, (double)1.075, (double)5.475), Block.m_49796_((double)1.6250000000000004, (double)1.0, (double)5.25, (double)1.7250000000000019, (double)1.075, (double)5.35), Block.m_49796_((double)1.5000000000000004, (double)1.0, (double)5.25, (double)1.6, (double)1.075, (double)5.35), Block.m_49796_((double)1.6250000000000004, (double)1.0, (double)5.375, (double)1.7250000000000019, (double)1.075, (double)5.475), Block.m_49796_((double)1.5000000000000004, (double)1.0, (double)5.375, (double)1.6, (double)1.075, (double)5.475), Block.m_49796_((double)1.0, (double)14.25, (double)5.0, (double)15.0, (double)16.0, (double)16.0), Block.m_49796_((double)13.25, (double)5.0, (double)5.0, (double)15.0, (double)14.25, (double)16.0), Block.m_49796_((double)1.0, (double)5.0, (double)5.0, (double)2.75, (double)14.25, (double)16.0), Block.m_49796_((double)2.75, (double)5.0, (double)15.0, (double)13.25, (double)14.25, (double)16.0), Block.m_49796_((double)2.75, (double)5.0, (double)6.25, (double)13.25, (double)14.25, (double)15.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
        SHAPE_EAST = XenoTechUtils.RotateVoxelShapeClockwise(SHAPE_NORTH);
        SHAPE_SOUTH = XenoTechUtils.RotateVoxelShapeClockwise(SHAPE_EAST);
        SHAPE_WEST = XenoTechUtils.RotateVoxelShapeClockwise(SHAPE_SOUTH);
        FACING = HorizontalDirectionalBlock.f_54117_;
    }
}

