/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.xenotech.world.level.block;

import com.dairymoose.xenotech.XenoBlocks;
import com.dairymoose.xenotech.block.SiftingNetBlock;
import com.dairymoose.xenotech.world.level.block.entity.SiftingNetPostBlockEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SiftingNetPostBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    private static final Logger LOGGER = LogManager.getLogger();
    public static BooleanProperty POST_ONLY = BooleanProperty.m_61465_((String)"post_only");
    public static BooleanProperty NORTH = BooleanProperty.m_61465_((String)"north");
    public static BooleanProperty EAST = BooleanProperty.m_61465_((String)"east");
    public static BooleanProperty SOUTH = BooleanProperty.m_61465_((String)"south");
    public static BooleanProperty WEST = BooleanProperty.m_61465_((String)"west");
    private static List<Item> fishItems = new ArrayList<Item>();
    protected static final VoxelShape NORTH_AABB = SiftingNetPostBlock.makeShape();
    protected static final VoxelShape NORTH_AABB_POST_ONLY = SiftingNetPostBlock.makeShapePostOnly();
    private final RecipeManager.CachedCheck<Container, CampfireCookingRecipe> quickCheck = RecipeManager.m_220267_((RecipeType)RecipeType.f_44111_);

    public SiftingNetPostBlock(BlockBehaviour.Properties p_49795_) {
        super(p_49795_.m_60955_());
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)POST_ONLY, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{NORTH}).m_61104_(new Property[]{EAST}).m_61104_(new Property[]{SOUTH}).m_61104_(new Property[]{WEST}).m_61104_(new Property[]{BlockStateProperties.f_61362_}).m_61104_(new Property[]{POST_ONLY});
        super.m_7926_(builder);
    }

    public void m_6402_(Level level, BlockPos blockPos, BlockState p_49849_, LivingEntity p_49850_, ItemStack p_49851_) {
        super.m_6402_(level, blockPos, p_49849_, p_49850_, p_49851_);
        BlockEntity blockEntity = level.m_7702_(blockPos);
        if (blockEntity instanceof SiftingNetPostBlockEntity) {
            SiftingNetPostBlockEntity sifting = (SiftingNetPostBlockEntity)blockEntity;
            sifting.updateSiftingNetMap();
        }
    }

    public boolean m_6724_(BlockState blockState) {
        if (SiftingNetPostBlock.isValidContainerBlock(blockState)) {
            Block block = blockState.m_60734_();
            if (block instanceof SiftingNetPostBlock) {
                SiftingNetPostBlock post = (SiftingNetPostBlock)block;
                return (Boolean)blockState.m_61143_((Property)BlockStateProperties.f_61362_);
            }
            return false;
        }
        return false;
    }

    public void m_213898_(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource randSource) {
        if (!serverLevel.isAreaLoaded(blockPos, 1)) {
            return;
        }
        BlockEntity blockEntity = serverLevel.m_7702_(blockPos);
        if (blockEntity instanceof SiftingNetPostBlockEntity) {
            SiftingNetPostBlockEntity sifting = (SiftingNetPostBlockEntity)blockEntity;
            float speedMult = 1.0f;
            if (randSource.m_188503_((int)(32.0f / speedMult) + 1) == 0) {
                int fishResult = randSource.m_188503_(80);
                if (fishResult == 0) {
                    if (fishItems.isEmpty()) {
                        for (Item item : ForgeRegistries.ITEMS.getValues()) {
                            SimpleContainer container;
                            Optional optRecipe;
                            if (!item.m_204114_().m_203656_(ItemTags.f_13156_) || !(optRecipe = this.quickCheck.m_213657_((Container)(container = new SimpleContainer(new ItemStack[]{new ItemStack((ItemLike)item)})), (Level)serverLevel)).isPresent()) continue;
                            fishItems.add(item);
                        }
                    }
                    if (fishItems.size() > 0) {
                        int randFish = randSource.m_188503_(fishItems.size());
                        ItemStack fish = new ItemStack((ItemLike)fishItems.get(randFish));
                        sifting.addItem(fish);
                    } else {
                        LOGGER.warn("Fish list was empty!");
                    }
                } else {
                    int result = randSource.m_188503_(6);
                    if (result <= 3) {
                        ItemStack goldNugget = new ItemStack((ItemLike)Items.f_42587_);
                        sifting.addItem(goldNugget);
                    } else {
                        ItemStack platinumNugget = new ItemStack((ItemLike)XenoBlocks.ITEM_PLATINUM_NUGGET.get());
                        sifting.addItem(platinumNugget);
                    }
                }
            } else {
                int siltResult = randSource.m_188503_(90);
                if (siltResult == 0) {
                    ItemStack silt = new ItemStack((ItemLike)XenoBlocks.ITEM_SILT.get());
                    sifting.addItem(silt);
                }
            }
        }
    }

    public static VoxelShape makeShape() {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.1875, (double)0.0, (double)0.1875, (double)0.8125, (double)0.25, (double)0.8125), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.375, (double)0.25, (double)0.375, (double)0.625, (double)1.125, (double)0.625), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    }

    public static VoxelShape makeShapePostOnly() {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.375, (double)0.125, (double)0.375, (double)0.625, (double)1.125, (double)0.625), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter p_60556_, BlockPos p_60557_, CollisionContext p_60558_) {
        if (((Boolean)state.m_61143_((Property)POST_ONLY)).booleanValue()) {
            return NORTH_AABB_POST_ONLY;
        }
        return NORTH_AABB;
    }

    public FluidState m_5888_(BlockState state) {
        if (((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
            return Fluids.f_76193_.m_76068_(false);
        }
        return super.m_5888_(state);
    }

    public BlockState getNewShape(BlockState state, BlockPos blockPos, LevelAccessor level) {
        BlockState northState = level.m_8055_(blockPos.m_122012_());
        BlockState eastState = level.m_8055_(blockPos.m_122029_());
        BlockState southState = level.m_8055_(blockPos.m_122019_());
        BlockState westState = level.m_8055_(blockPos.m_122024_());
        BlockState belowState = level.m_8055_(blockPos.m_7495_());
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(northState.m_60713_((Block)XenoBlocks.BLOCK_SIFTING_NET.get()) && (northState.m_61143_((Property)SiftingNetBlock.f_54117_) == Direction.NORTH || northState.m_61143_((Property)SiftingNetBlock.f_54117_) == Direction.SOUTH)))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(eastState.m_60713_((Block)XenoBlocks.BLOCK_SIFTING_NET.get()) && (eastState.m_61143_((Property)SiftingNetBlock.f_54117_) == Direction.EAST || eastState.m_61143_((Property)SiftingNetBlock.f_54117_) == Direction.WEST)))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(southState.m_60713_((Block)XenoBlocks.BLOCK_SIFTING_NET.get()) && (southState.m_61143_((Property)SiftingNetBlock.f_54117_) == Direction.NORTH || southState.m_61143_((Property)SiftingNetBlock.f_54117_) == Direction.SOUTH)))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(westState.m_60713_((Block)XenoBlocks.BLOCK_SIFTING_NET.get()) && (westState.m_61143_((Property)SiftingNetBlock.f_54117_) == Direction.EAST || westState.m_61143_((Property)SiftingNetBlock.f_54117_) == Direction.WEST)))).m_61124_((Property)POST_ONLY, (Comparable)Boolean.valueOf(belowState.m_60713_((Block)XenoBlocks.BLOCK_SIFTING_NET_POST.get())));
    }

    public BlockState m_7417_(BlockState p_53323_, Direction p_53324_, BlockState p_53325_, LevelAccessor level, BlockPos thisBlockPos, BlockPos p_53328_) {
        if (((Boolean)p_53323_.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
            level.m_186469_(thisBlockPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return this.getNewShape(super.m_7417_(p_53323_, p_53324_, p_53325_, level, thisBlockPos, p_53328_), thisBlockPos, level);
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        FluidState fluidState = ctx.m_43725_().m_6425_(ctx.m_8083_());
        return this.getNewShape((BlockState)super.m_5573_(ctx).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_)), ctx.m_8083_(), (LevelAccessor)ctx.m_43725_());
    }

    public void m_6810_(BlockState p_51538_, Level p_51539_, BlockPos p_51540_, BlockState p_51541_, boolean p_51542_) {
        if (!p_51538_.m_60713_(p_51541_.m_60734_())) {
            BlockEntity blockentity = p_51539_.m_7702_(p_51540_);
            if (blockentity instanceof Container) {
                Containers.m_19002_((Level)p_51539_, (BlockPos)p_51540_, (Container)((Container)blockentity));
                p_51539_.m_46717_(p_51540_, (Block)this);
            }
            super.m_6810_(p_51538_, p_51539_, p_51540_, p_51541_, p_51542_);
        }
    }

    public MenuProvider m_7246_(BlockState p_52240_, Level level, BlockPos blockPos) {
        BlockEntity blockEntity = level.m_7702_(blockPos);
        if (blockEntity instanceof SiftingNetPostBlockEntity) {
            SiftingNetPostBlockEntity sifting = (SiftingNetPostBlockEntity)blockEntity;
            return new SimpleMenuProvider((syncId, inventory, player) -> new ChestMenu(MenuType.f_39958_, syncId, inventory, (Container)sifting, sifting.m_6643_() / 9), sifting.getDefaultName());
        }
        return null;
    }

    public static boolean isValidContainerBlock(BlockState state) {
        return (Boolean)state.m_61143_((Property)NORTH) != false || (Boolean)state.m_61143_((Property)EAST) != false;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (SiftingNetPostBlock.isValidContainerBlock(state)) {
            if (level.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            if (!player.m_21120_(hand).m_150930_((Item)XenoBlocks.ITEM_SIFTING_NET.get()) && !player.m_21120_(hand).m_150930_((Item)XenoBlocks.ITEM_SIFTING_NET_POST.get())) {
                MenuProvider menuprovider = this.m_7246_(state, level, pos);
                if (menuprovider != null) {
                    player.m_5893_(menuprovider);
                }
                return InteractionResult.CONSUME;
            }
            return InteractionResult.PASS;
        }
        return SiftingNetBlock.scanBothDirectionsForContainer(level, pos, (LivingEntity)player, hand, hitResult);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockEntityType<? extends SiftingNetPostBlockEntity> blockEntityType() {
        return (BlockEntityType)XenoBlocks.BLOCK_ENTITY_SIFTING_NET_POST.get();
    }

    public BlockEntity m_142194_(BlockPos paramBlockPos, BlockState paramBlockState) {
        return ((BlockEntityType)XenoBlocks.BLOCK_ENTITY_SIFTING_NET_POST.get()).m_155264_(paramBlockPos, paramBlockState);
    }
}

