/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.xenotech.world.level.block.entity;

import com.dairymoose.xenotech.XenoBlocks;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.extensions.IForgeItemStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AutocraftingTableBlockEntity
extends BlockEntity
implements Container {
    private static final int CONTAINER_SIZE = 27;
    private NonNullList<ItemStack> items = NonNullList.m_122780_((int)27, (Object)ItemStack.f_41583_);
    private static final Logger LOGGER = LogManager.getLogger();
    private ResourceLocation targetItemResource = null;
    private Item targetItem = Items.f_41852_;
    private ItemStack blueprintReference = ItemStack.f_41583_;
    private Map<HashableItem, List<ItemStack>> itemLookup = new HashMap<HashableItem, List<ItemStack>>();
    public static final BlockEntityType<AutocraftingTableBlockEntity> AUTOCRAFTING_TABLE_BLOCK_ENTITY = BlockEntityType.Builder.m_155273_(AutocraftingTableBlockEntity::new, (Block[])new Block[]{(Block)XenoBlocks.BLOCK_AUTOCRAFTING_TABLE.get()}).m_58966_(null);
    private static List<CraftingRecipe> craftingRecipes = null;
    private static boolean printItemLookupDebug = true;
    private static boolean showDepositDebug = true;
    private static boolean showCraftDebug = true;
    private List<CraftingRecipe> blueprintRecipes = null;
    private int tickCount = 0;

    public AutocraftingTableBlockEntity(BlockPos p_155229_, BlockState p_155230_) {
        super(AUTOCRAFTING_TABLE_BLOCK_ENTITY, p_155229_, p_155230_);
    }

    public static void tick(Level level, BlockPos blockPos, BlockState blockState, AutocraftingTableBlockEntity table) {
        if (!level.f_46443_) {
            ++table.tickCount;
            boolean updatedTargetItem = false;
            ItemStack firstItem = table.m_8020_(0);
            if (firstItem.m_150930_((Item)XenoBlocks.ITEM_BLUEPRINTS.get())) {
                if (table.blueprintReference != firstItem) {
                    Item item;
                    String value;
                    String targetText;
                    String[] targetSplit;
                    String namespace;
                    ResourceLocation rsrc;
                    table.blueprintReference = firstItem;
                    CompoundTag tag = firstItem.m_41783_();
                    if (tag != null && tag.m_128441_("Target") && (rsrc = new ResourceLocation(namespace = (targetSplit = (targetText = tag.m_128461_("Target")).split(":"))[0], value = targetSplit[1])) != null && (item = (Item)ForgeRegistries.ITEMS.getValue(rsrc)) != null) {
                        table.targetItem = item;
                        table.targetItemResource = rsrc;
                        updatedTargetItem = true;
                    }
                }
            } else {
                table.blueprintReference = ItemStack.f_41583_;
                table.blueprintRecipes = null;
                table.targetItem = Items.f_41852_;
            }
            if (table.targetItem != null && table.targetItem != Items.f_41852_ && table.targetItemResource != null) {
                if (craftingRecipes == null) {
                    craftingRecipes = level.m_7465_().m_44013_(RecipeType.f_44107_);
                }
                if (table.blueprintRecipes == null || updatedTargetItem) {
                    table.blueprintRecipes = new ArrayList<CraftingRecipe>();
                    for (CraftingRecipe recipe : craftingRecipes) {
                        if (!recipe.m_8043_(level.m_9598_()).m_41720_().equals(table.targetItem)) continue;
                        table.blueprintRecipes.add(recipe);
                    }
                }
                boolean didCraft = false;
                for (CraftingRecipe recipe : table.blueprintRecipes) {
                    int tableFreeSlot;
                    boolean canCraft = true;
                    ArrayList<ItemStack> craftingItems = new ArrayList<ItemStack>();
                    NonNullList ingredients = null;
                    ingredients = recipe.m_7527_();
                    if (ingredients != null) {
                        HashMap<ItemStack, Integer> claimedItems = new HashMap<ItemStack, Integer>();
                        for (Ingredient ingredient : ingredients) {
                            if (ingredient.m_43908_().length <= 0) continue;
                            ItemStack matchingItem = table.getMatchingItemFromLookupMap(ingredient, claimedItems);
                            if (matchingItem == ItemStack.f_41583_) {
                                canCraft = false;
                                break;
                            }
                            craftingItems.add(matchingItem);
                        }
                    } else {
                        canCraft = false;
                    }
                    if (craftingItems.size() == 0) {
                        canCraft = false;
                    }
                    if (!canCraft || (tableFreeSlot = table.getFirstFreeSlot()) == -1) continue;
                    if (showCraftDebug) {
                        LOGGER.debug("craft item=" + table.targetItem);
                    }
                    if (printItemLookupDebug) {
                        for (Map.Entry<HashableItem, List<ItemStack>> entry : table.itemLookup.entrySet()) {
                            LOGGER.debug("item=" + entry.getKey().item + ", list=" + entry.getValue());
                        }
                    }
                    List<ItemStack> leftOvers = craftingItems.stream().map(IForgeItemStack::getCraftingRemainingItem).toList();
                    AutocraftingCraftingContainer autoContainer = new AutocraftingCraftingContainer(craftingItems);
                    ItemStack assembledItem = recipe.m_5874_((Container)autoContainer, level.m_9598_());
                    BlockEntity blockEntity = level.m_7702_(table.m_58899_().m_7495_());
                    boolean placedInContainer = false;
                    if (blockEntity instanceof Container) {
                        Container outputContainer = (Container)blockEntity;
                        placedInContainer = AutocraftingTableBlockEntity.depositItemIntoContainer(assembledItem, outputContainer);
                    }
                    if (!placedInContainer) {
                        AutocraftingTableBlockEntity.depositItemIntoContainer(assembledItem, table);
                    }
                    if (leftOvers != null && leftOvers.size() > 0) {
                        for (ItemStack leftOver : leftOvers) {
                            AutocraftingTableBlockEntity.depositItemIntoContainer(leftOver, table);
                        }
                    }
                    for (ItemStack itemStack : craftingItems) {
                        if (itemStack.m_41613_() == 1) {
                            table.removeItemStackFromLookupMap(itemStack);
                        }
                        itemStack.m_41620_(1);
                    }
                    didCraft = true;
                    break;
                }
            }
        }
    }

    private static boolean depositItemIntoContainer(ItemStack assembledItem, Container outputContainer) {
        boolean placedInContainer = false;
        for (int i = 0; i < outputContainer.m_6643_(); ++i) {
            ItemStack itemStack = outputContainer.m_8020_(i);
            if (ItemStack.m_150942_((ItemStack)assembledItem, (ItemStack)itemStack) && itemStack.m_41613_() < itemStack.m_41741_()) {
                int diff = itemStack.m_41741_() - itemStack.m_41613_();
                int depositCount = Math.min(diff, assembledItem.m_41613_());
                ItemStack splitItem = assembledItem.m_41620_(depositCount);
                itemStack.m_41769_(splitItem.m_41613_());
                if (showDepositDebug) {
                    LOGGER.debug("crafted item placed into container " + outputContainer + " with count=" + depositCount);
                }
                outputContainer.m_6596_();
                if (!assembledItem.m_41619_()) continue;
                placedInContainer = true;
                break;
            }
            if (!itemStack.m_41619_()) continue;
            outputContainer.m_6836_(i, assembledItem);
            outputContainer.m_6596_();
            if (showDepositDebug) {
                LOGGER.debug("crafted item placed into container: " + outputContainer);
            }
            placedInContainer = true;
            break;
        }
        return placedInContainer;
    }

    private void removeItemStackFromLookupMap(ItemStack itemStack) {
        List<ItemStack> values = this.itemLookup.get(new HashableItem(itemStack.m_41720_()));
        if (values != null) {
            values.remove(itemStack);
        }
    }

    private NonNullList<Ingredient> combineIngredients(NonNullList<Ingredient> ingredients) {
        HashSet<CombineableIngredient> combined = new HashSet<CombineableIngredient>();
        for (Ingredient ingredient : ingredients) {
            if (ingredient == null) continue;
            combined.add(new CombineableIngredient(ingredient));
        }
        NonNullList result = NonNullList.m_122780_((int)combined.size(), (Object)Ingredient.f_43901_);
        int i = 0;
        for (CombineableIngredient combine : combined) {
            result.set(i, (Object)combine.ingredient);
            ++i;
        }
        LOGGER.debug("changed list of size=" + ingredients.size() + " into list of size=" + result.size());
        return result;
    }

    public ItemStack getMatchingItem(Ingredient ingredient, Map<ItemStack, Integer> claimedItems) {
        for (ItemStack ingredientItemStack : ingredient.m_43908_()) {
            for (int i = 0; i < this.m_6643_(); ++i) {
                Integer claimCount;
                ItemStack itemStack = this.m_8020_(i);
                if (!ItemStack.m_41656_((ItemStack)ingredientItemStack, (ItemStack)itemStack) || (claimCount = claimedItems.get(itemStack)) != null && claimCount + 1 > itemStack.m_41613_()) continue;
                if (claimCount == null) {
                    claimCount = 0;
                }
                claimCount = claimCount + 1;
                claimedItems.put(itemStack, claimCount);
                return itemStack;
            }
        }
        return ItemStack.f_41583_;
    }

    public ItemStack getMatchingItemFromLookupMap(Ingredient ingredient, Map<ItemStack, Integer> claimedItems) {
        for (ItemStack ingredientItemStack : ingredient.m_43908_()) {
            List<ItemStack> itemStacks = this.itemLookup.get(new HashableItem(ingredientItemStack.m_41720_()));
            if (itemStacks == null) continue;
            for (ItemStack itemStack : itemStacks) {
                Integer claimCount;
                if (itemStack.m_41619_() || !ItemStack.m_41656_((ItemStack)itemStack, (ItemStack)ingredientItemStack) || (claimCount = claimedItems.get(itemStack)) != null && claimCount + 1 > itemStack.m_41613_()) continue;
                if (claimCount == null) {
                    claimCount = 0;
                }
                claimCount = claimCount + 1;
                claimedItems.put(itemStack, claimCount);
                return itemStack;
            }
        }
        return ItemStack.f_41583_;
    }

    public void m_142466_(CompoundTag p_155588_) {
        super.m_142466_(p_155588_);
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)p_155588_, this.items);
        this.populateItemLookupMap();
    }

    private void populateItemLookupMap() {
        this.itemLookup.clear();
        for (int i = 0; i < this.items.size(); ++i) {
            ItemStack itemStack = (ItemStack)this.items.get(i);
            this.addItemStackToLookupMap(itemStack);
        }
    }

    private void addItemStackToLookupMap(ItemStack itemStack) {
        if (itemStack == ItemStack.f_41583_) {
            return;
        }
        if (itemStack.m_41720_() == Items.f_41852_) {
            return;
        }
        HashableItem key = new HashableItem(itemStack.m_41720_());
        List<ItemStack> values = this.itemLookup.get(key);
        if (values == null) {
            values = new ArrayList<ItemStack>();
            this.itemLookup.put(key, values);
        }
        values.add(itemStack);
        this.removeEmptyItemStacks(values);
    }

    private void removeEmptyItemStacks(List<ItemStack> values) {
        ArrayList<ItemStack> toRemoveList = new ArrayList<ItemStack>();
        for (ItemStack lookupItemStack : values) {
            if (!lookupItemStack.m_41619_()) continue;
            toRemoveList.add(lookupItemStack);
        }
        for (ItemStack toRemove : toRemoveList) {
            values.remove(toRemove);
        }
    }

    protected void m_183515_(CompoundTag p_187502_) {
        super.m_183515_(p_187502_);
        ContainerHelper.m_18973_((CompoundTag)p_187502_, this.items);
    }

    public void m_6211_() {
        this.items.clear();
        this.itemLookup.clear();
    }

    public int m_6643_() {
        return 27;
    }

    public boolean isFull() {
        return this.getFirstFreeSlot() == -1;
    }

    public int getFirstFreeSlot() {
        for (int i = 0; i < this.items.size(); ++i) {
            if (!((ItemStack)this.items.get(i)).m_41619_()) continue;
            return i;
        }
        return -1;
    }

    public boolean m_7983_() {
        for (int i = 0; i < this.items.size(); ++i) {
            if (((ItemStack)this.items.get(i)).m_41619_()) continue;
            return false;
        }
        return true;
    }

    public boolean m_7013_(int slot, ItemStack itemStack) {
        if (slot == this.m_6643_() - 1) {
            return false;
        }
        return super.m_7013_(slot, itemStack);
    }

    public ItemStack m_8020_(int slot) {
        if (slot < 0 || slot >= this.items.size()) {
            return ItemStack.f_41583_;
        }
        return (ItemStack)this.items.get(slot);
    }

    public ItemStack m_7407_(int slot, int count) {
        ItemStack itemstack = ContainerHelper.m_18969_(this.items, (int)slot, (int)count);
        if (!itemstack.m_41619_()) {
            this.m_6596_();
        }
        if (this.m_8020_(slot).m_41619_()) {
            this.removeItemStackFromLookupMap(itemstack);
        }
        return itemstack;
    }

    public ItemStack m_8016_(int slot) {
        ItemStack itemstack = (ItemStack)this.items.get(slot);
        if (itemstack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        this.items.set(slot, (Object)ItemStack.f_41583_);
        return itemstack;
    }

    public void m_6836_(int slot, ItemStack itemStack) {
        if (slot < 0 || slot >= this.items.size()) {
            return;
        }
        this.removeItemStackFromLookupMap((ItemStack)this.items.get(slot));
        this.items.set(slot, (Object)itemStack);
        if (!itemStack.m_41619_() && itemStack.m_41613_() > this.m_6893_()) {
            itemStack.m_41764_(this.m_6893_());
        }
        this.addItemStackToLookupMap(itemStack);
        this.m_6596_();
    }

    public boolean m_6542_(Player player) {
        return true;
    }

    private static class HashableItem {
        Item item;

        public HashableItem(Item item) {
            this.item = item;
        }

        public int hashCode() {
            if (this.item == null) {
                return 0;
            }
            return Item.m_41393_((Item)this.item);
        }

        public boolean equals(Object obj) {
            if (obj instanceof HashableItem) {
                HashableItem other = (HashableItem)obj;
                return Item.m_41393_((Item)this.item) == Item.m_41393_((Item)other.item);
            }
            return false;
        }
    }

    private static class AutocraftingCraftingContainer
    extends SimpleContainer
    implements CraftingContainer {
        private List<ItemStack> craftingItems = new ArrayList<ItemStack>();

        public AutocraftingCraftingContainer(List<ItemStack> craftingItems) {
            super(new ItemStack[0]);
            this.craftingItems = craftingItems;
        }

        public int m_39347_() {
            return 3;
        }

        public int m_39346_() {
            return 3;
        }

        public List<ItemStack> m_280657_() {
            return this.craftingItems;
        }
    }

    private static class CombineableIngredient {
        private Ingredient ingredient;

        public CombineableIngredient(Ingredient ingredient) {
            this.ingredient = ingredient;
        }

        public int hashCode() {
            return this.ingredient.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof CombineableIngredient) {
                CombineableIngredient combine = (CombineableIngredient)obj;
                return this.ingredientsAreEqual(this.ingredient, combine.ingredient);
            }
            return false;
        }

        private boolean ingredientsAreEqual(Ingredient a, Ingredient b) {
            if (a == null && b == null) {
                return true;
            }
            if (a == null && b != null) {
                return false;
            }
            if (a != null && b == null) {
                return false;
            }
            if (a.m_43908_() == null && b.m_43908_() == null) {
                return true;
            }
            if (a.m_43908_() == null && b.m_43908_() != null) {
                return false;
            }
            if (a.m_43908_() != null && b.m_43908_() == null) {
                return false;
            }
            if (a.m_43908_().length != b.m_43908_().length) {
                return false;
            }
            for (int i = 0; i < a.m_43908_().length; ++i) {
                ItemStack bItemStack;
                ItemStack aItemStack = a.m_43908_()[i];
                if (ItemStack.m_41656_((ItemStack)aItemStack, (ItemStack)(bItemStack = b.m_43908_()[i]))) continue;
                return false;
            }
            return true;
        }
    }
}

