/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.xenotech.world.level.block.entity;

import com.dairymoose.xenotech.XenoBlocks;
import com.dairymoose.xenotech.world.level.block.entity.BaseDrillBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FluidShippingTankBlockEntity
extends BaseDrillBlockEntity
implements WorldlyContainer {
    private static final int CONTAINER_SIZE = 2;
    private NonNullList<ItemStack> items = NonNullList.m_122780_((int)2, (Object)ItemStack.f_41583_);
    private FluidTank fluidInventory = new FluidTank(16000, fluid -> true);
    private static final Logger LOGGER = LogManager.getLogger();
    public static final BlockEntityType<FluidShippingTankBlockEntity> FLUID_SHIPPING_TANK_BLOCK_ENTITY = BlockEntityType.Builder.m_155273_(FluidShippingTankBlockEntity::new, (Block[])new Block[]{(Block)XenoBlocks.BLOCK_FLUID_SHIPPING_TANK.get()}).m_58966_(null);
    private int tickCount = 0;

    public FluidShippingTankBlockEntity(BlockPos p_155229_, BlockState p_155230_) {
        super(FLUID_SHIPPING_TANK_BLOCK_ENTITY, p_155229_, p_155230_);
    }

    public FluidTank getFluidInventory() {
        return this.fluidInventory;
    }

    public static void tick(Level level, BlockPos blockPos, BlockState blockState, FluidShippingTankBlockEntity table) {
        if (!level.f_46443_) {
            boolean updated = false;
            Item item = ((ItemStack)table.items.get(0)).m_41720_();
            if (item instanceof BucketItem) {
                BucketItem bucket = (BucketItem)item;
                if (bucket.getFluid() != Fluids.f_76191_ && (((ItemStack)table.items.get(1)).m_41619_() || ((ItemStack)table.items.get(1)).m_150930_(Items.f_42446_) && ((ItemStack)table.items.get(1)).m_41613_() < ((ItemStack)table.items.get(1)).m_41741_())) {
                    updated = FluidShippingTankBlockEntity.addFluidToTank(table, bucket.getFluid(), 1000, updated);
                } else if (bucket.getFluid() == Fluids.f_76191_ && ((ItemStack)table.items.get(1)).m_41619_()) {
                    updated = FluidShippingTankBlockEntity.extractFluidFromTank(table, 1000, updated);
                }
            } else if (((ItemStack)table.items.get(0)).m_150930_((Item)XenoBlocks.ITEM_CRUDE_OIL_BARREL.get())) {
                updated = FluidShippingTankBlockEntity.addFluidToTank(table, (Fluid)XenoBlocks.FLUID_CRUDE_OIL_SOURCE.get(), 4000, updated);
            } else if (((ItemStack)table.items.get(0)).m_150930_((Item)XenoBlocks.ITEM_OIL_BARREL.get())) {
                updated = FluidShippingTankBlockEntity.addFluidToTank(table, (Fluid)XenoBlocks.FLUID_REFINED_OIL_SOURCE.get(), 4000, updated);
            }
            if (updated) {
                level.markAndNotifyBlock(table.m_58899_(), level.m_46745_(table.m_58899_()), blockState, blockState, 2, 0);
                table.m_6596_();
            }
        }
    }

    private static boolean extractFluidFromTank(FluidShippingTankBlockEntity table, int amount, boolean updated) {
        Fluid tankFluid = table.fluidInventory.getFluid().getFluid();
        FluidStack drained = table.fluidInventory.drain(new FluidStack(tankFluid, amount), IFluidHandler.FluidAction.SIMULATE);
        if (drained.getAmount() >= 1000) {
            table.fluidInventory.drain(new FluidStack(tankFluid, amount), IFluidHandler.FluidAction.EXECUTE);
            ((ItemStack)table.items.get(0)).m_41774_(1);
            table.items.set(1, (Object)new ItemStack((ItemLike)drained.getFluid().m_6859_()));
            if (table.fluidInventory.isEmpty()) {
                table.fluidInventory.setFluid(FluidStack.EMPTY);
            }
            updated = true;
        }
        return updated;
    }

    private static boolean addFluidToTank(FluidShippingTankBlockEntity table, Fluid fluid, int amount, boolean updated) {
        if (table.fluidInventory.fill(new FluidStack(fluid, amount), IFluidHandler.FluidAction.SIMULATE) == amount && table.fluidInventory.fill(new FluidStack(fluid, amount), IFluidHandler.FluidAction.EXECUTE) > 0) {
            ((ItemStack)table.items.get(0)).m_41774_(1);
            if (amount == 1000) {
                if (((ItemStack)table.items.get(1)).m_150930_(Items.f_42446_)) {
                    ((ItemStack)table.items.get(1)).m_41769_(1);
                } else {
                    table.items.set(1, (Object)new ItemStack((ItemLike)Items.f_42446_));
                }
            }
            updated = true;
        }
        return updated;
    }

    public void doLoad(CompoundTag tag) {
        this.fluidInventory.readFromNBT(tag);
    }

    public void doSave(CompoundTag tag) {
        this.fluidInventory.writeToNBT(tag);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)tag, this.items);
        this.doLoad(tag);
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        ContainerHelper.m_18973_((CompoundTag)tag, this.items);
        this.doSave(tag);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        this.doSave(tag);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        CompoundTag tag = pkt.m_131708_();
        if (tag != null) {
            this.doLoad(tag);
        }
    }

    public void m_6211_() {
        this.items.clear();
    }

    public int m_6643_() {
        return 2;
    }

    public boolean m_7983_() {
        for (int i = 0; i < this.items.size(); ++i) {
            if (((ItemStack)this.items.get(i)).m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int slot) {
        return (ItemStack)this.items.get(slot);
    }

    public ItemStack m_7407_(int slot, int count) {
        ItemStack itemstack = ContainerHelper.m_18969_(this.items, (int)slot, (int)count);
        if (!itemstack.m_41619_()) {
            this.m_6596_();
        }
        return itemstack;
    }

    public ItemStack m_8016_(int slot) {
        ItemStack itemstack = (ItemStack)this.items.get(slot);
        if (itemstack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        this.items.set(slot, (Object)ItemStack.f_41583_);
        return itemstack;
    }

    public void m_6836_(int slot, ItemStack itemStack) {
        this.items.set(slot, (Object)itemStack);
        if (!itemStack.m_41619_() && itemStack.m_41613_() > this.m_6893_()) {
            itemStack.m_41764_(this.m_6893_());
        }
        this.m_6596_();
    }

    public boolean m_6542_(Player player) {
        return true;
    }

    public int[] m_7071_(Direction dir) {
        if (dir == Direction.UP) {
            int[] slots = new int[]{0};
            return slots;
        }
        if (dir == Direction.DOWN) {
            int[] slots = new int[]{1};
            return slots;
        }
        int[] slots = new int[]{0};
        return slots;
    }

    public boolean m_7155_(int slot, ItemStack itemStack, Direction dir) {
        return true;
    }

    public boolean m_7157_(int slot, ItemStack itemStack, Direction dir) {
        return true;
    }
}

