/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.xenotech.world.level.block.entity;

import com.dairymoose.xenotech.XenoBlocks;
import com.dairymoose.xenotech.entity.DummyEntity;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.network.protocol.game.ServerboundPlayerActionPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ManipulatorBlockEntity
extends BlockEntity
implements Container {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final BlockEntityType<ManipulatorBlockEntity> MANIPULATOR_BLOCK_ENTITY = BlockEntityType.Builder.m_155273_(ManipulatorBlockEntity::new, (Block[])new Block[]{(Block)XenoBlocks.BLOCK_MANIPULATOR.get(), (Block)XenoBlocks.BLOCK_SNEAKY_MANIPULATOR.get()}).m_58966_(null);
    private NonNullList<ItemStack> items = NonNullList.m_122780_((int)1, (Object)ItemStack.f_41583_);
    public float itemRotation = 0.0f;
    public long lastRenderGameTime = 0L;
    public boolean attackMode = false;
    private BlockPos firstBlockPos = null;
    private int cooldownTicks = 0;
    private boolean wasPoweredLastTick = false;
    public static int manipulatorTickPeriod;
    private BlockPos[] endpoints = new BlockPos[4];
    private static Map<Direction, Integer> endpointArrayIndex;
    private int tickCount = 0;
    public static List<ManipulatorBlockEntity> fakePlayerHolders;
    private FakePlayer fp = null;
    private int sequenceNo = 0;
    public boolean isAttacking = false;
    private int destroyStartTick = -1;
    private BlockPos destroyPos;
    private Direction destroyDirection;
    private BlockState destroyState;
    private BlockPos playerMiningPosForDestroy;
    public static List<UUID> uuidList;
    private UUID uuid;
    public static boolean disallowTakingEmptyBucketFromManipulator;

    public ManipulatorBlockEntity(BlockPos p_155229_, BlockState p_155230_) {
        super(MANIPULATOR_BLOCK_ENTITY, p_155229_, p_155230_);
    }

    private Direction getDirectionForEndpointIndex(int idx) {
        for (Map.Entry<Direction, Integer> entry : endpointArrayIndex.entrySet()) {
            if (entry.getValue() != idx) continue;
            return entry.getKey();
        }
        return null;
    }

    public static void tick(Level level, BlockPos blockPos, BlockState blockState, ManipulatorBlockEntity manipulator) {
        if (manipulator == null) {
            return;
        }
        if (level.f_46443_) {
            return;
        }
        if (manipulator.firstBlockPos == null) {
            manipulator.firstBlockPos = blockPos;
        }
        if (manipulator.cooldownTicks > 0) {
            --manipulator.cooldownTicks;
        }
        if (level.m_277086_(blockPos) > 0 || DummyEntity.currentlyTickingDummyEntity != null && !DummyEntity.currentlyTickingDummyEntity.m_213877_() && DummyEntity.currentlyTickingDummyEntity.blockEntityTickInProgress && DummyEntity.currentlyTickingDummyEntity.hasSpecificBlockEntityOnboard(manipulator)) {
            ++manipulator.tickCount;
            if (manipulator.attackMode && manipulator.isAttacking && manipulator.fp != null) {
                manipulator.fp.f_8941_.m_7712_();
                if (manipulator.destroyPos != null && manipulator.playerMiningPosForDestroy != null && manipulator.destroyStartTick != -1) {
                    BlockState destroyState = level.m_8055_(manipulator.destroyPos);
                    if (manipulator.destroyState == null || destroyState != manipulator.destroyState) {
                        manipulator.stopAttacking();
                    } else {
                        int destroyTicks = manipulator.tickCount - manipulator.destroyStartTick;
                        float progressInc = destroyState.m_60625_((Player)manipulator.fp, (BlockGetter)level, manipulator.destroyPos);
                        float totalProgress = (float)(destroyTicks + 1) * progressInc;
                        if (totalProgress >= 1.0f) {
                            LOGGER.debug("Destroy block with state=" + destroyState);
                            BlockPos toDestroy = manipulator.destroyPos;
                            Direction destroyDirection = manipulator.destroyDirection;
                            manipulator.stopAttacking();
                            BlockPos mp = manipulator.playerMiningPosForDestroy;
                            manipulator.fp.m_20248_((double)mp.m_123341_(), (double)mp.m_123342_(), (double)mp.m_123343_());
                            manipulator.fp.f_8941_.m_214168_(toDestroy, ServerboundPlayerActionPacket.Action.STOP_DESTROY_BLOCK, destroyDirection, level.m_151558_(), manipulator.sequenceNo++);
                        }
                    }
                }
            }
            if (manipulator.cooldownTicks == 0 || !manipulator.wasPoweredLastTick) {
                manipulator.cooldownTicks = manipulatorTickPeriod;
                manipulator.doEndpointInteractions(blockState);
            }
            manipulator.wasPoweredLastTick = true;
        } else {
            manipulator.wasPoweredLastTick = false;
        }
        manipulator.updateToHeldItemstack();
    }

    private void updateToHeldItemstack() {
        ItemStack heldItem;
        if (this.fp != null && (heldItem = this.fp.m_21120_(InteractionHand.MAIN_HAND)) != null && this.getItem() != heldItem) {
            LOGGER.debug("updated heldItem from " + this.getItem() + " to " + heldItem + " for " + this + " at " + this.m_58899_());
            this.items.set(0, (Object)ItemStack.f_41583_);
            this.placeItem(heldItem);
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
    }

    private void stopAttacking() {
        this.isAttacking = false;
        this.destroyPos = null;
        this.destroyDirection = null;
        this.destroyState = null;
        this.destroyStartTick = -1;
    }

    public void unsetFakePlayer() {
        this.fp = null;
    }

    public boolean doEndpointInteractions(BlockState blockState) {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ItemStack itemStack = this.getItem();
            if (this.fp == null) {
                UUID genUuid = null;
                while (genUuid == null || uuidList.contains(genUuid)) {
                    genUuid = UUID.randomUUID();
                }
                uuidList.add(genUuid);
                this.uuid = genUuid;
                GameProfile gp = new GameProfile(genUuid, null);
                this.fp = FakePlayerFactory.get((ServerLevel)serverLevel, (GameProfile)gp);
                LOGGER.debug("create fakePlayer=" + this.fp + " with uuid=" + genUuid + " for BE=" + this + " at location=" + this.m_58899_());
                fakePlayerHolders.add(this);
            }
            this.fp.m_21008_(InteractionHand.MAIN_HAND, itemStack);
            if (blockState.m_60713_((Block)XenoBlocks.BLOCK_SNEAKY_MANIPULATOR.get())) {
                this.fp.m_20260_(true);
            }
            int e = 0;
            for (BlockPos endpoint : this.endpoints) {
                if (endpoint != null) {
                    Direction endpointDirection = this.getDirectionForEndpointIndex(e);
                    endpointDirection = endpointDirection.m_122424_();
                    BlockState state = this.f_58857_.m_8055_(endpoint);
                    BlockPos playerStandingPos = endpoint.m_121945_(endpointDirection);
                    this.fp.m_20248_((double)playerStandingPos.m_123341_(), (double)playerStandingPos.m_123342_(), (double)playerStandingPos.m_123343_());
                    if (!this.attackMode) {
                        boolean heldItemChanged;
                        BlockHitResult bhr = new BlockHitResult(new Vec3((double)endpoint.m_123341_() + 0.5, (double)endpoint.m_123342_() + 0.5, (double)endpoint.m_123343_() + 0.5), endpointDirection, endpoint, false);
                        ItemStack itemStackBefore = itemStack.m_41777_();
                        UseOnContext ctx = new UseOnContext(this.f_58857_, (Player)this.fp, InteractionHand.MAIN_HAND, itemStack, bhr);
                        InteractionResult result = itemStack.m_41661_(ctx);
                        result = state.m_60664_((Level)serverLevel, (Player)this.fp, InteractionHand.MAIN_HAND, bhr);
                        boolean bl = heldItemChanged = itemStack != itemStackBefore;
                        if (heldItemChanged) {
                            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
                        }
                        if (result != InteractionResult.PASS) {
                            this.f_58857_.m_7260_(endpoint, state, state, 3);
                        } else {
                            itemStack.m_41682_((Level)serverLevel, (Player)this.fp, InteractionHand.MAIN_HAND);
                        }
                    } else if (!this.isAttacking && !state.m_60795_()) {
                        this.isAttacking = true;
                        this.fp.f_8941_.m_214168_(endpoint, ServerboundPlayerActionPacket.Action.START_DESTROY_BLOCK, endpointDirection, this.f_58857_.m_151558_(), this.sequenceNo++);
                        this.destroyStartTick = this.tickCount;
                        this.destroyPos = endpoint;
                        this.destroyDirection = endpointDirection;
                        this.destroyState = state;
                        this.playerMiningPosForDestroy = playerStandingPos;
                    }
                }
                ++e;
            }
            return true;
        }
        return false;
    }

    public void addEndpoint(BlockPos endpoint, Direction direction) {
        Integer idx = endpointArrayIndex.get(direction);
        if (idx != null) {
            this.stopAttacking();
            this.endpoints[idx.intValue()] = endpoint;
        }
    }

    public void removeEndpoint(Direction direction) {
        Integer idx = endpointArrayIndex.get(direction);
        if (idx != null) {
            this.stopAttacking();
            this.endpoints[idx.intValue()] = null;
        }
    }

    public ItemStack getItem() {
        return (ItemStack)this.items.get(0);
    }

    public boolean placeItem(ItemStack toAdd) {
        if (!((ItemStack)this.items.get(0)).m_41619_()) {
            return false;
        }
        this.stopAttacking();
        if (toAdd.m_150930_(Items.f_42446_) || toAdd.m_150930_(Items.f_42590_)) {
            this.items.set(0, (Object)toAdd.m_41620_(1));
        } else {
            this.items.set(0, (Object)toAdd.m_278832_());
        }
        if (this.fp != null) {
            this.fp.m_21008_(InteractionHand.MAIN_HAND, this.getItem());
        }
        this.m_6596_();
        return true;
    }

    public ItemStack takeItem() {
        ItemStack itemStack = (ItemStack)this.items.get(0);
        if (itemStack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        this.stopAttacking();
        this.m_6596_();
        return itemStack.m_278832_();
    }

    private int[] blockPosToXYZ(BlockPos pos) {
        if (pos == null) {
            return null;
        }
        int[] ret = new int[]{pos.m_123341_(), pos.m_123342_(), pos.m_123343_()};
        return ret;
    }

    private BlockPos xyzToBlockPos(int[] xyz) {
        if (xyz == null || xyz.length != 3) {
            return null;
        }
        return new BlockPos(xyz[0], xyz[1], xyz[2]);
    }

    public void m_142466_(CompoundTag tag) {
        BlockPos pos;
        super.m_142466_(tag);
        ContainerHelper.m_18980_((CompoundTag)tag, this.items);
        if (tag.m_128441_("NorthEndpoint") && (pos = this.xyzToBlockPos(tag.m_128465_("NorthEndpoint"))) != null) {
            this.endpoints[ManipulatorBlockEntity.endpointArrayIndex.get((Object)Direction.NORTH).intValue()] = pos;
        }
        if (tag.m_128441_("EastEndpoint") && (pos = this.xyzToBlockPos(tag.m_128465_("EastEndpoint"))) != null) {
            this.endpoints[ManipulatorBlockEntity.endpointArrayIndex.get((Object)Direction.EAST).intValue()] = pos;
        }
        if (tag.m_128441_("SouthEndpoint") && (pos = this.xyzToBlockPos(tag.m_128465_("SouthEndpoint"))) != null) {
            this.endpoints[ManipulatorBlockEntity.endpointArrayIndex.get((Object)Direction.SOUTH).intValue()] = pos;
        }
        if (tag.m_128441_("WestEndpoint") && (pos = this.xyzToBlockPos(tag.m_128465_("WestEndpoint"))) != null) {
            this.endpoints[ManipulatorBlockEntity.endpointArrayIndex.get((Object)Direction.WEST).intValue()] = pos;
        }
        this.attackMode = tag.m_128471_("AttackMode");
    }

    protected void m_183515_(CompoundTag tag) {
        int[] westPos;
        int[] southPos;
        int[] eastPos;
        super.m_183515_(tag);
        ContainerHelper.m_18973_((CompoundTag)tag, this.items);
        int[] northPos = this.blockPosToXYZ(this.endpoints[endpointArrayIndex.get(Direction.NORTH)]);
        if (northPos != null) {
            tag.m_128385_("NorthEndpoint", northPos);
        }
        if ((eastPos = this.blockPosToXYZ(this.endpoints[endpointArrayIndex.get(Direction.EAST)])) != null) {
            tag.m_128385_("EastEndpoint", eastPos);
        }
        if ((southPos = this.blockPosToXYZ(this.endpoints[endpointArrayIndex.get(Direction.SOUTH)])) != null) {
            tag.m_128385_("SouthEndpoint", southPos);
        }
        if ((westPos = this.blockPosToXYZ(this.endpoints[endpointArrayIndex.get(Direction.WEST)])) != null) {
            tag.m_128385_("WestEndpoint", westPos);
        }
        tag.m_128379_("AttackMode", this.attackMode);
    }

    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        ContainerHelper.m_18973_((CompoundTag)nbt, this.items);
        return nbt;
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.items = NonNullList.m_122780_((int)1, (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)tag, this.items);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection conn, ClientboundBlockEntityDataPacket pkt) {
        CompoundTag tag = pkt.m_131708_();
        if (tag != null) {
            this.items = NonNullList.m_122780_((int)1, (Object)ItemStack.f_41583_);
            ContainerHelper.m_18980_((CompoundTag)tag, this.items);
        }
    }

    public boolean m_7013_(int slot, ItemStack itemStack) {
        if (slot != 0) {
            return false;
        }
        if (itemStack.m_150930_(Items.f_42446_) || itemStack.m_150930_(Items.f_42590_)) {
            return ((ItemStack)this.items.get(0)).m_41619_();
        }
        return super.m_7013_(slot, itemStack);
    }

    public void m_6211_() {
        this.stopAttacking();
        this.items.set(0, (Object)ItemStack.f_41583_);
        this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
    }

    public int m_6643_() {
        return 1;
    }

    public boolean m_7983_() {
        return ((ItemStack)this.items.get(0)).m_41619_();
    }

    public ItemStack m_8020_(int slot) {
        ItemStack itemStack;
        if (slot != 0) {
            return ItemStack.f_41583_;
        }
        if (disallowTakingEmptyBucketFromManipulator && ((itemStack = (ItemStack)this.items.get(0)).m_150930_(Items.f_42446_) || itemStack.m_150930_(Items.f_42590_))) {
            return ItemStack.f_41583_;
        }
        return this.getItem();
    }

    public ItemStack m_7407_(int slot, int p_18943_) {
        if (slot != 0) {
            return ItemStack.f_41583_;
        }
        this.stopAttacking();
        ItemStack itemStack = (ItemStack)this.items.get(0);
        this.items.set(0, (Object)ItemStack.f_41583_);
        if (this.fp != null) {
            this.fp.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
        }
        this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        this.m_6596_();
        return itemStack;
    }

    public ItemStack m_8016_(int slot) {
        if (slot != 0) {
            return ItemStack.f_41583_;
        }
        this.stopAttacking();
        ItemStack itemStack = (ItemStack)this.items.get(0);
        this.items.set(0, (Object)ItemStack.f_41583_);
        if (this.fp != null) {
            this.fp.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
        }
        this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        return itemStack;
    }

    public void m_6836_(int slot, ItemStack itemStack) {
        if (slot != 0) {
            return;
        }
        this.stopAttacking();
        this.items.set(0, (Object)ItemStack.f_41583_);
        this.placeItem(itemStack);
        this.m_6596_();
        this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
    }

    public boolean m_6542_(Player p_18946_) {
        return true;
    }

    public void updateEndpoints(BlockPos oldPos, BlockPos blockRotPos) {
        BlockPos blockPosDiff = blockRotPos.m_121996_((Vec3i)oldPos);
        for (int i = 0; i < this.endpoints.length; ++i) {
            if (this.endpoints[i] == null) continue;
            this.endpoints[i] = this.endpoints[i].m_121955_((Vec3i)blockPosDiff);
        }
    }

    public static void cleanupFakePlayerList(LevelAccessor level) {
        ArrayList<ManipulatorBlockEntity> toRemove = new ArrayList<ManipulatorBlockEntity>();
        for (int i = 0; i < fakePlayerHolders.size(); ++i) {
            ManipulatorBlockEntity manip = fakePlayerHolders.get(i);
            if (manip == null || !(manip.m_58904_() instanceof LevelAccessor)) continue;
            Level accessor = manip.m_58904_();
            if (level != null && !accessor.equals(level)) continue;
            manip.unsetFakePlayer();
            toRemove.add(manip);
        }
        for (ManipulatorBlockEntity manip : toRemove) {
            fakePlayerHolders.remove((Object)manip);
        }
    }

    static {
        endpointArrayIndex = new HashMap<Direction, Integer>();
        endpointArrayIndex.put(Direction.NORTH, 0);
        endpointArrayIndex.put(Direction.EAST, 1);
        endpointArrayIndex.put(Direction.SOUTH, 2);
        endpointArrayIndex.put(Direction.WEST, 3);
        fakePlayerHolders = new ArrayList<ManipulatorBlockEntity>();
        uuidList = new ArrayList<UUID>();
    }
}

