/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.xenotech.world.level.block.entity;

import com.dairymoose.xenotech.XenoBlocks;
import com.dairymoose.xenotech.XenoTechClient;
import com.dairymoose.xenotech.block.MountedGunBlock;
import com.dairymoose.xenotech.entity.DummyEntity;
import com.dairymoose.xenotech.entity.RenderableBlock;
import com.dairymoose.xenotech.network.ServerboundHitscanArrayPacket;
import com.dairymoose.xenotech.world.level.block.entity.IntegratedGunBlockEntity;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MountedGunBlockEntity
extends BlockEntity {
    private static final Logger LOGGER = LogManager.getLogger();
    public BlockPos initialBlockPos = null;
    public Entity mountedTo = null;
    public Entity carrier = null;
    public RenderableBlock renderable = null;
    public float barrelRotation = 0.0f;
    public float barrelRotationSpeed = 0.0f;
    public long lastRenderTimestamp = 0L;
    public boolean isFiring = false;
    public boolean canEverFire = true;
    public boolean immobile = false;
    public Vec3 relativeCarrierOffset = null;
    public int tickCount = 0;
    public static final int FIRING_TICK_MAX = 6;
    public static final int RELOADING_TICK_MAX = 30;
    public static int reloadingTick = -1;
    public static Map<Player, Integer> firingTickMap = new ConcurrentHashMap<Player, Integer>();
    public static long lastShotTimestamp = 0L;

    public MountedGunBlockEntity(BlockEntityType type, BlockPos p_155229_, BlockState p_155230_) {
        super(type, p_155229_, p_155230_);
    }

    public void resetMountVariables() {
        LOGGER.debug("resetMountVariables for " + this);
        this.initialBlockPos = null;
        this.mountedTo = null;
        this.carrier = null;
        this.barrelRotation = 0.0f;
        this.barrelRotationSpeed = 0.0f;
        this.relativeCarrierOffset = null;
        this.isFiring = false;
        this.m_6596_();
    }

    public void assignMountVariables(BlockPos pos, DummyEntity dummy, Entity carrier) {
        LOGGER.debug("assign variables with mountedTo=" + dummy + " for " + this);
        this.initialBlockPos = pos;
        this.mountedTo = dummy;
        this.carrier = carrier;
        Entity entity = this.mountedTo;
        if (entity instanceof DummyEntity) {
            DummyEntity gunDummy = (DummyEntity)entity;
            gunDummy.thisMountedGun = this;
            Entity entity2 = this.carrier;
            if (entity2 instanceof DummyEntity) {
                DummyEntity dummyCarrier = (DummyEntity)entity2;
                this.relativeCarrierOffset = this.mountedTo.m_20182_().m_82546_(dummyCarrier.m_20182_());
                LOGGER.debug("set relativeCarrierOffset to: " + this.relativeCarrierOffset);
                gunDummy.setMountedGunInitialParentAngle(dummyCarrier.m_146908_());
            }
        }
        if (this.renderable != null && (entity = this.renderable.state.m_60734_()) instanceof MountedGunBlock) {
            MountedGunBlock mgb = (MountedGunBlock)entity;
            this.renderable.state = (BlockState)this.renderable.state.m_61124_((Property)MountedGunBlock.MOUNTED, (Comparable)Boolean.valueOf(true));
        }
        this.m_6596_();
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.mountedTo != null) {
            tag.m_128405_("MountedTo", this.mountedTo.m_19879_());
        }
        if (this.carrier != null) {
            tag.m_128405_("Carrier", this.carrier.m_19879_());
        }
        if (this.initialBlockPos != null) {
            tag.m_128385_("InitialBlockPos", new int[]{this.initialBlockPos.m_123341_(), this.initialBlockPos.m_123342_(), this.initialBlockPos.m_123343_()});
        }
    }

    public void m_142466_(CompoundTag tag) {
        if (tag == null) {
            return;
        }
        super.m_142466_(tag);
        if (tag.m_128441_("MountedTo")) {
            this.mountedTo = this.m_58904_().m_6815_(tag.m_128451_("MountedTo"));
        }
    }

    public static void tick(Level level, BlockPos blockPos, BlockState blockState, MountedGunBlockEntity gun) {
        ++gun.tickCount;
        if (gun.mountedTo != null && !gun.mountedTo.m_213877_() && gun.carrier != null && !gun.carrier.m_213877_() && gun.relativeCarrierOffset != null && level.f_46443_) {
            Vec3 vec3 = gun.carrier.m_20182_().m_82549_(gun.relativeCarrierOffset);
        }
    }

    public int getCurrentMagazineCapacity(Player player) {
        for (int i = 0; i < player.m_150109_().f_35974_.size(); ++i) {
            ItemStack itemStack = (ItemStack)player.m_150109_().f_35974_.get(i);
            if (itemStack == null || itemStack.m_41720_() != XenoBlocks.ITEM_ACACIA_LOG_ANGULAR_HULL.get() && itemStack.m_41720_() != XenoBlocks.ITEM_ACACIA_LOG_ANGULAR_SLAB_HULL.get()) continue;
            return itemStack.m_41776_();
        }
        return 0;
    }

    public int getAmmoTotal(Player player) {
        int total = 0;
        for (int i = 0; i < player.m_150109_().f_35974_.size(); ++i) {
            ItemStack itemStack = (ItemStack)player.m_150109_().f_35974_.get(i);
            if (itemStack == null || itemStack.m_41720_() != XenoBlocks.ITEM_ACACIA_LOG_ANGULAR_HULL.get() && itemStack.m_41720_() != XenoBlocks.ITEM_ACACIA_LOG_ANGULAR_SLAB_HULL.get()) continue;
            int remaining = itemStack.m_41776_() - itemStack.m_41773_();
            total += remaining;
        }
        return total;
    }

    public boolean hasAmmo(Player player) {
        return true;
    }

    public boolean removeAmmo(Player player, int ammo) {
        for (int i = 0; i < player.m_150109_().f_35974_.size(); ++i) {
            ItemStack itemStack = (ItemStack)player.m_150109_().f_35974_.get(i);
            if (itemStack == null || itemStack.m_41720_() != XenoBlocks.ITEM_ACACIA_LOG_ANGULAR_HULL.get() && itemStack.m_41720_() != XenoBlocks.ITEM_ACACIA_LOG_ANGULAR_SLAB_HULL.get()) continue;
            itemStack.m_41622_(ammo, (LivingEntity)player, (Consumer)new Consumer<Player>(){

                @Override
                public void accept(Player t) {
                }
            });
            return true;
        }
        return false;
    }

    public int getCurrentMagazineAmmo(Player player) {
        for (int i = 0; i < player.m_150109_().f_35974_.size(); ++i) {
            ItemStack itemStack = (ItemStack)player.m_150109_().f_35974_.get(i);
            if (itemStack == null || itemStack.m_41720_() != XenoBlocks.ITEM_ACACIA_LOG_ANGULAR_HULL.get() && itemStack.m_41720_() != XenoBlocks.ITEM_ACACIA_LOG_ANGULAR_SLAB_HULL.get()) continue;
            int remaining = itemStack.m_41776_() - itemStack.m_41773_();
            return remaining;
        }
        return 0;
    }

    public boolean fireGun(Player player, boolean aimDownSights) {
        if (!this.canEverFire) {
            return false;
        }
        long timeDiff = System.currentTimeMillis() - lastShotTimestamp;
        reloadingTick = -1;
        if (!this.hasAmmo(player)) {
            player.m_9236_().m_5594_(player, player.m_20183_(), SoundEvents.f_12088_, SoundSource.BLOCKS, 1.0f, 2.0f);
            return false;
        }
        int magAmmo = this.getCurrentMagazineAmmo(player);
        int totalAmmo = this.getAmmoTotal(player);
        lastShotTimestamp = System.currentTimeMillis();
        firingTickMap.put(player, 6);
        HitResult rayTrace = this.getRayTraceForPlayer(player.m_9236_(), player, 500.0, aimDownSights);
        BlockPos pos = null;
        int entityId = -1;
        Vec3 location = rayTrace.m_82450_();
        Direction direction = null;
        BlockState state = null;
        if (rayTrace instanceof BlockHitResult) {
            BlockHitResult blockRayTrace = (BlockHitResult)rayTrace;
            pos = blockRayTrace.m_82425_();
            direction = blockRayTrace.m_82434_();
            state = this.m_58904_().m_8055_(pos);
        } else if (rayTrace instanceof EntityHitResult) {
            EntityHitResult entityRayTrace = (EntityHitResult)rayTrace;
            pos = entityRayTrace.m_82443_().m_20183_();
            entityId = entityRayTrace.m_82443_().m_19879_();
        }
        if (magAmmo == 1 && totalAmmo > 1) {
            reloadingTick = 30;
        }
        boolean hitAirBlock = state != null && state.m_60795_();
        this.isFiring = true;
        if (entityId != -1 || !hitAirBlock) {
            final ServerboundHitscanArrayPacket.SingleHitscanResult shr = new ServerboundHitscanArrayPacket.SingleHitscanResult();
            shr.blockPos = pos;
            shr.entityId = entityId;
            shr.location = location;
            shr.direction = direction;
            shr.isIntegratedGun = this instanceof IntegratedGunBlockEntity;
            DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> new Runnable(){

                @Override
                public void run() {
                    XenoTechClient.pendingHitscanResults.add(shr);
                }
            });
        }
        return true;
    }

    private HitResult getRayTraceForPlayer(Level world, Player player, double range, boolean aimDownSights) {
        boolean useAdsSpread;
        double d0 = range;
        Vec3 entityPos = player.m_20299_(1.0f);
        Vec3 targetPos = entityPos.m_82549_(player.m_20252_(1.0f).m_82490_(range));
        boolean useMovementSpread = true;
        double spreadFactor = 0.0;
        if (useMovementSpread) {
            Vec3 movement = player.m_20184_();
            double offsetFactor = 1800.0;
            boolean useAdsSpread2 = true;
            if (useAdsSpread2 && !aimDownSights) {
                offsetFactor *= 2.0;
            }
            spreadFactor = (movement.f_82479_ * movement.f_82479_ + movement.f_82481_ * movement.f_82481_) * offsetFactor;
        }
        if ((useAdsSpread = true) && spreadFactor == 0.0 && !player.m_6117_()) {
            spreadFactor = 4.0;
        }
        if (spreadFactor != 0.0) {
            targetPos = targetPos.m_82520_(Math.random() * spreadFactor - spreadFactor / 2.0, 0.0, Math.random() * spreadFactor - spreadFactor / 2.0);
        }
        BlockHitResult rayTrace = world.m_45547_(new ClipContext(entityPos, targetPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player));
        Vec3 Vec32 = player.m_20299_(1.0f);
        boolean flag = false;
        int i = 3;
        double d1 = d0;
        d1 *= d1;
        if (rayTrace != null) {
            d1 = rayTrace.m_82450_().m_82557_(Vec32);
        }
        Vec3 Vec31 = player.m_20252_(1.0f);
        Vec3 Vec322 = Vec32.m_82520_(Vec31.f_82479_ * d0, Vec31.f_82480_ * d0, Vec31.f_82481_ * d0);
        if (useMovementSpread) {
            Vec322 = Vec322.m_82520_(Math.random() * spreadFactor - spreadFactor / 2.0, 0.0, Math.random() * spreadFactor - spreadFactor / 2.0);
        }
        float f = 1.0f;
        DummyEntity dummy = new DummyEntity(DummyEntity.DUMMY_ENTITY, world);
        AABB axisalignedbb = player.m_20191_().m_82369_(Vec31.m_82490_(d0)).m_82377_(1.0, 1.0, 1.0);
        EntityHitResult entityHitResult = ProjectileUtil.m_37287_((Entity)dummy, (Vec3)Vec32, (Vec3)Vec322, (AABB)axisalignedbb, entity -> entity != player && !entity.m_5833_() && !(entity instanceof DummyEntity), (double)d1);
        if (entityHitResult != null) {
            Entity entity1 = entityHitResult.m_82443_();
            Vec3 Vec33 = entityHitResult.m_82450_();
            double d2 = Vec32.m_82557_(Vec33);
            rayTrace = entityHitResult;
        }
        dummy.m_142687_(Entity.RemovalReason.DISCARDED);
        return rayTrace;
    }
}

