/*
 * Decompiled with CFR 0.152.
 */
package com.dairymoose.xenotech.world.level.block.entity;

import com.dairymoose.xenotech.XenoBlocks;
import com.dairymoose.xenotech.block.SiftingNetBlock;
import com.dairymoose.xenotech.world.level.block.SiftingNetPostBlock;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class SiftingNetPostBlockEntity
extends BlockEntity
implements Container {
    private static final Logger LOGGER = LogManager.getLogger();
    private int CHEST_SIZE = 18;
    private NonNullList<ItemStack> items = NonNullList.m_122780_((int)this.CHEST_SIZE, (Object)ItemStack.f_41583_);
    public static final BlockEntityType<SiftingNetPostBlockEntity> SIFTING_NET_POST_BLOCK_ENTITY = BlockEntityType.Builder.m_155273_(SiftingNetPostBlockEntity::new, (Block[])new Block[]{(Block)XenoBlocks.BLOCK_SIFTING_NET_POST.get()}).m_58966_(null);
    public static Map<BlockPos, SiftingNetPostBlockEntity> siftingNetMap = new HashMap<BlockPos, SiftingNetPostBlockEntity>();
    ExecutorService siftingUpdater = Executors.newCachedThreadPool();

    public SiftingNetPostBlockEntity(BlockPos p_155331_, BlockState p_155332_) {
        this((BlockEntityType<SiftingNetPostBlockEntity>)((BlockEntityType)XenoBlocks.BLOCK_ENTITY_SIFTING_NET_POST.get()), p_155331_, p_155332_);
    }

    public SiftingNetPostBlockEntity(@NotNull BlockEntityType<SiftingNetPostBlockEntity> blockEntityType, BlockPos p_155331_, BlockState p_155332_) {
        super(blockEntityType, p_155331_, p_155332_);
    }

    public void updateSiftingNetMap() {
        LOGGER.debug("updateSiftingNetMap");
        BlockState state = this.m_58900_();
        ArrayList<Direction> directions = new ArrayList<Direction>();
        if (((Boolean)state.m_61143_((Property)SiftingNetPostBlock.NORTH)).booleanValue()) {
            directions.add(Direction.NORTH);
        }
        if (((Boolean)state.m_61143_((Property)SiftingNetPostBlock.EAST)).booleanValue()) {
            directions.add(Direction.EAST);
        }
        if (((Boolean)state.m_61143_((Property)SiftingNetPostBlock.SOUTH)).booleanValue()) {
            directions.add(Direction.SOUTH);
        }
        if (((Boolean)state.m_61143_((Property)SiftingNetPostBlock.WEST)).booleanValue()) {
            directions.add(Direction.WEST);
        }
        block0: for (Direction direction : directions) {
            BlockPos pos = this.m_58899_();
            BlockPos checkPos = pos.m_121945_(direction);
            BlockState checkState = this.f_58857_.m_8055_(checkPos);
            boolean netCounter = false;
            while (checkState.m_60734_() instanceof SiftingNetBlock) {
                siftingNetMap.put(checkPos, this);
                checkPos = checkPos.m_121945_(direction);
                if (!this.f_58857_.isAreaLoaded(checkPos, 1)) continue block0;
                checkState = this.f_58857_.m_8055_(checkPos);
            }
        }
    }

    public int m_6643_() {
        return this.CHEST_SIZE;
    }

    public Component getDefaultName() {
        return Component.m_237115_((String)"xenotech.sifting.net");
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)tag, this.items);
    }

    protected void m_183515_(CompoundTag p_187489_) {
        super.m_183515_(p_187489_);
        ContainerHelper.m_18973_((CompoundTag)p_187489_, this.items);
    }

    public CompoundTag m_5995_() {
        this.asyncUpdateSiftingNetMap();
        return super.m_5995_();
    }

    private void asyncUpdateSiftingNetMap() {
        final BlockState blockState = this.m_58900_();
        final SiftingNetPostBlockEntity siftingNet = this;
        this.siftingUpdater.submit(new Runnable(){

            @Override
            public void run() {
                if (SiftingNetPostBlock.isValidContainerBlock(blockState)) {
                    siftingNet.updateSiftingNetMap();
                }
            }
        });
    }

    protected NonNullList<ItemStack> getItems() {
        return this.items;
    }

    protected void setItems(NonNullList<ItemStack> p_59110_) {
        this.items = p_59110_;
    }

    public ItemStack m_8016_(int p_19180_) {
        ItemStack itemstack = (ItemStack)this.items.get(p_19180_);
        if (itemstack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        this.items.set(p_19180_, (Object)ItemStack.f_41583_);
        return itemstack;
    }

    public void m_6836_(int p_19162_, ItemStack p_19163_) {
        this.items.set(p_19162_, (Object)p_19163_);
        if (!p_19163_.m_41619_() && p_19163_.m_41613_() > this.m_6893_()) {
            p_19163_.m_41764_(this.m_6893_());
        }
        this.m_6596_();
    }

    public boolean m_7983_() {
        for (ItemStack itemstack : this.items) {
            if (itemstack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public boolean m_6542_(Player p_19167_) {
        return true;
    }

    public void m_6211_() {
        this.items.clear();
        this.m_6596_();
    }

    public ItemStack m_8020_(int p_19157_) {
        return p_19157_ >= 0 && p_19157_ < this.items.size() ? (ItemStack)this.items.get(p_19157_) : ItemStack.f_41583_;
    }

    public ItemStack m_7407_(int p_19159_, int p_19160_) {
        ItemStack itemstack = ContainerHelper.m_18969_(this.items, (int)p_19159_, (int)p_19160_);
        if (!itemstack.m_41619_()) {
            this.m_6596_();
        }
        return itemstack;
    }

    public ItemStack addItem(ItemStack p_19174_) {
        if (p_19174_.m_41619_()) {
            return ItemStack.f_41583_;
        }
        ItemStack itemstack = p_19174_.m_41777_();
        this.moveItemToOccupiedSlotsWithSameType(itemstack);
        if (itemstack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        this.moveItemToEmptySlots(itemstack);
        return itemstack.m_41619_() ? ItemStack.f_41583_ : itemstack;
    }

    private void moveItemToOccupiedSlotsWithSameType(ItemStack p_19192_) {
        for (int i = 0; i < this.items.size(); ++i) {
            ItemStack itemstack = this.m_8020_(i);
            if (!ItemStack.m_150942_((ItemStack)itemstack, (ItemStack)p_19192_)) continue;
            this.moveItemsBetweenStacks(p_19192_, itemstack);
            if (!p_19192_.m_41619_()) continue;
            return;
        }
    }

    private void moveItemsBetweenStacks(ItemStack p_19186_, ItemStack p_19187_) {
        int i = Math.min(this.m_6893_(), p_19187_.m_41741_());
        int j = Math.min(p_19186_.m_41613_(), i - p_19187_.m_41613_());
        if (j > 0) {
            p_19187_.m_41769_(j);
            p_19186_.m_41774_(j);
            this.m_6596_();
        }
    }

    private void moveItemToEmptySlots(ItemStack p_19190_) {
        for (int i = 0; i < this.items.size(); ++i) {
            ItemStack itemstack = this.m_8020_(i);
            if (!itemstack.m_41619_()) continue;
            this.m_6836_(i, p_19190_.m_278832_());
            return;
        }
    }
}

