/*
 * Decompiled with CFR 0.152.
 */
package kr.icetang0123.mods.hit_particles.config;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import kr.icetang0123.mods.hit_particles.config.ConfigSerializer;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.gui.entries.DoubleListEntry;
import net.minecraft.class_2223;
import net.minecraft.class_2561;
import net.minecraft.class_437;
import net.minecraft.class_7225;
import net.minecraft.class_7887;

public abstract class ConfigScreenFactory {
    public static ConfigSerializer serializer = new ConfigSerializer();
    public static AtomicReference<String> particleType;
    public static AtomicReference<Integer> particleCount;
    public static AtomicReference<Double> radiusX;
    public static AtomicReference<Double> radiusY;
    public static AtomicReference<Double> radiusZ;
    public static AtomicReference<Double> offsetX;
    public static AtomicReference<Double> offsetY;
    public static AtomicReference<Double> offsetZ;
    public static AtomicReference<Boolean> spawnAtFeet;
    public static AtomicReference<Double> velocityMin;
    public static AtomicReference<Double> velocityMax;

    public static class_437 getConfigScreen(class_437 parent) {
        ConfigScreenFactory.loadConfig();
        class_7225.class_7874 registries = class_7887.method_46817();
        ConfigBuilder builder = ConfigBuilder.create().setParentScreen(parent).setTitle(class_2561.method_30163((String)"Config"));
        ConfigCategory configCategory = builder.getOrCreateCategory(class_2561.method_30163((String)"HitParticles config"));
        ConfigEntryBuilder entryBuilder = builder.entryBuilder();
        configCategory.addEntry((AbstractConfigListEntry)entryBuilder.startStrField(class_2561.method_30163((String)"Particle type"), particleType.get()).setDefaultValue("minecraft:enchanted_hit").setTooltip(new class_2561[]{class_2561.method_30163((String)"This is the particle that appears when you hit an entity. When using particles that require additional parameters (i.e., non-simple particles), you must provide the necessary data. For example: minecraft:block{block_state:\"minecraft:stone\"}.")}).setErrorSupplier(s -> {
            StringReader reader = new StringReader(s);
            try {
                class_2223.method_9418((StringReader)reader, (class_7225.class_7874)registries);
            }
            catch (CommandSyntaxException e) {
                return Optional.of(class_2561.method_30163((String)e.getMessage()));
            }
            return Optional.empty();
        }).setSaveConsumer(particleType::set).build());
        configCategory.addEntry((AbstractConfigListEntry)entryBuilder.startIntField(class_2561.method_30163((String)"Particle count"), particleCount.get().intValue()).setDefaultValue(25).setTooltip(new class_2561[]{class_2561.method_30163((String)"Particle count")}).setSaveConsumer(particleCount::set).build());
        DoubleListEntry radiusXEntry = entryBuilder.startDoubleField(class_2561.method_30163((String)"X"), radiusX.get().doubleValue()).setMin(0.0).setDefaultValue(0.0).setTooltip(new class_2561[]{class_2561.method_30163((String)"The X-axis radius within which the particle spawns.")}).setSaveConsumer(radiusX::set).build();
        DoubleListEntry radiusYEntry = entryBuilder.startDoubleField(class_2561.method_30163((String)"Y"), radiusY.get().doubleValue()).setMin(0.0).setDefaultValue(0.0).setTooltip(new class_2561[]{class_2561.method_30163((String)"The Y-axis radius within which the particle spawns.")}).setSaveConsumer(radiusY::set).build();
        DoubleListEntry radiusZEntry = entryBuilder.startDoubleField(class_2561.method_30163((String)"Z"), radiusZ.get().doubleValue()).setMin(0.0).setDefaultValue(0.0).setTooltip(new class_2561[]{class_2561.method_30163((String)"The Z-axis radius within which the particle spawns.")}).setSaveConsumer(radiusZ::set).build();
        configCategory.addEntry((AbstractConfigListEntry)entryBuilder.startSubCategory(class_2561.method_30163((String)"Radius"), List.of(radiusXEntry, radiusYEntry, radiusZEntry)).build());
        DoubleListEntry offsetXEntry = entryBuilder.startDoubleField(class_2561.method_30163((String)"X"), offsetX.get().doubleValue()).setMin(0.0).setDefaultValue(0.0).setTooltip(new class_2561[]{class_2561.method_30163((String)"The X-axis offset applied to the particle position.")}).setSaveConsumer(offsetX::set).build();
        DoubleListEntry offsetYEntry = entryBuilder.startDoubleField(class_2561.method_30163((String)"Y"), offsetY.get().doubleValue()).setMin(0.0).setDefaultValue(0.0).setTooltip(new class_2561[]{class_2561.method_30163((String)"The Y-axis offset applied to the particle position.")}).setSaveConsumer(offsetY::set).build();
        DoubleListEntry offsetZEntry = entryBuilder.startDoubleField(class_2561.method_30163((String)"Z"), offsetZ.get().doubleValue()).setMin(0.0).setDefaultValue(0.0).setTooltip(new class_2561[]{class_2561.method_30163((String)"The Z-axis offset applied to the particle position.")}).setSaveConsumer(offsetZ::set).build();
        configCategory.addEntry((AbstractConfigListEntry)entryBuilder.startSubCategory(class_2561.method_30163((String)"Offset"), List.of(offsetXEntry, offsetYEntry, offsetZEntry)).build());
        DoubleListEntry velocityMinEntry = entryBuilder.startDoubleField(class_2561.method_30163((String)"Minimum value"), velocityMin.get().doubleValue()).setMin(0.0).setDefaultValue(0.001).setTooltip(new class_2561[]{class_2561.method_30163((String)"The minimum value of random velocity.")}).setSaveConsumer(velocityMin::set).build();
        DoubleListEntry velocityMaxEntry = entryBuilder.startDoubleField(class_2561.method_30163((String)"Maximum value"), velocityMax.get().doubleValue()).setMin(0.0).setDefaultValue(1.0).setTooltip(new class_2561[]{class_2561.method_30163((String)"The maximum value of random velocity.")}).setSaveConsumer(velocityMax::set).build();
        configCategory.addEntry((AbstractConfigListEntry)entryBuilder.startSubCategory(class_2561.method_30163((String)"Velocity"), List.of(velocityMinEntry, velocityMaxEntry)).build());
        configCategory.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle(class_2561.method_30163((String)"Spawn at feet"), spawnAtFeet.get().booleanValue()).setDefaultValue(false).setTooltip(new class_2561[]{class_2561.method_30163((String)"If enabled, the particle will spawn at the entity\u2019s feet instead of the center.")}).setSaveConsumer(spawnAtFeet::set).build());
        builder.setSavingRunnable(() -> serializer.save());
        return builder.build();
    }

    public static void loadConfig() {
        Map<String, Object> config = serializer.load();
        particleType = new AtomicReference<String>((String)config.get("particle_type"));
        particleCount = new AtomicReference<Integer>(ConfigScreenFactory.toInt(config.get("particle_count")));
        radiusX = new AtomicReference<Double>(ConfigScreenFactory.toDouble(config.get("radius_x")));
        radiusY = new AtomicReference<Double>(ConfigScreenFactory.toDouble(config.get("radius_y")));
        radiusZ = new AtomicReference<Double>(ConfigScreenFactory.toDouble(config.get("radius_z")));
        offsetX = new AtomicReference<Double>(ConfigScreenFactory.toDouble(config.get("offset_x")));
        offsetY = new AtomicReference<Double>(ConfigScreenFactory.toDouble(config.get("offset_y")));
        offsetZ = new AtomicReference<Double>(ConfigScreenFactory.toDouble(config.get("offset_z")));
        spawnAtFeet = new AtomicReference<Boolean>((Boolean)config.get("spawn_at_feet"));
        velocityMin = new AtomicReference<Double>(ConfigScreenFactory.toDouble(config.get("velocity_min")));
        velocityMax = new AtomicReference<Double>(ConfigScreenFactory.toDouble(config.get("velocity_max")));
    }

    public static int toInt(Object unknown) {
        if (unknown instanceof Double) {
            return ((Double)unknown).intValue();
        }
        if (unknown instanceof Float) {
            return ((Float)unknown).intValue();
        }
        return (Integer)unknown;
    }

    public static double toDouble(Object unknown) {
        if (unknown instanceof Integer) {
            return ((Integer)unknown).doubleValue();
        }
        if (unknown instanceof Float) {
            return ((Float)unknown).doubleValue();
        }
        return (Double)unknown;
    }
}

